/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.DesktopEvent;
import oracle.ewt.lwAWT.lwWindow.DesktopLayout;
import oracle.ewt.lwAWT.lwWindow.DesktopListener;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowManager;
import oracle.ewt.lwAWT.lwWindow.WindowType;
import oracle.ewt.plaf.DesktopUI;
import oracle.ewt.util.FocusUtils;

public class DesktopContainer
extends LWComponent
implements Desktop {
    private ListenerManager _listeners;
    private boolean _ignoreRepaints;
    private int _windowCount;
    private static int _DEFAULT_LAYER = 0;
    private static int _FLOATING_DIALOG_LAYER = 100;
    private static int _PALETTE_LAYER = 200;
    private static int _MODAL_LAYER = 300;
    private ActiveListener _activeListener;

    public DesktopContainer() {
        this.setLayout(new DesktopLayout(this));
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            this.enableEvents(4L);
            this._activeListener = new ActiveListener();
        }
    }

    public void addDesktopListener(DesktopListener desktopListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(desktopListener);
    }

    public final void addWindow(LWWindow lWWindow) {
        this.addWindow(lWWindow, lWWindow.isVisible());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindow(LWWindow lWWindow, boolean bl) {
        Desktop desktop = lWWindow.getDesktop();
        if (desktop != null) {
            if (desktop == this) {
                return;
            }
            desktop.removeWindow(lWWindow);
        }
        lWWindow.setVisible(bl);
        Object object = this.getTreeLock();
        synchronized (object) {
            this.add((Component)lWWindow, this._getLayeredPosition(lWWindow, 0));
            lWWindow.setDesktop(this);
            ++this._windowCount;
        }
        object = new DesktopEvent(this, 2002, lWWindow);
        this.processEvent((AWTEvent)object);
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            lWWindow.addPropertyChangeListener(this._activeListener);
            this._tryTransferFocus(lWWindow);
        }
    }

    public Component getDesktopComponent() {
        return this;
    }

    public LWWindow getWindow(int n) {
        return (LWWindow)this.getComponent(n);
    }

    public LWWindow getWindowAtStackPosition(int n) {
        return (LWWindow)this.getComponent(n);
    }

    public int getWindowCount() {
        return this._windowCount;
    }

    public WindowManager getWindowManager() {
        return ((DesktopUI)this.getUI()).getWindowManager(this);
    }

    public Enumeration getWindows() {
        return new WindowEnum(this.getComponents());
    }

    public void removeDesktopListener(DesktopListener desktopListener) {
        if (this._listeners != null) {
            this._listeners.removeListener(desktopListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindow(LWWindow lWWindow) {
        if (lWWindow.getDesktop() == this) {
            if (FocusUtils.areNewFocusAPIsAvailable()) {
                lWWindow.removePropertyChangeListener(this._activeListener);
            }
            Object object = this.getTreeLock();
            synchronized (object) {
                this.remove(lWWindow);
                lWWindow.setDesktop(null);
                --this._windowCount;
            }
            object = new DesktopEvent(this, 2003, lWWindow);
            this.processEvent((AWTEvent)object);
        }
    }

    public void setWindowPosition(LWWindow lWWindow, int n) {
        Desktop desktop = lWWindow.getDesktop();
        if (desktop != this) {
            if (desktop == null) {
                return;
            }
            throw new IllegalArgumentException();
        }
        n = this._getLayeredPosition(lWWindow, n);
        this._ignoreRepaints = true;
        this.add((Component)lWWindow, n);
        this._ignoreRepaints = false;
        lWWindow.repaint();
    }

    public Dimension preferredSize() {
        return new Dimension(super.preferredSize());
    }

    public void addNotify() {
        super.addNotify();
        this.processEvent(new DesktopEvent(this, 2000, null));
    }

    public void removeNotify() {
        super.removeNotify();
        this.processEvent(new DesktopEvent(this, 2001, null));
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (!this._ignoreRepaints) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public boolean isFocusTraversable() {
        return FocusUtils.areNewFocusAPIsAvailable();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004 && FocusUtils.areNewFocusAPIsAvailable() && this.isAutoFocusTransfer()) {
            for (int i = 0; i < this.getWindowCount(); ++i) {
                LWWindow lWWindow = this.getWindow(i);
                if (!lWWindow.isActive()) continue;
                this._tryTransferFocus(lWWindow);
                return;
            }
        }
    }

    public Object getUIClassID() {
        return "DesktopUI";
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof DesktopEvent) {
            this.processDesktopEvent((DesktopEvent)aWTEvent);
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processDesktopEvent(DesktopEvent desktopEvent) {
        Enumeration enumeration;
        if (this._listeners == null || (enumeration = this._listeners.getListeners()) == null) {
            return;
        }
        int n = desktopEvent.getID();
        while (enumeration.hasMoreElements()) {
            DesktopListener desktopListener = (DesktopListener)enumeration.nextElement();
            switch (n) {
                case 2000: {
                    desktopListener.desktopAdded(desktopEvent);
                    break;
                }
                case 2001: {
                    desktopListener.desktopRemoved(desktopEvent);
                    break;
                }
                case 2002: {
                    desktopListener.windowAdded(desktopEvent);
                    break;
                }
                case 2003: {
                    desktopListener.windowRemoved(desktopEvent);
                    break;
                }
            }
        }
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    protected boolean isAutoFocusTransfer() {
        return FocusUtils.areNewFocusAPIsAvailable();
    }

    private int _getLayer(LWWindow lWWindow) {
        if (lWWindow.isModal()) {
            return _MODAL_LAYER;
        }
        WindowType windowType = lWWindow.getType();
        if (windowType == WindowType.PALETTE) {
            return _PALETTE_LAYER;
        }
        if (windowType == WindowType.DIALOG && lWWindow.getLeader() == null) {
            return _FLOATING_DIALOG_LAYER;
        }
        return _DEFAULT_LAYER;
    }

    private int _getLayeredPosition(LWWindow lWWindow, int n) {
        int n2 = this._getLayer(lWWindow);
        int n3 = 0;
        Enumeration enumeration = this.getWindows();
        while (enumeration.hasMoreElements()) {
            LWWindow lWWindow2 = (LWWindow)enumeration.nextElement();
            if (lWWindow2 == lWWindow) continue;
            int n4 = this._getLayer(lWWindow2);
            if (n2 > n4) {
                return n3;
            }
            if (n2 == n4 && n <= n3) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    private void _tryTransferFocus(LWWindow lWWindow) {
        if (this.isAutoFocusTransfer() && lWWindow.isActive() && DesktopContainer.getFocusedComponent() == this) {
            Component component = lWWindow.getRootFocusOwner();
            if (component == null) {
                component = lWWindow.__getFirstFocusableComponent(lWWindow.getContent());
            }
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(DesktopContainer.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DESKTOP_PANE;
        }

        public int getAccessibleChildrenCount() {
            Component[] componentArray = DesktopContainer.this.getComponents();
            int n = componentArray.length;
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if ((!(component instanceof LWWindow) || ((LWWindow)component).getLeader() == null) && component instanceof Accessible) continue;
                --n;
            }
            return n;
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0) {
                return null;
            }
            Component[] componentArray = DesktopContainer.this.getComponents();
            int n2 = componentArray.length;
            if (n >= n2) {
                return null;
            }
            for (int i = 0; i < n2; ++i) {
                Component component = componentArray[i];
                if (component instanceof LWWindow && ((LWWindow)component).getLeader() != null || !(component instanceof Accessible)) {
                    ++n;
                    continue;
                }
                if (n != i) continue;
                return (Accessible)((Object)component);
            }
            return null;
        }
    }

    private class ActiveListener
    implements PropertyChangeListener {
        private ActiveListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("active".equals(propertyChangeEvent.getPropertyName())) {
                LWWindow lWWindow = (LWWindow)propertyChangeEvent.getSource();
                DesktopContainer.this._tryTransferFocus(lWWindow);
            }
        }
    }

    private static class WindowEnum
    implements Enumeration {
        private Component[] _comps;
        int _index;

        public WindowEnum(Component[] componentArray) {
            this._comps = componentArray;
        }

        public boolean hasMoreElements() {
            while (this._index < this._comps.length) {
                if (this._comps[this._index] instanceof LWWindow) {
                    return true;
                }
                ++this._index;
            }
            return false;
        }

        public Object nextElement() {
            if (this._index >= this._comps.length) {
                throw new NoSuchElementException();
            }
            Component component = this._comps[this._index];
            ++this._index;
            return component;
        }
    }
}

