/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.peer.LightweightPeer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Locale;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.help.HelpCapable;
import oracle.ewt.help.HelpProvider;
import oracle.ewt.lwAWT.DoubleBuffer;
import oracle.ewt.lwAWT.DoubleBuffer2;
import oracle.ewt.lwAWT.ImmediatePainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.VirtualComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FGBGColorChange;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.util.ImmInsets;

class SharedPainter {
    private int _repaintFrozenLevel;
    private Rectangle _frozenDamage;
    private Rectangle _frozenSyncDamage;
    private Painter _fill;
    private static final byte _OVERLAP_NOT_COMPUTED = 0;
    private static final byte _OVERLAP_DOES_NOT = 1;
    private static final byte _OVERLAP_OVERLAPS = 2;
    private byte[] _childrenOverlap;
    private Component[] _childrenMirror;
    private Container _comp;
    private static Class _sJInternalFrame;
    private static Class _sJComponent;
    private static Method _sPaintImmediately;
    private static boolean _isMicrosoft;
    private static int _sUnfreezing;
    private static final Object _sUnfreezingLock;
    private static final Painter _sBackgroundFill;

    public SharedPainter(Container container, Painter painter) {
        if (container == null || painter == null) {
            throw new IllegalArgumentException();
        }
        this._comp = container;
        this._fill = painter;
    }

    public void setFill(Painter painter) {
        if (painter == null) {
            painter = NullPainter.getPainter();
        }
        if (painter != this._fill) {
            this._fill = painter;
            this._comp.repaint();
        }
    }

    public Painter getFill() {
        LWComponent lWComponent;
        ComponentUI componentUI;
        if (this._fill == LWComponent.DEFAULT_PAINTER && (componentUI = (lWComponent = (LWComponent)this._comp).getUI()) != null) {
            return componentUI.getDefaultFill(lWComponent);
        }
        return this._fill;
    }

    public void freezeRepaints() {
        ++this._repaintFrozenLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfreezeRepaints(DoubleBuffer doubleBuffer) {
        --this._repaintFrozenLevel;
        if (this._repaintFrozenLevel == 0) {
            Rectangle rectangle;
            Object object = _sUnfreezingLock;
            synchronized (object) {
                ++_sUnfreezing;
            }
            Object object2 = this;
            synchronized (object2) {
                object = this._frozenDamage;
                this._frozenDamage = null;
                rectangle = this._frozenSyncDamage;
                this._frozenSyncDamage = null;
            }
            if (rectangle != null) {
                if (object != null && rectangle.intersects((Rectangle)object)) {
                    this._clipToParents((Rectangle)object);
                    rectangle.add((Rectangle)object);
                    object = null;
                }
                object2 = null;
                if (this._comp instanceof LWComponent) {
                    object2 = (LWComponent)this._comp;
                }
                this.paintImmediate(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (LWComponent)object2, doubleBuffer);
            }
            if (object != null) {
                this._comp.repaint(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            }
            object2 = _sUnfreezingLock;
            synchronized (object2) {
                --_sUnfreezing;
            }
        }
    }

    public synchronized void shiftFrozenDamage(int n, int n2) {
        if (this._frozenDamage != null) {
            this._frozenDamage.x += n;
            this._frozenDamage.y += n2;
        }
        if (this._frozenSyncDamage != null) {
            this._frozenSyncDamage.x += n;
            this._frozenSyncDamage.y += n2;
        }
    }

    public void showHelp() {
        HelpProvider helpProvider;
        HelpCapable helpCapable = this._getHelpCapable();
        if (helpCapable != null && (helpProvider = helpCapable.getHelpProvider()) != null) {
            helpProvider.showHelp(helpCapable.getHelpBook(), helpCapable.getHelpTopic(), this._comp);
        }
    }

    public void clearClipCache() {
        this._childrenOverlap = null;
    }

    public boolean isClippedBySibling() {
        Container container = this._comp;
        if (!container.isVisible()) {
            return false;
        }
        if (container instanceof Window) {
            return false;
        }
        if (this._repaintFrozenLevel > 0) {
            return true;
        }
        Container container2 = container.getParent();
        if (container2 == null) {
            return false;
        }
        if (container2 instanceof ImmediatePainter) {
            return ((ImmediatePainter)((Object)container2)).isChildClipped(container);
        }
        if (_sJInternalFrame != null) {
            Container container3;
            Class clazz = _sJInternalFrame;
            do {
                container3 = container2.getParent();
                if (!clazz.isInstance(container2) || container3.getComponent(0) == container2) continue;
                return true;
            } while ((container2 = container3) != null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChildClipped(Component component) {
        if (this.isClippedBySibling()) {
            return true;
        }
        Container container = this._comp;
        SharedPainter sharedPainter = this;
        synchronized (sharedPainter) {
            byte by;
            int n;
            int n2 = container.getComponentCount();
            if (n2 <= 1) {
                return false;
            }
            Component[] componentArray = this._childrenMirror;
            if (componentArray == null || n2 > componentArray.length) {
                return true;
            }
            for (n = 0; n < n2 && componentArray[n] != component; ++n) {
            }
            if (n == n2) {
                return true;
            }
            byte[] byArray = this._childrenOverlap;
            if (byArray == null) {
                this._childrenOverlap = byArray = new byte[n2];
                by = 0;
            } else {
                by = byArray[n];
            }
            if (by == 0) {
                byArray[n] = by = this._computeOverlaps(component, componentArray, n);
            }
            return by == 2;
        }
    }

    public void paintImmediateClipped(int n, int n2, int n3, int n4, LWComponent lWComponent, DoubleBuffer doubleBuffer) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this._clipToParents(rectangle);
        if (rectangle.width > 0 && rectangle.height > 0) {
            this.paintImmediate(rectangle.x, rectangle.y, rectangle.width, rectangle.height, lWComponent, doubleBuffer);
        }
    }

    public void paintImmediate(int n, int n2, int n3, int n4, DoubleBuffer doubleBuffer) {
        this.paintImmediate(n, n2, n3, n4, null, doubleBuffer);
    }

    public void paintImmediate(int n, int n2, int n3, int n4, LWComponent lWComponent, DoubleBuffer doubleBuffer) {
        Container container = this._comp;
        if (this._repaintFrozenLevel == 0 || !this._addFrozenDamage(n, n2, n3, n4, true)) {
            if (lWComponent != null && lWComponent.isPaintPropagationRequired(n, n2, n3, n4)) {
                Point point = container.getLocation();
                n += point.x;
                n2 += point.y;
                Container container2 = container.getParent();
                if (container2 == null) {
                    return;
                }
                if (container2 instanceof ImmediatePainter) {
                    ((ImmediatePainter)((Object)container2)).paintImmediateUnclipped(n, n2, n3, n4);
                } else if (_sJComponent != null && _sJComponent.isInstance(container2) && _sPaintImmediately != null) {
                    try {
                        _sPaintImmediately.invoke((Object)container2, new Integer(n), new Integer(n2), IntegerUtils.getInteger((int)n3), IntegerUtils.getInteger((int)n4));
                    }
                    catch (Exception exception) {}
                } else {
                    Graphics graphics = container2.getGraphics();
                    if (graphics != null) {
                        graphics.clipRect(n, n2, n3, n4);
                        if (lWComponent.isTransparent()) {
                            container2.update(graphics);
                        } else {
                            container2.paint(graphics);
                        }
                        graphics.dispose();
                    } else {
                        container.repaint(n, n2, n3, n4);
                    }
                }
            } else {
                Graphics graphics = container.getGraphics();
                if (graphics != null) {
                    graphics.clipRect(n, n2, n3, n4);
                    this.paint(graphics, doubleBuffer, this._getVirtualComponent());
                    graphics.dispose();
                } else {
                    container.repaint(n, n2, n3, n4);
                }
            }
        }
    }

    public boolean repaint(int n, int n2, int n3, int n4) {
        return !this._addFrozenDamage(n, n2, n3, n4, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics, DoubleBuffer doubleBuffer, VirtualComponent virtualComponent) {
        Object object;
        Graphics graphics2 = graphics;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = virtualComponent.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            graphics.setClip(rectangle);
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        Container container = this._comp;
        if (_isMicrosoft) {
            object = virtualComponent.getSize();
            if (n3 > ((Dimension)object).width) {
                n3 = ((Dimension)object).width;
            }
            if (n4 > ((Dimension)object).height) {
                n4 = ((Dimension)object).height;
            }
        }
        if (graphics instanceof PrintGraphics) {
            object = null;
        } else {
            try {
                object = ((DoubleBuffer2)doubleBuffer).getOffscreenBuffer(container, n3, n4);
            }
            catch (ClassCastException classCastException) {
                object = doubleBuffer.getOffscreenBuffer(container);
            }
            catch (Exception exception) {
                object = null;
            }
        }
        try {
            if (object != null) {
                BorderPainter borderPainter;
                graphics = ((Image)object).getGraphics();
                graphics.translate(-n, -n2);
                GraphicUtils.synchronizeGraphics(graphics, graphics2, rectangle);
                PaintContext paintContext = virtualComponent.getPaintContext();
                if (this._fill.isTransparent(paintContext) || (borderPainter = virtualComponent.getBorderPainter()) != null && borderPainter.isTransparent(paintContext)) {
                    _sBackgroundFill.paint(paintContext, graphics, 0, 0, n3, n4);
                }
            }
            this.paintExtents(graphics, virtualComponent);
            if (object != null) {
                graphics2.drawImage((Image)object, n, n2, n + n3, n2 + n4, 0, 0, rectangle.width, rectangle.height, container);
                graphics.dispose();
            }
        }
        finally {
            if (object != null) {
                doubleBuffer.releaseOffscreenBuffer((Image)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintExtents(Graphics graphics, VirtualComponent virtualComponent) {
        int n;
        int n2;
        int n3;
        Serializable serializable;
        if (virtualComponent instanceof LWComponent) {
            serializable = (LWComponent)virtualComponent;
            n3 = serializable.__bounds.width;
            n2 = serializable.__bounds.height;
        } else {
            serializable = virtualComponent.getSize();
            n3 = ((Dimension)serializable).width;
            n2 = ((Dimension)serializable).height;
        }
        this._paintBackground(graphics, virtualComponent, this.getFill(), n3, n2);
        boolean bl = false;
        BorderPainter borderPainter = virtualComponent.getBorderPainter();
        Component[] componentArray = this._childrenMirror;
        if (componentArray != null && (n = componentArray.length) > 0) {
            Shape shape = graphics.getClip();
            this._paintInterior(graphics, virtualComponent, borderPainter, n3, n2, shape);
            try {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                for (int i = n - 1; i >= 0; --i) {
                    Rectangle rectangle2;
                    LWComponent lWComponent;
                    Component component = componentArray[i];
                    if (component == null || !component.isVisible() || !(component.getPeer() instanceof LightweightPeer)) continue;
                    if (component instanceof LWComponent) {
                        lWComponent = (LWComponent)component;
                        rectangle2 = lWComponent.__bounds;
                    } else {
                        lWComponent = null;
                        rectangle2 = component.getBounds();
                    }
                    if (rectangle != null && !rectangle2.intersects(rectangle)) continue;
                    Graphics graphics2 = graphics.create();
                    if (rectangle == null) {
                        graphics2.setClip(0, 0, rectangle2.width, rectangle2.height);
                    } else {
                        int n4 = rectangle2.x;
                        int n5 = rectangle2.y;
                        int n6 = rectangle.x;
                        int n7 = rectangle.y;
                        if (n4 != 0 || n5 != 0) {
                            graphics2.translate(n4, n5);
                            n6 -= n4;
                            n7 -= n5;
                        }
                        if (n6 != 0 || n7 != 0 || rectangle.width != rectangle2.width || rectangle.height != rectangle2.height) {
                            int n8 = Math.max(n6, 0);
                            int n9 = Math.max(n7, 0);
                            int n10 = Math.min(rectangle2.width, n6 + rectangle.width) - n8;
                            int n11 = Math.min(rectangle2.height, n7 + rectangle.height) - n9;
                            graphics2.setClip(n8, n9, n10, n11);
                        }
                    }
                    graphics2.setFont(component.getFont());
                    try {
                        if (lWComponent != null) {
                            lWComponent.__setBuffered(true);
                        }
                        component.paint(graphics2);
                        continue;
                    }
                    finally {
                        if (lWComponent != null) {
                            lWComponent.__setBuffered(false);
                        }
                        graphics2.dispose();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = true;
        }
        if (!bl) {
            this._paintInterior(graphics, virtualComponent, borderPainter, n3, n2, null);
        }
        if (virtualComponent instanceof LWComponent) {
            ((LWComponent)virtualComponent).paintOverChildren(graphics);
        }
        this._paintBorder(graphics, virtualComponent, borderPainter, n3, n2);
    }

    private void _paintBorder(Graphics graphics, VirtualComponent virtualComponent, BorderPainter borderPainter, int n, int n2) {
        if (borderPainter != null && n > 0 && n2 > 0) {
            borderPainter.paint(virtualComponent.getBorderContext(), graphics, 0, 0, n, n2);
        }
    }

    private void _paintInterior(Graphics graphics, VirtualComponent virtualComponent, BorderPainter borderPainter, int n, int n2, Shape shape) {
        if (n <= 0 || n2 <= 0) {
            return;
        }
        PaintContext paintContext = virtualComponent.getPaintContext();
        int n3 = n;
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        int n7 = 0;
        int n8 = 0;
        if (borderPainter != null) {
            ImmInsets immInsets;
            if (virtualComponent instanceof LWComponent && !((LWComponent)virtualComponent).__clipToBorder()) {
                immInsets = borderPainter.getFillInsets(paintContext);
                ImmInsets immInsets2 = borderPainter.getInsets(paintContext);
                n7 = immInsets2.left - immInsets.left;
                n8 = immInsets2.top - immInsets.top;
            } else {
                immInsets = borderPainter.getInsets(paintContext);
            }
            if (immInsets != ImmInsets.getEmptyInsets()) {
                bl = true;
                n5 = immInsets.left;
                n6 = immInsets.top;
                n3 -= n5 + immInsets.right;
                n4 -= n6 + immInsets.bottom;
            }
        }
        if (n3 > 0 && n4 > 0) {
            if (bl) {
                if (shape == null) {
                    shape = graphics.getClip();
                }
                graphics.translate(n5 + n7, n6 + n8);
                graphics.clipRect(-n7, -n8, n3, n4);
            }
            virtualComponent.paintInterior(graphics);
            if (bl) {
                graphics.translate(-n5 - n7, -n6 - n8);
            }
            if (shape != null) {
                graphics.setClip(shape);
            }
        }
    }

    private void _paintBackground(Graphics graphics, VirtualComponent virtualComponent, Painter painter, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        PaintContext paintContext = virtualComponent.getPaintContext();
        BorderPainter borderPainter = virtualComponent.getBorderPainter();
        if (borderPainter != null) {
            ImmInsets immInsets = borderPainter.getFillInsets(paintContext);
            n3 = immInsets.left;
            n4 = immInsets.top;
            n -= immInsets.left + immInsets.right;
            n2 -= immInsets.top + immInsets.bottom;
        }
        painter.paint(paintContext, graphics, n3, n4, n, n2);
    }

    public void propagateLocale(Locale locale, Locale locale2) {
        if (this._comp.getComponentCount() == 0) {
            return;
        }
        Component[] componentArray = this._comp.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            LWComponent lWComponent;
            Component component = componentArray[i];
            if (!(component instanceof LWComponent) || !(lWComponent = (LWComponent)component).isLocaleDefaulted()) continue;
            lWComponent.updateLocale(locale, locale2);
        }
    }

    public void propagateReadingDirection(int n) {
        if (this._comp.getComponentCount() == 0) {
            return;
        }
        Component[] componentArray = this._comp.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            LWComponent lWComponent;
            Component component = componentArray[i];
            if (!(component instanceof LWComponent) || !(lWComponent = (LWComponent)component).isReadingDirectionDefaulted() || !lWComponent.isLocaleDefaulted()) continue;
            lWComponent.updateReadingDirection(n);
            lWComponent.propagateReadingDirection(n);
        }
    }

    static boolean __isUnfreezing() {
        return _sUnfreezing > 0;
    }

    synchronized void add(Component component, int n) {
        this.clearClipCache();
        int n2 = this._comp.getComponentCount();
        Component[] componentArray = this._childrenMirror;
        if (componentArray == null || n2 > componentArray.length) {
            if (n2 < 4) {
                this._childrenMirror = this._comp.getComponents();
                return;
            }
            int n3 = componentArray == null ? 4 : componentArray.length + 8;
            Component[] componentArray2 = new Component[n3];
            if (componentArray != null) {
                System.arraycopy(componentArray, 0, componentArray2, 0, componentArray.length);
            }
            componentArray = componentArray2;
            this._childrenMirror = componentArray2;
        }
        if (n == -1 || n == n2 - 1) {
            componentArray[n2 - 1] = component;
        } else {
            System.arraycopy(componentArray, n, componentArray, n + 1, n2 - n - 1);
            componentArray[n] = component;
        }
    }

    synchronized void remove(int n) {
        this.clearClipCache();
        int n2 = this._comp.getComponentCount();
        Component[] componentArray = this._childrenMirror;
        if (n < n2) {
            System.arraycopy(componentArray, n + 1, componentArray, n, n2 - n);
        }
        componentArray[n2] = null;
    }

    synchronized void removeAll() {
        this.clearClipCache();
        this._childrenMirror = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _addFrozenDamage(int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        if (this._repaintFrozenLevel == 0) {
            bl2 = false;
        } else {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            SharedPainter sharedPainter = this;
            synchronized (sharedPainter) {
                boolean bl3 = bl2 = this._repaintFrozenLevel != 0;
                if (bl2) {
                    Rectangle rectangle2;
                    Rectangle rectangle3 = rectangle2 = bl ? this._frozenSyncDamage : this._frozenDamage;
                    if (rectangle2 == null) {
                        rectangle2 = rectangle;
                    } else {
                        rectangle2.add(rectangle);
                    }
                    if (bl) {
                        this._frozenSyncDamage = rectangle2;
                    } else {
                        this._frozenDamage = rectangle2;
                    }
                }
            }
        }
        return bl2;
    }

    private byte _computeOverlaps(Component component, Component[] componentArray, int n) {
        Container container = this._comp;
        Component component2 = null;
        if (container instanceof MouseGrabProvider) {
            component2 = ((MouseGrabProvider)((Object)container)).getProxyComponent();
        }
        Rectangle rectangle = component.getBounds();
        for (int i = 0; i < n; ++i) {
            Component component3 = componentArray[i];
            if (component2 == component3 || !component3.isVisible() || !component3.getBounds().intersects(rectangle)) continue;
            return 2;
        }
        return 1;
    }

    void _clipToParents(Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        Container container = this._comp;
        do {
            Rectangle rectangle2 = container instanceof LWComponent ? ((LWComponent)container).__bounds : container.getBounds();
            rectangle.x += rectangle2.x;
            rectangle.y += rectangle2.y;
            n += rectangle2.x;
            n2 += rectangle2.y;
            SharedPainter.__intersectRect(rectangle, rectangle, rectangle2);
        } while ((container = container.getParent()) != null && !(container instanceof Window));
        rectangle.x -= n;
        rectangle.y -= n2;
    }

    static void __intersectRect(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = rectangle2.x;
        int n2 = n + rectangle2.width;
        int n3 = rectangle2.y;
        int n4 = n3 + rectangle2.height;
        int n5 = rectangle3.x;
        int n6 = n5 + rectangle3.width;
        int n7 = rectangle3.y;
        int n8 = n7 + rectangle3.height;
        rectangle.x = n >= n5 ? n : n5;
        rectangle.y = n3 >= n7 ? n3 : n7;
        rectangle.width = (n2 <= n6 ? n2 : n6) - rectangle.x;
        rectangle.height = (n4 <= n8 ? n4 : n8) - rectangle.y;
    }

    private VirtualComponent _getVirtualComponent() {
        return (VirtualComponent)((Object)this._comp);
    }

    private HelpCapable _getHelpCapable() {
        if (this._comp instanceof HelpCapable) {
            return (HelpCapable)((Object)this._comp);
        }
        return null;
    }

    static {
        try {
            _sJInternalFrame = Class.forName("javax.swing.JInternalFrame");
            _sJComponent = Class.forName("javax.swing.JComponent");
            _sPaintImmediately = _sJComponent.getMethod("paintImmediately", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            String string = System.getProperty("java.vendor");
            _isMicrosoft = string != null && string.startsWith("Microsoft");
        }
        catch (Exception exception) {
            _isMicrosoft = false;
        }
        _sUnfreezing = 0;
        _sUnfreezingLock = new Object();
        _sBackgroundFill = new FGBGColorChange(FilledRectPainter.getPainter(), false);
    }
}

