/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.ColorScheme;
import oracle.ewt.EwtComponent;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.EmptyOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ListUI;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;
import oracle.ewt.util.EventQueueUtils;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LookAndFeelUtils;
import oracle.ewt.util.StringUtils;

public class LWDataSourceList
extends LWContainer
implements ItemSelectable {
    private static final int _DEFAULT_VISIBLE_ROWS = 4;
    static final int _MINIMUM_WIDTH = 8;
    private static final int _SCROLLBAR_WIDTH = 15;
    private OneDDataSource _dataSource;
    private DSCheck _dsListener;
    private int _rows;
    private boolean _multipleMode;
    int[] _selection = new int[1];
    int _selectCount;
    private int _visibleIndex;
    int _focusItem;
    int _anchorItem;
    private ListenerManager _iListenerManager;
    private ListenerManager _aListenerManager;
    private boolean _focusTraversable = true;
    private Content _content;
    private ScrollBox _scrollBox;
    private long _typeAheadDelay = -1L;
    private static long _sDefaultTypeAheadDelay = 750L;
    private long _currentTime;
    private char _keyChar;
    private StringBuffer _buffer;

    public LWDataSourceList() {
        this(null, 4, false);
    }

    public LWDataSourceList(OneDDataSource oneDDataSource) {
        this(oneDDataSource, 4, false);
    }

    public LWDataSourceList(int n) {
        this(null, n, false);
    }

    public LWDataSourceList(OneDDataSource oneDDataSource, int n, boolean bl) {
        if (oneDDataSource == null) {
            oneDDataSource = EmptyOneDDataSource.getOneDDataSource();
        }
        this._dataSource = oneDDataSource;
        this._rows = n != 0 ? n : 4;
        this._multipleMode = bl;
        this.setLayout(new BorderLayout());
        this._content = new Content();
        this._scrollBox = new ScrollBox(this._content, 0, 0);
        this._scrollBox.setBorderPainter(null);
        this.add((Component)this._scrollBox, "Center");
        this._dsListener = new DSCheck();
        this._dataSource.addDataSourceListener(this._dsListener);
        this.enableEvents(12L);
        this._init();
    }

    public Object getUIClassID() {
        return "ListUI";
    }

    public OneDDataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(OneDDataSource oneDDataSource) {
        OneDDataSource oneDDataSource2 = this.getDataSource();
        if (oneDDataSource == null) {
            oneDDataSource = EmptyOneDDataSource.getOneDDataSource();
        }
        if (oneDDataSource != oneDDataSource2) {
            oneDDataSource2.removeDataSourceListener(this._dsListener);
            this._dataSource = oneDDataSource;
            this._init();
            this._scrollBox.setScrollPosition(0, 0);
            this._dataSource.addDataSourceListener(this._dsListener);
            this.reconfigureScrolling();
            this._repaintList();
            this.accessibleDataChanged();
        }
    }

    public int getItemCount() {
        return this.getDataSource().getItemCount();
    }

    public String getItem(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            throw new IllegalArgumentException("index " + n + " is not valid.");
        }
        Object object = this.getDataSource().getData(n);
        return object != null ? object.toString() : null;
    }

    public synchronized String[] getItems() {
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getItem(i);
        }
        return stringArray;
    }

    public synchronized int getSelectedIndex() {
        if (this._selectCount == 0) {
            return -1;
        }
        return this._selection[this._selectCount - 1];
    }

    public synchronized int[] getSelectedIndexes() {
        int[] nArray = new int[this._selectCount];
        if (this._selectCount != 0) {
            System.arraycopy(this._selection, 0, nArray, 0, this._selectCount);
        }
        return nArray;
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        return n < 0 ? null : this.getItem(n);
    }

    public synchronized String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getItem(nArray[i]);
        }
        return stringArray;
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public int getRowHeight() {
        Font font = this.getFont();
        int n = 0;
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            n = fontMetrics.getHeight() + 2;
        }
        return n;
    }

    public int getFirstVisibleIndex() {
        return this._content.getVValueOfOffset(-this._scrollBox.getScrollPosition().y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void select(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            throw new IllegalArgumentException("index " + n + " is not valid.");
        }
        if (this.isIndexSelected(n)) {
            return;
        }
        try {
            this.freezeRepaints();
            if (!this.isMultipleMode()) {
                int n2 = -1;
                if (this._selectCount != 0) {
                    n2 = this._selection[0];
                }
                this._selection[0] = n;
                this._selectCount = 1;
                if (n2 != -1) {
                    this._repaintItem(n2);
                }
                this._setFocusItem(n);
            } else {
                if (this._selection.length == this._selectCount) {
                    int[] nArray = new int[this._selection.length * 2];
                    System.arraycopy(this._selection, 0, nArray, 0, this._selection.length);
                    this._selection = nArray;
                }
                this._selection[this._selectCount] = n;
                ++this._selectCount;
            }
            if (this._focusItem == -1) {
                this._setFocusItemImpl(n);
            }
            if (this._anchorItem == -1) {
                this._anchorItem = n;
            }
            this._repaintItem(n);
            this.makeVisible(n);
        }
        finally {
            this.unfreezeRepaints();
        }
        this.accessibleSelectionChanged();
    }

    public synchronized void deselectAll() {
        this._selectCount = 0;
        this._anchorItem = -1;
        this._content.repaintInterior();
        this.accessibleSelectionChanged();
    }

    public synchronized void deselect(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            throw new IllegalArgumentException("index " + n + " is not valid.");
        }
        if (!this.isIndexSelected(n)) {
            return;
        }
        for (int i = 0; i < this._selectCount; ++i) {
            if (this._selection[i] != n) continue;
            if (i != 0) {
                System.arraycopy(this._selection, 0, this._selection, 0, i);
            }
            if (i == this._selectCount - 1) continue;
            System.arraycopy(this._selection, i + 1, this._selection, i, this._selectCount - (i + 1));
        }
        --this._selectCount;
        this._repaintItem(n);
        this.accessibleSelectionChanged();
    }

    public boolean isIndexSelected(int n) {
        if (this._selectCount == 0) {
            return false;
        }
        for (int i = 0; i < this._selectCount; ++i) {
            if (this._selection[i] != n) continue;
            return true;
        }
        return false;
    }

    public int getRows() {
        return this._rows;
    }

    public boolean isMultipleMode() {
        return this._multipleMode;
    }

    public synchronized void setMultipleMode(boolean bl) {
        if (bl == this.isMultipleMode()) {
            return;
        }
        this._multipleMode = bl;
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleState", bl ? null : AccessibleState.MULTISELECTABLE, bl ? AccessibleState.MULTISELECTABLE : null);
        }
        if (!bl && this._selectCount > 1) {
            this._selectCount = 1;
            this._repaintList();
            this.accessibleSelectionChanged();
        }
    }

    public int getVisibleIndex() {
        return this._visibleIndex;
    }

    public synchronized void makeVisible(int n) {
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("index " + n + " is not valid.");
        }
        this._visibleIndex = n;
        int n3 = -1;
        int n4 = this._getRows();
        if (n4 == 0) {
            return;
        }
        int n5 = this.getFirstVisibleIndex();
        if (n < n5) {
            n3 = n;
        } else if (n >= n5 + n4) {
            n3 = n - n4 + 1;
        } else if (n5 + n4 > n2 && (n3 = n2 - n4) < 0) {
            n3 = 0;
        }
        if (n3 != -1) {
            this._setFirstVisibleIndex(n3);
        }
    }

    public void setColorScheme(ColorScheme colorScheme) {
        super.setColorScheme(colorScheme);
        LookAndFeelUtils.setComponentTreeColorScheme(this._scrollBox, colorScheme);
    }

    public Dimension getPreferredSize(int n) {
        Dimension dimension = this._content.getPreferredSize(n);
        int n2 = 15;
        ScrollBox scrollBox = this._scrollBox;
        if (scrollBox.getComponentCount() > 2) {
            n2 = scrollBox.getComponent((int)2).getPreferredSize().width;
        }
        dimension.width += n2;
        return this.convertInnerToOuterSize(dimension);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getRows());
    }

    public Dimension getMinimumSize(int n) {
        return this.getMinimumSize();
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (this._iListenerManager == null) {
            this._iListenerManager = new ListenerManager();
        }
        this._iListenerManager.addListener(itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (this._iListenerManager != null) {
            this._iListenerManager.removeListener(itemListener);
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this._aListenerManager == null) {
            this._aListenerManager = new ListenerManager();
        }
        this._aListenerManager.addListener(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this._aListenerManager != null) {
            this._aListenerManager.removeListener(actionListener);
        }
    }

    public int getFocusedItem() {
        return this._focusItem;
    }

    public void setFocusedItem(int n) {
        this._setFocusItem(n);
    }

    public synchronized void removeAll() {
        this._init();
        this._scrollBox.setScrollPosition(0, 0);
        this._repaintList();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._scrollBox.setEnabled(bl);
        this._content.setEnabled(bl);
    }

    public void setFill(Painter painter) {
        this._content.setFill(painter);
        super.setFill(painter);
    }

    public boolean isFocusTraversable() {
        return this._focusTraversable;
    }

    public void invalidate() {
        super.invalidate();
        if (this._content != null) {
            this._content.invalidate();
        }
    }

    public void setTypeAheadDelay(long l) {
        this._typeAheadDelay = l;
    }

    public long getTypeAheadDelay() {
        if (this._typeAheadDelay == -1L) {
            return LWDataSourceList.getDefaultTypeAheadDelay();
        }
        return this._typeAheadDelay;
    }

    public static final void setDefaultTypeAheadDelay(long l) {
        _sDefaultTypeAheadDelay = l;
    }

    public static final long getDefaultTypeAheadDelay() {
        return _sDefaultTypeAheadDelay;
    }

    protected ImageSet getImageSet(int n) {
        return null;
    }

    protected final ListUI getListUI() {
        return (ListUI)this.getUI();
    }

    protected Object getPaintData(Object object) {
        return this._scrollBox.getPaintContext().getPaintData(object);
    }

    protected void validateTree() {
        ImmInsets immInsets = this.getBorderInsets();
        super.validateTree();
        if (!this.getBorderInsets().equals(immInsets)) {
            this.invalidate();
            super.validateTree();
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this._iListenerManager == null) {
            return;
        }
        Enumeration enumeration = this._iListenerManager.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled() || this.getItemCount() == 0) {
            return;
        }
        switch (keyEvent.getID()) {
            case 400: {
                this._processKeyTyped(keyEvent);
                break;
            }
            case 401: {
                this._processKeyPressed(keyEvent);
                break;
            }
            case 402: {
                this._processKeyReleased(keyEvent);
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        AccessibleContext accessibleContext;
        super.processFocusEvent(focusEvent);
        if (this._focusItem == -1 && this.getItemCount() != 0) {
            this._setFocusItemImpl(0);
        } else if (focusEvent.getID() == 1004 && (accessibleContext = this.accessAccessibleContext()) != null) {
            ((Access)accessibleContext).fireActiveChanged(-1, this._focusItem);
        }
        this._repaintItem(this._focusItem);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this._aListenerManager == null) {
            return;
        }
        Enumeration enumeration = this._aListenerManager.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
            }
        }
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    protected int getRepaintFlags() {
        return super.getRepaintFlags() | 0x100 | 0x200 | 0x400 | 0x800;
    }

    protected int getInvalidateFlags() {
        return super.getInvalidateFlags() | 0x100;
    }

    protected String paramString() {
        return super.paramString() + ",selected=" + this.getSelectedItem();
    }

    void setFocusTraversable(boolean bl) {
        this._focusTraversable = bl;
    }

    int getItemAt(int n) {
        return this._content.getContentItemAt(n);
    }

    void _scrollToTop(int n) {
        this._setFirstVisibleIndex(n);
    }

    void _repaintList() {
        this._content.paintImmediateInterior();
    }

    int _getRows() {
        int n = this.getRowHeight();
        if (n == 0) {
            return 0;
        }
        return this._scrollBox.getViewPortSize().height / n;
    }

    boolean _isIndexOnScreen(int n) {
        int n2 = this.getFirstVisibleIndex();
        return n >= n2 && n <= n2 + this._getRows();
    }

    void _setFirstVisibleIndex(int n) {
        int n2 = 0;
        if (this.getActualReadingDirection() == 2) {
            Dimension dimension = this._scrollBox.getContentSize();
            Dimension dimension2 = this._scrollBox.getViewPortSize();
            n2 = dimension.width - dimension2.width;
        }
        this._scrollBox.setScrollPosition(n2, -this._content.getVOffsetOfValue(n));
    }

    void _updateSelection() {
        int n;
        int n2 = n = this._selectCount;
        for (int i = 0; i < this._selectCount; ++i) {
            if (this._selection[i] != -1) continue;
            if (i != 0) {
                System.arraycopy(this._selection, 0, this._selection, 0, i);
            }
            if (i != this._selectCount - 1) {
                System.arraycopy(this._selection, i + 1, this._selection, i, this._selectCount - (i + 1));
            }
            --n;
        }
        this._selectCount = n;
        if (n2 != n) {
            this.accessibleSelectionChanged();
        }
    }

    private void _processKeyPressed(KeyEvent keyEvent) {
        int n = this.getItemCount();
        int n2 = this._focusItem;
        int n3 = -1;
        int n4 = this._getRows();
        int n5 = n - 1;
        this._keyChar = keyEvent.getKeyChar();
        if (keyEvent.isAltDown()) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 32: {
                if (this.isMultipleMode() && this._focusItem != -1) {
                    if (!this.isIndexSelected(this._focusItem)) {
                        this.select(this._focusItem);
                        this._postItemEvent(this.getItem(this._focusItem), 1);
                        this.accessibleSelectionChanged();
                    } else {
                        this.deselect(this._focusItem);
                        this._postItemEvent(this.getItem(this._focusItem), 2);
                        this.accessibleSelectionChanged();
                    }
                    this._anchorItem = this._focusItem;
                }
                return;
            }
            case 37: 
            case 38: {
                if (n2 == -1) {
                    n3 = 0;
                    break;
                }
                if (n2 == 0) break;
                n3 = n2 - 1;
                break;
            }
            case 39: 
            case 40: {
                if (n2 == -1) {
                    n3 = 0;
                    break;
                }
                if (n2 == n5) break;
                n3 = n2 + 1;
                break;
            }
            case 33: {
                if (n2 == -1) {
                    n3 = 0;
                    break;
                }
                if (n2 == 0 || (n3 = n2 - n4) >= 0) break;
                n3 = 0;
                break;
            }
            case 34: {
                if (n2 == -1) {
                    n3 = 0;
                    break;
                }
                if (n2 == n5 || (n3 = n2 + n4) <= n5) break;
                n3 = n5;
                break;
            }
            case 36: {
                if (n2 == 0) break;
                n3 = 0;
                break;
            }
            case 35: {
                if (n2 == n5) break;
                n3 = n5;
                break;
            }
            default: {
                return;
            }
        }
        if (n3 != -1) {
            this.freezeRepaints();
            this.makeVisible(n3);
            this._setFocusItem(n3);
            if (!this.isMultipleMode()) {
                if (!this.isIndexSelected(n3)) {
                    this._selectItem(n3);
                    this._postItemEvent(this.getItem(n3), 1);
                    this.accessibleSelectionChanged();
                }
            } else {
                int n6;
                boolean bl;
                int n7 = InputEventUtils.getMods(keyEvent);
                boolean bl2 = bl = (n7 & (n6 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) != 0;
                if ((n7 & 1) != 0) {
                    this._extendSelection(n3, bl);
                } else if (!bl) {
                    boolean bl3 = this.isIndexSelected(n3);
                    this._selectItem(n3);
                    if (!bl3) {
                        this._postItemEvent(this.getItem(n3), 1);
                        this.accessibleSelectionChanged();
                    }
                }
            }
            this.unfreezeRepaints();
        }
        keyEvent.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processKeyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (this._keyChar != c) {
            return;
        }
        if (this._checkTime(this.getTypeAheadDelay())) {
            this._buffer = null;
        }
        StringBuffer stringBuffer = this._getBuffer();
        stringBuffer.append(c);
        int n = this.getSelectedIndex();
        int n2 = stringBuffer.length() == 1 ? n + 1 : n;
        int n3 = this._findItem(n2, stringBuffer.toString());
        if (n3 == -1 && stringBuffer.length() == 2 && stringBuffer.charAt(0) == stringBuffer.charAt(1)) {
            stringBuffer.setLength(1);
            n3 = this._findItem(n + 1, stringBuffer.toString());
        }
        if (n3 != -1 && n3 != n) {
            try {
                this.freezeRepaints();
                this._selectItem(n3);
                this._setFocusItem(n3);
                this.makeVisible(n3);
                this._postItemEvent(this.getItem(n3), 1);
                this.accessibleSelectionChanged();
            }
            finally {
                this.unfreezeRepaints();
            }
        }
        this._storeTime();
    }

    private void _processKeyReleased(KeyEvent keyEvent) {
        this._keyChar = StringUtils.CHAR_UNDEFINED;
    }

    private void _storeTime() {
        this._currentTime = System.currentTimeMillis();
    }

    private boolean _checkTime(long l) {
        return System.currentTimeMillis() - this._currentTime > l;
    }

    private StringBuffer _getBuffer() {
        if (this._buffer == null) {
            this._buffer = new StringBuffer();
        }
        return this._buffer;
    }

    private int _findItem(int n, String string) {
        String string2;
        int n2;
        int n3 = this.getItemCount();
        if (n == -1) {
            n = 0;
        }
        Locale locale = this.getLocale();
        string = string.toUpperCase(locale);
        for (n2 = n; n2 < n3; ++n2) {
            string2 = this.getItem(n2).toUpperCase(locale);
            if (!string2.startsWith(string)) continue;
            return n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            string2 = this.getItem(n2).toUpperCase(locale);
            if (!string2.startsWith(string)) continue;
            return n2;
        }
        return -1;
    }

    private void _repaintItem(int n) {
        if (!this._isIndexOnScreen(n)) {
            return;
        }
        int n2 = this.getRowHeight();
        int n3 = this.getListUI().getItemOutset(this);
        this._content.paintImmediateCanvas(0, n2 * n - n3, this._content.getCanvasSize().width, n2 + 2 * n3);
    }

    void _extendSelection(int n, boolean bl) {
        int n2;
        if (this._anchorItem == -1) {
            this._anchorItem = this.getSelectedIndex();
        }
        if (this._anchorItem == -1) {
            return;
        }
        int n3 = this._anchorItem;
        int n4 = n;
        if (n3 > n4) {
            n4 = this._anchorItem;
            n3 = n;
        }
        if (!bl) {
            for (n2 = this._selectCount - 1; n2 >= 0; --n2) {
                this._postItemEvent(this.getItem(this._selection[n2]), 2);
                --this._selectCount;
            }
        }
        n2 = 0;
        int[] nArray = new int[n4 - n3 + 1];
        for (int i = n3; i <= n4; ++i) {
            if (this.isIndexSelected(i)) continue;
            nArray[n2] = i;
            ++n2;
        }
        int[] nArray2 = new int[this._selectCount + n2];
        System.arraycopy(this._selection, 0, nArray2, 0, this._selectCount);
        System.arraycopy(nArray, 0, nArray2, this._selectCount, n2);
        this._selection = nArray2;
        this._selectCount += n2;
        for (int i = 0; i < n2; ++i) {
            this._postItemEvent(this.getItem(nArray[i]), 1);
        }
        this._repaintList();
        this.accessibleSelectionChanged();
    }

    void _selectItem(int n) {
        int n2;
        int n3 = this._selectCount;
        String[] stringArray = null;
        if (n3 >= 0) {
            stringArray = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[n2] = this.getItem(this._selection[n2]);
            }
        }
        this._anchorItem = n;
        this._selectCount = 1;
        this._selection[0] = n;
        this._repaintList();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            this._postItemEvent(stringArray[n2], 2);
        }
    }

    void _postActionEvent(String string, MouseEvent mouseEvent) {
        int n = 0;
        if (mouseEvent.isControlDown()) {
            n |= 2;
        }
        if (mouseEvent.isShiftDown()) {
            n |= 1;
        }
        if (mouseEvent.isMetaDown()) {
            n |= 4;
        }
        if (mouseEvent.isAltDown()) {
            n |= 8;
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, string, n);
        this.processEvent(actionEvent);
    }

    void _postItemEvent(String string, int n) {
        ItemEvent itemEvent = new ItemEvent(this, 701, string, n);
        this.processEvent(itemEvent);
    }

    void _setFocusItem(int n) {
        if (this._focusItem == n) {
            return;
        }
        int n2 = this._focusItem;
        this._setFocusItemImpl(n);
        if (n2 != -1) {
            this._repaintItem(n2);
        }
        this._repaintItem(this._focusItem);
    }

    private void _setFocusItemImpl(int n) {
        int n2 = this._focusItem;
        if (n2 != n) {
            AccessibleContext accessibleContext;
            this._focusItem = n;
            if (this.hasFocus() && (accessibleContext = this.accessAccessibleContext()) != null) {
                ((Access)accessibleContext).fireActiveChanged(n2, n);
            }
        }
    }

    private void _init() {
        this._anchorItem = -1;
        this._focusItem = -1;
        this._visibleIndex = -1;
        this._selectCount = 0;
        this.setFill(this.getListUI().getContentFill(this));
        this._content._init();
    }

    void reconfigureScrolling() {
        this._content.reconfigureScrolling();
    }

    EwtComponent getContent() {
        return this._content;
    }

    void accessibleDataChanged() {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            Access access = (Access)accessibleContext;
            access.fireDataChanged();
            access.clearCache();
        }
    }

    void accessibleSelectionChanged() {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            ((Access)accessibleContext).fireSelectionChanged();
        }
    }

    private class Child
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent {
        private int _index;

        public Child(int n) {
            this._index = n;
            this.accessibleParent = LWDataSourceList.this;
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public String getAccessibleName() {
            return LWDataSourceList.this.getItem(this._index);
        }

        public void setAccessibleName(String string) {
        }

        public String getAccessibleDescription() {
            return null;
        }

        public void setAccessibleDescription(String string) {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (LWDataSourceList.this.isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
            if (LWDataSourceList.this.hasFocus() && this._index == LWDataSourceList.this._focusItem) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (LWDataSourceList.this.isIndexSelected(this._index)) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            if (this.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
            }
            accessibleStateSet.add(AccessibleState.TRANSIENT);
            return accessibleStateSet;
        }

        public int getAccessibleIndexInParent() {
            return this._index;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() {
            return LWDataSourceList.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return LWDataSourceList.this.getBackground();
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            return LWDataSourceList.this.getForeground();
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            return Cursor.getDefaultCursor();
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return LWDataSourceList.this.getFont();
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return LWDataSourceList.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return LWDataSourceList.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            int n = LWDataSourceList.this.getFirstVisibleIndex();
            int n2 = n + LWDataSourceList.this._getRows();
            return this._index >= n && this._index < n2;
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return LWDataSourceList.this.isShowing() && this.isVisible();
        }

        public boolean contains(Point point) {
            int n = LWDataSourceList.this.getRowHeight();
            if (n == 0) {
                return false;
            }
            return point.y / n == this._index - LWDataSourceList.this.getFirstVisibleIndex();
        }

        public Point getLocationOnScreen() {
            Point point = LWDataSourceList.this.getLocationOnScreen();
            point.y += LWDataSourceList.this.getRowHeight() * (this._index - LWDataSourceList.this.getFirstVisibleIndex());
            return point;
        }

        public Point getLocation() {
            return new Point(0, LWDataSourceList.this.getRowHeight() * (this._index - LWDataSourceList.this.getFirstVisibleIndex()));
        }

        public void setLocation(Point point) {
            LWDataSourceList.this.makeVisible(this._index);
        }

        public Rectangle getBounds() {
            return new Rectangle(this.getLocation(), this.getSize());
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            return new Dimension(LWDataSourceList.this.getSize().width, LWDataSourceList.this.getRowHeight());
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void requestFocus() {
            LWDataSourceList.this.requestFocus();
            LWDataSourceList.this._focusItem = this._index;
            LWDataSourceList.this.makeVisible(this._index);
            LWDataSourceList.this.repaintInterior();
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }
    }

    private class Access
    extends AccessibleLWComponent
    implements AccessibleSelection {
        private ArrayOneDDataSource _children;

        public Access() {
            super(LWDataSourceList.this);
        }

        public void fireDataChanged() {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void fireSelectionChanged() {
            this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
        }

        public void fireActiveChanged(int n, int n2) {
            this.firePropertyChange("AccessibleActiveDescendant", n >= 0 ? this.getAccessibleChild(n) : null, n2 >= 0 ? this.getAccessibleChild(n2) : null);
        }

        public void clearCache() {
            if (this._children != null) {
                int n = this._children.getItemCount();
                if (n != 0) {
                    this._children.removeItems(0, n);
                }
                this._children = null;
            }
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (LWDataSourceList.this.isMultipleMode()) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = LWDataSourceList.this.getItemAt(point.y);
            if (n >= 0) {
                return this.getAccessibleChild(n);
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return LWDataSourceList.this.getItemCount();
        }

        public Accessible getAccessibleChild(int n) {
            int n2 = this.getAccessibleChildrenCount();
            if (n < 0 || n >= n2) {
                return null;
            }
            if (this._children == null) {
                this._children = new ArrayOneDDataSource(n2);
            }
            Object var3_3 = null;
            if (this._children.getData(n) == null) {
                this._children.setData(n, new Child(n));
            }
            return (Accessible)this._children.getData(n);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            return LWDataSourceList.this._selectCount;
        }

        public Accessible getAccessibleSelection(int n) {
            if (n < 0) {
                return null;
            }
            int[] nArray = LWDataSourceList.this.getSelectedIndexes();
            if (n >= nArray.length) {
                return null;
            }
            return this.getAccessibleChild(nArray[n]);
        }

        public boolean isAccessibleChildSelected(int n) {
            return LWDataSourceList.this.isIndexSelected(n);
        }

        public void addAccessibleSelection(int n) {
            if (!LWDataSourceList.this.isIndexSelected(n)) {
                int n2 = LWDataSourceList.this.isMultipleMode() ? -1 : LWDataSourceList.this.getSelectedIndex();
                LWDataSourceList.this.select(n);
                if (n2 != -1) {
                    LWDataSourceList.this._postItemEvent(LWDataSourceList.this.getItem(n2), 2);
                }
                LWDataSourceList.this._postItemEvent(LWDataSourceList.this.getItem(n), 1);
            }
        }

        public void removeAccessibleSelection(int n) {
            if (LWDataSourceList.this.isIndexSelected(n)) {
                LWDataSourceList.this.deselect(n);
                LWDataSourceList.this._postItemEvent(LWDataSourceList.this.getItem(n), 2);
            }
        }

        public void clearAccessibleSelection() {
            int[] nArray = LWDataSourceList.this.getSelectedIndexes();
            for (int i = 0; i < nArray.length; ++i) {
                this.removeAccessibleSelection(nArray[i]);
            }
        }

        public void selectAllAccessibleSelection() {
            if (LWDataSourceList.this.isMultipleMode()) {
                int n = LWDataSourceList.this.getItemCount();
                for (int i = 0; i < n; ++i) {
                    this.addAccessibleSelection(i);
                }
            }
        }
    }

    private class Content
    extends EwtComponent {
        private int _toBeDeselectedItem;
        private boolean _ignoreMouseReleased;
        private Adjustable _hAdjustable;
        private Adjustable _vAdjustable;
        private boolean _isthumbRightExtreme = true;
        private Adjust _adjustmentListener;

        public Content() {
            this.enableEvents(48L);
        }

        protected void updateReadingDirection(int n) {
            super.updateReadingDirection(n);
            Dimension dimension = this.getInnerSize();
            Rectangle rectangle = this.getCanvasBounds();
            this.setCanvasOrigin(dimension.width - rectangle.width - rectangle.x, rectangle.y);
        }

        public void doLayout() {
            super.doLayout();
            this.reconfigureScrolling();
        }

        public void reconfigureScrolling() {
            if (this.getActualReadingDirection() == 2) {
                boolean bl;
                if (this._adjustmentListener == null && this._hAdjustable != null) {
                    this._adjustmentListener = new Adjust();
                    this._hAdjustable.addAdjustmentListener(this._adjustmentListener);
                }
                Rectangle rectangle = this.getCanvasBounds();
                Dimension dimension = this.getInnerSize();
                Dimension dimension2 = this.layoutCanvas();
                boolean bl2 = this._hAdjustable == null ? false : (bl = this._hAdjustable.getValue() + this._hAdjustable.getVisibleAmount() == this._hAdjustable.getMaximum());
                if (this._isthumbRightExtreme || bl) {
                    this.setCanvasOrigin(-rectangle.width, rectangle.y);
                }
                this.setCanvasSize(dimension2.width, dimension2.height);
            } else {
                Dimension dimension = this.layoutCanvas();
                this.setCanvasSize(dimension.width, dimension.height);
            }
        }

        public void itemsRemoved(OneDDataSourceEvent oneDDataSourceEvent) {
            int n;
            int n2 = oneDDataSourceEvent.getStartIndex();
            int n3 = n2 + (n = oneDDataSourceEvent.getItemCount()) - 1;
            if (this._toBeDeselectedItem > n3) {
                this._toBeDeselectedItem -= n;
            } else if (this._toBeDeselectedItem >= n2 && this._toBeDeselectedItem <= n3) {
                this._toBeDeselectedItem = -1;
            }
        }

        public void itemsAdded(OneDDataSourceEvent oneDDataSourceEvent) {
            int n = oneDDataSourceEvent.getStartIndex();
            int n2 = oneDDataSourceEvent.getItemCount();
            if (this._toBeDeselectedItem >= n) {
                this._toBeDeselectedItem += n2;
            }
        }

        public boolean isHScrollable() {
            return true;
        }

        public boolean isVScrollable() {
            return true;
        }

        public void attachHAdjustable(Adjustable adjustable) {
            this._hAdjustable = adjustable;
        }

        public void attachVAdjustable(Adjustable adjustable) {
            this._vAdjustable = adjustable;
        }

        public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
            if (this._hAdjustable == adjustable) {
                if (this._adjustmentListener != null) {
                    this._hAdjustable.removeAdjustmentListener(this._adjustmentListener);
                    this._adjustmentListener = null;
                }
                this._hAdjustable = null;
            } else if (this._vAdjustable == adjustable) {
                this._vAdjustable = null;
            } else {
                super.detachAdjustable(adjustable);
            }
        }

        public Adjustable getHAdjustable() {
            return this._hAdjustable;
        }

        public Adjustable getVAdjustable() {
            return this._vAdjustable;
        }

        public Dimension getPreferredSize(int n) {
            return this.convertInnerToOuterSize(this._computeCanvasWidth(), LWDataSourceList.this.getRowHeight() * n);
        }

        public Dimension getPreferredSize() {
            return this.getPreferredSize(LWDataSourceList.this.getItemCount());
        }

        public Dimension getMinimumSize() {
            int n = LWDataSourceList.this.getRowHeight();
            if (n == 0) {
                n = 15;
            }
            return this.convertInnerToOuterSize(n, 8);
        }

        protected Dimension layoutCanvas() {
            int n = Math.max(this._computeCanvasWidth(), this.getInnerSize().width);
            return new Dimension(n, LWDataSourceList.this.getRowHeight() * LWDataSourceList.this.getItemCount());
        }

        protected void paintCanvasInterior(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4 = this.getCanvasSize().width;
            int n5 = LWDataSourceList.this.getItemCount();
            int n6 = LWDataSourceList.this.getRowHeight();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n7 = LWDataSourceList.this.getActualAlignment();
            int n8 = fontMetrics.getLeading() + fontMetrics.getAscent();
            UIDefaults uIDefaults = this.getUIDefaults();
            Color color = this.isEnabled() ? graphics.getColor() : uIDefaults.getColor(LookAndFeel.TEXT_INACTIVE_TEXT);
            ListUI listUI = LWDataSourceList.this.getListUI();
            Painter painter = listUI.getItemPainter(this);
            int n9 = listUI.getItemOutset(this);
            Rectangle rectangle = graphics.getClipBounds();
            int n10 = (rectangle.y - n9) / n6;
            if (n10 < 0) {
                n10 = 0;
            }
            int n11 = n3 = LWDataSourceList.this.hasGlobalFocus() ? LWDataSourceList.this._focusItem : -1;
            if (n3 < n10) {
                n3 = -1;
            }
            if (n3 > (n2 = (rectangle.y + rectangle.height + n9) / n6)) {
                n3 = -1;
            }
            n2 = Math.min(n2, LWDataSourceList.this.getItemCount() - 1);
            ItemCtxt itemCtxt = new ItemCtxt();
            for (n = n10; n <= n2; ++n) {
                if (n == n3 || LWDataSourceList.this.isIndexSelected(n)) continue;
                itemCtxt.setIndex(n);
                painter.paint(itemCtxt, graphics, 0, n * n6 - n9, n4, n6 + 2 * n9);
            }
            for (n = n10; n <= n2; ++n) {
                if (n == n3 || !LWDataSourceList.this.isIndexSelected(n)) continue;
                itemCtxt.setIndex(n);
                painter.paint(itemCtxt, graphics, 0, n * n6 - n9, n4, n6 + 2 * n9);
            }
            if (n3 != -1) {
                itemCtxt.setIndex(n3);
                if (!LWDataSourceList.this.isIndexSelected(n3)) {
                    Color color2 = graphics.getColor();
                    graphics.setColor(itemCtxt.getPaintBackground());
                    graphics.fillRect(0, n3 * n6 - n9, n4, n6 + 2 * n9);
                    graphics.setColor(color2);
                }
                painter.paint(itemCtxt, graphics, 0, n3 * n6 - n9, n4, n6 + 2 * n9);
            }
        }

        protected int getVMaximum() {
            int n;
            int n2 = LWDataSourceList.this.getRowHeight();
            if (n2 == 0) {
                n = 0;
            } else {
                Dimension dimension = this.getCanvasSize();
                n = dimension.height / n2;
                if (dimension.height % n2 != 0) {
                    ++n;
                }
            }
            return n;
        }

        protected int getVOffsetOfValue(int n) {
            return -n * LWDataSourceList.this.getRowHeight();
        }

        protected int getVValueOfOffset(int n) {
            int n2 = 0;
            int n3 = LWDataSourceList.this.getRowHeight();
            if (n3 != 0) {
                n2 = -n / n3;
                if (-n % n3 != 0) {
                    ++n2;
                }
            }
            return n2;
        }

        protected int getPaintState() {
            int n = super.getPaintState();
            if (LWDataSourceList.this.hasGlobalFocus()) {
                n |= 0x20;
            }
            return n;
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.isConsumed() || !this.isEnabled() || LWDataSourceList.this.getItemCount() == 0) {
                return;
            }
            if (!InputEventUtils.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n = mouseEvent.getID();
            if (n == 501) {
                this._processMousePressed(mouseEvent);
            } else if (n == 502) {
                this._processMouseReleased(mouseEvent);
            }
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
            if (mouseEvent.isConsumed() || !this.isEnabled()) {
                return;
            }
            int n = InputEventUtils.getMods(mouseEvent);
            if ((n & 4) != 0) {
                return;
            }
            int n2 = mouseEvent.getID();
            if (n2 == 506) {
                this._processMouseDragged(mouseEvent);
            }
        }

        int getContentItemAt(int n) {
            n = this.convertOuterToCanvas((int)0, (int)n).y;
            int n2 = LWDataSourceList.this.getRowHeight();
            int n3 = LWDataSourceList.this.getItemCount();
            int n4 = n / n2;
            if (n4 < 0) {
                n4 = -1;
            } else if (n4 >= n3) {
                n4 = n3 - 1;
            }
            return n4;
        }

        void _init() {
            this._toBeDeselectedItem = -1;
        }

        private void _processMousePressed(MouseEvent mouseEvent) {
            int n;
            if (LWDataSourceList.this.isFocusTraversable()) {
                LWDataSourceList.this.requestFocus();
            }
            if ((n = this.getContentItemAt(mouseEvent.getY())) == -1) {
                return;
            }
            mouseEvent.consume();
            String string = LWDataSourceList.this.getItem(n);
            int n2 = mouseEvent.getClickCount();
            this.freezeRepaints();
            boolean bl = LWDataSourceList.this.isMultipleMode() && LWDataSourceList.this._anchorItem != -1 && mouseEvent.isShiftDown();
            boolean bl2 = LWDataSourceList.this.isMultipleMode() && mouseEvent.isControlDown();
            this._ignoreMouseReleased = true;
            if (bl) {
                LWDataSourceList.this._extendSelection(n, bl2);
            } else if (bl2) {
                if (LWDataSourceList.this.isIndexSelected(n)) {
                    if (n2 == 1) {
                        LWDataSourceList.this.deselect(n);
                        LWDataSourceList.this._postItemEvent(LWDataSourceList.this.getItem(n), 2);
                        LWDataSourceList.this.accessibleSelectionChanged();
                    }
                } else {
                    LWDataSourceList.this.select(n);
                    LWDataSourceList.this._postItemEvent(LWDataSourceList.this.getItem(n), 1);
                    LWDataSourceList.this.accessibleSelectionChanged();
                    LWDataSourceList.this._anchorItem = n;
                }
            } else {
                this._ignoreMouseReleased = false;
                this._toBeDeselectedItem = LWDataSourceList.this.getSelectedIndex();
                if (LWDataSourceList.this._selectCount > 1) {
                    LWDataSourceList.this._selectItem(n);
                    this._toBeDeselectedItem = -1;
                } else if (!LWDataSourceList.this.isIndexSelected(n)) {
                    if (this._toBeDeselectedItem != n) {
                        --LWDataSourceList.this._selectCount;
                    }
                    LWDataSourceList.this._selectItem(n);
                }
            }
            LWDataSourceList.this._setFocusItem(n);
            if (n2 > 1 && n2 % 2 == 0) {
                LWDataSourceList.this._postActionEvent(string, mouseEvent);
            }
            this.unfreezeRepaints();
        }

        private void _processMouseDragged(MouseEvent mouseEvent) {
            int n = this.getContentItemAt(mouseEvent.getY());
            if (n == -1) {
                return;
            }
            this.freezeRepaints();
            LWDataSourceList.this.makeVisible(n);
            LWDataSourceList.this._setFocusItem(n);
            if (!this._ignoreMouseReleased) {
                LWDataSourceList.this.deselectAll();
                LWDataSourceList.this.select(n);
            }
            this.unfreezeRepaints();
            mouseEvent.consume();
        }

        private void _processMouseReleased(MouseEvent mouseEvent) {
            if (this._ignoreMouseReleased) {
                return;
            }
            int n = LWDataSourceList.this.getSelectedIndex();
            if (this._toBeDeselectedItem == -1 && n == -1) {
                return;
            }
            if (n != this._toBeDeselectedItem) {
                if (this._toBeDeselectedItem != -1) {
                    LWDataSourceList.this._postItemEvent(LWDataSourceList.this.getItem(this._toBeDeselectedItem), 2);
                }
                if (n != -1) {
                    LWDataSourceList.this._postItemEvent(LWDataSourceList.this.getItem(n), 1);
                }
                LWDataSourceList.this.accessibleSelectionChanged();
            }
            this._toBeDeselectedItem = -1;
            mouseEvent.consume();
        }

        private int _computeCanvasWidth() {
            int n = 0;
            Font font = this.getFont();
            if (font != null) {
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n2 = LWDataSourceList.this.getItemCount();
                if (n2 > 50 && !(LWDataSourceList.this.getDataSource() instanceof ArrayOneDDataSource)) {
                    n2 = 50;
                }
                n = fontMetrics.stringWidth("abcde");
                if (n2 > 0) {
                    ListUI listUI = LWDataSourceList.this.getListUI();
                    Painter painter = listUI.getItemPainter(this);
                    ItemCtxt itemCtxt = new ItemCtxt();
                    for (int i = 0; i < n2; ++i) {
                        itemCtxt.setIndex(i);
                        int n3 = painter.getPreferredSize((PaintContext)itemCtxt).width;
                        if (n >= n3) continue;
                        n = n3;
                    }
                }
            }
            return n;
        }

        private class Adjust
        implements AdjustmentListener {
            private Adjust() {
            }

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (Content.this._hAdjustable != null && Content.this._hAdjustable.getValue() + Content.this._hAdjustable.getVisibleAmount() == Content.this._hAdjustable.getMaximum()) {
                    Content.this._isthumbRightExtreme = true;
                } else {
                    Content.this._isthumbRightExtreme = false;
                }
            }
        }
    }

    private class ItemCtxt
    extends PaintContextProxy {
        private int _index;

        private ItemCtxt() {
        }

        public void setIndex(int n) {
            this._index = n;
        }

        public Object getPaintData(Object object) {
            if (PaintContext.LABEL_KEY.equals(object)) {
                return LWDataSourceList.this.getItem(this._index);
            }
            if (PaintContext.IMAGESET_KEY.equals(object)) {
                return LWDataSourceList.this.getImageSet(this._index);
            }
            return super.getPaintData(object);
        }

        public int getPaintState() {
            int n = super.getPaintState();
            if (LWDataSourceList.this.isIndexSelected(this._index)) {
                n |= 0x80;
            }
            if (LWDataSourceList.this.hasGlobalFocus() && this._index != LWDataSourceList.this._focusItem) {
                n &= 0xFFFFFFDF;
            }
            return n;
        }

        protected PaintContext getPaintContext() {
            return LWDataSourceList.this.getPaintContext();
        }
    }

    private class DSCheck
    implements OneDDataSourceListener,
    Task {
        private DSCheck() {
        }

        public void itemsAdded(OneDDataSourceEvent oneDDataSourceEvent) {
            int n = oneDDataSourceEvent.getStartIndex();
            int n2 = oneDDataSourceEvent.getItemCount();
            for (int i = 0; i < LWDataSourceList.this._selectCount; ++i) {
                int n3 = LWDataSourceList.this._selection[i];
                if (n3 < n) continue;
                LWDataSourceList.this._selection[i] = n3 + n2;
            }
            if (LWDataSourceList.this._focusItem >= n) {
                LWDataSourceList.this._focusItem += n2;
            }
            if (LWDataSourceList.this._anchorItem >= n) {
                LWDataSourceList.this._anchorItem += n2;
            }
            LWDataSourceList.this._content.itemsAdded(oneDDataSourceEvent);
            LWDataSourceList.this._repaintList();
            this._configureScrollingLater();
            LWDataSourceList.this.accessibleDataChanged();
        }

        public void itemsRemoved(OneDDataSourceEvent oneDDataSourceEvent) {
            int n;
            int n2 = oneDDataSourceEvent.getStartIndex();
            int n3 = oneDDataSourceEvent.getItemCount();
            int n4 = n2 + n3 - 1;
            for (n = 0; n < LWDataSourceList.this._selectCount; ++n) {
                int n5 = LWDataSourceList.this._selection[n];
                if (n5 > n4) {
                    LWDataSourceList.this._selection[n] = n5 - n3;
                    continue;
                }
                if (n5 < n2 || n5 > n4) continue;
                LWDataSourceList.this._selection[n] = -1;
            }
            LWDataSourceList.this._updateSelection();
            if (LWDataSourceList.this._focusItem > n4) {
                LWDataSourceList.this._focusItem -= n3;
            } else if (LWDataSourceList.this._focusItem >= n2 && LWDataSourceList.this._focusItem <= n4) {
                LWDataSourceList.this._focusItem = -1;
            }
            if (LWDataSourceList.this._anchorItem > n4) {
                LWDataSourceList.this._anchorItem -= n3;
            } else if (LWDataSourceList.this._anchorItem >= n2 && LWDataSourceList.this._anchorItem <= n4) {
                LWDataSourceList.this._anchorItem = -1;
            }
            n = LWDataSourceList.this.getFirstVisibleIndex();
            if (n > n4) {
                LWDataSourceList.this._setFirstVisibleIndex(Math.min(0, n - n3));
            } else if (n >= n2 && n <= n4) {
                LWDataSourceList.this._setFirstVisibleIndex(0);
            }
            LWDataSourceList.this._content.itemsRemoved(oneDDataSourceEvent);
            LWDataSourceList.this._repaintList();
            this._configureScrollingLater();
            LWDataSourceList.this.accessibleDataChanged();
        }

        public void invalidateItems(OneDDataSourceEvent oneDDataSourceEvent) {
            int n = oneDDataSourceEvent.getStartIndex();
            int n2 = n + oneDDataSourceEvent.getItemCount();
            int n3 = LWDataSourceList.this._getRows();
            int n4 = LWDataSourceList.this.getFirstVisibleIndex();
            int n5 = n4 + n3;
            if (n >= n4 && n <= n5 || n2 >= n4 && n2 <= n5 || n <= n4 && n2 >= n5) {
                LWDataSourceList.this.repaint();
            }
            LWDataSourceList.this.accessibleDataChanged();
        }

        public void runTask(TaskEvent taskEvent) {
            if (!FocusUtils.areNewFocusAPIsAvailable()) {
                EventQueueUtils.invokeLater(new Runnable(){

                    public void run() {
                        LWDataSourceList.this.reconfigureScrolling();
                    }
                });
            } else {
                LWDataSourceList.this.reconfigureScrolling();
            }
        }

        private void _configureScrollingLater() {
            if (LWDataSourceList.this.isShowing()) {
                TaskScheduler.getDefaultTaskScheduler().schedule(this, 10);
            }
        }
    }

    private class Adjust
    implements AdjustmentListener {
        private Adjust() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (LWDataSourceList.this.hasGlobalFocus() && LWDataSourceList.this.isFocusTraversable()) {
                LWDataSourceList.this._content.requestFocus();
            }
            LWDataSourceList.this._scrollToTop(adjustmentEvent.getValue());
        }
    }
}

