/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.awt.peer.LightweightPeer;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Stack;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.ColorScheme;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.UIManager;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.dnd.DropTarget;
import oracle.ewt.event.AnyEventListener;
import oracle.ewt.event.AnyEventMulticaster;
import oracle.ewt.help.HelpCapable;
import oracle.ewt.help.HelpProvider;
import oracle.ewt.layout.DirectionalLayout;
import oracle.ewt.lwAWT.BalkingDoubleBuffer;
import oracle.ewt.lwAWT.DoubleBuffer;
import oracle.ewt.lwAWT.DoubleBufferer;
import oracle.ewt.lwAWT.FocusRoot;
import oracle.ewt.lwAWT.ImmediatePainter;
import oracle.ewt.lwAWT.KeyProcessor;
import oracle.ewt.lwAWT.NullDoubleBuffer;
import oracle.ewt.lwAWT.SharedPainter;
import oracle.ewt.lwAWT.VirtualComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.popup.ToolTipManager;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;

public class LWComponent
extends Container
implements DoubleBufferer,
HelpCapable,
ImmediatePainter,
VirtualComponent,
KeyProcessor,
Accessible {
    public static final int MNEMONIC_INDEX_NONE = -1;
    public static final char MNEMONIC_CHAR_NONE = '\u0000';
    public static final BorderPainter DEFAULT_BORDERPAINTER = new NullPainter();
    public static final Painter DEFAULT_PAINTER = new NullPainter();
    public static final Color DEFAULT_COLOR = new Color(0);
    public static final Font DEFAULT_FONT = new Font("", 0, 0);
    private static boolean _needsRepaintFix;
    private static int _sInstanceCounter;
    private static LWComponent _sFocusedComponent;
    private static LWComponent _sMouseGrab;
    private static LWComponent _sMouseOver;
    private static LWComponent _sClickComp;
    private static DoubleBuffer _sDoubleBuffer;
    private static boolean _sDoubleBufferingEnabled;
    private static final String _TOOLTIP_VALUE = "_EWTToolTip";
    private static final String _HELP_TOPIC = "_EWTHelpTopic";
    private static final String _HELP_BOOK = "_EWTHelpBook";
    private static final String _HELP_PROVIDER = "_EWTHelpProvider";
    private static final String _POST_KEY_LISTENER = "_EWTPostKeyListener";
    private static final String _EWT_DROP_TARGET_KEY = "_EWTDropTarget";
    private static final Rectangle _EMPTY_RECTANGLE;
    private static final String _DEFAULT_NAME;
    private static HelpProvider _sDefaultHelpProvider;
    private transient SharedPainter _painter;
    private AnyEventListener _anyListener;
    private Stack _preKeyListeners = new Stack();
    private Object[] _properties;
    transient Rectangle __bounds = _EMPTY_RECTANGLE;
    private transient ComponentUI _ui;
    private transient PaintContext _paintContext;
    private transient PaintContext _borderContext;
    private transient LookAndFeel _lookAndFeel;
    private int _readingDirection = -1;
    private int _alignment = -1;
    private boolean _isLocaleDefaulted = true;
    private boolean _isReadingDirectionDefaulted = true;
    private boolean _isAlignmentDefaulted = true;
    private Object _mnemonic;
    private ColorScheme _colorScheme;
    private transient AccessibleContext _accessibleContext;
    private transient boolean _buffered;
    private transient Object _clientPropLock = new Object();

    public LWComponent() {
        this._lookAndFeel = UIManager.getLookAndFeel();
        this.setName(_DEFAULT_NAME);
        this._painter = new SharedPainter(this, DEFAULT_PAINTER);
        this.enableEvents(48L);
        this.enableEvents(4L);
        this.updateReadingDirection(LocaleUtils.getReadingDirectionForLocale(Locale.getDefault()));
        super.setFont(DEFAULT_FONT);
        super.setForeground(DEFAULT_COLOR);
        super.setBackground(DEFAULT_COLOR);
        this.updateUI(LWComponent.class);
    }

    public void setLookAndFeel(LookAndFeel lookAndFeel) {
        if (lookAndFeel == null) {
            lookAndFeel = UIManager.getLookAndFeel();
        }
        if (lookAndFeel != this.getLookAndFeel()) {
            this._lookAndFeel = lookAndFeel;
            if (this._colorScheme != null) {
                this._colorScheme = lookAndFeel.getColorScheme(this._colorScheme);
            }
            this.updateUI(lookAndFeel);
        }
    }

    public LookAndFeel getLookAndFeel() {
        return this._lookAndFeel;
    }

    public BorderPainter getBorderPainter() {
        ComponentUI componentUI = this.getUI();
        if (componentUI != null) {
            return componentUI.getDefaultBorderPainter(this);
        }
        return null;
    }

    public void setMnemonicIndex(int n) {
        if (n != this.getMnemonicIndex()) {
            this._mnemonic = n != -1 ? IntegerUtils.getInteger((int)n) : null;
            this.repaint();
        }
    }

    public void setMnemonicChar(char c) {
        if (c != this.getMnemonicChar()) {
            this._mnemonic = c != '\u0000' ? new Character(c) : null;
            this.repaint();
        }
    }

    public int getMnemonicIndex() {
        if (this._mnemonic != null) {
            int n;
            if (this._mnemonic instanceof Integer) {
                return (Integer)this._mnemonic;
            }
            String string = this.getMnemonicString();
            if (string != null && (n = string.indexOf(((Character)this._mnemonic).charValue())) != -1) {
                return n;
            }
        }
        return -1;
    }

    public char getMnemonicChar() {
        if (this._mnemonic != null) {
            int n;
            if (this._mnemonic instanceof Character) {
                return ((Character)this._mnemonic).charValue();
            }
            String string = this.getMnemonicString();
            if (string != null && (n = ((Integer)this._mnemonic).intValue()) < string.length()) {
                return string.charAt(n);
            }
        }
        return '\u0000';
    }

    protected void updateUI(Class clazz) {
        this.updateUI();
    }

    protected final void updateUI() {
        this.updateUI(this.getLookAndFeel());
    }

    protected void updateUI(LookAndFeel lookAndFeel) {
        this.setUI(lookAndFeel.getDefaults(this.getPaintContext()).getUI(this));
    }

    protected void setUI(ComponentUI componentUI) {
        boolean bl;
        boolean bl2 = bl = this.getPeer() != null;
        if (this._ui != null) {
            if (bl) {
                this._ui.componentRemoveNotify(this);
            }
            this._ui.uninstallUI(this);
        }
        this._ui = componentUI;
        if (componentUI != null) {
            componentUI.installUI(this);
            if (bl) {
                componentUI.componentAddNotify(this);
                this.invalidate();
                this.repaint();
            }
        }
    }

    public ComponentUI getUI() {
        return this._ui;
    }

    public Object getUIClassID() {
        return "ComponentUI";
    }

    public final UIDefaults getUIDefaults() {
        return this.getPaintContext().getPaintUIDefaults();
    }

    public boolean isActive() {
        Container container = this.getParent();
        if (container instanceof VirtualComponent) {
            return ((VirtualComponent)((Object)container)).isActive();
        }
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected String getMnemonicString() {
        return (String)this.getPaintData(PaintContext.LABEL_KEY);
    }

    protected int getPaintState() {
        int n = 0;
        if (!this.isEnabled()) {
            n |= 1;
        }
        if (!this.isActive()) {
            n |= 4;
        }
        if (_sMouseOver == this) {
            n |= 0x10;
        }
        if (this.hasGlobalFocus()) {
            n |= 0x20;
        }
        return n;
    }

    protected Object getPaintData(Object object) {
        if (object == ComponentUI.MNEMONIC_INDEX_KEY && this._mnemonic != null) {
            if (this._mnemonic instanceof Integer) {
                return this._mnemonic;
            }
            return IntegerUtils.getInteger((int)this.getMnemonicIndex());
        }
        return null;
    }

    protected float getInteriorAlignmentX() {
        switch (this.getActualAlignment()) {
            case 1: {
                return 0.0f;
            }
            case 2: {
                return 1.0f;
            }
        }
        return 0.5f;
    }

    protected float getInteriorAlignmentY() {
        return 0.5f;
    }

    public synchronized void addAnyEventListener(AnyEventListener anyEventListener) {
        this._anyListener = AnyEventMulticaster.add(this._anyListener, anyEventListener);
    }

    public synchronized void removeAnyEventListener(AnyEventListener anyEventListener) {
        this._anyListener = AnyEventMulticaster.remove(this._anyListener, anyEventListener);
    }

    public void setFill(Painter painter) {
        this._painter.setFill(painter);
    }

    public Painter getFill() {
        return this._painter.getFill();
    }

    public final boolean isTransparent() {
        return this.isInteriorTransparent() || this.isBorderTransparent();
    }

    public boolean isInteriorTransparent() {
        return this.getFill().isTransparent(this.getPaintContext());
    }

    public boolean isBorderTransparent() {
        BorderPainter borderPainter = this.getBorderPainter();
        if (borderPainter != null) {
            return borderPainter.isTransparent(this.getBorderContext());
        }
        return false;
    }

    public boolean isPaintPropagationRequired(int n, int n2, int n3, int n4) {
        if (this.isInteriorTransparent() || this.isClippedBySibling()) {
            return true;
        }
        ImmInsets immInsets = this.getBorderInsets();
        return immInsets != ImmInsets.getEmptyInsets() && this.isBorderTransparent() && (n < immInsets.left || n2 < immInsets.top || n + n3 > this.__bounds.width - immInsets.right || n2 + n4 > this.__bounds.height - immInsets.bottom);
    }

    public boolean isClippedBySibling() {
        return this._painter.isClippedBySibling();
    }

    public boolean isChildClipped(Component component) {
        return this._painter.isChildClipped(component);
    }

    public final Insets insets() {
        return this.getBorderInsets().toInsets();
    }

    public final Insets getInsets() {
        return this.getBorderInsets().toInsets();
    }

    public final ImmInsets getBorderInsets() {
        BorderPainter borderPainter = this.getBorderPainter();
        if (borderPainter != null) {
            return borderPainter.getInsets(this.getPaintContext());
        }
        return ImmInsets.getEmptyInsets();
    }

    public void freezeRepaints() {
        this._painter.freezeRepaints();
    }

    public void unfreezeRepaints() {
        this._painter.unfreezeRepaints(this.getDoubleBuffer());
    }

    public final void paintImmediate() {
        this.paintImmediate(0, 0, this.__bounds.width, this.__bounds.height);
    }

    public void paintImmediate(int n, int n2, int n3, int n4) {
        if (this.isShowing()) {
            this._painter.paintImmediateClipped(n, n2, n3, n4, this, this.getDoubleBuffer());
        }
    }

    public void paintImmediateUnclipped(int n, int n2, int n3, int n4) {
        this._painter.paintImmediate(n, n2, n3, n4, this, this.getDoubleBuffer());
    }

    public final void paintImmediateInterior() {
        ImmInsets immInsets = this.getBorderInsets();
        this.paintImmediate(immInsets.left, immInsets.top, this.__bounds.width - immInsets.left - immInsets.right, this.__bounds.height - immInsets.top - immInsets.bottom);
    }

    public final void paintImmediateInterior(int n, int n2, int n3, int n4) {
        ImmInsets immInsets = this.getBorderInsets();
        this.paintImmediate(n + immInsets.left, n2 + immInsets.top, n3, n4);
    }

    public final void repaintInterior() {
        ImmInsets immInsets = this.getBorderInsets();
        this.repaint(immInsets.left, immInsets.top, this.__bounds.width - immInsets.left - immInsets.right, this.__bounds.height - immInsets.top - immInsets.bottom);
    }

    public final void repaintInterior(int n, int n2, int n3, int n4) {
        ImmInsets immInsets = this.getBorderInsets();
        this.repaint(n + immInsets.left, n2 + immInsets.top, n3, n4);
    }

    public final Point convertOuterToInterior(int n, int n2) {
        ImmInsets immInsets = this.getBorderInsets();
        return new Point(n - immInsets.left, n2 - immInsets.top);
    }

    public final Point convertInteriorToOuter(int n, int n2) {
        ImmInsets immInsets = this.getBorderInsets();
        return new Point(n + immInsets.left, n2 + immInsets.top);
    }

    final Dimension convertInnerToOuterSize(Dimension dimension) {
        ImmInsets immInsets = this.getBorderInsets();
        dimension.width += immInsets.left + immInsets.right;
        dimension.height += immInsets.top + immInsets.bottom;
        return dimension;
    }

    public final Dimension convertInnerToOuterSize(int n, int n2) {
        return this.convertInnerToOuterSize(new Dimension(n, n2));
    }

    public final int getInnerWidth() {
        int n = this.__bounds.width;
        ImmInsets immInsets = this.getBorderInsets();
        if ((n -= immInsets.left + immInsets.right) < 0) {
            n = 0;
        }
        return n;
    }

    public final int getInnerHeight() {
        int n = this.__bounds.height;
        ImmInsets immInsets = this.getBorderInsets();
        if ((n -= immInsets.top + immInsets.bottom) < 0) {
            n = 0;
        }
        return n;
    }

    public final Dimension getInnerSize() {
        int n = this.__bounds.width;
        int n2 = this.__bounds.height;
        ImmInsets immInsets = this.getBorderInsets();
        n2 -= immInsets.top + immInsets.bottom;
        if ((n -= immInsets.left + immInsets.right) < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return new Dimension(n, n2);
    }

    public final Point getInnerOrigin() {
        ImmInsets immInsets = this.getBorderInsets();
        return new Point(immInsets.left, immInsets.top);
    }

    public final Rectangle getInnerBounds() {
        ImmInsets immInsets = this.getBorderInsets();
        return new Rectangle(immInsets.left, immInsets.top, this.__bounds.width - immInsets.left - immInsets.right, this.__bounds.height - immInsets.top - immInsets.bottom);
    }

    public final boolean hasFocus() {
        return this.hasGlobalFocus();
    }

    public final boolean hasGlobalFocus() {
        return this == LWComponent.getFocusedComponent();
    }

    public final boolean hasWindowFocus() {
        FocusRoot focusRoot;
        if (this.hasGlobalFocus()) {
            return true;
        }
        if (!this.isActive() && (focusRoot = this._getFocusRoot()) != null) {
            return this == focusRoot.getRootFocusOwner();
        }
        return false;
    }

    public static LWComponent getFocusedComponent() {
        return _sFocusedComponent;
    }

    public void setToolTipValue(String string) {
        this._setToolTipValue(string);
    }

    public void setToolTipValue(ToolTipClient toolTipClient) {
        this._setToolTipValue(toolTipClient);
    }

    public Object getToolTipValue() {
        return this.getClientProperty(_TOOLTIP_VALUE);
    }

    public String getHelpTopic() {
        HelpCapable helpCapable;
        Object object = this.getClientProperty(_HELP_TOPIC);
        if (object != null && object instanceof String) {
            return (String)object;
        }
        if (this.getClientProperty(_HELP_BOOK) == null && this.getClientProperty(_HELP_PROVIDER) == null && (helpCapable = LWComponent._getParentHelpCapable(this)) != null) {
            return helpCapable.getHelpTopic();
        }
        return null;
    }

    public void setHelpTopic(String string) {
        this.putClientProperty(_HELP_TOPIC, string);
    }

    public Object getHelpBook() {
        HelpCapable helpCapable;
        Object object = this.getClientProperty(_HELP_BOOK);
        if (object != null) {
            return object;
        }
        if (this.getClientProperty(_HELP_PROVIDER) == null && (helpCapable = LWComponent._getParentHelpCapable(this)) != null) {
            return helpCapable.getHelpBook();
        }
        return null;
    }

    public void setHelpBook(Object object) {
        this.putClientProperty(_HELP_BOOK, object);
    }

    public HelpProvider getHelpProvider() {
        Object object = this.getClientProperty(_HELP_PROVIDER);
        if (object != null && object instanceof HelpProvider) {
            return (HelpProvider)object;
        }
        HelpProvider helpProvider = null;
        HelpCapable helpCapable = LWComponent._getParentHelpCapable(this);
        if (helpCapable != null) {
            helpProvider = helpCapable.getHelpProvider();
        }
        if (helpProvider == null) {
            helpProvider = LWComponent.getDefaultHelpProvider();
        }
        return helpProvider;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.putClientProperty(_HELP_PROVIDER, helpProvider);
    }

    public static HelpProvider getDefaultHelpProvider() {
        return _sDefaultHelpProvider;
    }

    public static void setDefaultHelpProvider(HelpProvider helpProvider) {
        _sDefaultHelpProvider = helpProvider;
    }

    public void showHelp() {
        this._painter.showHelp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putClientProperty(Object object, Object object2) {
        if (object2 == null) {
            this.removeClientProperty(object);
        }
        Object object3 = this._clientPropLock;
        synchronized (object3) {
            Object[] objectArray = this._properties;
            if (objectArray == null) {
                this._properties = new Object[]{object, object2};
                return;
            }
            int n = this._getClientPropertyIndex(object);
            if (n >= 0) {
                objectArray[n * 2 + 1] = object2;
            } else {
                int n2 = objectArray.length;
                Object[] objectArray2 = new Object[n2 + 2];
                System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                objectArray2[n2] = object;
                objectArray2[n2 + 1] = object2;
                this._properties = objectArray2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeClientProperty(Object object) {
        Object object2 = this._clientPropLock;
        synchronized (object2) {
            int n = this._getClientPropertyIndex(object);
            if (n >= 0) {
                Object[] objectArray = this._properties;
                int n2 = objectArray.length;
                Object[] objectArray2 = new Object[n2 - 2];
                System.arraycopy(objectArray, 0, objectArray2, 0, 2 * n);
                System.arraycopy(objectArray, 2 * n + 2, objectArray2, 2 * n, n2 - (2 * n + 2));
                this._properties = objectArray2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getClientProperty(Object object) {
        Object object2 = this._clientPropLock;
        synchronized (object2) {
            int n = this._getClientPropertyIndex(object);
            if (n >= 0) {
                return this._properties[2 * n + 1];
            }
            return null;
        }
    }

    public void clipToParents(Rectangle rectangle) {
        this._painter._clipToParents(rectangle);
    }

    public void addPreKeyListener(KeyListener keyListener) {
        this._preKeyListeners.push(keyListener);
    }

    public void removePreKeyListener(KeyListener keyListener) {
        this._preKeyListeners.removeElement(keyListener);
    }

    public void addPostKeyListener(KeyListener keyListener) {
        this.putClientProperty(_POST_KEY_LISTENER, AWTEventMulticaster.add(this._getPostKeyListener(), keyListener));
    }

    public void removePostKeyListener(KeyListener keyListener) {
        this.putClientProperty(_POST_KEY_LISTENER, AWTEventMulticaster.remove(this._getPostKeyListener(), keyListener));
    }

    public void postProcessKey(KeyEvent keyEvent) {
        KeyListener keyListener;
        if (keyEvent.isConsumed()) {
            return;
        }
        int n = keyEvent.getID();
        if (keyEvent.getSource() == this && n == 402) {
            switch (keyEvent.getKeyCode()) {
                case 112: {
                    if (InputEventUtils.isOnlyControlDown(keyEvent) && this.getToolTipValue() != null) {
                        ToolTipManager.getToolTipManager().show(this);
                        keyEvent.consume();
                        return;
                    }
                }
                case 156: {
                    if (!this._hasHelp() || InputEventUtils.getMods(keyEvent) == 3) break;
                    this.showHelp();
                    keyEvent.consume();
                    return;
                }
            }
        }
        if ((keyListener = this._getPostKeyListener()) != null) {
            switch (n) {
                case 401: {
                    keyListener.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    keyListener.keyReleased(keyEvent);
                    break;
                }
                case 400: {
                    keyListener.keyTyped(keyEvent);
                }
            }
        }
    }

    static void __postProcessKeyInWindow(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            Component component = null;
            for (Component component2 = keyEvent.getComponent(); component2 != null; component2 = component2.getParent()) {
                if (component2 instanceof KeyProcessor) {
                    ((KeyProcessor)((Object)component2)).postProcessKey(keyEvent);
                }
                if (keyEvent.isConsumed()) {
                    return;
                }
                if (component2 instanceof Container) {
                    LWComponent._postProcessChildren((Container)component2, component, keyEvent);
                }
                if (keyEvent.isConsumed()) {
                    return;
                }
                if (component2 instanceof Window) break;
                component = component2;
            }
        }
    }

    public void setEWTDropTarget(DropTarget dropTarget) {
        block9: {
            block8: {
                block10: {
                    DropTarget dropTarget2 = this.getEWTDropTarget();
                    if (dropTarget2 == dropTarget) break block9;
                    if (dropTarget2 != null) {
                        try {
                            dropTarget2.setComponent(null);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if (dropTarget == null) break block10;
                    try {
                        dropTarget.setComponent(this);
                        this.putClientProperty(_EWT_DROP_TARGET_KEY, dropTarget);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (dropTarget2 == null) break block8;
                        try {
                            dropTarget2.setComponent(this);
                            break block8;
                        }
                        catch (IllegalArgumentException illegalArgumentException2) {}
                    }
                    break block8;
                }
                this.removeClientProperty(_EWT_DROP_TARGET_KEY);
            }
            if (dropTarget != null) {
                dropTarget.setComponent(this);
            }
        }
    }

    public DropTarget getEWTDropTarget() {
        return (DropTarget)this.getClientProperty(_EWT_DROP_TARGET_KEY);
    }

    public ColorScheme getColorScheme() {
        return this._colorScheme;
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this._setColorScheme(colorScheme, true);
    }

    public final boolean contains(int n, int n2) {
        int n3 = this.__bounds.width;
        int n4 = this.__bounds.height;
        ImmInsets immInsets = this.getBorderInsets();
        if (immInsets != ImmInsets.getEmptyInsets()) {
            BorderPainter borderPainter = this.getBorderPainter();
            if (borderPainter != null && borderPainter.contains(this.getPaintContext(), n3, n4, n, n2)) {
                return true;
            }
            if (this.getComponentCount() == 0) {
                n -= immInsets.left;
                n2 -= immInsets.top;
                n3 -= immInsets.left + immInsets.right;
                n4 -= immInsets.top + immInsets.bottom;
            }
        }
        return this.interiorContains(n, n2, n3, n4);
    }

    public void removeNotify() {
        this._painter.clearClipCache();
        boolean bl = false;
        LWComponent lWComponent = LWComponent.getFocusedComponent();
        if (this._isParentOf(lWComponent)) {
            _sFocusedComponent = null;
            bl = true;
        }
        super.removeNotify();
        if (bl) {
            this.transferFocus();
            if (_sFocusedComponent == null) {
                _sFocusedComponent = lWComponent;
            }
        }
        this.getUI().componentRemoveNotify(this);
        if (this.getToolTipValue() != null) {
            ToolTipManager.getToolTipManager().leaveLater(this);
        }
    }

    public void hide() {
        boolean bl = this.isVisible();
        if (bl) {
            Rectangle rectangle;
            super.hide();
            Container container = this.getParent();
            if (container != null && (rectangle = this.__bounds) != _EMPTY_RECTANGLE) {
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (this._isParentOf(LWComponent.getFocusedComponent())) {
                this.transferFocus();
            }
            if (this.getToolTipValue() != null) {
                ToolTipManager.getToolTipManager().leave(this);
            }
        }
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        super.setVisible(bl);
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null && bl2 != bl) {
            accessibleContext.firePropertyChange("AccessibleState", bl ? null : AccessibleState.VISIBLE, bl ? AccessibleState.VISIBLE : null);
        }
    }

    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.invalidateAndRepaintIfNecessary(1);
        }
    }

    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            if (this.hasWindowFocus()) {
                this.transferFocus();
            }
            this.invalidateAndRepaintIfNecessary(1);
        }
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = bl;
        super.setEnabled(bl);
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null && bl2 != bl) {
            accessibleContext.firePropertyChange("AccessibleState", bl ? AccessibleState.ENABLED : null, bl ? null : AccessibleState.ENABLED);
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.isVisible() && this.getParent() != null && this._painter.repaint(n, n2, n3, n4)) {
            Rectangle rectangle = this.__bounds;
            Rectangle rectangle2 = new Rectangle(n + rectangle.x, n2 + rectangle.y, n3, n4);
            SharedPainter.__intersectRect(rectangle2, rectangle2, rectangle);
            if (rectangle2.width > 0 && rectangle2.height > 0) {
                super.repaint(l, rectangle2.x - rectangle.x, rectangle2.y - rectangle.y, rectangle2.width, rectangle2.height);
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this._paintComponent(graphics, LWComponent.isDoubleBuffered(this));
    }

    public void print(Graphics graphics) {
        this.__setBuffered(true);
        this._paintComponent(graphics, true);
        this.__setBuffered(false);
    }

    public void printAll(Graphics graphics) {
        this.print(graphics);
    }

    public void printPage(PaintContext paintContext, Dictionary dictionary, Graphics graphics) {
        this.print(graphics);
    }

    public Dimension getDocumentSize(PaintContext paintContext, Dictionary dictionary) {
        return this.getSize();
    }

    public Rectangle getPageBounds(PaintContext paintContext, Dictionary dictionary, int n, int n2, int n3, int n4) {
        return new Rectangle(n3, n4, n3, n4);
    }

    public void paintInterior(Graphics graphics) {
    }

    public void paintAll(Graphics graphics) {
        if (this.isVisible()) {
            this.paint(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reshape(int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = this.__bounds.x;
        int n6 = this.__bounds.y;
        int n7 = this.__bounds.width;
        int n8 = this.__bounds.height;
        boolean bl2 = false;
        boolean bl3 = bl = n7 != n3 || n8 != n4;
        if (bl && (this.getRepaintFlags() & 0x80) != 0) {
            bl2 = true;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.__bounds == _EMPTY_RECTANGLE) {
                this.__bounds = new Rectangle(n, n2, n3, n4);
            } else {
                this.__bounds.setBounds(n, n2, n3, n4);
            }
            super.reshape(n, n2, n3, n4);
        }
        if (bl2 && !_needsRepaintFix) {
            this.repaint();
        } else if (_needsRepaintFix && bl && this.getParent() != null) {
            object = new Rectangle(n5, n6, n7, n8);
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            Rectangle rectangle2 = rectangle.union((Rectangle)object);
            this.getParent().repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    public void setBackground(Color color) {
        Color color2 = super.getBackground();
        if (color2 != color) {
            Painter painter;
            super.setBackground(color);
            if (color != DEFAULT_COLOR && (painter = this.getFill()) == DEFAULT_PAINTER) {
                UIDefaults uIDefaults = this.getUIDefaults();
                painter = uIDefaults != null ? uIDefaults.getPainter(LookAndFeel.BACKGROUND_PAINTER) : UIManager.getPainter(LookAndFeel.BACKGROUND_PAINTER);
                this.setFill(painter);
            }
            this.invalidateAndRepaintIfNecessary(1024);
        }
    }

    public Color getBackground() {
        Container container;
        ComponentUI componentUI;
        Color color = super.getBackground();
        if (color == DEFAULT_COLOR && (componentUI = this.getUI()) != null && (color = componentUI.getDefaultBackground(this)) == null && (container = this.getParent()) != null) {
            color = container.getBackground();
        }
        return color;
    }

    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        super.setForeground(color);
        if (color2 != this.getForeground()) {
            this.invalidateAndRepaintIfNecessary(512);
        }
    }

    public Color getForeground() {
        Color color = super.getForeground();
        if (color == DEFAULT_COLOR) {
            ComponentUI componentUI = this.getUI();
            if (componentUI != null) {
                Container container;
                color = componentUI.getDefaultForeground(this);
                if (color == null && (container = this.getParent()) != null) {
                    color = container.getForeground();
                }
            } else {
                color = null;
            }
        }
        return color;
    }

    public String getName() {
        String string = super.getName();
        if (string == _DEFAULT_NAME) {
            string = this.getDefaultName();
            this.setName(string);
        }
        return string;
    }

    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        if (graphics != null) {
            graphics.setFont(this.getFont());
            graphics.setColor(this.getForeground());
        }
        return graphics;
    }

    public void setLocale(Locale locale) {
        Locale locale2 = LocaleUtils.getDefaultableLocale(this);
        Locale locale3 = locale;
        if (locale == null) {
            this._isLocaleDefaulted = true;
            Container container = this.getParent();
            if (container != null) {
                locale3 = LocaleUtils.getDefaultableLocale(container);
            }
        } else {
            this._isLocaleDefaulted = false;
        }
        if (!locale3.equals(locale2)) {
            this._updateLocale(locale3, locale2, true);
        } else {
            super.setLocale(locale);
        }
    }

    public void setReadingDirection(int n) {
        this._setReadingDirection(n, true);
    }

    public int getReadingDirection() {
        if (this._isReadingDirectionDefaulted) {
            return 0;
        }
        return this._readingDirection;
    }

    public int getActualReadingDirection() {
        return this._readingDirection;
    }

    public void setAlignment(int n) {
        if (n == 0) {
            this._isAlignmentDefaulted = true;
            n = LocaleUtils.getAlignmentForReadingDirection(this.getActualReadingDirection());
        } else {
            this._isAlignmentDefaulted = false;
        }
        if (n != this._alignment) {
            this.updateAlignment(n);
        }
    }

    public int getAlignment() {
        if (this._isAlignmentDefaulted) {
            return 0;
        }
        return this._alignment;
    }

    public int getActualAlignment() {
        return this._alignment;
    }

    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        if (font2 != this.getFont()) {
            this.invalidateAndRepaintIfNecessary(256);
        }
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == DEFAULT_FONT) {
            ComponentUI componentUI = this.getUI();
            if (componentUI != null) {
                Container container;
                font = componentUI.getDefaultFont(this);
                if (font == null && (container = this.getParent()) != null) {
                    font = container.getFont();
                }
            } else {
                font = null;
            }
        }
        return font;
    }

    protected boolean isLocaleDefaulted() {
        return this._isLocaleDefaulted;
    }

    protected boolean isReadingDirectionDefaulted() {
        return this._isReadingDirectionDefaulted;
    }

    protected void updateLocale(Locale locale, Locale locale2) {
        super.setLocale(locale);
        if (this._isReadingDirectionDefaulted) {
            this._setReadingDirection(0, false);
        }
        this._painter.propagateLocale(locale, locale2);
    }

    protected void updateReadingDirection(int n) {
        this._readingDirection = n;
        this.invalidateAndRepaintIfNecessary(16384);
        if (this._isAlignmentDefaulted) {
            this.setAlignment(0);
        }
    }

    void propagateReadingDirection(int n) {
        this._painter.propagateReadingDirection(n);
    }

    protected void updateAlignment(int n) {
        this._alignment = n;
        this.invalidateAndRepaintIfNecessary(2048);
    }

    public void addNotify() {
        super.addNotify();
        if (this._isLocaleDefaulted) {
            Locale locale = LocaleUtils.getDefaultableLocale(this);
            this._updateLocale(locale, Locale.getDefault(), false);
        }
        if (this.getColorScheme() == null) {
            this._setColorScheme(null, false);
        }
        this.getUI().componentAddNotify(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        Component component;
        Object object = this.getTreeLock();
        synchronized (object) {
            component = this.getComponent(n);
            if (!(component.getPeer() instanceof LightweightPeer)) {
                component = null;
            }
            super.remove(n);
            this._painter.remove(n);
        }
        if (component != null && component.isVisible()) {
            object = component.getBounds();
            this.repaint(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Rectangle rectangle;
        Object object = this.getTreeLock();
        synchronized (object) {
            rectangle = LWComponent._getLWChildBounds(this);
            super.removeAll();
            this._painter.removeAll();
        }
        if (rectangle != null) {
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void invalidate() {
        if (this.isValid()) {
            if (this._painter != null) {
                this._painter.clearClipCache();
            }
            super.invalidate();
        }
    }

    public void doLayout() {
        this._painter.clearClipCache();
        super.doLayout();
    }

    public void redispatchEvent(AWTEvent aWTEvent) {
        Object object;
        if (aWTEvent instanceof KeyEvent) {
            object = (KeyEvent)aWTEvent;
            Enumeration enumeration = this._preKeyListeners.elements();
            while (enumeration.hasMoreElements()) {
                KeyListener keyListener = (KeyListener)enumeration.nextElement();
                switch (((AWTEvent)object).getID()) {
                    case 401: {
                        keyListener.keyPressed((KeyEvent)object);
                        break;
                    }
                    case 402: {
                        keyListener.keyReleased((KeyEvent)object);
                        break;
                    }
                    case 400: {
                        keyListener.keyTyped((KeyEvent)object);
                    }
                }
            }
        }
        if ((object = this._anyListener) != null) {
            object.processEventStart(aWTEvent);
        }
        this.processEventImpl(aWTEvent);
        if (aWTEvent instanceof KeyEvent) {
            LWComponent.__postProcessKeyInWindow((KeyEvent)aWTEvent);
            if (aWTEvent.getID() == 401) {
                ToolTipManager.getToolTipManager().hide();
            }
        }
        if (object != null) {
            object.processEventEnd(aWTEvent);
        }
    }

    protected boolean interiorContains(int n, int n2, int n3, int n4) {
        return this.pointInInterior(n, n2, n3, n4);
    }

    protected final boolean pointInInterior(int n, int n2, int n3, int n4) {
        return n >= 0 && n2 >= 0 && n < n3 && n2 < n4;
    }

    protected final boolean pointIsInChild(int n, int n2) {
        int n3 = this.getComponentCount();
        for (int i = n3 - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (component == null) continue;
            Point point = component.getLocation();
            if (!component.contains(n - point.x, n2 - point.y)) continue;
            return true;
        }
        return false;
    }

    protected final void processEvent(AWTEvent aWTEvent) {
        int n;
        Serializable serializable;
        Serializable serializable2;
        if (aWTEvent instanceof KeyEvent && !this.hasGlobalFocus()) {
            serializable2 = (KeyEvent)aWTEvent;
            serializable = LWComponent.getFocusedComponent();
            if (serializable != null) {
                ((LWComponent)serializable).redispatchEvent(new KeyEvent((Component)serializable, ((AWTEvent)serializable2).getID(), ((InputEvent)serializable2).getWhen(), ((InputEvent)serializable2).getModifiers(), ((KeyEvent)serializable2).getKeyCode(), ((KeyEvent)serializable2).getKeyChar()));
                ((InputEvent)serializable2).consume();
                return;
            }
        }
        serializable2 = null;
        if (aWTEvent instanceof MouseEvent && ((n = ((AWTEvent)(serializable = (MouseEvent)aWTEvent)).getID()) == 501 || n == 500 || n == 506 || n == 502)) {
            if (n == 501) {
                _sMouseGrab = _sClickComp = this;
            } else if (n == 500) {
                if (this != _sClickComp) {
                    return;
                }
            } else if (n == 502 || n == 506) {
                LWComponent lWComponent = _sMouseGrab;
                if (lWComponent == null) {
                    return;
                }
                if (lWComponent != this) {
                    Point point = this._translatePoint(this, lWComponent, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
                    serializable2 = serializable;
                    serializable = new MouseEvent(lWComponent, n, ((InputEvent)serializable).getWhen(), ((InputEvent)serializable).getModifiers(), point.x, point.y, ((MouseEvent)serializable).getClickCount(), ((MouseEvent)serializable).isPopupTrigger());
                    lWComponent.redispatchEvent((AWTEvent)serializable);
                    if (((InputEvent)serializable).isConsumed()) {
                        ((InputEvent)serializable2).consume();
                    }
                    return;
                }
                if (n == 502) {
                    _sMouseGrab = null;
                }
            }
            int n2 = ((InputEvent)serializable).getModifiers();
            if ((n2 & 0xFFFFFFFC) == 0) {
                serializable2 = serializable;
                aWTEvent = new MouseEvent(this, n, ((InputEvent)serializable).getWhen(), 0x10 | n2, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY(), ((MouseEvent)serializable).getClickCount(), ((MouseEvent)serializable).isPopupTrigger());
            }
        }
        this.redispatchEvent(aWTEvent);
        if (serializable2 != null && aWTEvent instanceof InputEvent && ((InputEvent)aWTEvent).isConsumed()) {
            ((InputEvent)serializable2).consume();
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        boolean bl;
        int n = mouseEvent.getID();
        if (n == 504 || n == 505) {
            _sMouseOver = n == 504 ? this : null;
            bl = true;
        } else {
            bl = false;
        }
        super.processMouseEvent(mouseEvent);
        if (bl) {
            this.invalidateAndRepaintIfNecessary(16);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        int n = focusEvent.getID();
        boolean bl = this.hasGlobalFocus();
        switch (n) {
            case 1004: {
                if (this.isEnabled()) {
                    Component component;
                    _sFocusedComponent = this;
                    FocusRoot focusRoot = this._getFocusRoot();
                    if (focusRoot == null || (component = focusRoot.getRootFocusOwner()) == this) break;
                    focusRoot.setRootFocusOwner(this);
                    if (component == null) break;
                    component.repaint();
                    break;
                }
                this.transferFocus();
                break;
            }
            case 1005: {
                _sFocusedComponent = null;
                ToolTipManager.getToolTipManager().hide();
            }
        }
        super.processFocusEvent(focusEvent);
        if (bl != this.hasGlobalFocus()) {
            this.invalidateAndRepaintIfNecessary(32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            super.addImpl(component, object, n);
            this._painter.add(component, n);
        }
        if (component.getPeer() instanceof LightweightPeer && component.isVisible()) {
            component.repaint();
        }
    }

    protected void paintOverChildren(Graphics graphics) {
    }

    protected DoubleBuffer getDoubleBuffer() {
        return LWComponent._getDoubleBuffer();
    }

    public final PaintContext getPaintContext() {
        if (this._paintContext == null) {
            this._paintContext = new PaintCtxt(false);
        }
        return this._paintContext;
    }

    public PaintContext getPrintPaintContext(Graphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException();
        }
        return new PrintContext(graphics);
    }

    public PaintContext getBorderContext() {
        if (this._borderContext == null) {
            this._borderContext = new PaintCtxt(true);
        }
        return this._borderContext;
    }

    public final AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = this.createAccessibleContext();
        }
        return this._accessibleContext;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x10) != 0 && !this.isShowing()) {
            return false;
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    protected void shiftFrozenDamage(int n, int n2) {
        this._painter.shiftFrozenDamage(n, n2);
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleLWComponent(this);
    }

    protected AccessibleContext accessAccessibleContext() {
        return this._accessibleContext;
    }

    protected String getDefaultName() {
        return this.getBaseClassName() + _sInstanceCounter++;
    }

    protected final String getBaseClassName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    protected void invalidateAndRepaintIfNecessary(int n) {
        if (this.getUI() == null || this.getParent() == null) {
            return;
        }
        PaintContext paintContext = this.getPaintContext();
        if ((this.getInvalidateFlags() & n) != 0) {
            this.invalidate();
        }
        if ((this.getRepaintFlags() & n) != 0) {
            this.repaint();
        }
    }

    protected int getRepaintFlags() {
        BorderPainter borderPainter;
        PaintContext paintContext = this.getPaintContext();
        int n = 0;
        Painter painter = this.getFill();
        if (painter != null) {
            n |= painter.getRepaintFlags(paintContext);
        }
        if ((borderPainter = this.getBorderPainter()) != null) {
            n |= borderPainter.getRepaintFlags(paintContext);
        }
        return n;
    }

    protected int getInvalidateFlags() {
        BorderPainter borderPainter;
        PaintContext paintContext = this.getPaintContext();
        int n = 0;
        Painter painter = this.getFill();
        if (painter != null) {
            n = painter.getInvalidateFlags(paintContext);
        }
        if ((borderPainter = this.getBorderPainter()) != null) {
            n |= borderPainter.getInvalidateFlags(paintContext);
        }
        if (this.getLayout() instanceof DirectionalLayout) {
            n |= 0x4000;
        }
        return n;
    }

    protected String paramString() {
        String string = super.paramString();
        BorderPainter borderPainter = this.getBorderPainter();
        if (borderPainter != null) {
            string = string + ", " + borderPainter.toString();
        }
        return string;
    }

    protected static boolean eventMatchesMnemonic(KeyEvent keyEvent, char c) {
        if (c == '\u0000') {
            return false;
        }
        int n = keyEvent.getKeyCode();
        if (n >= 96 && n <= 105) {
            return false;
        }
        c = Character.toUpperCase(c);
        char c2 = keyEvent.getKeyChar();
        return c2 > '\u0000' && Character.toUpperCase(c2) == c;
    }

    protected boolean eventMatchesMnemonic(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return false;
        }
        return LWComponent.eventMatchesMnemonic(keyEvent, this.getMnemonicChar());
    }

    protected static boolean hasMnemonicModifier(KeyEvent keyEvent) {
        int n = InputEventUtils.getMods(keyEvent);
        if (n == 0) {
            return false;
        }
        if (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4) {
            return (2 & n) != 0;
        }
        return n == 8;
    }

    static boolean isDoubleBuffered(Component component) {
        Container container = component.getParent();
        if (container != null) {
            return container instanceof DoubleBufferer;
        }
        return false;
    }

    public static final void setDoubleBufferingEnabled(boolean bl) {
        if (_sDoubleBufferingEnabled != bl) {
            _sDoubleBufferingEnabled = bl;
        }
    }

    public static final boolean isDoubleBufferingEnabled() {
        return _sDoubleBufferingEnabled;
    }

    static DoubleBuffer _getDoubleBuffer() {
        if (LWComponent.isDoubleBufferingEnabled()) {
            if (_sDoubleBuffer == null) {
                _sDoubleBuffer = new BalkingDoubleBuffer();
            }
            return _sDoubleBuffer;
        }
        return NullDoubleBuffer.getDoubleBuffer();
    }

    static void _flushDoubleBuffer(Container container) {
        LWComponent._getDoubleBuffer().flush();
    }

    boolean __clipToBorder() {
        return true;
    }

    void __setBuffered(boolean bl) {
        this._buffered = bl;
    }

    private void _paintComponent(Graphics graphics, boolean bl) {
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        boolean bl2 = false;
        if (!this._buffered) {
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof LWComponent) || !((LWComponent)container)._buffered) continue;
                bl2 = true;
                break;
            }
        }
        if ((bl || this.isTransparent()) && (this._buffered || bl2)) {
            this._painter.paintExtents(graphics, this);
        } else {
            this._painter.paint(graphics, this.getDoubleBuffer(), this);
        }
    }

    private FocusRoot _getFocusRoot() {
        for (Container container = this; container != null; container = container.getParent()) {
            if (container instanceof FocusRoot) {
                return (FocusRoot)((Object)container);
            }
            if (container instanceof Window) break;
        }
        return null;
    }

    private void _updateLocale(Locale locale, Locale locale2, boolean bl) {
        this.updateLocale(locale, locale2);
        if (bl) {
            this._painter.propagateLocale(locale, locale2);
        }
    }

    private void _setReadingDirection(int n, boolean bl) {
        if (n == 0) {
            this._isReadingDirectionDefaulted = true;
            Container container = this.getParent();
            n = this._isLocaleDefaulted && container instanceof VirtualComponent ? ((VirtualComponent)((Object)container)).getActualReadingDirection() : LocaleUtils.getReadingDirectionForLocale(LocaleUtils.getDefaultableLocale(this));
        } else {
            this._isReadingDirectionDefaulted = false;
        }
        if (n != this._readingDirection) {
            this.updateReadingDirection(n);
            if (bl) {
                this.propagateReadingDirection(n);
            }
        }
    }

    private void _setColorScheme(ColorScheme colorScheme, boolean bl) {
        Object object;
        LookAndFeel lookAndFeel = this.getLookAndFeel();
        if (colorScheme == null && this.getPeer() != null) {
            object = this.getParent();
            colorScheme = this.getParent() instanceof LWComponent ? ((LWComponent)object).getColorScheme() : lookAndFeel.getDefaultColorScheme();
        }
        if (colorScheme != null) {
            colorScheme = lookAndFeel.getColorScheme(colorScheme);
        }
        if ((object = this._colorScheme) != colorScheme) {
            this._colorScheme = colorScheme;
            if (bl || object != null) {
                this.updateUI();
            }
        }
    }

    static HelpCapable _getParentHelpCapable(Component component) {
        for (component = component.getParent(); component != null; component = component.getParent()) {
            if (!(component instanceof HelpCapable)) continue;
            return (HelpCapable)((Object)component);
        }
        return null;
    }

    private static void _postProcessChildren(Container container, Component component, KeyEvent keyEvent) {
        try {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                if (component2 == component || !component2.isVisible() || !component2.isEnabled() || component2 instanceof FocusRoot) continue;
                if (component2 instanceof KeyProcessor) {
                    ((KeyProcessor)((Object)component2)).postProcessKey(keyEvent);
                }
                if (keyEvent.isConsumed()) {
                    return;
                }
                if (!(component2 instanceof Container)) continue;
                LWComponent._postProcessChildren((Container)component2, null, keyEvent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private KeyListener _getPostKeyListener() {
        return (KeyListener)this.getClientProperty(_POST_KEY_LISTENER);
    }

    private boolean _hasHelp() {
        return this.getHelpProvider() != null;
    }

    private synchronized void _setToolTipValue(Object object) {
        Object object2 = this.getToolTipValue();
        this.putClientProperty(_TOOLTIP_VALUE, object);
        if (object == null != (object2 == null)) {
            if (object != null) {
                ToolTipManager.getToolTipManager().registerComponent(this);
            } else {
                ToolTipManager.getToolTipManager().unregisterComponent(this);
            }
        }
    }

    private int _getClientPropertyIndex(Object object) {
        Object[] objectArray = this._properties;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; i += 2) {
                if (!object.equals(objectArray[i])) continue;
                return i / 2;
            }
        }
        return -1;
    }

    static boolean _loseFocusIfChild(Container container) {
        for (Container container2 = LWComponent.getFocusedComponent(); container2 != null; container2 = container2.getParent()) {
            if (container2 != container) continue;
            _sFocusedComponent = null;
            return true;
        }
        return false;
    }

    private boolean _isParentOf(Component component) {
        while (component != null) {
            if (component == this) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    static Rectangle _getLWChildBounds(Container container) {
        Rectangle rectangle = null;
        if (container.isShowing()) {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible() || !(component.getPeer() instanceof LightweightPeer)) continue;
                Rectangle rectangle2 = component.getBounds();
                if (rectangle == null) {
                    rectangle = rectangle2;
                    continue;
                }
                rectangle.add(rectangle2);
            }
        }
        return rectangle;
    }

    private Point _translatePoint(Component component, Component component2, int n, int n2) {
        Point point;
        while (!(component instanceof Window) && component != null) {
            point = component.getLocation();
            n += point.x;
            n2 += point.y;
            component = component.getParent();
        }
        while (!(component2 instanceof Window) && component2 != null) {
            point = component2.getLocation();
            n -= point.x;
            n2 -= point.y;
            component2 = component2.getParent();
        }
        return new Point(n, n2);
    }

    static {
        LWComponent.setDoubleBufferingEnabled(true);
        FocusUtils.installDefaultKeyboardNavigation();
        String string = System.getProperty("java.version");
        _needsRepaintFix = string == null ? true : string.startsWith("1.2") || string.startsWith("1.3");
        _sInstanceCounter = 0;
        _sMouseGrab = null;
        _sMouseOver = null;
        _EMPTY_RECTANGLE = new Rectangle();
        _DEFAULT_NAME = new String("");
    }

    private class PaintCtxt
    implements PaintContext {
        private boolean _useParentBackground;

        public PaintCtxt() {
        }

        public PaintCtxt(boolean bl) {
            this._useParentBackground = bl;
        }

        public Color getPaintForeground() {
            return LWComponent.this.getForeground();
        }

        public Color getPaintBackground() {
            return LWComponent.this.getBackground();
        }

        public ColorScheme getColorScheme() {
            return LWComponent.this.getColorScheme();
        }

        public Color getSurroundingColor() {
            if (this._useParentBackground) {
                Container container = LWComponent.this.getParent();
                if (container != null) {
                    return container.getBackground();
                }
                return null;
            }
            return LWComponent.this.getBackground();
        }

        public Font getPaintFont() {
            return LWComponent.this.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return LWComponent.this.getFontMetrics(font);
        }

        public int getPaintState() {
            return LWComponent.this.getPaintState();
        }

        public Object getPaintData(Object object) {
            return LWComponent.this.getPaintData(object);
        }

        public ImageObserver getImageObserver() {
            return LWComponent.this;
        }

        public Locale getPaintLocale() {
            return LocaleUtils.getDefaultableLocale(LWComponent.this);
        }

        public UIDefaults getPaintUIDefaults() {
            ComponentUI componentUI = LWComponent.this.getUI();
            return componentUI != null ? componentUI.getUIDefaults(this) : null;
        }

        public float getInteriorAlignmentX() {
            return LWComponent.this.getInteriorAlignmentX();
        }

        public float getInteriorAlignmentY() {
            return LWComponent.this.getInteriorAlignmentY();
        }

        public int getReadingDirection() {
            return LWComponent.this.getActualReadingDirection();
        }

        public String toString() {
            String string = super.toString();
            string = string + ", Component:" + LWComponent.this.getName();
            int n = this.getPaintState();
            if ((n & 1) != 0) {
                string = string + ", disabled";
            }
            if ((n & 2) != 0) {
                string = string + ", armed";
            }
            if ((n & 4) != 0) {
                string = string + ", inactive";
            }
            if ((n & 8) != 0) {
                string = string + ", set";
            }
            if ((n & 0x10) != 0) {
                string = string + ", mouse over";
            }
            if ((n & 0x20) != 0) {
                string = string + ", focused";
            }
            if ((n & 0x40) != 0) {
                string = string + ", default";
            }
            return string;
        }
    }

    private class PrintContext
    extends PaintContextProxy {
        private Graphics _printGraphics;

        public PrintContext(Graphics graphics) {
            this._printGraphics = graphics;
        }

        protected PaintContext getPaintContext() {
            return LWComponent.this.getPaintContext();
        }

        public int getPaintState() {
            return 0;
        }

        public FontMetrics getFontMetrics(Font font) {
            return this._printGraphics.getFontMetrics(font);
        }
    }
}

