/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import oracle.ewt.alert.AlertRowLayout;
import oracle.ewt.alert.BaseAlertPane;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.laf.oracle.OracleComponentUI;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.plaf.AlertUI;
import oracle.ewt.util.ImmInsets;

public class OracleAlertUI
extends OracleComponentUI
implements AlertUI {
    private LWComponent _mainButtonPane;
    private LWComponent _helpButtonPane;
    private LWComponent _cancelButtonPane;
    private Component _yes;
    private Component _no;
    private Component _cancel;
    private Component _help;
    private int _userButtons;
    private static final BorderPainter _BORDER_PAINTER = new FixedBorderPainter(8, 8, 8, 8);
    private static final ImmInsets _MESSAGE_INSETS = new ImmInsets(24, 26, 32, 0);
    private static final ImmInsets _R2L_MESSAGE_INSETS = new ImmInsets(24, 0, 32, 26);

    public OracleAlertUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    public Image getStopIcon(LWComponent lWComponent) {
        return this.getUIDefaults(lWComponent).getImage("Alert.errorImage");
    }

    public Image getCautionIcon(LWComponent lWComponent) {
        return this.getUIDefaults(lWComponent).getImage("Alert.warningImage");
    }

    public Image getNoteIcon(LWComponent lWComponent) {
        return this.getUIDefaults(lWComponent).getImage("Alert.informationImage");
    }

    public BorderPainter getDefaultBorderPainter(LWComponent lWComponent) {
        return _BORDER_PAINTER;
    }

    public ImmInsets getMessageInsets(LWComponent lWComponent) {
        if (lWComponent.getActualReadingDirection() == 1) {
            return _MESSAGE_INSETS;
        }
        return _R2L_MESSAGE_INSETS;
    }

    public int getMessageIconDelta(LWComponent lWComponent) {
        return 34;
    }

    public LWComponent createButtonContainer(BaseAlertPane baseAlertPane) {
        LWComponent lWComponent = new LWComponent();
        lWComponent.setLayout(new BorderLayout());
        this._mainButtonPane = new ButtonBar();
        this._mainButtonPane.setLayout(this._createRowLayout());
        lWComponent.add("Center", this._mainButtonPane);
        this._helpButtonPane = new ButtonBar();
        this._helpButtonPane.setLayout(this._createRowLayout());
        this._cancelButtonPane = new ButtonBar();
        this._cancelButtonPane.setLayout(this._createRowLayout());
        this._mainButtonPane.addContainerListener(baseAlertPane);
        this._helpButtonPane.addContainerListener(baseAlertPane);
        this._cancelButtonPane.addContainerListener(baseAlertPane);
        if (baseAlertPane.getActualReadingDirection() == 1) {
            lWComponent.add("East", this._cancelButtonPane);
            lWComponent.add("West", this._helpButtonPane);
        } else {
            lWComponent.add("West", this._cancelButtonPane);
            lWComponent.add("East", this._helpButtonPane);
        }
        return lWComponent;
    }

    public void addUserButton(LWComponent lWComponent, String string, Component component) {
        if ("Cancel".equals(string)) {
            this._cancel = component;
        } else if ("Yes".equals(string)) {
            this._yes = component;
        } else if ("No".equals(string)) {
            this._no = component;
        } else if ("Help".equals(string)) {
            this._help = component;
        } else {
            ++this._userButtons;
        }
        if ("Help".equals(string)) {
            this._helpButtonPane.add(string, component);
        } else if ("Cancel".equals(string)) {
            this._updateCancelButton();
        } else {
            this._updateCancelButton();
            this._mainButtonPane.add(string, component);
        }
    }

    public void removeUserButton(LWComponent lWComponent, Component component) {
        BaseAlertPane baseAlertPane = (BaseAlertPane)lWComponent;
        if (this._cancel == component) {
            this._cancel = null;
        } else if (this._yes == component) {
            this._yes = null;
        } else if (this._no == component) {
            this._no = null;
        } else if (this._help == component) {
            this._help = null;
        } else {
            --this._userButtons;
        }
        this._helpButtonPane.remove(component);
        this._mainButtonPane.remove(component);
        this._cancelButtonPane.remove(component);
        this._updateCancelButton();
    }

    public void removeAllButtons(LWComponent lWComponent) {
        this._mainButtonPane.removeAll();
        this._helpButtonPane.removeAll();
        this._cancelButtonPane.removeAll();
        this._yes = null;
        this._no = null;
        this._cancel = null;
        this._help = null;
        this._userButtons = 0;
    }

    public Dimension getButtonCellSize(boolean bl) {
        AlertRowLayout alertRowLayout = (AlertRowLayout)this._mainButtonPane.getLayout();
        Dimension dimension = alertRowLayout.getNaturalCellSize(this._mainButtonPane, bl);
        Dimension dimension2 = alertRowLayout.getNaturalCellSize(this._helpButtonPane, bl);
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        dimension2 = alertRowLayout.getNaturalCellSize(this._cancelButtonPane, bl);
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        dimension.width = (int)((double)dimension.width * 1.5);
        return dimension;
    }

    private LayoutManager _createRowLayout() {
        AlertRowLayout alertRowLayout = new AlertRowLayout();
        alertRowLayout.setLayoutAlignment(2);
        alertRowLayout.setInteriorGap(0);
        return alertRowLayout;
    }

    private void _updateCancelButton() {
        if (this._cancel != null) {
            this._cancelButtonPane.remove(this._cancel);
            this._mainButtonPane.remove(this._cancel);
            if (this._yes != null && this._no != null || this._userButtons > 0) {
                this._cancelButtonPane.add("Cancel", this._cancel);
            } else {
                this._mainButtonPane.add("Cancel", this._cancel);
            }
        }
    }
}

