/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import oracle.ewt.UIDefaults;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.laf.basic.BasicTreeUI;
import oracle.ewt.laf.basic.NonZeroWidthTextPainter;
import oracle.ewt.laf.basic.SelColorChange;
import oracle.ewt.laf.basic.SelTextColorChange;
import oracle.ewt.laf.generic.GenericFocusPainter;
import oracle.ewt.laf.generic.GenericLookAndFeel;
import oracle.ewt.laf.generic.SelFocusColorChange;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.AndOrStatePainterSwitcher;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.FixedImagePainter;
import oracle.ewt.painter.ImagePainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterJoiner;
import oracle.ewt.painter.PainterStacker;
import oracle.ewt.util.ImmInsets;

public class GenericTreeUI
extends BasicTreeUI {
    private static Painter _sCollapsedButtonPainter;
    private static Painter _sExpandedButtonPainter;
    private static final int _TEXT_ICON_GAP = 1;
    private static final Object _sLock;
    private static final int _ZERO_REPLACEMENT_WIDTH = 10;

    public GenericTreeUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if (object.equals("CollapsedNodePainter")) {
            return GenericTreeUI._getExpansionButtonPainter(uIDefaults, false);
        }
        if (object.equals("ExpandedNodePainter")) {
            return GenericTreeUI._getExpansionButtonPainter(uIDefaults, true);
        }
        return null;
    }

    public Painter getExpansionButtonPainter(LWComponent lWComponent, DTreeItem dTreeItem) {
        return GenericTreeUI._getExpansionButtonPainter(this.getUIDefaults(lWComponent), dTreeItem.isExpanded());
    }

    protected Painter createItemPainter() {
        ImmInsets immInsets = this.getSelectionInsets();
        return new PainterJoiner(new FixedBorderPainter(new ImagePainter(), 0, 0, 0, 1, false), new PainterStacker(new AndOrStatePainterSwitcher(new SelColorChange(FilledRectPainter.getPainter(), false), null, 128, 128, 0, 0), new SelFocusColorChange(new GenericFocusPainter(new SelTextColorChange(this.getTextPainter())))), 13);
    }

    protected ImmInsets getSelectionInsets() {
        return ImmInsets.getEmptyInsets();
    }

    protected boolean isLineDotted() {
        return true;
    }

    protected Painter createTextPainter() {
        return new NonZeroWidthTextPainter(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Painter _getExpansionButtonPainter(UIDefaults uIDefaults, boolean bl) {
        Object object = _sLock;
        synchronized (object) {
            if (bl) {
                if (_sExpandedButtonPainter == null) {
                    _sExpandedButtonPainter = new PainterStacker(uIDefaults.getPainter(GenericLookAndFeel.DISABLED_BG_PAINTER), new FixedImagePainter(uIDefaults.getImage("Tree.closedImage")));
                }
                return _sExpandedButtonPainter;
            }
            if (_sCollapsedButtonPainter == null) {
                _sCollapsedButtonPainter = new PainterStacker(uIDefaults.getPainter(GenericLookAndFeel.DISABLED_BG_PAINTER), new FixedImagePainter(uIDefaults.getImage("Tree.openImage")));
            }
            return _sCollapsedButtonPainter;
        }
    }

    static {
        _sLock = new Object();
    }
}

