/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.iterator;

import oracle.ewt.iterator.Iterator;
import oracle.ewt.iterator.NumericIterator;
import oracle.ewt.iterator.Range;
import oracle.ewt.iterator.WrappingNumericIterator;

public class ArrayIterator
implements Iterator {
    private Object[] _array;
    private NumericIterator _numeric;
    private boolean _wrap;

    public ArrayIterator(Object[] objectArray, boolean bl) {
        this._array = objectArray;
        this._wrap = bl;
        Range range = new Range(0, objectArray.length - 1);
        this._numeric = bl ? new WrappingNumericIterator(range) : new NumericIterator(range);
    }

    public Object[] getArray() {
        return this._array;
    }

    public boolean isWrapping() {
        return this._wrap;
    }

    public void setIndex(int n) {
        if (n < 0 || n >= this._array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._numeric.setValue(n);
    }

    public int getIndex() {
        return this._numeric.getValue();
    }

    public Object nextElement() {
        return this._array[(Integer)this._numeric.nextElement()];
    }

    public void setIteratingForward(boolean bl) {
        this._numeric.setIteratingForward(bl);
    }

    public boolean isIteratingForward() {
        return this._numeric.isIteratingForward();
    }

    public boolean hasMoreElements() {
        return this._numeric.hasMoreElements();
    }

    public Object skip(int n) {
        return this._array[(Integer)this._numeric.skip(n)];
    }

    public int remainingElements(int n) {
        return this._numeric.remainingElements(n);
    }
}

