/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.header;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.header.Header;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.popup.ToolTipSite;
import oracle.ewt.util.LocaleUtils;

public class AccessibleHeader
extends AccessibleLWComponent
implements AccessibleSelection {
    private static final String _ROWHEADER = "HEADER.ROW";
    private static final String _COLHEADER = "HEADER.COLUMN";
    private static final String _IMAGE = "GRID_IMAGE";
    private static final String _NULL = "EMPTY_CELL";
    private static final String _UNKNOWN = "UNKNOWN";
    private static final String _RESOURCE = "oracle.ewt.access.resource.AccessibilityBundle";
    private Header _header;

    public AccessibleHeader(Header header) {
        super(header);
        this._header = header;
        this._header.attachAccessibleHeader(this);
    }

    public Header getHeader() {
        return this._header;
    }

    public String getAccessibleName(int n) {
        Object object = this.getHeader().getDataSource().getData(n);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Image || object instanceof ImageSet) {
            return this._getTranslatedString(_IMAGE);
        }
        if (object == null) {
            return null;
        }
        return this._getTranslatedString(_UNKNOWN);
    }

    public String getAccessibleName() {
        String string;
        AccessibleContext accessibleContext;
        Accessible accessible;
        String string2 = super.getAccessibleName();
        if (string2 == null && (accessible = this.getAccessibleParent()) != null && (accessibleContext = accessible.getAccessibleContext()) != null && accessibleContext.getAccessibleRole() == AccessibleRole.TABLE && (string = accessibleContext.getAccessibleName()) != null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(this.getLocale()));
            String string3 = resourceBundle.getString(this.getHeader().isHorizontal() ? _COLHEADER : _ROWHEADER);
            MessageFormat messageFormat = new MessageFormat(string3);
            Object[] objectArray = new Object[]{string};
            return messageFormat.format(objectArray);
        }
        return string2;
    }

    public String getAccessibleDescription(int n) {
        ToolTipSite toolTipSite;
        Object object = this.getHeader().getToolTipValue();
        if (!(object instanceof ToolTipClient)) {
            return null;
        }
        ToolTipClient toolTipClient = (ToolTipClient)object;
        int n2 = this.getHeader().getItemPosition(n) + 1;
        ToolTipSite toolTipSite2 = toolTipSite = this.getHeader().isHorizontal() ? toolTipClient.getToolTipSite(this.getHeader(), n2, 1) : toolTipClient.getToolTipSite(this.getHeader(), 1, n2);
        if (toolTipSite != null && (object = toolTipSite.getValue()) instanceof String) {
            return (String)object;
        }
        return null;
    }

    public AccessibleRole getAccessibleRole() {
        return this.getHeader().isHorizontal() ? AccessibleRole.COLUMN_HEADER : AccessibleRole.ROW_HEADER;
    }

    public Accessible getAccessibleAt(Point point) {
        return this.getAccessibleChild(this.getHeader().getItemAt(point.x, point.y));
    }

    public int getAccessibleChildrenCount() {
        return this.getHeader().getItemCount();
    }

    public Accessible getAccessibleChild(int n) {
        if (n < 0 || n >= this.getAccessibleChildrenCount()) {
            return null;
        }
        return new Item(n);
    }

    public AccessibleSelection getAccessibleSelection() {
        return this;
    }

    public int getAccessibleSelectionCount() {
        int[] nArray = this.getHeader().getHeaderSelection().getSelectedItems();
        if (nArray == null) {
            return 0;
        }
        return nArray.length;
    }

    public Accessible getAccessibleSelection(int n) {
        if (n < 0) {
            return null;
        }
        int[] nArray = this.getHeader().getHeaderSelection().getSelectedItems();
        if (nArray == null || n >= nArray.length) {
            return null;
        }
        return this.getAccessibleChild(nArray[n]);
    }

    public boolean isAccessibleChildSelected(int n) {
        return this.getHeader().getHeaderSelection().isItemSelected(n);
    }

    public void addAccessibleSelection(int n) {
        this.getHeader().getHeaderSelection().addItemToSelection(n);
    }

    public void removeAccessibleSelection(int n) {
        this.getHeader().getHeaderSelection().removeItemFromSelection(n);
    }

    public void clearAccessibleSelection() {
        this.getHeader().getHeaderSelection().deselectAll();
    }

    public void selectAllAccessibleSelection() {
        this.getHeader().getHeaderSelection().selectItemRange(0, this.getHeader().getItemCount() - 1);
    }

    private String _getTranslatedString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE, LocaleUtils.getTranslationLocale(this.getLocale()));
        return resourceBundle.getString(string);
    }

    private class Item
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent {
        private int _position;

        public Item(int n) {
            this._position = n;
            this.setAccessibleParent(AccessibleHeader.this.getHeader());
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public String getAccessibleName() {
            if (this.accessibleName != null && this.accessibleName != "") {
                return this.accessibleName;
            }
            return AccessibleHeader.this.getAccessibleName(this._position);
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null && this.accessibleDescription != "") {
                return this.accessibleDescription;
            }
            return AccessibleHeader.this.getAccessibleDescription(this._position);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            if (this.isVisible()) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                }
            }
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
            if (AccessibleHeader.this.getHeader().getFocusItem() == this._position) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            accessibleStateSet.add(AccessibleState.TRANSIENT);
            if (AccessibleHeader.this.getHeader().isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            if (AccessibleHeader.this.getHeader().isItemResizable(this._position)) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (AccessibleHeader.this.getHeader().getHeaderSelection().isItemSelected(this._position)) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return this._position;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() {
            return AccessibleHeader.this.getHeader().getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            Color color = AccessibleHeader.this.getHeader().getItemAppearance(this._position).getBackground();
            if (color == null) {
                return AccessibleHeader.this.getHeader().getBackground();
            }
            return color;
        }

        public void setBackground(Color color) {
            Appearance appearance = AccessibleHeader.this.getHeader().getItemAppearance(this._position);
            appearance.setBackground(color);
            AccessibleHeader.this.getHeader().setItemAppearance(this._position, appearance);
        }

        public Font getFont() {
            Font font = AccessibleHeader.this.getHeader().getItemAppearance(this._position).getFont();
            if (font == null) {
                return AccessibleHeader.this.getHeader().getFont();
            }
            return font;
        }

        public void setFont(Font font) {
            Appearance appearance = AccessibleHeader.this.getHeader().getItemAppearance(this._position);
            appearance.setFont(font);
            AccessibleHeader.this.getHeader().setItemAppearance(this._position, appearance);
        }

        public FontMetrics getFontMetrics(Font font) {
            return AccessibleHeader.this.getHeader().getFontMetrics(font);
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean bl) {
        }

        public Color getForeground() {
            Color color = AccessibleHeader.this.getHeader().getItemAppearance(this._position).getForeground();
            if (color == null) {
                return AccessibleHeader.this.getHeader().getForeground();
            }
            return color;
        }

        public void setForeground(Color color) {
            Appearance appearance = AccessibleHeader.this.getHeader().getItemAppearance(this._position);
            appearance.setForeground(color);
            AccessibleHeader.this.getHeader().setItemAppearance(this._position, appearance);
        }

        public Cursor getCursor() {
            Cursor cursor = AccessibleHeader.this.getHeader().getCursor();
            if (cursor == null) {
                cursor = Cursor.getDefaultCursor();
            }
            return cursor;
        }

        public void setCursor(Cursor cursor) {
        }

        public boolean isVisible() {
            return AccessibleHeader.this.getHeader().isItemVisible(this._position);
        }

        public void setVisible(boolean bl) {
            AccessibleHeader.this.getHeader().setItemVisible(this._position, bl);
        }

        public boolean isShowing() {
            return this.isVisible() && AccessibleHeader.this.getHeader().isShowing();
        }

        public boolean contains(Point point) {
            Rectangle rectangle = this.getBounds();
            if (rectangle == null) {
                return false;
            }
            return rectangle.contains(point);
        }

        public Point getLocationOnScreen() {
            if (!this.isShowing()) {
                return null;
            }
            Header header = AccessibleHeader.this.getHeader();
            Point point = header.getLocationOnScreen();
            Point point2 = this.getLocation();
            point2.translate(point.x, point.y);
            point2.translate(header.getCanvasOriginX(), header.getCanvasOriginY());
            return point2;
        }

        public Point getLocation() {
            Rectangle rectangle = this.getBounds();
            if (rectangle == null) {
                return null;
            }
            return new Point(rectangle.x, rectangle.y);
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            if (!this.isShowing()) {
                return null;
            }
            Header header = AccessibleHeader.this.getHeader();
            Dimension dimension = header.getInnerSize();
            int n = this._position;
            if (header.isHorizontal()) {
                return new Rectangle(header.getItemPosition(n), 0, header.getItemSize(n), dimension.height);
            }
            return new Rectangle(0, header.getItemPosition(n), dimension.width, header.getItemSize(n));
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            Rectangle rectangle = this.getBounds();
            if (rectangle == null) {
                return null;
            }
            return new Dimension(rectangle.width, rectangle.height);
        }

        public void setSize(Dimension dimension) {
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }
    }
}

