/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid.bigCell;

import oracle.ewt.dataSource.AbstractTwoDDataSource;
import oracle.ewt.grid.bigCell.AbstractBigCell;
import oracle.ewt.grid.bigCell.BigCell;

public class BigCellTwoDDataSource
extends AbstractTwoDDataSource {
    private int _columns;
    private int _rows;
    private Object[][] _data;
    private static int _COLUMNS_ALLOCATED_AHEAD = 20;

    public BigCellTwoDDataSource(int n, int n2) {
        this._columns = n;
        this._rows = n2;
    }

    public int getColumnCount() {
        return this._columns;
    }

    public int getRowCount() {
        return this._rows;
    }

    public Object getData(int n, int n2) {
        if (this._data == null) {
            return null;
        }
        return this._data[n][n2];
    }

    public void setData(int n, int n2, Object object) {
        if (this._data == null) {
            this._data = new Object[this.getColumnCount()][this.getRowCount()];
        }
        if (!(object instanceof AbstractBigCell) && object != this._getAbstractBigCell(n, n2)) {
            this._clearCell(n, n2);
        }
        this._data[n][n2] = object;
        this.fireDataSourceEvent(2007, n, 1, n2, 1);
    }

    public Object getRealData(int n, int n2) {
        AbstractBigCell abstractBigCell = this._getAbstractBigCell(n, n2);
        return abstractBigCell == null ? this.getData(n, n2) : abstractBigCell.getData();
    }

    public void setBigCellData(int n, int n2, int n3, int n4, Object object) {
        BigCell bigCell = new BigCell(n, n2, n3, n4, object);
        this.storeCell(n, n2, n3, n4, bigCell);
    }

    public void addColumns(int n, int n2) {
        this._addColumnsToArray(n, n2);
        this._columns += n2;
        this.fireDataSourceEvent(2001, n, n2);
        this._adjustAfterAddColumns(n, n2);
    }

    public final void addColumns(int n) {
        this.addColumns(this.getColumnCount(), n);
    }

    public void removeColumns(int n, int n2) {
        this._removeColumnsFromArray(n, n2);
        this._columns -= n2;
        this.fireDataSourceEvent(2002, n, n2);
        this._adjustAfterRemoveColumns(n, n2);
    }

    public final void removeColumns(int n) {
        this.removeColumns(this.getColumnCount() - n, n);
    }

    public void addRows(int n, int n2) {
        this._addRowsToArray(n, n2);
        this._rows += n2;
        this.fireDataSourceEvent(2004, n, n2);
        this._adjustAfterAddRows(n, n2);
    }

    public final void addRows(int n) {
        this.addRows(this.getRowCount(), n);
    }

    public void removeRows(int n, int n2) {
        this._removeRowsFromArray(n, n2);
        this._rows -= n2;
        this.fireDataSourceEvent(2005, n, n2);
        this._adjustAfterRemoveRows(n, n2);
    }

    public final void removeRows(int n) {
        this.removeRows(this.getRowCount() - n, n);
    }

    protected void storeCell(int n, int n2, int n3, int n4, Object object) {
        if (this._data == null) {
            this._data = new Object[this._columns][this._rows];
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n4; ++j) {
                this._clearCell(i + n, j + n3);
                this._data[i + n][j + n3] = object;
            }
        }
        this._data[n][n3] = object;
        this.fireDataSourceEvent(2007, n, n2, n3, n4);
    }

    private void _clearCell(int n, int n2) {
        AbstractBigCell abstractBigCell = this._getAbstractBigCell(n, n2);
        if (abstractBigCell == null) {
            return;
        }
        int n3 = abstractBigCell.getColumnCount();
        int n4 = abstractBigCell.getRowCount();
        int n5 = abstractBigCell.getColumn();
        int n6 = abstractBigCell.getRow();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                this._data[i + n5][j + n6] = null;
            }
        }
        this.fireDataSourceEvent(2007, n5, n3, n6, n4);
    }

    private AbstractBigCell _getAbstractBigCell(int n, int n2) {
        Object object = this.getData(n, n2);
        AbstractBigCell abstractBigCell = null;
        if (object instanceof AbstractBigCell) {
            abstractBigCell = (AbstractBigCell)object;
        }
        return abstractBigCell;
    }

    private BigCell _getBigCell(int n, int n2) {
        AbstractBigCell abstractBigCell = this._getAbstractBigCell(n, n2);
        BigCell bigCell = null;
        if (abstractBigCell instanceof BigCell) {
            bigCell = (BigCell)abstractBigCell;
        }
        return bigCell;
    }

    private void _adjustAfterAddColumns(int n, int n2) {
        for (int i = 0; i < this._rows; ++i) {
            int n3 = n + n2;
            while (n3 < this._columns) {
                BigCell bigCell = this._getBigCell(n3, i);
                if (bigCell == null) {
                    ++n3;
                    continue;
                }
                if (bigCell.getRow() != i) {
                    n3 = bigCell.getColumn() + bigCell.getColumnCount();
                    continue;
                }
                if (bigCell.getColumn() < n) {
                    bigCell.setColumnCount(bigCell.getColumnCount() + n2);
                    for (int j = 0; j < bigCell.getRowCount(); ++j) {
                        for (int k = 0; k < n2; ++k) {
                            this._data[n + k][i + j] = bigCell;
                        }
                    }
                    n3 = bigCell.getColumn() + bigCell.getColumnCount();
                    continue;
                }
                bigCell.setColumn(n3);
                n3 += bigCell.getColumnCount();
            }
        }
    }

    private void _adjustAfterRemoveColumns(int n, int n2) {
        for (int i = 0; i < this._rows; ++i) {
            BigCell bigCell;
            int n3 = 0;
            if (n > 0) {
                n3 = n - 1;
                bigCell = this._getBigCell(n3, i);
                if (bigCell == null) {
                    ++n3;
                } else if (bigCell.getRow() != i) {
                    n3 = Math.max(n3 + 1, bigCell.getColumn() + bigCell.getColumnCount());
                } else if (bigCell.getColumn() + bigCell.getColumnCount() > n) {
                    if (bigCell.getColumn() + bigCell.getColumnCount() < n + n2) {
                        bigCell.setColumnCount(n - bigCell.getColumn());
                        ++n3;
                    } else {
                        bigCell.setColumnCount(bigCell.getColumnCount() - n2);
                        n3 = Math.max(n3 + 1, bigCell.getColumn() + bigCell.getColumnCount());
                    }
                } else {
                    ++n3;
                }
            }
            while (n3 < this._columns) {
                bigCell = this._getBigCell(n3, i);
                if (bigCell == null) {
                    ++n3;
                    continue;
                }
                if (bigCell.getRow() != i) {
                    n3 = Math.max(n3 + 1, bigCell.getColumn() + bigCell.getColumnCount());
                    continue;
                }
                if (bigCell.getColumn() - n2 < n) {
                    bigCell.setColumn(n);
                    int n4 = n + n2 - bigCell.getColumn();
                    bigCell.setColumnCount(bigCell.getColumnCount() - n4);
                    n3 = Math.max(n3 + 1, bigCell.getColumn() + bigCell.getColumnCount());
                    continue;
                }
                bigCell.setColumn(bigCell.getColumn() - n2);
                n3 += bigCell.getColumnCount();
            }
        }
    }

    private void _addColumnsToArray(int n, int n2) {
        Object[][] objectArray;
        Object[][] objectArray2 = this._data;
        if (objectArray2 == null) {
            return;
        }
        int n3 = this._columns;
        if (objectArray2.length >= n3 + n2) {
            objectArray = objectArray2;
        } else {
            objectArray = new Object[n3 + n2 + _COLUMNS_ALLOCATED_AHEAD][this._rows];
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
            this._data = objectArray;
        }
        System.arraycopy(objectArray2, n, objectArray, n + n2, n3 - n);
        if (objectArray == objectArray2) {
            int n4 = n;
            for (int i = 0; i < n2; ++i) {
                objectArray2[n4++] = new Object[this._rows];
            }
        }
    }

    private void _removeColumnsFromArray(int n, int n2) {
        Object[][] objectArray;
        Object[][] objectArray2 = this._data;
        if (objectArray2 == null) {
            return;
        }
        int n3 = this._columns;
        if (n3 - n2 + _COLUMNS_ALLOCATED_AHEAD < objectArray2.length / 2) {
            objectArray = new Object[n3 - n2 + _COLUMNS_ALLOCATED_AHEAD][this._rows];
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
            this._data = objectArray;
        } else {
            objectArray = objectArray2;
        }
        System.arraycopy(objectArray2, n + n2, objectArray, n, n3 - n - n2);
        if (objectArray == objectArray2) {
            int n4 = n3;
            for (int i = 0; i < n2; ++i) {
                objectArray2[--n4] = new Object[this._rows];
            }
        }
    }

    private void _adjustAfterAddRows(int n, int n2) {
        for (int i = 0; i < this._columns; ++i) {
            int n3 = n + n2;
            while (n3 < this._rows) {
                BigCell bigCell = this._getBigCell(i, n3);
                if (bigCell == null) {
                    ++n3;
                    continue;
                }
                if (bigCell.getColumn() != i) {
                    n3 = bigCell.getRow() + bigCell.getRowCount();
                    continue;
                }
                if (bigCell.getRow() < n) {
                    bigCell.setRowCount(bigCell.getRowCount() + n2);
                    for (int j = 0; j < bigCell.getColumnCount(); ++j) {
                        for (int k = 0; k < n2; ++k) {
                            this._data[i + j][n + k] = bigCell;
                        }
                    }
                    n3 = bigCell.getRow() + bigCell.getRowCount();
                    continue;
                }
                bigCell.setRow(n3);
                n3 += bigCell.getRowCount();
            }
        }
    }

    private void _adjustAfterRemoveRows(int n, int n2) {
        for (int i = 0; i < this._columns; ++i) {
            BigCell bigCell;
            int n3 = 0;
            if (n > 0) {
                n3 = n - 1;
                bigCell = this._getBigCell(i, n3);
                if (bigCell == null) {
                    ++n3;
                } else if (bigCell.getColumn() != i) {
                    n3 = Math.max(n3 + 1, bigCell.getRow() + bigCell.getRowCount());
                } else if (bigCell.getRow() + bigCell.getRowCount() > n) {
                    if (bigCell.getRow() + bigCell.getRowCount() < n + n2) {
                        bigCell.setRowCount(n - bigCell.getRow());
                        ++n3;
                    } else {
                        bigCell.setRowCount(bigCell.getRowCount() - n2);
                        n3 = Math.max(n3 + 1, bigCell.getRow() + bigCell.getRowCount());
                    }
                } else {
                    ++n3;
                }
            }
            while (n3 < this._rows) {
                bigCell = this._getBigCell(i, n3);
                if (bigCell == null) {
                    ++n3;
                    continue;
                }
                if (bigCell.getColumn() != i) {
                    n3 = Math.max(n3 + 1, bigCell.getRow() + bigCell.getRowCount());
                    continue;
                }
                if (bigCell.getRow() - n2 < n) {
                    bigCell.setRow(n);
                    int n4 = n + n2 - bigCell.getRow();
                    bigCell.setRowCount(bigCell.getRowCount() - n4);
                    n3 = Math.max(n3 + 1, bigCell.getRow() + bigCell.getRowCount());
                    continue;
                }
                bigCell.setRow(bigCell.getRow() - n2);
                n3 += bigCell.getRowCount();
            }
        }
    }

    private void _addRowsToArray(int n, int n2) {
        Object[][] objectArray = this._data;
        if (objectArray == null) {
            return;
        }
        int n3 = this._rows;
        int n4 = n3 + n2;
        int n5 = n + n2;
        int n6 = n3 - n;
        for (int i = 0; i < this._columns; ++i) {
            Object[] objectArray2 = objectArray[i];
            if (objectArray2 == null) continue;
            Object[] objectArray3 = new Object[n4];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n);
            System.arraycopy(objectArray2, n, objectArray3, n5, n6);
            objectArray[i] = objectArray3;
        }
    }

    private void _removeRowsFromArray(int n, int n2) {
        Object[][] objectArray = this._data;
        if (objectArray == null) {
            return;
        }
        int n3 = this._rows;
        int n4 = n3 - n2;
        int n5 = n + n2;
        int n6 = n3 - n - n2;
        for (int i = 0; i < this._columns; ++i) {
            Object[] objectArray2 = objectArray[i];
            if (objectArray2 == null) continue;
            Object[] objectArray3 = new Object[n4];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n);
            System.arraycopy(objectArray2, n5, objectArray3, n, n6);
            objectArray[i] = objectArray3;
        }
    }
}

