/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid.bigCell;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.MessageFormat;
import javax.accessibility.Accessible;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.AccessibleGrid;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.bigCell.AbstractBigCell;

public class AccessibleBigCellGrid
extends AccessibleGrid {
    private static final String _SPANMM = "BIGCELL.SPAN_MULTIPLE_COLUMN_MULTIPLE_ROW";
    private static final String _SPANSM = "BIGCELL.SPAN_SINGLE_COLUMN_MULTIPLE_ROW";
    private static final String _SPANMS = "BIGCELL.SPAN_MULTIPLE_COLUMN_SINGLE_ROW";
    private static final String _SPANSS = "BIGCELL.SPAN_SINGLE_COLUMN_SINGLE_ROW";

    public AccessibleBigCellGrid(Grid grid) {
        super(grid);
    }

    protected String getAccessibleName(int n, int n2, Object object) {
        Object object2;
        int n3 = 1;
        int n4 = 1;
        if (object instanceof AbstractBigCell) {
            object2 = (AbstractBigCell)object;
            object = ((AbstractBigCell)object2).getData();
            n3 = ((AbstractBigCell)object2).getColumnCount();
            n4 = ((AbstractBigCell)object2).getRowCount();
        }
        if ((object2 = super.getAccessibleName(n, n2, object)) != null) {
            String string = AccessibleBigCellGrid._getKey(n3, n4);
            String string2 = this.getTranslatedString(string);
            MessageFormat messageFormat = new MessageFormat(string2);
            Object[] objectArray = new Object[]{object2, IntegerUtils.getString((int)n3), IntegerUtils.getString((int)n4)};
            object2 = messageFormat.format(objectArray);
        }
        return object2;
    }

    public int getAccessibleChildrenCount() {
        int n = this.getGrid().getColumnCount();
        int n2 = this.getGrid().getRowCount();
        int n3 = 0;
        TwoDDataSource twoDDataSource = this.getGrid().getDataSource();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Object object = twoDDataSource.getData(j, i);
                if (object != null && object instanceof AbstractBigCell) {
                    AbstractBigCell abstractBigCell = (AbstractBigCell)object;
                    if (abstractBigCell.getColumn() != j || abstractBigCell.getRow() != i) continue;
                    ++n3;
                    continue;
                }
                ++n3;
            }
        }
        return n3;
    }

    public int getAccessibleRowAtIndex(int n) {
        return this._convertIndexToCell((int)n).row;
    }

    public int getAccessibleColumnAtIndex(int n) {
        return this._convertIndexToCell((int)n).column;
    }

    public int getAccessibleIndexAt(int n, int n2) {
        return this._convertCellToIndex(n, n2);
    }

    public Accessible getAccessibleChild(int n) {
        int n2 = this.getAccessibleChildrenCount();
        if (n < 0 || n >= n2) {
            return null;
        }
        return new AccessibleBigCell(n);
    }

    private Cell _convertIndexToCell(int n) {
        int n2 = this.getGrid().getColumnCount();
        int n3 = this.getGrid().getRowCount();
        int n4 = -1;
        TwoDDataSource twoDDataSource = this.getGrid().getDataSource();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = twoDDataSource.getData(j, i);
                if (object != null && object instanceof AbstractBigCell) {
                    AbstractBigCell abstractBigCell = (AbstractBigCell)object;
                    if (abstractBigCell.getColumn() == j && abstractBigCell.getRow() == i) {
                        ++n4;
                    }
                } else {
                    ++n4;
                }
                if (n4 != n) continue;
                return new Cell(j, i);
            }
        }
        return null;
    }

    private int _convertCellToIndex(int n, int n2) {
        int n3 = this.getGrid().getColumnCount();
        int n4 = this.getGrid().getRowCount();
        int n5 = 0;
        TwoDDataSource twoDDataSource = this.getGrid().getDataSource();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (j == n && i == n2) {
                    return n5;
                }
                Object object = twoDDataSource.getData(j, i);
                if (object != null && object instanceof AbstractBigCell) {
                    AbstractBigCell abstractBigCell = (AbstractBigCell)object;
                    if (abstractBigCell.getColumn() != j || abstractBigCell.getRow() != i) continue;
                    ++n5;
                    continue;
                }
                ++n5;
            }
        }
        return -1;
    }

    private static String _getKey(int n, int n2) {
        if (n > 1) {
            if (n2 > 1) {
                return _SPANMM;
            }
            return _SPANMS;
        }
        if (n2 > 1) {
            return _SPANSM;
        }
        return _SPANSS;
    }

    private class AccessibleBigCell
    extends AccessibleGrid.AccessibleCell {
        public AccessibleBigCell(int n) {
            super(n);
        }

        public Rectangle getBounds() {
            int n;
            AbstractBigCell abstractBigCell = this._getBigCell();
            if (abstractBigCell == null) {
                return super.getBounds();
            }
            int n2 = abstractBigCell.getColumn();
            int n3 = abstractBigCell.getRow();
            int n4 = AccessibleBigCellGrid.this.getGrid().getColumnPosition(n2);
            int n5 = AccessibleBigCellGrid.this.getGrid().getRowPosition(n3);
            int n6 = 0;
            int n7 = 0;
            for (n = n2; n < n2 + abstractBigCell.getColumnCount(); ++n) {
                n6 += AccessibleBigCellGrid.this.getGrid().getColumnWidth(n);
            }
            for (n = n3; n < n3 + abstractBigCell.getRowCount(); ++n) {
                n7 += AccessibleBigCellGrid.this.getGrid().getRowHeight(n);
            }
            return new Rectangle(n4, n5, n6, n7);
        }

        public Dimension getSize() {
            AbstractBigCell abstractBigCell = this._getBigCell();
            if (abstractBigCell == null) {
                return super.getSize();
            }
            int n = abstractBigCell.getColumn();
            int n2 = abstractBigCell.getRow();
            Rectangle rectangle = AbstractBigCell.getCellBounds(AccessibleBigCellGrid.this.getGrid(), n, n2);
            return rectangle.getSize();
        }

        private AbstractBigCell _getBigCell() {
            int n = this.getAccessibleIndexInParent();
            int n2 = AccessibleBigCellGrid.this.getAccessibleRowAtIndex(n);
            int n3 = AccessibleBigCellGrid.this.getAccessibleColumnAtIndex(n);
            return AbstractBigCell.getBigCell(AccessibleBigCellGrid.this.getGrid(), n3, n2);
        }
    }
}

