/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import oracle.ewt.grid.Cell;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;

public class MultipleSelection
implements GridSelection {
    private Grid _grid;
    private int _rowCount;
    private int _selectedRowCount;
    private boolean[] _rows;
    private int _selectedColumnCount;
    private int _columnCount;
    private boolean[] _columns;
    private int _selectedCellCount;
    private boolean[][] _cells;

    public void setParent(Grid grid) {
        this._grid = grid;
        this._rows = null;
        this._columns = null;
        this._cells = null;
        this._rowCount = grid == null ? 0 : grid.getRowCount();
        this._columnCount = grid == null ? 0 : grid.getColumnCount();
        this._selectedRowCount = 0;
        this._selectedColumnCount = 0;
        this._selectedCellCount = 0;
    }

    public Grid getParent() {
        return this._grid;
    }

    public void rowsAdded(int n, int n2) {
        if (this._rows != null) {
            this._rows = this._addToArray(this._rows, n, n2);
        }
        if (this._cells != null) {
            this._addRowsToCells(n, n2);
        }
        this._rowCount += n2;
    }

    public void rowsRemoved(int n, int n2) {
        int n3;
        Object[] objectArray;
        if (this._rows != null) {
            objectArray = this.getSelectedRows();
            if (objectArray != null) {
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    if (objectArray[n3] < n || objectArray[n3] >= n + n2) continue;
                    --this._selectedRowCount;
                }
            }
            this._rows = this._removeFromArray(this._rows, n, n2);
        }
        if (this._cells != null) {
            objectArray = this.getSelectedCells();
            if (objectArray != null) {
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    if (objectArray[n3].row < n || objectArray[n3].row >= n + n2) continue;
                    --this._selectedCellCount;
                }
            }
            this._removeRowsFromCells(n, n2);
        }
        this._rowCount -= n2;
    }

    public void columnsAdded(int n, int n2) {
        if (this._columns != null) {
            this._columns = this._addToArray(this._columns, n, n2);
        }
        if (this._cells != null) {
            this._addColumnsToCells(n, n2);
        }
        this._columnCount += n2;
    }

    public void columnsRemoved(int n, int n2) {
        int n3;
        Object[] objectArray;
        if (this._columns != null) {
            objectArray = this.getSelectedColumns();
            if (objectArray != null) {
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    if (objectArray[n3] < n || objectArray[n3] >= n + n2) continue;
                    --this._selectedColumnCount;
                }
            }
            this._columns = this._removeFromArray(this._columns, n, n2);
        }
        if (this._cells != null) {
            objectArray = this.getSelectedCells();
            if (objectArray != null) {
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    if (objectArray[n3].column < n || objectArray[n3].column >= n + n2) continue;
                    --this._selectedCellCount;
                }
            }
            this._removeColumnsFromCells(n, n2);
        }
        this._columnCount -= n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAll() {
        this._grid.freezeRepaints();
        try {
            this.deselectAll();
            int n = this._grid.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.setColumnSelected(i, true);
            }
        }
        finally {
            this._grid.unfreezeRepaints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deselectAll() {
        this._grid.freezeRepaints();
        try {
            Cell[] cellArray;
            int[] nArray;
            int[] nArray2 = this.getSelectedRows();
            if (nArray2 != null) {
                for (int i = 0; i < nArray2.length; ++i) {
                    this.setRowSelected(nArray2[i], false);
                }
            }
            if ((nArray = this.getSelectedColumns()) != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    this.setColumnSelected(nArray[i], false);
                }
            }
            if ((cellArray = this.getSelectedCells()) != null) {
                for (int i = 0; i < cellArray.length; ++i) {
                    this.setCellSelected(cellArray[i].column, cellArray[i].row, false);
                }
            }
        }
        finally {
            this._grid.unfreezeRepaints();
        }
    }

    public boolean isSomethingSelected() {
        return this._selectedRowCount != 0 || this._selectedColumnCount != 0 || this._selectedCellCount != 0;
    }

    public void setColumnSelected(int n, boolean bl) {
        if (this.isColumnSelected(n) == bl) {
            return;
        }
        if (bl) {
            if (this._grid.fireCancelableColumnEvent(n, 2009)) {
                return;
            }
            if (this._selectedRowCount != 0 || this._selectedCellCount != 0) {
                this.deselectAll();
            }
            if (this._columns == null) {
                this._columns = new boolean[this._columnCount];
            }
            this._columns[n] = true;
            ++this._selectedColumnCount;
            this._grid.fireColumnEvent(n, 2010);
        } else {
            if (this._grid.fireCancelableColumnEvent(n, 2011)) {
                return;
            }
            this._columns[n] = false;
            --this._selectedColumnCount;
            this._grid.fireColumnEvent(n, 2012);
        }
        this._grid.paintColumn(n);
    }

    public boolean isColumnSelected(int n) {
        return this._columns != null && this._columns[n];
    }

    public int[] getSelectedColumns() {
        if (this._selectedColumnCount == 0) {
            return null;
        }
        int[] nArray = new int[this._selectedColumnCount];
        int n = 0;
        for (int i = 0; i < this._columnCount; ++i) {
            if (!this.isColumnSelected(i)) continue;
            nArray[n] = i;
            if (++n == this._selectedColumnCount) break;
        }
        return nArray;
    }

    public void setRowSelected(int n, boolean bl) {
        if (this.isRowSelected(n) == bl) {
            return;
        }
        if (bl) {
            if (this._grid.fireCancelableRowEvent(n, 2005)) {
                return;
            }
            if (this._selectedColumnCount != 0 || this._selectedCellCount != 0) {
                this.deselectAll();
            }
            if (this._rows == null) {
                this._rows = new boolean[this._rowCount];
            }
            this._rows[n] = true;
            ++this._selectedRowCount;
            this._grid.fireRowEvent(n, 2006);
        } else {
            if (this._grid.fireCancelableRowEvent(n, 2007)) {
                return;
            }
            this._rows[n] = false;
            --this._selectedRowCount;
            this._grid.fireRowEvent(n, 2008);
        }
        this._grid.paintRow(n);
    }

    public boolean isRowSelected(int n) {
        return this._rows != null && this._rows[n];
    }

    public int[] getSelectedRows() {
        if (this._selectedRowCount == 0) {
            return null;
        }
        int[] nArray = new int[this._selectedRowCount];
        int n = 0;
        for (int i = 0; i < this._rowCount; ++i) {
            if (!this.isRowSelected(i)) continue;
            nArray[n] = i;
            if (++n == this._selectedRowCount) break;
        }
        return nArray;
    }

    public void setCellSelected(int n, int n2, boolean bl) {
        if (this.isCellSelected(n, n2) == bl) {
            return;
        }
        if (bl) {
            if (this._grid.fireCancelableCellEvent(n, n2, 2001)) {
                return;
            }
            if (this._selectedRowCount != 0 || this._selectedColumnCount != 0) {
                this.deselectAll();
            }
            if (this._cells == null) {
                this._cells = new boolean[this._columnCount][this._rowCount];
            }
            this._cells[n][n2] = true;
            ++this._selectedCellCount;
            this._grid.fireCellEvent(n, n2, 2002);
        } else {
            if (this._grid.fireCancelableCellEvent(n, n2, 2003)) {
                return;
            }
            this._cells[n][n2] = false;
            --this._selectedCellCount;
            this._grid.fireCellEvent(n, n2, 2004);
        }
        this._grid.paintCell(n, n2);
    }

    public boolean isCellSelected(int n, int n2) {
        return this._cells != null && this._cells[n][n2];
    }

    public Cell[] getSelectedCells() {
        if (this._selectedCellCount == 0) {
            return null;
        }
        Cell[] cellArray = new Cell[this._selectedCellCount];
        int n = 0;
        for (int i = 0; i < this._columnCount; ++i) {
            for (int j = 0; j < this._rowCount; ++j) {
                if (!this.isCellSelected(i, j)) continue;
                cellArray[n] = new Cell(i, j);
                if (++n != this._selectedCellCount) continue;
                return cellArray;
            }
        }
        return cellArray;
    }

    public void selectCellRange(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        Grid grid = this._grid;
        int n11 = grid.getRowVisibleIndex(n2);
        if (n11 <= (n10 = grid.getRowVisibleIndex(n4))) {
            n9 = n11;
            n8 = n10;
        } else {
            n9 = n10;
            n8 = n11;
        }
        int n12 = grid.getColumnVisibleIndex(n);
        int n13 = grid.getColumnVisibleIndex(n3);
        if (n12 <= n13) {
            n7 = n12;
            n6 = n13;
        } else {
            n7 = n13;
            n6 = n12;
        }
        Cell[] cellArray = this.getSelectedCells();
        if (cellArray != null) {
            for (n5 = 0; n5 < cellArray.length; ++n5) {
                Cell cell = cellArray[n5];
                int n14 = grid.getColumnVisibleIndex(cell.column);
                int n15 = grid.getRowVisibleIndex(cell.row);
                if (n14 >= n7 && n14 <= n6 && n15 >= n9 && n15 <= n8) continue;
                this.setCellSelected(cell.column, cell.row, false);
            }
        }
        if (n11 <= n10) {
            n9 = n2;
            n8 = n4;
        } else {
            n9 = n4;
            n8 = n2;
        }
        if (n12 <= n13) {
            n7 = n;
            n6 = n3;
        } else {
            n7 = n3;
            n6 = n;
        }
        n5 = n7;
        while (n5 != -1) {
            int n16 = n9;
            while (n16 != -1) {
                if (!this.isCellSelected(n5, n16)) {
                    this.setCellSelected(n5, n16, true);
                }
                if (n16 == n8) break;
                n16 = grid.getNextVisibleRow(n16);
            }
            if (n5 == n6) break;
            n5 = grid.getNextVisibleColumn(n5);
        }
    }

    public void addCellToSelection(int n, int n2) {
        this.setCellSelected(n, n2, true);
    }

    public void removeCellFromSelection(int n, int n2) {
        this.setCellSelected(n, n2, false);
    }

    private boolean[] _addToArray(boolean[] blArray, int n, int n2) {
        int n3 = blArray.length;
        boolean[] blArray2 = new boolean[n3 + n2];
        if (n != 0) {
            System.arraycopy(blArray, 0, blArray2, 0, n);
        }
        if (n != n3) {
            System.arraycopy(blArray, n, blArray2, n + n2, n3 - n);
        }
        return blArray2;
    }

    private boolean[] _removeFromArray(boolean[] blArray, int n, int n2) {
        int n3 = blArray.length;
        boolean[] blArray2 = new boolean[n3 - n2];
        if (n != 0) {
            System.arraycopy(blArray, 0, blArray2, 0, n);
        }
        if (n3 - n2 != n) {
            System.arraycopy(blArray, n + n2, blArray2, n, n3 - (n + n2));
        }
        return blArray2;
    }

    private void _addRowsToCells(int n, int n2) {
        int n3 = this._rowCount;
        boolean[][] blArray = this._cells;
        boolean[][] blArray2 = new boolean[this._columnCount][n3 + n2];
        for (int i = 0; i < this._columnCount; ++i) {
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                blArray2[i][n4] = blArray[i][n4];
            }
            for (n4 = n; n4 < n3; ++n4) {
                blArray2[i][n4 + n2] = blArray[i][n4];
            }
        }
        this._cells = blArray2;
    }

    private void _removeRowsFromCells(int n, int n2) {
        int n3 = this._rowCount;
        boolean[][] blArray = this._cells;
        boolean[][] blArray2 = new boolean[this._columnCount][n3 - n2];
        for (int i = 0; i < this._columnCount; ++i) {
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                blArray2[i][n4] = blArray[i][n4];
            }
            for (n4 = n + n2; n4 < n3; ++n4) {
                blArray2[i][n4 - n2] = blArray[i][n4];
            }
        }
        this._cells = blArray2;
    }

    private void _addColumnsToCells(int n, int n2) {
        int n3 = this._columnCount;
        boolean[][] blArray = this._cells;
        boolean[][] blArray2 = new boolean[n3 + n2][this._rowCount];
        for (int i = 0; i < this._rowCount; ++i) {
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                blArray2[n4][i] = blArray[n4][i];
            }
            for (n4 = n; n4 < n3; ++n4) {
                blArray2[n4 + n2][i] = blArray[n4][i];
            }
        }
        this._cells = blArray2;
    }

    private void _removeColumnsFromCells(int n, int n2) {
        int n3 = this._columnCount;
        boolean[][] blArray = this._cells;
        boolean[][] blArray2 = new boolean[n3 - n2][this._rowCount];
        for (int i = 0; i < this._rowCount; ++i) {
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                blArray2[n4][i] = blArray[n4][i];
            }
            for (n4 = n + n2; n4 < n3; ++n4) {
                blArray2[n4 - n2][i] = blArray[n4][i];
            }
        }
        this._cells = blArray2;
    }
}

