/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.grid;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.util.InputEventUtils;

public class BooleanInputHandler
extends CellInputHandler {
    private static BooleanInputHandler _sInputHandler;
    private static final int SPACE = 32;

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        super.mousePressed(mouseEvent, grid, n, n2);
        if (InputEventUtils.isLeftMouseButton(mouseEvent)) {
            this.toggleValue(grid, n, n2);
        }
    }

    public void keyTyped(KeyEvent keyEvent, Grid grid, int n, int n2) {
        if (keyEvent.getKeyChar() == ' ') {
            this.toggleValue(grid, n, n2);
        }
    }

    private void toggleValue(Grid grid, int n, int n2) {
        if (grid.fireCancelableCellEvent(n, n2, 2019)) {
            return;
        }
        TwoDDataSource twoDDataSource = grid.getDataSource();
        Object object = twoDDataSource.getData(n, n2);
        if (object == null) {
            twoDDataSource.setData(n, n2, Boolean.TRUE);
        } else if (((Boolean)object).booleanValue()) {
            twoDDataSource.setData(n, n2, Boolean.FALSE);
        } else {
            twoDDataSource.setData(n, n2, Boolean.TRUE);
        }
        grid.fireCellEvent(n, n2, 2020);
    }

    public static CellInputHandler getCellInputHandler() {
        if (_sInputHandler == null) {
            _sInputHandler = new BooleanInputHandler();
        }
        return _sInputHandler;
    }

    protected BooleanInputHandler() {
    }
}

