/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.graphics;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

class TransparencyTester
implements ImageConsumer {
    private ImageProducer _producer;
    private static final int _COMPUTING_TRANSPARENCY = -1;
    private static final int _IS_NOT_TRANSPARENT = 0;
    private static final int _IS_TRANSPARENT = 1;
    private transient int _isTransparent = -1;

    public TransparencyTester(Image image) {
        this(image.getSource());
    }

    public TransparencyTester(ImageProducer imageProducer) {
        this._producer = imageProducer;
    }

    public synchronized boolean isTransparent() {
        if (this._isTransparent == -1) {
            this._producer.startProduction(this);
            while (this._isTransparent == -1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    return true;
                }
            }
        }
        return this._isTransparent != 0;
    }

    public void setDimensions(int n, int n2) {
    }

    public void setProperties(Hashtable hashtable) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setHints(int n) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (this._isTransparent == -1) {
            int n7 = n2 + n4;
            int n8 = n + n3;
            while (n2 < n7) {
                int n9 = n5;
                for (int i = n; i < n8; ++i) {
                    int n10 = byArray[n9];
                    if (n10 < 0) {
                        n10 += 256;
                    }
                    if (colorModel.getAlpha(n10) != 0) {
                        this._isTransparent = 1;
                    }
                    ++n9;
                }
                n5 += n6;
                ++n2;
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this._isTransparent == -1) {
            int n7 = n2 + n4;
            int n8 = n + n3;
            do {
                int n9 = n5;
                int n10 = n;
                do {
                    if (colorModel.getAlpha(nArray[n9]) != 0) {
                        this._isTransparent = 1;
                        break;
                    }
                    ++n9;
                } while (++n10 < n8);
                n5 += n6;
            } while (this._isTransparent == -1 && ++n2 < n7);
        }
    }

    public synchronized void imageComplete(int n) {
        if (n != 3) {
            this._isTransparent = 1;
        } else if (this._isTransparent != 0) {
            this._isTransparent = 1;
        }
        this._producer.removeConsumer(this);
        this.notifyAll();
    }
}

