/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.graphics;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;

public class ArrowUtils {
    private static final int _ARROW_WIDTH = 11;
    private static final int _ARROW_HEIGHT = 8;
    private static Image _upArrow;
    private static Image _downArrow;
    private static Image _rightArrow;
    private static Image _leftArrow;

    public static Image getRightArrow() {
        if (_rightArrow == null) {
            _rightArrow = ArrowUtils._createHorizontalArrow(true);
        }
        return _rightArrow;
    }

    public static Image getLeftArrow() {
        if (_leftArrow == null) {
            _leftArrow = ArrowUtils._createHorizontalArrow(false);
        }
        return _leftArrow;
    }

    public static Image getUpArrow() {
        if (_upArrow == null) {
            _upArrow = ArrowUtils._createVerticalArrow(true);
        }
        return _upArrow;
    }

    public static Image getDownArrow() {
        if (_downArrow == null) {
            _downArrow = ArrowUtils._createVerticalArrow(false);
        }
        return _downArrow;
    }

    private static Image _createVerticalArrow(boolean bl) {
        int n;
        int n2;
        int n3;
        byte[] byArray = ArrowUtils._getColorArray();
        byte[] byArray2 = new byte[88];
        ArrowUtils._zeroArray(byArray2);
        if (bl) {
            n3 = 0;
            n2 = 11;
        } else {
            n3 = 77;
            n2 = -11;
        }
        byArray2[(n3 += 3 * n2) + 5] = 1;
        n3 += n2;
        for (n = 4; n <= 6; ++n) {
            byArray2[n3 + n] = 1;
        }
        n3 += n2;
        for (n = 3; n <= 7; ++n) {
            byArray2[n3 + n] = 1;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 2, byArray, 0, false, 0);
        MemoryImageSource memoryImageSource = new MemoryImageSource(11, 8, (ColorModel)indexColorModel, byArray2, 0, 11);
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    private static Image _createHorizontalArrow(boolean bl) {
        byte[] byArray = ArrowUtils._getColorArray();
        byte[] byArray2 = new byte[88];
        ArrowUtils._zeroArray(byArray2);
        int n = bl ? 3 : 3;
        int n2 = 16;
        for (int i = 0; i <= 4; ++i) {
            int n3 = 2 - i;
            if (n3 < 0) {
                n3 = -n3;
            }
            n3 = 3 - n3;
            int n4 = n2 + n;
            if (bl) {
                while (--n3 >= 0) {
                    byArray2[n4 + n3] = 1;
                }
            } else {
                while (--n3 >= 0) {
                    byArray2[n4 - n3] = 1;
                }
            }
            n2 += 8;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 2, byArray, 0, false, 0);
        MemoryImageSource memoryImageSource = new MemoryImageSource(8, 11, (ColorModel)indexColorModel, byArray2, 0, 8);
        return Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    private static void _zeroArray(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = n = n2 > 8 ? 8 : n2;
        while (n-- > 0) {
            byArray[n] = 0;
        }
        if (n2 <= 8) {
            return;
        }
        n = 8;
        while (n << 1 <= n2) {
            System.arraycopy(byArray, 0, byArray, n, n);
            n <<= 1;
        }
        System.arraycopy(byArray, 0, byArray, n, n2 - n);
    }

    private static byte[] _getColorArray() {
        byte[] byArray = new byte[6];
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        int n = UIManager.getColor(LookAndFeel.DARK_INTENSITY).getRGB();
        byArray[3] = (byte)((n & 0xFF0000) >> 16);
        byArray[4] = (byte)((n & 0xFF00) >> 8);
        byArray[5] = (byte)(n & 0xFF);
        return byArray;
    }
}

