/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.event;

import java.awt.event.KeyEvent;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.StringUtils;

public class KeyStroke {
    private int _keyCode;
    private char _keyChar;
    private int _modifiers;

    public KeyStroke(int n, int n2) {
        this._keyCode = n;
        this._modifiers = n2;
        this._keyChar = StringUtils.CHAR_UNDEFINED;
    }

    public KeyStroke(char c, int n) {
        this._keyChar = c;
        this._modifiers = n;
        this._keyCode = 0;
    }

    public boolean equals(KeyEvent keyEvent) {
        if (!InputEventUtils.equals(keyEvent.getModifiers(), this._modifiers)) {
            return false;
        }
        if (this._keyCode != 0) {
            return this._keyCode == keyEvent.getKeyCode();
        }
        if (keyEvent.getID() == 400) {
            return Character.toUpperCase(this._keyChar) == Character.toUpperCase(keyEvent.getKeyChar());
        }
        return Character.toUpperCase(this._keyChar) == keyEvent.getKeyCode();
    }

    public boolean equals(Object object) {
        if (object instanceof KeyStroke) {
            KeyStroke keyStroke = (KeyStroke)object;
            return this._keyChar == keyStroke._keyChar && this._keyCode == keyStroke._keyCode && this._modifiers == keyStroke._modifiers;
        }
        return false;
    }

    public int hashCode() {
        return (this._keyChar + '\u0001') * (2 * (this._keyCode + 1)) * (this._modifiers + 1);
    }

    public char getKeyChar() {
        return this._keyChar;
    }

    public int getKeyCode() {
        return this._keyCode;
    }

    public int getModifiers() {
        return this._modifiers;
    }
}

