/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Dimension;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeChildManager;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dTree.OneDSparseArray;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;

public class DTreeSparseChildManager
implements DTreeChildManager,
OneDDataSourceListener {
    private DTreeDeferringParent _parent;
    private OneDSparseArray _children;
    private DTreeItem[] _expandedchildren;
    private int _nexpanded;
    private int _subht;
    private int _parentht;

    public DTreeSparseChildManager(DTreeDeferringParent dTreeDeferringParent) {
        this._parent = dTreeDeferringParent;
        OneDDataSource oneDDataSource = dTreeDeferringParent.getDataSource();
        if (oneDDataSource != null) {
            oneDDataSource.addDataSourceListener(this);
        }
    }

    public void childExpansionChanged(DTreeItem dTreeItem) {
        if (dTreeItem.isExpanded()) {
            this._addExpandedChild(dTreeItem);
        } else {
            this._removeExpandedChild(dTreeItem);
        }
    }

    public int getChildX(int n) {
        DTree dTree = this._parent.getTree();
        int n2 = this._parent.getX();
        int n3 = this.getChildrenXOffset(dTree.getIndentWidth());
        if (dTree.getActualReadingDirection() == 2) {
            Dimension dimension = this._parent.getSize();
            DTreeItem dTreeItem = this.getItem(n);
            Dimension dimension2 = dTreeItem.getSize();
            return n2 + dimension.width - dimension2.width - n3;
        }
        if (this._parent == dTree.getRoot()) {
            return n2;
        }
        return n2 + n3;
    }

    public int getChildY(int n) {
        int n2 = this._parent.getY();
        int n3 = this._getParentHeight();
        int n4 = this._parent.getChildHeight();
        int n5 = 0;
        int n6 = n2 + this.getChildrenYOffset(n3);
        if (this._parent.isExpanded() && this._nexpanded != 0) {
            DTreeItem dTreeItem;
            int n7;
            for (int i = 0; i < this._nexpanded && n > (n7 = (dTreeItem = this._expandedchildren[i]).getIndex()); ++i) {
                n6 += (n7 - n5) * n4 + dTreeItem.getSubTreeHeight();
                n5 = n7 + 1;
            }
        }
        return n6 + (n - n5) * n4;
    }

    public DTreeItem getItem(int n) {
        DTreeItemFactory dTreeItemFactory;
        DTreeItem dTreeItem;
        if (this._children == null) {
            this._children = new OneDSparseArray();
        }
        if ((dTreeItem = (DTreeItem)this._children.getElement(n)) == null && (dTreeItem = (dTreeItemFactory = this._parent.getItemFactory()).createItem(this._parent, n)) != null) {
            this._children.setElement(dTreeItem, n);
            dTreeItem.itemAdded(this._parent, n);
        }
        return dTreeItem;
    }

    public DTreeItem getItemAt(int n, int n2) {
        int n3 = this._parent.getSubTreeHeight();
        if (n2 >= n3) {
            return null;
        }
        int n4 = this._getParentHeight();
        if (n2 < n4) {
            return this._parent;
        }
        int n5 = this._parent.getChildHeight();
        int n6 = 0;
        int n7 = this.getChildrenYOffset(n4);
        if (this._parent.isExpanded() && this._nexpanded != 0) {
            int n8 = this._parent.getY();
            for (int i = 0; i < this._nexpanded; ++i) {
                DTreeItem dTreeItem = this._expandedchildren[i];
                int n9 = dTreeItem.getIndex();
                int n10 = n7 + (n9 - n6) * n5;
                n3 = dTreeItem.getSubTreeHeight();
                if (n2 < n10) break;
                if (n2 < n10 + n3) {
                    return dTreeItem.getItemAt(n, n2 - n10);
                }
                n7 = n10 + n3;
                n6 = n9 + 1;
            }
        }
        return this._parent.getItem(n6 + (n2 - n7) / n5);
    }

    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = null;
        if (dTreeItem == null) {
            if (this._nexpanded > 0) {
                dTreeItem2 = this._expandedchildren[0];
            }
        } else {
            int n;
            for (n = 0; n < this._nexpanded && this._expandedchildren[n] != dTreeItem; ++n) {
            }
            if (n < this._nexpanded - 1) {
                dTreeItem2 = this._expandedchildren[n + 1];
            }
        }
        return dTreeItem2;
    }

    public DTreeItem getNextInstantiatedChild(DTreeItem dTreeItem) {
        if (this._children == null) {
            return null;
        }
        int n = 0;
        n = dTreeItem == null ? this._children.getFirstIndex() : this._children.getNextIndex(dTreeItem.getIndex());
        if (n == -1) {
            return null;
        }
        return (DTreeItem)this._children.getElement(n);
    }

    public int getSubTreeHeight() {
        return this._subht;
    }

    public void invalidateItems(OneDDataSourceEvent oneDDataSourceEvent) {
        DTree dTree = this._parent.getTree();
        dTree.itemsInvalidated(this._parent, oneDDataSourceEvent.getStartIndex(), oneDDataSourceEvent.getItemCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemsAdded(OneDDataSourceEvent oneDDataSourceEvent) {
        Object object;
        int n = oneDDataSourceEvent.getStartIndex();
        int n2 = oneDDataSourceEvent.getItemCount();
        OneDDataSource oneDDataSource = this._parent.getDataSource();
        int n3 = oneDDataSource.getItemCount();
        if (this._children != null) {
            object = this._children;
            synchronized (object) {
                this._children.insertElements(n, n2);
                int n4 = this._children.getNextIndex(n);
                while (n4 != -1) {
                    DTreeItem dTreeItem = (DTreeItem)this._children.getElement(n4);
                    if (dTreeItem != null) {
                        dTreeItem.setIndex(n4);
                    }
                    n4 = this._children.getNextIndex(n4);
                }
            }
        }
        if ((object = this._parent.getTree()) != null) {
            ((DTree)object).itemsAdded(this._parent, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemsRemoved(OneDDataSourceEvent oneDDataSourceEvent) {
        Object object;
        int n = oneDDataSourceEvent.getStartIndex();
        int n2 = oneDDataSourceEvent.getItemCount();
        OneDDataSource oneDDataSource = this._parent.getDataSource();
        int n3 = oneDDataSource.getItemCount();
        if (this._children != null) {
            object = this._children;
            synchronized (object) {
                DTreeItem dTreeItem;
                int n4 = n;
                while (n4 != -1 && n4 < n + n2) {
                    dTreeItem = (DTreeItem)this._children.getElement(n4);
                    if (dTreeItem != null) {
                        if (dTreeItem.isExpanded()) {
                            this._removeExpandedChild(dTreeItem);
                        }
                        dTreeItem.itemRemoved();
                    }
                    n4 = this._children.getNextIndex(n4);
                }
                this._children.removeElements(n, n2);
                n4 = n;
                while (n4 != -1) {
                    dTreeItem = (DTreeItem)this._children.getElement(n4);
                    if (dTreeItem != null) {
                        dTreeItem.setIndex(n4);
                    }
                    n4 = this._children.getNextIndex(n4);
                }
            }
        }
        if ((object = this._parent.getTree()) != null) {
            ((DTree)object).itemsRemoved(this._parent, n, n2);
        }
    }

    public void layout(int n, int n2) {
        int n3 = this._parentht = this._parent.getSize().height;
        if (this._parent.isExpanded() && this._parent.getItemCount() != 0) {
            DTree dTree = this._parent.getTree();
            int n4 = this.getChildrenYOffset(n3);
            int n5 = 0;
            if (this._parent != dTree.getRoot()) {
                n5 = this.getChildrenXOffset(dTree.getIndentWidth());
            }
            int n6 = this._layoutChildren(n + n5, n2 + n4);
            this._subht = Math.max(n3, n4 + n6);
        } else {
            this._subht = n3;
        }
    }

    protected int getChildrenXOffset(int n) {
        return n;
    }

    protected int getChildrenYOffset(int n) {
        return n;
    }

    protected DTreeItem getParent() {
        return this._parent;
    }

    private void _addExpandedChild(DTreeItem dTreeItem) {
        if (this._expandedchildren == null) {
            this._expandedchildren = new DTreeItem[1];
        }
        if (this._nexpanded == this._expandedchildren.length) {
            DTreeItem[] dTreeItemArray = new DTreeItem[this._expandedchildren.length * 2];
            System.arraycopy(this._expandedchildren, 0, dTreeItemArray, 0, this._nexpanded);
            this._expandedchildren = dTreeItemArray;
        }
        int n = dTreeItem.getIndex();
        for (int i = 0; i < this._nexpanded; ++i) {
            if (n >= this._expandedchildren[i].getIndex()) continue;
            System.arraycopy(this._expandedchildren, i, this._expandedchildren, i + 1, this._nexpanded - i);
            break;
        }
        this._expandedchildren[i] = dTreeItem;
        ++this._nexpanded;
    }

    private int _layoutChildren(int n, int n2) {
        int n3 = 0;
        int n4 = this._parent.getChildHeight();
        if (this._parent.isExpanded() && this._nexpanded != 0) {
            int n5 = 0;
            for (int i = 0; i < this._nexpanded; ++i) {
                DTreeItem dTreeItem = this._expandedchildren[i];
                n5 = (dTreeItem.getIndex() - i) * n4 + n3;
                dTreeItem.layout(n, n2 + n5);
                n3 += dTreeItem.getSubTreeHeight();
            }
        }
        return n3 + (this._parent.getItemCount() - this._nexpanded) * n4;
    }

    private void _removeExpandedChild(DTreeItem dTreeItem) {
        for (int i = 0; i < this._nexpanded; ++i) {
            if (this._expandedchildren[i] != dTreeItem) continue;
            if (i != this._nexpanded - 1) {
                System.arraycopy(this._expandedchildren, i + 1, this._expandedchildren, i, this._nexpanded - i - 1);
            }
            --this._nexpanded;
            this._expandedchildren[this._nexpanded] = null;
            return;
        }
    }

    private int _getParentHeight() {
        return this._parentht;
    }
}

