/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.color;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.access.AccessibleContextProxy;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.button.PushButton;
import oracle.ewt.color.ColorGrid;
import oracle.ewt.color.ColorPalettePane;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.NullTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.event.tracking.TrackingUtils;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.grid.Cell;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridKeyNavigator;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.popup.PopupUtils;
import oracle.ewt.popup.ToolTipManager;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.util.FocusUtils;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.InputEventUtils;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.ewt.util.WindowUtils;

public class ColorChoice
extends LWComponent
implements ItemSelectable {
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_COLOR_PALETTE = "customColorPalette";
    private static final int[] _sPOPUP_LOCATIONS = new int[]{17, 12, 22, 7, 18, 23, 9, 14, 16, 11, 21, 6, 10, 5, 2, 1, 0, 24, 19, 23, 18, 4, 3, 20, 15};
    private static final String _RESOURCE_FILE = "oracle.ewt.color.resource.ColorBundle";
    private static final String _KEY_NO_COLOR = "COLORCHOICE.NO_COLOR";
    private static final String _KEY_EDIT_COLOR = "COLORCHOICE.EDIT_COLOR";
    private static Color _sCOLOR;
    private static Image _sColorImage;
    private static ImageSet _defaultImageSet;
    private Listener _listener;
    private static final long _VISIBLE_MILLIS = 400L;
    private Image _image;
    private Color _colorToChange;
    private Filter _filter;
    private ColorGrid _grid;
    private ColorGrid _customGrid;
    private GridListener _gridListener;
    private long _popMillis;
    private PushButton _button;
    private boolean _dragging;
    private ColorGrid _dragGrid;
    private boolean _isDropDownVisible;
    private MoveCheck _moveCheck;
    private MouseGrabProvider _mouseGrabProvider;
    private Window _checkWindow;
    private KeeperUpper _popdownCanceller;
    private ListenerManager _iListenerManager;
    private boolean _changeBackground = true;
    private boolean _transparentAllowed;
    private LWCheckbox _transparent;
    private boolean _editAllowed;
    private PushButton _editButton;
    private PropertyChangeSupport _propertyChangeSupport;
    private ColorPopup _popup;
    private ColorPalettePane _colorPalettePane;
    private LWCheckboxGroup _checkboxGroup;
    private static final Navigate _navigator;
    private Color _selectedColor;
    private boolean _isCustomColor;

    public ColorChoice() {
        this._init(null, null, null, null);
    }

    public ColorChoice(String string) {
        this._init(string, null, null, null);
    }

    public ColorChoice(ImageSet imageSet) {
        this._init(null, imageSet, null, null);
    }

    public ColorChoice(String string, Color[][] colorArray, Color color) {
        this._init(string, null, colorArray, color);
    }

    public ColorChoice(ImageSet imageSet, Color[][] colorArray, Color color) {
        this._init(null, imageSet, colorArray, color);
    }

    public void setLabel(String string) {
        this.getButton().setLabel(string);
    }

    public String getLabel() {
        return this.getButton().getLabel();
    }

    public void setImageSet(ImageSet imageSet) {
        this.getButton().setImageSet(imageSet);
    }

    public ImageSet getImageSet() {
        return this.getButton().getImageSet();
    }

    public void setColumnWidth(int n) {
        this._getGrid().setDefaultColumnWidth(n);
    }

    public void setRowHeight(int n) {
        this._getGrid().setDefaultRowHeight(n);
    }

    public void setColors(Color[][] colorArray) {
        int n = colorArray == null ? 0 : colorArray.length;
        int n2 = n == 0 ? 0 : colorArray[0].length;
        ArrayTwoDDataSource arrayTwoDDataSource = n == 0 && n2 == 0 ? null : new ArrayTwoDDataSource(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                arrayTwoDDataSource.setData(i, j, colorArray[i][j]);
            }
        }
        this.setColorPalette(arrayTwoDDataSource);
    }

    public Color[][] getColors() {
        TwoDDataSource twoDDataSource = this.getColorPalette();
        Color[][] colorArray = new Color[twoDDataSource.getColumnCount()][twoDDataSource.getRowCount()];
        for (int i = 0; i < twoDDataSource.getColumnCount(); ++i) {
            int n = 0;
            while (i < twoDDataSource.getRowCount()) {
                colorArray[i][n] = (Color)twoDDataSource.getData(i, n);
                ++n;
            }
        }
        return colorArray;
    }

    public void setChangesBackground(boolean bl) {
        this._changeBackground = bl;
    }

    public boolean getChangesBackground() {
        return this._changeBackground;
    }

    public void setImage(Image image, Color color) {
        if (this._image != image) {
            if (image == null) {
                image = ColorChoice._getColorImage();
                color = _sCOLOR;
            }
            this._image = image;
            this._colorToChange = color;
            this._filter = new Filter(color);
            this._filter.setColor(this.getSelectedColor());
            this._setIcons(this._image, this._filter);
        }
    }

    public Image getImage() {
        return this._image;
    }

    public Color getColorToChange() {
        return this._colorToChange;
    }

    public void setColorPalette(TwoDDataSource twoDDataSource) {
        this._getGrid().setColorPalette(twoDDataSource);
    }

    public TwoDDataSource getColorPalette() {
        return this._getGrid().getColorPalette();
    }

    public void setCustomColorPalette(TwoDDataSource twoDDataSource) {
        this._getCustomGrid().setColorPalette(twoDDataSource);
    }

    public TwoDDataSource getCustomColorPalette() {
        return this._getCustomGrid().getColorPalette();
    }

    public boolean isTransparentAllowed() {
        return this._transparentAllowed;
    }

    public void setTransparentAllowed(boolean bl) {
        if (this._transparentAllowed != bl) {
            this._transparentAllowed = bl;
        }
    }

    public boolean isEditAllowed() {
        return this._editAllowed;
    }

    public void setEditAllowed(boolean bl) {
        if (this._editAllowed != bl) {
            this._editAllowed = bl;
        }
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = null;
        Color color = this.getSelectedColor();
        if (color != null) {
            objectArray = new Object[]{color};
        }
        return objectArray;
    }

    public void addItemListener(ItemListener itemListener) {
        if (this._iListenerManager == null) {
            this._iListenerManager = new ListenerManager();
        }
        this._iListenerManager.addListener(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        if (this._iListenerManager != null) {
            this._iListenerManager.removeListener(itemListener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void setSelectedColor(Color color) {
        this.setSelectedColor(color, false);
    }

    public Color getSelectedColor() {
        return this._selectedColor;
    }

    public boolean isCustomColorSelected() {
        return this._isCustomColor;
    }

    public void setSelectedColor(Color color, boolean bl) {
        if (bl) {
            this._getCustomGrid().setSelectedColor(color);
        } else {
            this._getGrid().setSelectedColor(color);
        }
        Color color2 = this._selectedColor;
        this._isCustomColor = bl;
        this._selectedColor = color;
        this._setSelectedColor(color2, color, bl);
    }

    public Color getClosestColor(Color color) {
        return this.getClosestColor(color, false);
    }

    public Color getClosestColor(Color color, boolean bl) {
        if (bl) {
            return this._getCustomGrid().getClosestColor(color);
        }
        return this._getGrid().getClosestColor(color);
    }

    public static Color[][] getDefaultColorPalette() {
        return ColorGrid.__sDEFAULT_PALETTE;
    }

    public ColorPalettePane getColorPalettePane() {
        if (this._colorPalettePane == null) {
            this._colorPalettePane = new ColorPalettePane();
            this._initPane(this._colorPalettePane);
        }
        return this._colorPalettePane;
    }

    public void requestFocus() {
        this.getButton().requestFocus();
        this.getButton().repaint();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void removeNotify() {
        this.setDropDownVisible(false);
        super.removeNotify();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this._button != null) {
            this._button.setEnabled(this.isEnabled() && this.allowDropDown());
        }
    }

    public Dimension getPreferredSize() {
        return this.getButton().getPreferredSize();
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    protected PushButton getButton() {
        return this._button;
    }

    protected boolean allowDropDown() {
        return this.getColorPalette().getColumnCount() > 0 && this.getColorPalette().getRowCount() > 0 || this.getCustomColorPalette() != null && this.getCustomColorPalette().getColumnCount() > 0 && this.getCustomColorPalette().getRowCount() > 0;
    }

    protected void setDropDownVisible(boolean bl) {
        if (this._isDropDownVisible == bl) {
            return;
        }
        ColorPopup colorPopup = this._getPopup();
        ColorGrid colorGrid = this._getGrid();
        ColorGrid colorGrid2 = this._getCustomGrid();
        if (bl) {
            if (!this.allowDropDown()) {
                return;
            }
            FocusUtils.setFocusTraversalKeysEnabled(this.getButton(), false);
            colorPopup.updatePanel();
            ToolTipManager.getToolTipManager().leave(this);
            this._popMillis = System.currentTimeMillis();
            if (this._moveCheck == null) {
                this._moveCheck = new MoveCheck();
            }
            colorGrid.setReadingDirection(this.getActualReadingDirection());
            colorGrid.setForeground(this.getForeground());
            colorGrid.setBackground(this.getBackground());
            colorGrid2.setReadingDirection(this.getActualReadingDirection());
            colorGrid2.setForeground(this.getForeground());
            colorGrid2.setBackground(this.getBackground());
            if (this.isCustomColorSelected()) {
                colorGrid2.setSelectedColor(this.getSelectedColor());
                colorGrid2.requestFocus(colorGrid2.getSelectedColumn(), colorGrid2.getSelectedRow(), null);
                colorGrid2.setArmedCell(colorGrid2.getSelectedColumn(), colorGrid2.getSelectedRow());
            } else {
                colorGrid.setSelectedColor(this.getSelectedColor());
                colorGrid.requestFocus(colorGrid.getSelectedColumn(), colorGrid.getSelectedRow(), null);
                colorGrid.setArmedCell(colorGrid.getSelectedColumn(), colorGrid.getSelectedRow());
            }
            this._isDropDownVisible = this._showDropDown();
            if (this._isDropDownVisible) {
                this._mouseGrabProvider = TrackingUtils.getMouseGrabProvider(this);
                this._checkWindow = WindowUtils.getWindow(colorGrid);
                this._checkWindow.addComponentListener(this._moveCheck);
                if (this.isCustomColorSelected()) {
                    colorGrid2.requestFocus();
                } else {
                    colorGrid.requestFocus();
                }
                if (this._mouseGrabProvider != null) {
                    this._popdownCanceller = new KeeperUpper(colorPopup);
                    this._mouseGrabProvider.addMouseGrab(this._popdownCanceller);
                }
            }
        } else {
            PopupUtils.hidePopup(colorPopup);
            this._checkWindow.removeComponentListener(this._moveCheck);
            if (this._mouseGrabProvider != null) {
                this._mouseGrabProvider.removeMouseGrab(this._popdownCanceller);
                this._popdownCanceller = null;
                this._mouseGrabProvider = null;
            }
            this._isDropDownVisible = false;
            this._dragGrid = null;
            this._dragging = false;
            this.getButton().requestFocus();
            FocusUtils.setFocusTraversalKeysEnabled(this.getButton(), true);
        }
        this._button.repaint();
    }

    protected boolean isDropDownVisible() {
        return this._isDropDownVisible;
    }

    protected void fireItemEvent(Color color, int n) {
        ItemEvent itemEvent = new ItemEvent(this, 701, color, n);
        this.processEvent(itemEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this._iListenerManager == null) {
            return;
        }
        Enumeration enumeration = this._iListenerManager.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
            }
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEventImpl(aWTEvent);
        }
    }

    void processMouseDrag(MouseEvent mouseEvent) {
        if (!this.isDropDownVisible()) {
            return;
        }
        if (this._handleDragInGrid(mouseEvent, this._getGrid())) {
            return;
        }
        if (this._handleDragInGrid(mouseEvent, this._getCustomGrid())) {
            return;
        }
    }

    void processMouseReleased(MouseEvent mouseEvent) {
        long l = System.currentTimeMillis();
        if (l - this._popMillis < 400L) {
            mouseEvent.consume();
            return;
        }
        if (this._dragging) {
            Point point = this.getLocationOnScreen();
            Point point2 = this._dragGrid.getLocationOnScreen();
            int n = point.x - point2.x;
            int n2 = point.y - point2.y;
            mouseEvent.translatePoint(n, n2);
            this._gridListener.handleMouseReleased(mouseEvent, this._dragGrid);
            mouseEvent.consume();
        }
        this._dragging = false;
        this._dragGrid = null;
    }

    void internalKeyPressed(KeyEvent keyEvent) {
        ColorGrid colorGrid;
        boolean bl;
        if (!this.isEnabled()) {
            return;
        }
        LWComponent lWComponent = ColorChoice.getFocusedComponent();
        int n = keyEvent.getKeyCode();
        boolean bl2 = lWComponent == this._getGrid();
        boolean bl3 = bl = lWComponent == this._getCustomGrid();
        ColorGrid colorGrid2 = bl2 ? this._getGrid() : (colorGrid = bl ? this._getCustomGrid() : null);
        TwoDDataSource twoDDataSource = bl2 ? this.getColorPalette() : (bl ? this.getCustomColorPalette() : NullTwoDDataSource.getTwoDDataSource());
        int n2 = twoDDataSource.getColumnCount();
        int n3 = twoDDataSource.getRowCount();
        int n4 = -1;
        int n5 = -1;
        boolean bl4 = this.isDropDownVisible();
        if (!bl4) {
            n5 = this._getGrid().getSelectedColumn();
            n4 = this._getGrid().getSelectedRow();
        } else if (colorGrid != null) {
            n5 = colorGrid.getArmedColumn();
            n4 = colorGrid.getArmedRow();
        }
        boolean bl5 = false;
        switch (n) {
            case 40: {
                if (keyEvent.isAltDown()) {
                    this.setDropDownVisible(!this.isDropDownVisible());
                    bl5 = true;
                    break;
                }
            }
            case 34: {
                if (n5 == -1 || n4 == -1) {
                    n5 = 0;
                    n4 = 0;
                    break;
                }
                if (n4 >= n3 - 1) {
                    n4 = 0;
                    break;
                }
                ++n4;
                break;
            }
            case 39: {
                if (n5 == -1 || n4 == -1) {
                    n5 = 0;
                    n4 = 0;
                    break;
                }
                if (n5 >= n2 - 1) {
                    n5 = 0;
                    break;
                }
                ++n5;
                break;
            }
            case 38: {
                if (keyEvent.isAltDown()) {
                    this.setDropDownVisible(!this.isDropDownVisible());
                    bl5 = true;
                    break;
                }
            }
            case 33: {
                if (n5 == -1 || n4 == -1) {
                    n5 = n2 - 1;
                    n4 = n3 - 1;
                    break;
                }
                if (n4 == 0) {
                    n4 = n3 - 1;
                    break;
                }
                --n4;
                break;
            }
            case 37: {
                if (n5 == -1 || n4 == -1) {
                    n5 = n2 - 1;
                    n4 = n3 - 1;
                    break;
                }
                if (n5 == 0) {
                    n5 = n2 - 1;
                    break;
                }
                --n5;
                break;
            }
            case 36: {
                n5 = 0;
                n4 = 0;
                break;
            }
            case 35: {
                n5 = n2 - 1;
                n4 = n3 - 1;
                break;
            }
            case 10: {
                if (!this.isDropDownVisible()) break;
                this.setDropDownVisible(false);
                if (n5 != -1 && n4 != -1) {
                    Color color = (Color)twoDDataSource.getData(n5, n4);
                    this.setSelectedColor(color, bl);
                }
                this.repaint();
                bl5 = true;
                break;
            }
            case 27: {
                if (!this.isDropDownVisible()) break;
                this.setDropDownVisible(false);
                this.repaint();
                bl5 = true;
                break;
            }
            case 32: {
                if (this.isDropDownVisible()) break;
                this.setDropDownVisible(true);
                bl5 = true;
                break;
            }
            case 9: {
                if (!this.isDropDownVisible()) break;
                boolean bl6 = keyEvent.isShiftDown() & !keyEvent.isControlDown() & !keyEvent.isMetaDown() & !keyEvent.isAltDown();
                this._transferFocus(lWComponent, bl6);
                bl5 = true;
                break;
            }
            default: {
                return;
            }
        }
        if (this.isDropDownVisible() && n5 != -1 && n4 != -1) {
            if (colorGrid == null && lWComponent == this.getButton()) {
                colorGrid = this._getGrid();
                colorGrid.requestFocus();
            }
            if (colorGrid != null) {
                colorGrid.scrollCellIntoView(n5, n4);
                colorGrid.setArmedCell(n5, n4);
                bl5 = true;
            }
        }
        this._getGrid().repaint();
        if (bl5) {
            keyEvent.consume();
        }
    }

    void updateImage() {
        Color color = this.getSelectedColor();
        if (this.getImage() != null) {
            this._filter.setColor(color);
            this._setIcons(this.getImage(), this._filter);
        }
    }

    ColorPopup _getPopup() {
        if (this._popup == null) {
            this._popup = new ColorPopup();
            this._popup.setBackground(this.getBackground());
            FocusUtils.setFocusTraversalKeysEnabled(this._popup, false, true);
        }
        return this._popup;
    }

    ColorGrid _getGrid() {
        if (this._grid == null) {
            this._grid = new ColorGrid();
            this._grid.setInDropDown(true);
            this._grid.setGridKeyNavigator(_navigator);
            if (this._gridListener == null) {
                this._gridListener = new GridListener();
            }
            this._grid.addMouseListener(this._gridListener);
            this._grid.addPropertyChangeListener(this._gridListener);
            FocusUtils.setFocusTraversalKeysEnabled(this._grid, false);
        }
        return this._grid;
    }

    ColorGrid _getCustomGrid() {
        if (this._customGrid == null) {
            this._customGrid = new ColorGrid();
            this._customGrid.setInDropDown(true);
            this._customGrid.setGridKeyNavigator(_navigator);
            if (this._gridListener == null) {
                this._gridListener = new GridListener();
            }
            this._customGrid.addMouseListener(this._gridListener);
            this._customGrid.addPropertyChangeListener(this._gridListener);
            TwoDDataSource twoDDataSource = NullTwoDDataSource.getTwoDDataSource();
            this._customGrid.setColorPalette(twoDDataSource);
            FocusUtils.setFocusTraversalKeysEnabled(this._customGrid, false);
        }
        return this._customGrid;
    }

    private void _transferFocus(Component component, boolean bl) {
        boolean bl2;
        Component component2 = component;
        boolean bl3 = bl2 = this._getCustomGrid().getColumnCount() != 0 && this._getCustomGrid().getRowCount() != 0;
        if (component == this._getGrid()) {
            if (bl) {
                if (this.isEditAllowed()) {
                    component2 = this._getEditButton();
                } else if (this.isTransparentAllowed()) {
                    component2 = this._getCheckbox();
                } else if (bl2) {
                    component2 = this._getCustomGrid();
                }
            } else if (bl2) {
                component2 = this._getCustomGrid();
            } else if (this.isTransparentAllowed()) {
                component2 = this._getCheckbox();
            } else if (this.isEditAllowed()) {
                component2 = this._getEditButton();
            }
        } else if (component == this._getCustomGrid()) {
            component2 = bl ? this._getGrid() : (this.isTransparentAllowed() ? this._getCheckbox() : (this.isEditAllowed() ? this._getEditButton() : this._getGrid()));
        } else if (component == this._getCheckbox()) {
            component2 = bl ? (bl2 ? this._getCustomGrid() : this._getGrid()) : (this.isEditAllowed() ? this._getEditButton() : this._getGrid());
        } else if (component == this._getEditButton()) {
            component2 = bl ? (this.isTransparentAllowed() ? this._getCheckbox() : (bl2 ? this._getCustomGrid() : this._getGrid())) : this._getGrid();
        } else if (component == this.getButton()) {
            component2 = this._getGrid();
        }
        if (component != component2) {
            component2.requestFocus();
        }
    }

    private void _setIcons(Image image, ImageFilter imageFilter) {
        this._button.setImage(ColorChoice._createFilteredImage(image, imageFilter));
    }

    private static Image _getColorImage() {
        if (_sColorImage == null) {
            _sColorImage = ImageUtils.getImageResource(ColorChoice.class, "images/color.gif");
            _sCOLOR = new Color(100, 100, 100);
        }
        return _sColorImage;
    }

    private static Image _createFilteredImage(Image image, ImageFilter imageFilter) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    private void _init(String string, ImageSet imageSet, Color[][] colorArray, Color color) {
        Object object;
        this._transparentAllowed = false;
        this._listener = new Listener();
        this.setColors(colorArray);
        this.setSelectedColor(color);
        long l = 60L;
        this.enableEvents(l);
        this._button = new ChoiceButton();
        if (string != null) {
            this._button.setLabel(string);
        } else if (imageSet != null) {
            this._button.setImageSet(imageSet);
        } else {
            object = ColorChoice._getColorImage();
            this.setImage((Image)object, _sCOLOR);
        }
        object = new ButtonListen();
        this._button.addMouseListener((MouseListener)object);
        this._button.addMouseMotionListener((MouseMotionListener)object);
        this._button.addKeyListener((KeyListener)object);
        this.setLayout(new BorderLayout());
        this.add("Center", this._button);
        this._button.setEnabled(this.isEnabled() && this.allowDropDown());
    }

    private void _setSelectedColor(Color color, Color color2, boolean bl) {
        if (bl) {
            this._getGrid().setSelectedColor(null);
        } else {
            this._getCustomGrid().setSelectedColor(null);
        }
        this.updateImage();
        this.firePropertyChange(PROPERTY_SELECTED_COLOR, color, this.getSelectedColor());
    }

    private LWCheckbox _getCheckbox() {
        if (this._transparent == null) {
            this._transparent = new LWCheckbox();
            this._transparent.addItemListener(this._listener);
            String string = this._getTranslatedString(_KEY_NO_COLOR);
            this._transparent.setLabel(StringUtils.stripMnemonic(string));
            this._transparent.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
            this._checkboxGroup = new LWCheckboxGroup();
            this._transparent.setCheckboxGroup(this._checkboxGroup);
            FocusUtils.setFocusTraversalKeysEnabled(this._transparent, false);
        }
        return this._transparent;
    }

    private PushButton _getEditButton() {
        if (this._editButton == null) {
            this._editButton = new PushButton();
            this._editButton.addActionListener(this._listener);
            String string = this._getTranslatedString(_KEY_EDIT_COLOR);
            this._editButton.setLabel(StringUtils.stripMnemonic(string));
            this._editButton.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
            FocusUtils.setFocusTraversalKeysEnabled(this._editButton, false);
        }
        return this._editButton;
    }

    private String _getTranslatedString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_RESOURCE_FILE, LocaleUtils.getTranslationLocale(LocaleUtils.getDefaultableLocale(this)));
        return resourceBundle.getString(string);
    }

    private void _changeButtonColor() {
        if (this._changeBackground) {
            this.getButton().setBackground(this.getSelectedColor());
        }
    }

    private boolean _showDropDown() {
        return null != PopupUtils.displayPopupRelativeTo((Component)this, (Component)this._getPopup(), null, null, _sPOPUP_LOCATIONS);
    }

    private boolean _handleDragInGrid(MouseEvent mouseEvent, ColorGrid colorGrid) {
        Point point = ((Component)mouseEvent.getSource()).getLocationOnScreen();
        Point point2 = colorGrid.getLocationOnScreen();
        int n = mouseEvent.getX() + point.x - point2.x;
        int n2 = mouseEvent.getY() + point.y - point2.y;
        Dimension dimension = colorGrid.getSize();
        if (n < 0 || n > dimension.width || n2 < 0 || n2 > dimension.height) {
            return false;
        }
        Point point3 = colorGrid.getLocationOnScreen();
        mouseEvent.translatePoint(point.x - point3.x, point.y - point3.y);
        this._gridListener.fakeMouseDragged(mouseEvent, colorGrid);
        this._dragging = true;
        if (this._dragGrid != null && this._dragGrid != colorGrid) {
            this._dragGrid.setArmedCell(-1, -1);
        }
        this._dragGrid = colorGrid;
        mouseEvent.consume();
        return true;
    }

    private void _initPane(ColorPalettePane colorPalettePane) {
        boolean bl;
        colorPalettePane.setColorPalette(this.getColorPalette());
        TwoDDataSource twoDDataSource = this.getCustomColorPalette();
        boolean bl2 = bl = twoDDataSource != null && twoDDataSource.getColumnCount() > 0 && twoDDataSource.getRowCount() > 0;
        if (bl) {
            int n = twoDDataSource.getColumnCount();
            int n2 = twoDDataSource.getRowCount();
            ArrayTwoDDataSource arrayTwoDDataSource = new ArrayTwoDDataSource(n, n2);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    arrayTwoDDataSource.setData(i, j, twoDDataSource.getData(i, j));
                }
            }
            colorPalettePane.setCustomColorPalette(arrayTwoDDataSource);
        }
        colorPalettePane.setCustomColorsVisible(bl);
        colorPalettePane.setEditVisible(bl);
        colorPalettePane.setSelectedColor(this.getSelectedColor(), this.isCustomColorSelected());
    }

    private static void _copyDataSource(TwoDDataSource twoDDataSource, TwoDDataSource twoDDataSource2) {
        int n = twoDDataSource.getColumnCount();
        int n2 = twoDDataSource.getRowCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                twoDDataSource2.setData(i, j, twoDDataSource.getData(i, j));
            }
        }
    }

    static {
        _navigator = new Navigate();
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(ColorChoice.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COLOR_CHOOSER;
        }

        public int getAccessibleChildCount() {
            return 2;
        }

        public Accessible getAccessibleChild(int n) {
            if (n == 0) {
                return ColorChoice.this.getButton();
            }
            if (n == 1) {
                ColorPopup colorPopup = ColorChoice.this._getPopup();
                colorPopup.getAccessibleContext().setAccessibleParent(ColorChoice.this);
                return colorPopup;
            }
            return null;
        }
    }

    private static class Navigate
    implements GridKeyNavigator {
        private Navigate() {
        }

        public Cell tab(Grid grid, Cell cell, KeyEvent keyEvent, boolean bl) {
            return cell;
        }

        public Cell enter(Grid grid, Cell cell, KeyEvent keyEvent, boolean bl) {
            return cell;
        }

        public Cell left(Grid grid, Cell cell, KeyEvent keyEvent) {
            return cell;
        }

        public Cell right(Grid grid, Cell cell, KeyEvent keyEvent) {
            return cell;
        }

        public Cell up(Grid grid, Cell cell, KeyEvent keyEvent) {
            return cell;
        }

        public Cell down(Grid grid, Cell cell, KeyEvent keyEvent) {
            return cell;
        }

        public Cell pageUp(Grid grid, Cell cell, KeyEvent keyEvent) {
            return cell;
        }

        public Cell pageDown(Grid grid, Cell cell, KeyEvent keyEvent) {
            return cell;
        }

        public Cell home(Grid grid, Cell cell, KeyEvent keyEvent) {
            return cell;
        }

        public Cell end(Grid grid, Cell cell, KeyEvent keyEvent) {
            return cell;
        }
    }

    private class Listener
    implements ItemListener,
    ActionListener,
    PropertyChangeListener {
        private boolean _dirty;

        private Listener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (ColorChoice.this._transparent.getState()) {
                ColorChoice.this.setSelectedColor(null);
                ColorChoice.this.setDropDownVisible(false);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ColorPalettePane colorPalettePane = ColorChoice.this.getColorPalettePane();
            ColorChoice.this._initPane(colorPalettePane);
            colorPalettePane.addPropertyChangeListener(this);
            this._dirty = false;
            if (ColorPalettePane.showDialog(ColorChoice.this, colorPalettePane) == 1) {
                if (this._dirty) {
                    ColorChoice._copyDataSource(colorPalettePane.getCustomColorPalette(), ColorChoice.this.getCustomColorPalette());
                    ColorChoice.this.firePropertyChange(ColorChoice.PROPERTY_COLOR_PALETTE, null, ColorChoice.this.getCustomColorPalette());
                }
                ColorChoice.this.setSelectedColor(colorPalettePane.getSelectedColor(), colorPalettePane.isCustomColorSelected());
            }
            colorPalettePane.removePropertyChangeListener(this);
            ColorChoice.this.setDropDownVisible(false);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("colorPalette".equals(string)) {
                this._dirty = true;
            }
        }
    }

    private class Filter
    extends RGBImageFilter {
        private int _color;
        private int _colorToChange;

        public Filter(Color color) {
            this._colorToChange = color == null ? 0 : color.getRGB();
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color color) {
            this._color = color == null ? 0 : color.getRGB();
        }

        public int filterRGB(int n, int n2, int n3) {
            if (n3 == this._colorToChange) {
                return this._color;
            }
            return n3;
        }
    }

    private class ColorPopup
    extends LWContainer {
        private LWContainer _panel;
        private LWContainer _gridPanel;
        private ScrollBox _box;
        private boolean _boxAdded;

        public ColorPopup() {
            this.setLayout(new BorderLayout(0, 2));
            this._panel = new LWContainer();
            this._panel.setBorderPainter(new FixedBorderPainter(0, 2, 0, 2));
            this._panel.setLayout(new BorderLayout());
            this._gridPanel = new LWContainer();
            this._gridPanel.setLayout(new BorderLayout(0, 2));
            this._gridPanel.add("North", ColorChoice.this._getGrid());
            this._gridPanel.add("Center", ColorChoice.this._getCustomGrid());
            this._gridPanel.setBorderPainter(null);
            this._box = new ScrollBox(null, 0, 0);
            this._box.setBorderPainter(null);
            this._boxAdded = false;
            this.setBorderPainter(new BlackBorder());
            this.add("Center", this._gridPanel);
            this.add("South", this._panel);
        }

        public void postProcessKey(KeyEvent keyEvent) {
            super.postProcessKey(keyEvent);
            if (keyEvent.isConsumed() || !this.isEnabled() || keyEvent.getID() != 401) {
                return;
            }
            ColorChoice.this.internalKeyPressed(keyEvent);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = ColorChoice.this._getGrid().getPreferredSize();
            Dimension dimension2 = ColorChoice.this._getCustomGrid().getPreferredSize();
            Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), dimension.height + dimension2.height);
            if (dimension2.height != 0) {
                dimension3.height += 2;
            }
            Dimension dimension4 = this._panel.getPreferredSize();
            dimension3.width = Math.max(dimension3.width, dimension4.width);
            dimension3.height += dimension4.height;
            if (ColorChoice.this.isTransparentAllowed() || ColorChoice.this.isEditAllowed()) {
                dimension3.height += 2;
            }
            ImmInsets immInsets = this.getBorderInsets();
            dimension3.width += immInsets.left + immInsets.right;
            dimension3.height += immInsets.top + immInsets.bottom;
            return dimension3;
        }

        public void reshape(int n, int n2, int n3, int n4) {
            Dimension dimension = this.getPreferredSize();
            if (dimension.width > n3 || dimension.height > n4) {
                if (!this._boxAdded) {
                    this.remove(this._gridPanel);
                    this._box.setContent(this._gridPanel);
                    this.add("Center", this._box);
                    this._boxAdded = true;
                    this.validate();
                }
            } else if (this._boxAdded) {
                this._box.setContent(null);
                this.remove(this._box);
                this.add("Center", this._gridPanel);
                this._boxAdded = false;
                this.validate();
            }
            super.reshape(n, n2, n3, n4);
        }

        public void updatePanel() {
            this._panel.removeAll();
            if (ColorChoice.this.isTransparentAllowed()) {
                this._panel.add("West", ColorChoice.this._getCheckbox());
                ColorChoice.this._checkboxGroup.setSelectedCheckbox(null);
                boolean bl = ColorChoice.this.getSelectedColor() == null;
                ColorChoice.this._getCheckbox().setState(bl);
            }
            if (ColorChoice.this.isEditAllowed()) {
                this._panel.add("East", ColorChoice.this._getEditButton());
            }
        }

        private class BlackBorder
        extends FixedBorderPainter {
            public BlackBorder() {
                super(1, 1, 1, 1);
            }

            protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setColor(Color.black);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            }
        }
    }

    private class ButtonListen
    extends MouseAdapter
    implements MouseMotionListener,
    KeyListener {
        private ButtonListen() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            ColorChoice.this.internalKeyPressed(keyEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ColorChoice.this.processMouseDrag(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!ColorChoice.this.isEnabled() || !InputEventUtils.isLeftMouseButton(mouseEvent)) {
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n < 0 || n > dimension.width || n2 < 0 || n2 > dimension.height) {
                return;
            }
            mouseEvent.consume();
            ColorChoice.this.setDropDownVisible(!ColorChoice.this.isDropDownVisible());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ColorChoice.this.processMouseReleased(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class GridListener
    extends MouseAdapter
    implements PropertyChangeListener {
        private GridListener() {
        }

        public void fakeMouseDragged(MouseEvent mouseEvent, ColorGrid colorGrid) {
            Point point = colorGrid.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
            int n = colorGrid.getColumnAt(point.x);
            int n2 = colorGrid.getRowAt(point.y);
            colorGrid.setArmedCell(n, n2);
            if (n2 != -1 && n != -1) {
                mouseEvent.consume();
            }
        }

        public void handleMouseReleased(MouseEvent mouseEvent, ColorGrid colorGrid) {
            int n;
            mouseEvent.consume();
            ColorChoice.this.setDropDownVisible(false);
            if (!InputEventUtils.isLeftMouseButton(mouseEvent)) {
                return;
            }
            Point point = colorGrid.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
            int n2 = point.x < 0 ? -1 : colorGrid.getColumnAt(point.x);
            int n3 = n = point.y < 0 ? -1 : colorGrid.getRowAt(point.y);
            if (n == -1 || n2 == -1) {
                return;
            }
            boolean bl = colorGrid == ColorChoice.this._customGrid;
            TwoDDataSource twoDDataSource = bl ? ColorChoice.this.getCustomColorPalette() : ColorChoice.this.getColorPalette();
            Color color = (Color)twoDDataSource.getData(n2, n);
            ColorChoice.this.setSelectedColor(color, bl);
            ColorChoice.this.requestFocus();
            ColorChoice.this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ColorGrid colorGrid = (ColorGrid)mouseEvent.getSource();
            this.handleMouseReleased(mouseEvent, colorGrid);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (ColorChoice.PROPERTY_SELECTED_COLOR.equals(string) && propertyChangeEvent.getNewValue() != null) {
                if (propertyChangeEvent.getSource() == ColorChoice.this._getGrid()) {
                    ColorChoice.this._getCustomGrid().setSelectedColor(null);
                } else {
                    ColorChoice.this._getGrid().setSelectedColor(null);
                }
            }
        }
    }

    private class Proxy
    extends AccessibleContextProxy {
        private AccessibleContext _ac;

        public Proxy(AccessibleContext accessibleContext) {
            this._ac = accessibleContext;
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            return string == null ? ColorChoice.this.getAccessibleContext().getAccessibleName() : string;
        }

        public String getAccessibleDescription() {
            String string = super.getAccessibleDescription();
            return string == null ? ColorChoice.this.getAccessibleContext().getAccessibleDescription() : string;
        }

        protected AccessibleContext getAccessibleContext() {
            return this._ac;
        }
    }

    private class ChoiceButton
    extends PushButton {
        private ChoiceButton() {
        }

        protected int getPaintState() {
            int n = super.getPaintState();
            n &= 0xFFFFFFFD;
            if (ColorChoice.this.isDropDownVisible()) {
                n |= 2;
            }
            return n;
        }

        protected AccessibleContext createAccessibleContext() {
            AccessibleContext accessibleContext = super.createAccessibleContext();
            return new Proxy(accessibleContext);
        }
    }

    private class MoveCheck
    extends ComponentAdapter {
        private MoveCheck() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            ColorChoice.this.setDropDownVisible(false);
        }
    }

    private class KeeperUpper
    extends MouseAdapter {
        private Component _parent;

        public KeeperUpper(Component component) {
            this._parent = component;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            for (Component component = (Component)mouseEvent.getSource(); component != null; component = component.getParent()) {
                if (component != this._parent) continue;
                return;
            }
            if (mouseEvent.getComponent() == ColorChoice.this.getButton()) {
                mouseEvent.consume();
            }
            ColorChoice.this.setDropDownVisible(false);
        }
    }
}

