/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.alert;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.ewt.alert.BaseAlertPane;
import oracle.ewt.layout.EqualRowLayout;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.plaf.AlertUI;

public class AlertRowLayout
extends EqualRowLayout {
    public static final String CONSTRAINT_YES = "Yes";
    public static final String CONSTRAINT_NO = "No";
    public static final String CONSTRAINT_CANCEL = "Cancel";
    public static final String CONSTRAINT_HELP = "Help";
    public static final int ALIGN_START = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_END = 2;
    Component _yesComponent;
    Component _noComponent;
    Component _cancelComponent;
    Component _helpComponent;
    private static final int _DEFAULT_GAP = 8;
    static final int _START_STAGE = -1;
    static final int _YES_STAGE = 0;
    static final int _NO_STAGE = 1;
    static final int _EVERYTHING_ELSE_STAGE = 2;
    static final int _CANCEL_STAGE = 3;
    static final int _HELP_STAGE = 4;
    static final int _DONE_STAGE = 5;

    public AlertRowLayout() {
        this(1);
    }

    public AlertRowLayout(int n) {
        super(8, n, 1);
    }

    public void addLayoutComponent(String string, Component component) {
        if (CONSTRAINT_YES.equals(string)) {
            this._yesComponent = component;
        } else if (CONSTRAINT_NO.equals(string)) {
            this._noComponent = component;
        } else if (CONSTRAINT_CANCEL.equals(string)) {
            this._cancelComponent = component;
        } else if (CONSTRAINT_HELP.equals(string)) {
            this._helpComponent = component;
        }
        super.addLayoutComponent(string, component);
    }

    public void removeLayoutComponent(Component component) {
        if (this._yesComponent == component) {
            this._yesComponent = null;
        } else if (this._noComponent == component) {
            this._noComponent = null;
        } else if (this._cancelComponent == component) {
            this._cancelComponent = null;
        } else if (this._helpComponent == component) {
            this._helpComponent = null;
        }
        super.removeLayoutComponent(component);
    }

    public Dimension getNaturalCellSize(Container container, boolean bl) {
        return super.getCellSize(container, bl);
    }

    protected Enumeration getComponentEnumeration(Container container) {
        return new Enum(container);
    }

    protected Dimension getCellSize(Container container, boolean bl) {
        AlertUI alertUI = null;
        for (Container container2 = container.getParent(); container2 != null; container2 = container2.getParent()) {
            if (!(container2 instanceof BaseAlertPane)) continue;
            alertUI = (AlertUI)((LWComponent)container2).getUI();
            break;
        }
        if (alertUI != null) {
            return alertUI.getButtonCellSize(bl);
        }
        return super.getCellSize(container, bl);
    }

    boolean _isBuiltInComponent(Component component) {
        return component == this._yesComponent || component == this._noComponent || component == this._cancelComponent || component == this._helpComponent;
    }

    class Enum
    implements Enumeration {
        private int _index;
        private int _count;
        private int _stage;
        private Container _target;

        public Enum(Container container) {
            this._count = container.getComponentCount();
            this._target = container;
            this._stage = this._nextStage(-1);
        }

        public boolean hasMoreElements() {
            return this._stage != 5;
        }

        public Object nextElement() throws NoSuchElementException {
            Component component = null;
            switch (this._stage) {
                case 0: {
                    component = AlertRowLayout.this._yesComponent;
                    break;
                }
                case 1: {
                    component = AlertRowLayout.this._noComponent;
                    break;
                }
                case 2: {
                    component = this._target.getComponent(this._index);
                    break;
                }
                case 3: {
                    component = AlertRowLayout.this._cancelComponent;
                    break;
                }
                case 4: {
                    component = AlertRowLayout.this._helpComponent;
                }
            }
            this._stage = this._nextStage(this._stage);
            if (component == null) {
                throw new NoSuchElementException();
            }
            return component;
        }

        private int _nextStage(int n) {
            switch (n) {
                case -1: {
                    if (AlertRowLayout.this._yesComponent != null) {
                        return 0;
                    }
                }
                case 0: {
                    if (AlertRowLayout.this._noComponent != null) {
                        return 1;
                    }
                }
                case 2: {
                    if (n != -1) {
                        ++this._index;
                    }
                }
                case 1: {
                    int n2 = this._target.getComponentCount();
                    while (this._index < n2) {
                        Component component = this._target.getComponent(this._index);
                        if (!AlertRowLayout.this._isBuiltInComponent(component)) {
                            return 2;
                        }
                        ++this._index;
                    }
                    if (AlertRowLayout.this._cancelComponent != null) {
                        return 3;
                    }
                }
                case 3: {
                    if (AlertRowLayout.this._helpComponent == null) break;
                    return 4;
                }
            }
            return 5;
        }
    }
}

