/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.access;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.popup.PopupOwner;

public class AccessibleUtils {
    private static final String _LABELED_BY_PROPERTY = "_accessLabeledBy";

    public static void setLabeledBy(LWComponent lWComponent, Component component) {
        lWComponent.putClientProperty(_LABELED_BY_PROPERTY, component);
    }

    public static Component getLabeledBy(LWComponent lWComponent) {
        Object object = lWComponent.getClientProperty(_LABELED_BY_PROPERTY);
        if (object instanceof Component) {
            return (Component)object;
        }
        return null;
    }

    public static int getAccessibleIndexInParent(Component component) {
        int n = -1;
        Container container = component.getParent();
        if (container instanceof Accessible) {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] instanceof Accessible) {
                    ++n;
                }
                if (component != componentArray[i]) continue;
                return n;
            }
        }
        return -1;
    }

    public static Accessible getAccessibleAt(Component component, Point point) {
        if (component instanceof Accessible) {
            AccessibleContext accessibleContext = ((Accessible)((Object)component)).getAccessibleContext();
            if (accessibleContext != null) {
                int n = accessibleContext.getAccessibleChildrenCount();
                for (int i = 0; i < n; ++i) {
                    AccessibleComponent accessibleComponent;
                    Accessible accessible = accessibleContext.getAccessibleChild(i);
                    if (accessible == null || (accessibleContext = accessible.getAccessibleContext()) == null || (accessibleComponent = accessibleContext.getAccessibleComponent()) == null || !accessibleComponent.isShowing()) continue;
                    Point point2 = accessibleComponent.getLocation();
                    Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                    if (!accessibleComponent.contains(point3)) continue;
                    return accessible;
                }
            }
            return (Accessible)((Object)component);
        }
        Component component2 = component;
        if (!component.contains(point.x, point.y)) {
            component2 = null;
        } else if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component3 = container.getComponent(i);
                if (!component3.isShowing()) continue;
                Point point4 = component3.getLocation();
                if (!component3.contains(point.x - point4.x, point.y - point4.y)) continue;
                component2 = component3;
            }
        }
        if (component2 instanceof Accessible) {
            return (Accessible)((Object)component2);
        }
        return null;
    }

    public static AccessibleStateSet getAccessibleStateSet(Component component) {
        AccessibleSelection accessibleSelection;
        AccessibleContext accessibleContext;
        Accessible accessible;
        AccessibleContext accessibleContext2;
        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
        if (component.isEnabled()) {
            accessibleStateSet.add(AccessibleState.ENABLED);
        }
        if (component.isFocusTraversable()) {
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
        }
        if (component.isVisible()) {
            accessibleStateSet.add(AccessibleState.VISIBLE);
            if (component.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
        }
        if (component instanceof Accessible && (accessibleContext2 = ((Accessible)((Object)component)).getAccessibleContext()) != null && (accessible = accessibleContext2.getAccessibleParent()) != null && (accessibleContext = accessible.getAccessibleContext()) != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            int n = accessibleContext2.getAccessibleIndexInParent();
            if (n >= 0 && accessibleSelection.isAccessibleChildSelected(n)) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
        }
        return accessibleStateSet;
    }

    public static int getAccessibleChildrenCount(Component component) {
        int n = 0;
        if (component instanceof Container) {
            PopupOwner popupOwner = component instanceof PopupOwner ? (PopupOwner)((Object)component) : null;
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Accessible) || popupOwner != null && popupOwner.isPopup(componentArray[i])) continue;
                ++n;
            }
        }
        return n;
    }

    public static Accessible getAccessibleChild(Component component, int n) {
        if (component instanceof Container) {
            PopupOwner popupOwner = component instanceof PopupOwner ? (PopupOwner)((Object)component) : null;
            Component[] componentArray = ((Container)component).getComponents();
            int n2 = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                Component component2 = componentArray[i];
                if (!(component2 instanceof Accessible) || popupOwner != null && popupOwner.isPopup(component2)) continue;
                if (n2 == n) {
                    return (Accessible)((Object)component2);
                }
                ++n2;
            }
        }
        return null;
    }

    private AccessibleUtils() {
    }
}

