/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard.dWizard;

import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.dWizard.NullSequence;
import oracle.bali.ewt.wizard.dWizard.WizardSequence;
import oracle.bali.ewt.wizard.dWizard.WizardSequence2;
import oracle.bali.ewt.wizard.dWizard.WizardSequenceEvent;
import oracle.bali.ewt.wizard.dWizard.WizardSequenceListener;

public class DWizard
extends Wizard {
    private static int _NO_DIRECTION = 0;
    private static int _FORWARD = 1;
    private static int _BACKWARD = 2;
    private WizardSequence _sequence;
    private int _currentIndex;
    private Listener _listener;
    private int _dir = _NO_DIRECTION;

    public DWizard() {
        this(NullSequence.getWizardSequence());
    }

    public DWizard(WizardSequence sequence) {
        this.setSequence(sequence);
    }

    public void setSequence(WizardSequence sequence) {
        if (this._sequence != null) {
            if (this._sequence instanceof WizardSequence2) {
                ((WizardSequence2)this._sequence).removeWizardSequenceListener(this._listener);
            }
            this.removeAllPages();
        }
        if (sequence == null) {
            sequence = NullSequence.getWizardSequence();
        }
        this._sequence = sequence;
        if (sequence instanceof WizardSequence2) {
            WizardSequence2 sequence2 = (WizardSequence2)sequence;
            int count = sequence2.getPageCount();
            for (int i = 0; i < count; ++i) {
                this.addPage(sequence2.getPageAt(i));
            }
            if (this._listener == null) {
                this._listener = new Listener();
            }
            sequence2.addWizardSequenceListener(this._listener);
        } else if (this.isRoadmapVisible()) {
            this.setRoadmapVisible(false);
        }
        this.restart();
    }

    public WizardSequence getSequence() {
        return this._sequence;
    }

    public void goBackwards() {
        if (this._sequence.getPreviousPage() != null) {
            this.doPrevious();
        }
    }

    public void goForward() {
        if (this._sequence.getNextPage() != null) {
            this.doNext();
        }
    }

    public void enableButtons() {
        super.enableButtons();
    }

    public void restart() {
        this.reset();
        this._sequence.goToFirstPage();
        this._currentIndex = 0;
        WizardPage page = this._sequence.getCurrentPage();
        if (page != null) {
            this.selectPage(page, false);
        }
    }

    public int getCurrentPageIndex() {
        if (this.getSequence() instanceof WizardSequence2) {
            return super.getCurrentPageIndex();
        }
        return this._currentIndex;
    }

    public int getPageCount() {
        if (this.getSequence() instanceof WizardSequence2) {
            return super.getPageCount();
        }
        return this._sequence.getPageCount();
    }

    public WizardPage getNextPage(WizardPage page) {
        if (this._sequence instanceof WizardSequence2) {
            return super.getNextPage(page);
        }
        if (page == null) {
            return null;
        }
        return this._sequence.getNextPage();
    }

    public WizardPage getPreviousPage(WizardPage page) {
        if (this._sequence instanceof WizardSequence2) {
            return super.getPreviousPage(page);
        }
        if (page == null) {
            return null;
        }
        return this._sequence.getPreviousPage();
    }

    public void setRoadmapVisible(boolean visible) {
        if (visible && !(this.getSequence() instanceof WizardSequence2)) {
            visible = false;
        }
        super.setRoadmapVisible(visible);
    }

    public void dispose() {
        super.dispose();
        this._sequence = null;
        this._currentIndex = -1;
        this._listener = null;
    }

    protected void doNext() {
        this._dir = _FORWARD;
        super.doNext();
        this._dir = _NO_DIRECTION;
    }

    protected void doPrevious() {
        this._dir = _BACKWARD;
        super.doPrevious();
        this._dir = _NO_DIRECTION;
    }

    protected void selectPage(WizardPage page, boolean validate) {
        WizardPage selectedPage = this.getSelectedPage();
        if (page != null) {
            if (this._sequence instanceof WizardSequence2) {
                if (page != selectedPage) {
                    WizardSequence2 sequence2 = (WizardSequence2)this._sequence;
                    sequence2.selectPage(page);
                }
            } else {
                boolean doPrev;
                boolean doNext = this._dir == _FORWARD || this._dir == _NO_DIRECTION;
                boolean bl = doPrev = this._dir == _BACKWARD || this._dir == _NO_DIRECTION;
                if (doNext && page == this._sequence.getNextPage()) {
                    this._checkAdded(page);
                    ++this._currentIndex;
                    this._sequence.goForward();
                } else if (doPrev && page == this._sequence.getPreviousPage()) {
                    this._checkAdded(page);
                    --this._currentIndex;
                    this._sequence.goBackwards();
                } else if (page == this._sequence.getCurrentPage()) {
                    this._checkAdded(page);
                }
            }
        }
        super.selectPage(page, validate);
    }

    private void _checkAdded(WizardPage page) {
        if (page != null && page.getParent() != this) {
            this.addPage(page, null);
        }
    }

    private WizardPage _getPageAt(int index) {
        if (index < 0 || index >= super.getPageCount()) {
            return null;
        }
        return this.getPageAt(index);
    }

    private class Listener
    implements WizardSequenceListener {
        private Listener() {
        }

        public void pagesAdded(WizardSequenceEvent event) {
            int startIndex = event.getStartIndex();
            int endIndex = startIndex + event.getPageCount();
            WizardSequence2 sequence2 = event.getWizardSequence();
            WizardPage beforeWhichPage = DWizard.this._getPageAt(startIndex);
            for (int i = startIndex; i < endIndex; ++i) {
                DWizard.this.addPage(sequence2.getPageAt(i), beforeWhichPage);
            }
        }

        public void pagesRemoved(WizardSequenceEvent event) {
            int startIndex = event.getStartIndex();
            int count = event.getPageCount();
            for (int i = 0; i < count; ++i) {
                WizardPage page = DWizard.this._getPageAt(startIndex);
                if (page == null) continue;
                DWizard.this.removePage(DWizard.this._getPageAt(startIndex));
            }
        }
    }
}

