/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard.dWizard;

import java.util.NoSuchElementException;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.dWizard.AbstractWizardSequence;

public class ArraySequence
extends AbstractWizardSequence {
    int _index;
    WizardPage[] _pages;

    public ArraySequence(WizardPage[] pages) {
        if (pages == null || pages.length == 0) {
            throw new IllegalArgumentException();
        }
        this._pages = new WizardPage[pages.length];
        System.arraycopy(pages, 0, this._pages, 0, pages.length);
        this.goToFirstPage();
    }

    public void goToFirstPage() {
        int index;
        this._index = 0;
        if (this.getCurrentPage() == null && (index = this._getNextIndex(this._index)) >= 0) {
            this._index = index;
        }
    }

    public void goToLastPage() {
        int index;
        this._index = this._pages.length - 1;
        if (this.getCurrentPage() == null && (index = this._getPreviousIndex(this._index)) >= 0) {
            this._index = index;
        }
    }

    public void goForward() {
        int index = this._getNextIndex(this._index);
        if (index < 0) {
            throw new NoSuchElementException();
        }
        this._index = index;
    }

    public void goBackwards() {
        int index = this._getPreviousIndex(this._index);
        if (index < 0) {
            throw new NoSuchElementException();
        }
        this._index = index;
    }

    public WizardPage getNextPage() {
        int index = this._getNextIndex(this._index);
        if (index < 0) {
            return null;
        }
        return this._pages[index];
    }

    public WizardPage getPreviousPage() {
        int index = this._getPreviousIndex(this._index);
        if (index < 0) {
            return null;
        }
        return this._pages[index];
    }

    public WizardPage getCurrentPage() {
        WizardPage page = this._pages[this._index];
        if (page.isEnabled() && page.isVisible()) {
            return page;
        }
        return null;
    }

    public int getPageCount() {
        int count = 0;
        for (int i = 0; i < this._pages.length; ++i) {
            WizardPage page = this._pages[i];
            if (!page.isEnabled() || !page.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public WizardPage getPageAt(int index) {
        return this._pages[index];
    }

    public boolean selectPage(WizardPage page) {
        for (int i = 0; i < this._pages.length; ++i) {
            if (page != this._pages[i]) continue;
            this._index = i;
            return true;
        }
        return false;
    }

    private int _getNextIndex(int index) {
        while (index < this._pages.length - 1) {
            WizardPage page;
            if (!(page = this._pages[++index]).isEnabled() || !page.isVisible()) continue;
            return index;
        }
        return -1;
    }

    private int _getPreviousIndex(int index) {
        while (index > 0) {
            WizardPage page;
            if (!(page = this._pages[--index]).isEnabled() || !page.isVisible()) continue;
            return index;
        }
        return -1;
    }
}

