/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WelcomeWizardPage;
import oracle.bali.ewt.wizard.WizardAdapter;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener2;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardSize;
import oracle.bali.ewt.wizard.WizardWindowTitle;

public class WizardFrame
extends JFrame {
    private BaseWizard _wizard;
    private boolean _cancelled;
    private WizardListener2 _listener;
    private boolean _skipNextTime;
    private WelcomeWizardPage _welcomeWizardPage;
    private int _initialWidth = -1;
    private int _initialHeight = -1;
    private WizardWindowTitle _windowTitle;
    private Dimension _prevMinSize = null;
    private boolean _isInitial = true;

    public WizardFrame() {
        this(null, "");
    }

    public WizardFrame(BaseWizard wizard) {
        this(wizard, "");
    }

    public WizardFrame(BaseWizard wizard, String title) {
        super(title);
        WindowUtils.registerWindow(this);
        this._wizard = wizard;
        this._listener = new WizListener();
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new BorderLayout());
        this.enableEvents(65L);
        this.setDefaultCloseOperation(0);
        this._windowTitle = new WizardWindowTitle(this, this._wizard);
    }

    public BaseWizard getWizard() {
        return this._wizard;
    }

    public void setWizard(BaseWizard wizard) {
        if (this.isVisible()) {
            throw new IllegalStateException();
        }
        this._wizard = wizard;
        this._windowTitle.setWizard(this._wizard);
    }

    public void setWizardTitle(String wizardTitle) {
        this._windowTitle.setBaseTitle(wizardTitle);
    }

    public String getWizardTitle() {
        return this._windowTitle.getBaseTitle();
    }

    public void setWelcomeWizardPage(WelcomeWizardPage welcomePage) {
        this._welcomeWizardPage = welcomePage;
    }

    public WelcomeWizardPage getWelcomeWizardPage() {
        return this._welcomeWizardPage;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public void show() {
        if (this.isVisible()) {
            return;
        }
        BaseWizard wizard = this._wizard;
        if (wizard == null || wizard.getParent() != null) {
            throw new IllegalStateException();
        }
        this.getContentPane().add((Component)wizard, "Center");
        wizard.addWizardListener(this._listener);
        this._initialWidth = -1;
        this._initialHeight = -1;
        if (!this._isInitial) {
            super.setMinimumSize(this._prevMinSize);
        }
        if (this._welcomeWizardPage != null && this._welcomeWizardPage.isVisible()) {
            this._skipNextTime = this._welcomeWizardPage.isSkipNextTime();
            if (this._skipNextTime && this._wizard.getSelectedPage() == this._welcomeWizardPage) {
                wizard.doNext();
            }
        }
        this._windowTitle.setCanUpdate(true);
        this._windowTitle.updateTitle();
        this.pack();
        this.setBackground(wizard.getBackground());
        this.getContentPane().setBackground(wizard.getBackground());
        WindowUtils.centerWindow(this);
        this._initialWidth = this.getWidth();
        this._initialHeight = this.getHeight();
        this._prevMinSize = this.isMinimumSizeSet() ? super.getMinimumSize() : null;
        this.setMinimumSize(new Dimension(this._initialWidth, this._initialHeight));
        this._isInitial = false;
        this._cancelled = false;
        super.show();
    }

    public Dimension getPreferredSize() {
        if (this._wizard != null) {
            return WizardSize.getWizardWindowSize(this._wizard.getDefaultWizardSize());
        }
        return WizardSize.getWizardWindowSize(0);
    }

    public Dimension getMinimumSize() {
        if (this._initialWidth != -1 && this._initialHeight != -1) {
            return new Dimension(this._initialWidth, this._initialHeight);
        }
        return super.getMinimumSize();
    }

    public void dispose() {
        super.dispose();
        if (this._wizard == null) {
            return;
        }
        WindowUtils.unregisterWindow(this);
        this._windowTitle.setWizard(null);
        this._windowTitle = null;
        this.getContentPane().remove(this._wizard);
        this._wizard.removeWizardListener(this._listener);
        this._wizard.dispose();
        this._listener = null;
        this._wizard = null;
    }

    protected void processComponentEvent(ComponentEvent ce) {
        super.processComponentEvent(ce);
        if (ce.getID() == 101) {
            int originalHeight;
            int originalWidth;
            int width = originalWidth = this.getWidth();
            int height = originalHeight = this.getHeight();
            if (this._initialWidth != -1) {
                width = Math.max(this._initialWidth, width);
            }
            if (this._initialHeight != -1) {
                height = Math.max(this._initialHeight, height);
            }
            if (originalWidth != width || originalHeight != height) {
                this.setSize(width, height);
            }
        }
    }

    protected void dismissFrame(boolean cancelled) {
        this._cancelled = cancelled;
        if (this.isVisible()) {
            this.setVisible(false);
            this._wizard.removeWizardListener(this._listener);
            this._windowTitle.setCanUpdate(false);
            this.getContentPane().remove(this._wizard);
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this._wizard.__doCancelClick();
        }
        super.processWindowEvent(e);
    }

    private class WizListener
    extends WizardAdapter {
        private WizListener() {
        }

        public void wizardFinished(WizardEvent event) {
            WizardPage proPage = WizardFrame.this._wizard.getProgressWizardPage();
            WizardPage endPage = WizardFrame.this._wizard.getEndOfProcessWizardPage();
            if (proPage == null && endPage == null) {
                WizardFrame.this.dismissFrame(false);
                return;
            }
            WizardPage page = WizardFrame.this._wizard.getNextPage(event.getPage());
            while (page == null || page != proPage && page != endPage) {
                if (page == null) {
                    WizardFrame.this.dismissFrame(false);
                    break;
                }
                page = WizardFrame.this._wizard.getNextPage(page);
            }
        }

        public void wizardCanceled(WizardEvent event) {
            WizardFrame.this.dismissFrame(true);
            if (WizardFrame.this._welcomeWizardPage != null) {
                WizardFrame.this._welcomeWizardPage.setSkipNextTime(WizardFrame.this._skipNextTime);
            }
        }

        public void wizardClosed(WizardEvent event) {
            WizardFrame.this.dismissFrame(false);
        }
    }
}

