/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.AccessibleLWComponent;
import oracle.bali.ewt.wizard.ImageWizardPage;

public class TitledWizardPage
extends ImageWizardPage {
    private AccessibleLWComponent _panel = (AccessibleLWComponent)super.getInteractiveArea();
    private TitleLabel _title;
    private Component _interactive;

    public TitledWizardPage() {
        this(null, null, "", "");
    }

    public TitledWizardPage(Component interactive, Image image, String label) {
        this(interactive, image, label, "");
    }

    public TitledWizardPage(Component interactive, Image image, String label, String title) {
        this(interactive, image, label, title, null);
    }

    public TitledWizardPage(Component interactive, String pageTitle) {
        this(interactive, null, "", "", pageTitle);
    }

    TitledWizardPage(Component interactive, Image image, String label, String title, String pageTitle) {
        super(new AccessibleLWComponent(), image, label, pageTitle);
        this._title = new TitleLabel(title);
        this._panel.setLayout(new BorderLayout(2, 2));
        this._panel.add("North", this._title);
        this._interactive = interactive;
        if (interactive != null) {
            this._panel.add("Center", interactive);
        }
    }

    public String getTitle() {
        return this._title.getText();
    }

    public void setTitle(String title) {
        String label;
        String pageTitle;
        String old = this._title.getText();
        this._title.setText(title);
        if (old != title && ((pageTitle = this.getPageTitle()) == null || "".equals(pageTitle)) && ((label = this.getLabel()) == null || "".equals(label))) {
            this.firePropertyChange("pageTitle", old, title);
        }
    }

    public Component getInteractiveArea() {
        return this._interactive;
    }

    public void setInteractiveArea(Component interactiveArea) {
        if (this._panel == null) {
            super.setInteractiveArea(interactiveArea);
        } else if (this._interactive != interactiveArea) {
            if (this._interactive != null) {
                this._panel.remove(this._interactive);
            }
            this._interactive = interactiveArea;
            if (this._interactive != null) {
                this._panel.add("Center", this._interactive);
            }
        }
    }

    public String getAccessibleDescription() {
        if (this.__isAccessibleDescriptionSet()) {
            return super.getAccessibleDescription();
        }
        return this.getTitle();
    }

    boolean __isAccessibleDescriptionSet() {
        String s = super.getAccessibleDescription();
        return s != null && !"".equals(s);
    }

    private class TitleLabel
    extends MultiLineLabel {
        private boolean _doInit;

        public TitleLabel(String label) {
            super(WordWrapper.getTextWrapper(), label);
            this._doInit = true;
            this.setPreferredAspectRatio(0.0f);
        }

        public void addNotify() {
            super.addNotify();
            if (this._doInit) {
                this._doInit = false;
                Font f = this.getFont();
                int size = (int)((double)f.getSize() * 1.5);
                this.setFont(f.deriveFont((float)size));
            }
        }
    }
}

