/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.elaf.EWTWizardUI;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessageModelEvent;
import oracle.bali.ewt.validate.ValidationMessageModelListener;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.bali.ewt.wizard.Background;
import oracle.bali.ewt.wizard.BackgroundLWComponent;
import oracle.bali.ewt.wizard.BackgroundPainter;
import oracle.bali.ewt.wizard.BackgroundPanel;
import oracle.bali.ewt.wizard.PaintCtxt;
import oracle.bali.ewt.wizard.TitledWizardPage;
import oracle.bali.ewt.wizard.WizardBackgroundHandler;
import oracle.bali.ewt.wizard.WizardBuilder;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;
import oracle.bali.ewt.wizard.WizardListener2;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardRoadMap;
import oracle.bali.ewt.wizard.WizardSize;
import oracle.bali.ewt.wizard.WizardSplitter;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public abstract class BaseWizard
extends LWComponent
implements Accessible {
    public static final int MNEMONIC_APPLY = 0;
    public static final int MNEMONIC_CANCEL = 1;
    public static final int MNEMONIC_FINISH = 2;
    public static final int MNEMONIC_NEXT = 3;
    public static final int MNEMONIC_PREVIOUS = 4;
    public static final int MNEMONIC_HELP = 5;
    public static final int MNEMONIC_SAVE = 6;
    public static final int SMALL_SIZE = 0;
    public static final int LARGE_SIZE = 1;
    public static final int SMALL_SIZE2 = 2;
    public static final int LARGE_SIZE2 = 3;
    public static final int VALIDATION_MESSAGE = 0;
    public static final int BILLBOARD = 1;
    protected static final Object PAGE_CONTAINER = new String("PageContainer");
    private static final String _BUNDLE_NAME = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _FINISH_KEY = "WIZARD.FINISH";
    private static final String _APPLY_KEY = "WIZARD.APPLY";
    private static final String _CANCEL_KEY = "WIZARD.CANCEL";
    private static final String _PREVIOUS_KEY = "WIZARD.PREV";
    private static final String _NEXT_KEY = "WIZARD.NEXT";
    private static final String _HELP_KEY = "WIZARD.HELP";
    private static final String _SAVE_KEY = "WIZARD.SAVE";
    private static final String _CLOSE_KEY = "WIZARD.CLOSE";
    private static final Border _BUTTONBAR_BORDER = new EmptyBorder(3, 9, 4, 9);
    private static final Border _HEADER_BORDER = new EmptyBorder(0, 7, 0, 0);
    private static final Border _sCONTENT_BORDER = new ContentBorder(1, 0, 0, 0);
    private static final Border _sCONTENT_NULL_BORDER = new EmptyBorder(0, 0, 0, 0);
    private static final Border _sCONTENT_EMPTY_BORDER = new EmptyBorder(7, 10, 7, 10);
    private static final Border _sMESSAGE_PANEL_BORDER = new EmptyBorder(0, 10, 7, 10);
    private static final Border _sMESSAGE_PANEL_NULL_BORDER = new EmptyBorder(0, 0, 0, 0);
    private static final Border _sAUXILIARY_PANEL_BORDER = new CompoundBorder(new EmptyBorder(0, 0, 7, 0), new ContentBorder(1, 0, 1, 1));
    private static final Border _sAUXILIARY_PANEL_BORDER1 = new CompoundBorder(new EmptyBorder(0, 0, 7, 0), new ContentBorder(0, 0, 0, 0));
    private static final Border _sAUXILIARY_PANEL_BORDER2 = new CompoundBorder(new EmptyBorder(0, 0, 7, 0), new ContentBorder(1, 0, 0, 0));
    private static final Border _sAUXILIARY_PANEL_NULL_BORDER = new EmptyBorder(7, 7, 1, 1);
    private static final int _NULL_DIVIDER_WIDTH = 0;
    private static final int _DIVIDER_WIDTH = 4;
    private static final String _FINISH_NAME = "Finish";
    private static final String _APPLY_NAME = "Apply";
    private static final String _CANCEL_NAME = "Cancel";
    private static final String _PREVIOUS_NAME = "Back";
    private static final String _NEXT_NAME = "Next";
    private static final String _HELP_NAME = "Help";
    private static final String _SAVE_NAME = "Save";
    private static final String _CLOSE_NAME = "Close";
    private static final String _LOGO = "LOGO";
    private static final String _ROADMAP = "ROADMAP";
    private static final String _MESSAGE = "MESSAGE";
    private static final String _AUXILIARY = "AUXILIARY";
    private static boolean _sImageWizardPageSupported = true;
    private static boolean _sAllLinksEnabledOnFinish = true;
    private static boolean _sWelcomeWizardPageVisible = true;
    private boolean _sequential;
    private String _accessibleDesc;
    private LWComponent _buttonRow;
    private JButton _apply;
    private JButton _cancel;
    private JButton _finish;
    private JButton _next;
    private JButton _previous;
    private JButton _help;
    private JButton _save;
    private int _customButtons;
    private boolean _finishDefaulted = true;
    private Action _listener;
    private ListenerManager _wizardListeners;
    private Vector _pages;
    private WizardPage _selectedPage;
    private WizardBackgroundHandler _bgHandler;
    private boolean _flatLook = true;
    private JLabel _accessibleLabel;
    private BackgroundPanel _bottomPanel;
    private WizardRoadMap _roadMap;
    private BottomContent _bottomContent;
    private AuxiliaryContent _auxiliaryContent;
    private Component _contentComp;
    private JPanel _mainPanel;
    private BackgroundPanel _contentPanel;
    private JPanel _leftPanel;
    private JPanel _topPanel;
    private HeaderLabel _headerLabel;
    private LogoCanvas _logoCanvas;
    private int _wizardSize = -1;
    private int _auxPaneHeight = -1;
    private int _bottomContentMode = 0;
    private boolean _wizardFinished;
    private boolean _closed;
    private boolean _pageValidation;
    private WizardPage _progressPage;
    private WizardPage _endProcessPage;
    private Color[] _hColors;
    private boolean _splitterMode;
    private WizardSplitter _leftVSp;
    private WizardSplitter _rightVSp;
    private WizardSplitter _centerHSp;

    protected BaseWizard() {
        this(true);
    }

    BaseWizard(boolean sequential) {
        this._sequential = sequential;
        this._pages = new Vector();
        this._createUI();
        this._wizardSize = 0;
        this._pageValidation = true;
        this.updateUI();
    }

    public static final void setImageWizardPageSupported(boolean imageSupported) {
        _sImageWizardPageSupported = imageSupported;
    }

    public static final boolean isImageWizardPageSupported() {
        return _sImageWizardPageSupported;
    }

    public static final void setWelcomeWizardPageVisible(boolean welcomeVisible) {
        _sWelcomeWizardPageVisible = welcomeVisible;
    }

    public static final boolean isWelcomeWizardPageVisible() {
        return _sWelcomeWizardPageVisible;
    }

    public static final void setAllLinksEnabledOnFinish(boolean enable) {
        _sAllLinksEnabledOnFinish = enable;
    }

    public static final boolean isAllLinksEnabledOnFinish() {
        return _sAllLinksEnabledOnFinish;
    }

    public final WizardPage addPage(WizardPage page) {
        return this.addPage(page, null);
    }

    public synchronized WizardPage addPage(WizardPage page, WizardPage beforeWhichPage) {
        this.addPageImpl(page, beforeWhichPage);
        if (this.getSelectedPage() == null && this.isEnabled(page) && page.isVisible()) {
            this.selectPage(page, false);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPages(BaseWizard wizard, WizardPage beforeWhichPage) {
        Object[] pages;
        if (wizard == this || wizard.getPageCount() == 0) {
            return;
        }
        BaseWizard baseWizard = wizard;
        synchronized (baseWizard) {
            pages = new WizardPage[wizard.getPageCount()];
            wizard._pages.copyInto(pages);
            wizard.removeAllPages();
        }
        for (int i = 0; i < pages.length; ++i) {
            this.addPage((WizardPage)pages[i], beforeWhichPage);
        }
    }

    public synchronized void removePage(WizardPage page) {
        if (this._selectedPage == page) {
            WizardPage newSelection = this.getNextPage(page);
            if (newSelection == null) {
                newSelection = this.getPreviousPage(page);
            }
            this.selectPage(newSelection, false);
        } else {
            int selectedIndex;
            int oldIndex = this.__getPageIndex(page);
            if (this._selectedPage != null && (selectedIndex = this.__getPageIndex(this._selectedPage)) > oldIndex && selectedIndex < this.__getActualPageCount() - 1) {
                this.selectPage(this.getPageAt(selectedIndex + 1));
            }
        }
        page.removePropertyChangeListener(this._listener);
        page.__setParent(null);
        if (this._pages.removeElement(page)) {
            this.firePropertyChange("pageRemoved", null, page);
        }
        this.enableButtons();
    }

    public synchronized void removeAllPages() {
        int i = this._pages.size();
        while (--i >= 0) {
            WizardPage page = (WizardPage)this._pages.elementAt(i);
            page.removePropertyChangeListener(this._listener);
            page.__setParent(null);
            this.firePropertyChange("pageRemoved", null, page);
        }
        this._pages.removeAllElements();
        this.selectPage(null, false);
        this.enableButtons();
    }

    public WizardBackgroundHandler getBackgroundHandler() {
        return this._bgHandler;
    }

    public void setBackgroundHandler(WizardBackgroundHandler handler) {
        WizardBackgroundHandler old = this.getBackgroundHandler();
        if (old != null) {
            old.removePropertyChangeListener(this._listener);
        }
        this._bgHandler = handler == null ? this.createDefaultWizardBackgroundHandler() : handler;
        this._bgHandler.addPropertyChangeListener(this._listener);
        Background[] _panels = this._bgHandler.__getBackgrounds();
        int len = _panels.length;
        for (int i = 0; i < len; ++i) {
            this._updatePaintContext(WizardBackgroundHandler.findPanel(i), _panels[i]);
        }
    }

    public void loadWizardProperties(URL url, URL baseUrl) {
        WizardBuilder.build(this, url, baseUrl);
    }

    public int getPageCount() {
        return this._pages.size();
    }

    public WizardPage getPageAt(int index) {
        return (WizardPage)this._pages.elementAt(index);
    }

    public void selectPage(WizardPage page) {
        this.selectPage(page, true);
    }

    public WizardPage getSelectedPage() {
        return this._selectedPage;
    }

    public void setCurrentPageIndex(int index) {
        this.selectPage(this.getPageAt(index));
    }

    public int getCurrentPageIndex() {
        WizardPage page = this.getSelectedPage();
        if (page == null) {
            return -1;
        }
        return page.getIndex();
    }

    public void restart() {
        this.reset();
        if (this.getPageCount() == 0) {
            return;
        }
        WizardPage first = this.getPageAt(0);
        if (!this.isEnabled(first) || !first.isVisible()) {
            first = this.getNextPage(first);
        }
        if (first != null) {
            this.selectPage(first, false);
        }
    }

    public void reset() {
        this._setCancel();
        this._wizardFinished = false;
        int count = this._pages.size();
        for (int i = 0; i < count; ++i) {
            WizardPage page = (WizardPage)this._pages.get(i);
            page.reset();
        }
    }

    public WizardPage getNextPage(WizardPage page) {
        if (page == null) {
            return null;
        }
        int index = page.getIndex();
        int count = this.getPageCount();
        while (++index < count) {
            WizardPage next = this.getPageAt(index);
            if (!next.isVisible() || !this.isEnabled(next)) continue;
            return next;
        }
        return null;
    }

    public WizardPage getPreviousPage(WizardPage page) {
        if (page == null) {
            return null;
        }
        int index = page.getIndex();
        while (--index >= 0) {
            WizardPage previous = this.getPageAt(index);
            if (!previous.isVisible() || !this.isEnabled(previous)) continue;
            return previous;
        }
        return null;
    }

    public void setFlatLook(boolean flat) {
        if (this._flatLook != flat) {
            this._flatLook = flat;
            if (flat) {
                this._contentPanel.setBorder(_sCONTENT_BORDER);
            } else {
                this._contentPanel.setBorder(_sCONTENT_NULL_BORDER);
            }
            this._updateLeftPanelBorders();
            this._setMessagePanelBorder(flat);
        }
    }

    public boolean isFlatLook() {
        return this._flatLook;
    }

    public void setHelpAvailable(boolean help) {
        this._help.setVisible(help);
    }

    public boolean isHelpAvailable() {
        return this._help.isVisible();
    }

    public void setCanApply(boolean apply) {
        this._apply.setVisible(apply);
        if (this._accessibleLabel != null && apply) {
            this.enableButtons();
        }
    }

    public boolean getCanApply() {
        return this._apply.isVisible();
    }

    public void setCanSave(boolean save) {
        this._save.setVisible(save);
    }

    public boolean getCanSave() {
        return this._save.isVisible();
    }

    public void setFinishText(String text) {
        if (text == null || "".equals(text)) {
            if (this._finishDefaulted) {
                return;
            }
            if (this.getPeer() == null) {
                this._finish.setText("");
            } else {
                ResourceBundle wizardBundle = ResourceBundle.getBundle(_BUNDLE_NAME, LocaleUtils.getDefaultableLocale((Component)this));
                this._setButtonLabel(this._finish, wizardBundle.getString(_FINISH_KEY));
            }
            this._finishDefaulted = true;
        } else {
            if (this._finishDefaulted) {
                this._finish.setMnemonic(0);
            }
            this._finish.setText(text);
            this._finishDefaulted = false;
        }
    }

    public String getFinishText() {
        return this._finish.getText();
    }

    public void setFinishMnemonic(int mnemonic) {
        this._finish.setMnemonic(mnemonic);
    }

    public int getFinishMnemonic() {
        return this._finish.getMnemonic();
    }

    public int getButtonMnemonic(int button) {
        int c = 0;
        switch (button) {
            case 0: {
                c = this._apply.getMnemonic();
                break;
            }
            case 1: {
                c = this._cancel.getMnemonic();
                break;
            }
            case 2: {
                c = this._finish.getMnemonic();
                break;
            }
            case 3: {
                c = this._next.getMnemonic();
                break;
            }
            case 4: {
                c = this._previous.getMnemonic();
                break;
            }
            case 5: {
                c = this._help.getMnemonic();
                break;
            }
            case 6: {
                c = this._save.getMnemonic();
            }
        }
        return c;
    }

    public void addCustomButton(Component comp) {
        if (comp.getParent() != this._buttonRow) {
            this._buttonRow.add(comp, 2 + this._customButtons);
            ++this._customButtons;
            this._buttonRow.revalidate();
        }
    }

    public void removeCustomButton(Component comp) {
        if (comp.getParent() == this._buttonRow) {
            --this._customButtons;
            this._buttonRow.remove(comp);
            this._buttonRow.revalidate();
        }
    }

    public void setReservedButtonSpaces(int reserved) {
        this._buttonRow.putClientProperty("WizardReservedButtonSpaces", reserved == 0 ? null : new Integer(reserved));
    }

    public int getReservedButtonSpaces() {
        Object o = this._buttonRow.getClientProperty("WizardReservedButtonSpaces");
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public void setLogoImage(Image logoImage) {
        if (this._logoCanvas == null) {
            this._logoCanvas = new LogoCanvas();
            this._logoCanvas.setFill(BackgroundPainter.getInstance());
            this._topPanel.add((Component)this._logoCanvas, "East");
            Background[] _panels = this.getBackgroundHandler().__getBackgrounds();
            WizardBackgroundHandler.Panel panel = WizardBackgroundHandler.findPanel(_LOGO);
            this._updatePaintContext(panel, _panels[panel.ordinal()]);
        }
        this._logoCanvas.setImage(logoImage);
    }

    public Image getLogoImage() {
        return this._logoCanvas == null ? null : this._logoCanvas.getImage();
    }

    public void setHeaderGradientBackground(Color[] colors) {
        this._hColors = colors;
        WizardBackgroundHandler bgHandler = this.getBackgroundHandler();
        if (colors == null) {
            colors = new Color[2];
        }
        bgHandler.setBackgroundGradient(WizardBackgroundHandler.Panel.HEADER, WizardBackgroundHandler.GradientType.HORIZONTAL, colors);
        this._headerLabel.repaint();
    }

    public Color[] getHeaderGradientBackground() {
        return this._hColors;
    }

    public void setRoadmapVisible(boolean showRoadmap) {
        if (showRoadmap != this.isRoadmapVisible()) {
            if (this._roadMap == null) {
                this._roadMap = new WizardRoadMap(this);
                this._roadMap.setFill(BackgroundPainter.getInstance());
                Background[] _panels = this.getBackgroundHandler().__getBackgrounds();
                WizardBackgroundHandler.Panel panel = WizardBackgroundHandler.findPanel(_ROADMAP);
                this._updatePaintContext(panel, _panels[panel.ordinal()]);
            }
            this._roadMap.setVisible(showRoadmap);
            this._updateLeftPanelBorders();
            if (this.isSplitterMode()) {
                this._updateLeftAndCenterSplitterUI();
            } else {
                this._updateLeftPanelUI();
            }
        }
    }

    public boolean isRoadmapVisible() {
        return this._roadMap != null && this._roadMap.isVisible();
    }

    public void setAllLinksEnabled(boolean enable) {
        if (this._roadMap != null) {
            this._roadMap.setAllLinksEnabled(enable);
        }
    }

    public boolean isAllLinksEnabled() {
        return this._roadMap != null && this._roadMap.isAllLinksEnabled();
    }

    public void setVisitedLinkEnabled(boolean enable) {
        if (this._roadMap != null) {
            this._roadMap.setVisitedLinkEnabled(enable);
        }
    }

    public boolean isVisitedLinkEnabled() {
        return this._roadMap != null && this._roadMap.isVisitedLinkEnabled();
    }

    public void setBillboard(Component billboard) {
        if (this.getBillboard() != billboard) {
            this._createBottomContent();
            this._bottomContent.setBillboard(billboard);
        }
    }

    public Component getBillboard() {
        return this._bottomContent == null ? null : this._bottomContent.getBillboard();
    }

    public void setAuxiliaryPane(Component auxiliaryPane) {
        if (this.getAuxiliaryPane() != auxiliaryPane) {
            this._createAuxiliaryContent();
            this._auxiliaryContent.setAuxiliaryPane(auxiliaryPane);
            if (this.isSplitterMode()) {
                this._updateLeftAndCenterSplitterUI();
            }
            this._updateLeftPanelBorders();
        }
    }

    public Component getAuxiliaryPane() {
        return this._auxiliaryContent == null ? null : this._auxiliaryContent.getAuxiliaryPane();
    }

    public void setAuxiliaryPaneHeight(int height) {
        if (height < 0 && height != -1) {
            throw new IllegalArgumentException("Height can't be negative except -1");
        }
        this._auxPaneHeight = height;
        if (this.isSplitterMode()) {
            this._updateLeftAndCenterSplitterUI();
        }
    }

    public int getAuxiliaryPaneHeight() {
        return this._auxPaneHeight;
    }

    public void setValidationMessagePane(ValidationMessagePane pane) {
        ValidationMessagePane oldPane = this.getValidationMessagePane();
        if (oldPane != pane) {
            if (oldPane != null) {
                oldPane.removePropertyChangeListener(this._listener);
            }
            this._createBottomContent();
            this._bottomContent.setValidationMessagePane(pane);
        }
    }

    public ValidationMessagePane getValidationMessagePane() {
        return this._bottomContent == null ? null : this._bottomContent.getValidationMessagePane();
    }

    public void setBottomContentMode(int mode) {
        if (mode != this.getBottomContentMode()) {
            if (mode != 0 && mode != 1) {
                throw new IllegalArgumentException();
            }
            this._bottomContentMode = mode;
            if (this._bottomContent != null) {
                this._bottomContent.updateVisibility();
            }
        }
    }

    public int getBottomContentMode() {
        return this._bottomContentMode;
    }

    public void setDefaultWizardSize(int size) {
        if (this.isShowing()) {
            throw new IllegalArgumentException("WizardSize cannot be set when the component is visible");
        }
        if (size != 1 && size != 0 && size != 3 && size != 2) {
            throw new IllegalArgumentException();
        }
        this._wizardSize = size;
    }

    public int getDefaultWizardSize() {
        return this._wizardSize;
    }

    public void setProgressWizardPage(WizardPage page) {
        this._progressPage = page;
        if (page != null) {
            this._progressPage.setCanGoBack(false);
            this._progressPage.setCanAdvance(false);
        }
    }

    public WizardPage getProgressWizardPage() {
        return this._progressPage;
    }

    public void setEndOfProcessWizardPage(WizardPage page) {
        this._endProcessPage = page;
        if (page != null) {
            this._endProcessPage.setCanGoBack(false);
        }
    }

    public WizardPage getEndOfProcessWizardPage() {
        return this._endProcessPage;
    }

    public synchronized void addWizardListener(WizardListener listener) {
        if (this._wizardListeners == null) {
            this._wizardListeners = new ListenerManager();
        }
        this._wizardListeners.addListener((EventListener)listener);
    }

    public synchronized void removeWizardListener(WizardListener listener) {
        if (this._wizardListeners != null) {
            this._wizardListeners.removeListener((EventListener)listener);
        }
    }

    public boolean isSplitterMode() {
        return this._splitterMode;
    }

    public void setSplitterMode(boolean mode) {
        this.__setSplitterMode(mode, true);
    }

    public void dispose() {
        if (this._listener == null) {
            return;
        }
        this._unregisterKeyboardActions();
        if (this._roadMap != null) {
            this._roadMap.dispose();
            this._roadMap = null;
        }
        this._leftPanel.removeAll();
        this._leftPanel = null;
        this.removeAllPages();
        this._pages = null;
        this._apply.removeActionListener(this._listener);
        this._apply.removeFocusListener(this._listener);
        this._apply = null;
        this._cancel.removeActionListener(this._listener);
        this._cancel.removeFocusListener(this._listener);
        this._cancel = null;
        this._finish.removeActionListener(this._listener);
        this._finish.removeFocusListener(this._listener);
        this._finish = null;
        this._next.removeActionListener(this._listener);
        this._next.removeFocusListener(this._listener);
        this._next = null;
        this._previous.removeActionListener(this._listener);
        this._previous.removeFocusListener(this._listener);
        this._previous = null;
        this._help.removeActionListener(this._listener);
        this._help.removeFocusListener(this._listener);
        this._help = null;
        this._save.removeActionListener(this._listener);
        this._save.removeFocusListener(this._listener);
        this._save = null;
        this._buttonRow.removeAll();
        this._buttonRow = null;
        this._wizardListeners = null;
        this._selectedPage = null;
        this._bottomPanel.removeAll();
        this._bottomPanel = null;
        this._topPanel.removeAll();
        this._topPanel = null;
        this._headerLabel = null;
        this._logoCanvas = null;
        if (this._bottomContent != null) {
            this._bottomContent.dispose();
            this._bottomContent = null;
        }
        this._contentPanel = null;
        this._mainPanel.removeAll();
        this._mainPanel = null;
        this._listener = null;
        if (this._centerHSp != null) {
            this._centerHSp.removeAll();
            this._centerHSp = null;
        }
        this._leftVSp = null;
        this._rightVSp = null;
    }

    public void updateUI() {
        this.setUI((EWTWizardUI)UIManager.getUI(this));
        this.updateReadingDirection(this.getActualReadingDirection());
    }

    public String getUIClassID() {
        return "EWTWizardUI";
    }

    public void addNotify() {
        super.addNotify();
        Window w = WindowUtils.getWindow(this);
        w.addWindowListener(this._listener);
        this._loadButtonText(this.getLocale());
        this.enableButtons();
        this.resetFocus(this.getSelectedPage());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BaseWizard.this.isSplitterMode()) {
                    BaseWizard.this._updateLeftAndCenterSplitterUI();
                    BaseWizard.this._updateRightSplitterUI();
                }
            }
        });
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._buttonRow != null) {
            this._loadButtonText(LocaleUtils.getDefaultableLocale((Component)this));
        }
    }

    public void enable() {
        super.enable();
        this.enableButtons();
        if (this._roadMap != null) {
            this._roadMap.setEnabled(true);
        }
    }

    public void disable() {
        super.disable();
        this.enableButtons();
        if (this._roadMap != null) {
            this._roadMap.setEnabled(false);
        }
    }

    public Dimension getPreferredSize() {
        return WizardSize.getWizardSize(this.getDefaultWizardSize());
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleWizard();
            if (this._bottomPanel != null) {
                this._accessibleLabel = new AccessibleLabel();
                StatusBar bar = new StatusBar();
                bar.setPreferredSize(new Dimension(0, 0));
                bar.add(this._accessibleLabel);
                this._bottomPanel.add("South", bar);
                this.validate();
            }
        }
        return this.accessibleContext;
    }

    protected final synchronized void addPageImpl(WizardPage page, WizardPage beforeWhichPage) {
        int selectedIndex;
        if (page.getParent() != null) {
            page.getParent().removePage(page);
        }
        if (beforeWhichPage == null) {
            this._pages.addElement(page);
        } else {
            this._pages.insertElementAt(page, this._pages.indexOf(beforeWhichPage));
        }
        page.__setParent(this);
        page.addPropertyChangeListener(this._listener);
        this.firePropertyChange("pageAdded", null, page);
        this.enableButtons();
        int newIndex = this.__getPageIndex(page);
        if (this._selectedPage != null && (selectedIndex = this.__getPageIndex(this._selectedPage)) >= newIndex) {
            this.selectPage(this.getPageAt(selectedIndex - 1));
        }
    }

    protected void selectPage(WizardPage page, boolean doValidate) {
        if (page != this._selectedPage && this._validatePage(doValidate, true)) {
            Component content;
            this.setSelectedPage(page);
            this.processEvent(new WizardEvent(this, 2001, page));
            WizardPage newSelected = this.getSelectedPage();
            if (newSelected != null) {
                this._updateValidationMessagePane(newSelected, true);
            }
            this.enableButtons();
            this._updateAccessibleTitle();
            this._updateAccessibleLabel();
            this.resetFocus(page);
            if (page != null && (content = page.getContent()) != null && content instanceof JComponent) {
                HelpUtils.setHelpID(this._buttonRow, HelpUtils.getHelpID(content));
                HelpUtils.setHelpProvider(this._buttonRow, HelpUtils.getHelpProvider(content));
                HelpUtils.setHelpSet(this._buttonRow, HelpUtils.getHelpSet(content));
                return;
            }
            HelpUtils.setHelpID(this._buttonRow, null);
            HelpUtils.setHelpProvider(this._buttonRow, null);
            HelpUtils.setHelpSet(this._buttonRow, null);
        }
    }

    protected void setSelectedPage(WizardPage page) {
        WizardPage prevSelected = this._selectedPage;
        if (prevSelected != null) {
            prevSelected.__setVisited(true);
        }
        this._selectedPage = page;
        this._updateHeaderText(page);
    }

    protected boolean getCanGoBack() {
        WizardPage page = this.getSelectedPage();
        if (page == null) {
            return false;
        }
        return page.getCanGoBack();
    }

    protected boolean getCanAdvance() {
        WizardPage page = this.getSelectedPage();
        if (page == null) {
            return false;
        }
        return page.getCanAdvance();
    }

    protected boolean getMustFinish() {
        return true;
    }

    protected void doHelp() {
        Component helpComponent = null;
        WizardPage selectedPage = this.getSelectedPage();
        Window window = WindowUtils.getWindow(this);
        if (window != null) {
            helpComponent = window.getFocusOwner();
        }
        if (helpComponent == null || helpComponent.getParent() == this._buttonRow || helpComponent.getParent() == this || this.isRoadmapVisible() && SwingUtilities.isDescendingFrom(helpComponent, this._roadMap)) {
            helpComponent = selectedPage != null ? selectedPage.getContent() : this;
        }
        try {
            HelpUtils.showHelp(helpComponent);
        }
        catch (HelpUnavailableException hue) {
            // empty catch block
        }
    }

    protected void doApply() {
        if (this._validatePage(true, false)) {
            this.processEvent(new WizardEvent(this, 2002, this.getSelectedPage()));
        }
    }

    protected void doSave() {
        this.processEvent(new WizardEvent(this, 2005, this.getSelectedPage()));
    }

    protected void doPrevious() {
        WizardPage previous = this.getPreviousPage(this.getSelectedPage());
        if (previous != null) {
            this.selectPage(previous, false);
        }
    }

    protected void doNext() {
        WizardPage next;
        if (this._validatePage(true, false) && (next = this.getNextPage(this.getSelectedPage())) != null) {
            this.selectPage(next, false);
        }
    }

    protected void doFinish() {
        if (this._validatePage(true, true)) {
            this._wizardFinished = true;
            WizardPage selected = this.getSelectedPage();
            this.processEvent(new WizardEvent(this, 2004, selected));
            WizardPage endPages = this.getProgressWizardPage();
            if (endPages == null || endPages.getParent() != this) {
                endPages = this.getEndOfProcessWizardPage();
            }
            if (endPages != null && endPages.getParent() == this) {
                this.selectPage(endPages, false);
            } else {
                this.reset();
            }
        }
    }

    protected void doCancel() {
        this.processEvent(new WizardEvent(this, 2003, this.getSelectedPage()));
    }

    protected void doClose() {
        this.processEvent(new WizardEvent(this, 2006, this.getSelectedPage()));
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableButtons() {
        this.freezeRepaints();
        try {
            WizardPage page = this._selectedPage;
            WizardPage next = this.getNextPage(page);
            boolean canAdvance = this.getCanAdvance();
            boolean canGoBack = this.getCanGoBack();
            boolean mustFinish = this.getMustFinish();
            boolean isEnabled = this.isEnabled();
            JRootPane root = this.getRootPane();
            if (root != null) {
                JButton b;
                JButton old = root.getDefaultButton();
                JButton jButton = b = !this._sequential || next == null ? this._finish : this._next;
                if (!(this._previous.hasFocus() || this._apply.hasFocus() || this._cancel.hasFocus() || this._help.hasFocus())) {
                    b.setDefaultCapable(true);
                    root.setDefaultButton(b);
                    if (old != b && old != null) {
                        old.setDefaultCapable(false);
                    }
                }
            }
            boolean isSelPost = this._isProgressPage(page) || this._isEndProcessPage(page);
            boolean isNexPost = this._isProgressPage(next) || this._isEndProcessPage(next);
            boolean finishEnabled = isEnabled && canAdvance && !isSelPost && (next == null || !mustFinish || isNexPost);
            this._finish.setEnabled(finishEnabled);
            if (this._roadMap != null) {
                this._roadMap.__setAllLinksEnabledOnFinish(finishEnabled && _sAllLinksEnabledOnFinish);
            }
            boolean nextEnabled = isEnabled && canAdvance && next != null && (isSelPost || !isNexPost);
            this._next.setEnabled(nextEnabled);
            this._previous.setEnabled(isEnabled && canGoBack && this.getPreviousPage(page) != null);
            if (this._accessibleLabel == null || this._apply.isVisible()) {
                this._apply.setEnabled(isEnabled && canAdvance);
            }
            this._cancel.setEnabled(isEnabled);
            if (isSelPost && (this._isProgressPage(page) && canAdvance || next == null)) {
                this._setClose();
            } else {
                this._setCancel();
            }
            boolean saveEnabled = isEnabled && !this._wizardFinished;
            this._save.setEnabled(saveEnabled);
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    boolean isEnabled(WizardPage page) {
        boolean enabled = page.isEnabled();
        if (this._isProgressPage(page) || this._isEndProcessPage(page)) {
            if (!this._wizardFinished) {
                enabled = false;
            }
        } else if (this._wizardFinished) {
            enabled = false;
        }
        return enabled;
    }

    protected boolean validateSelectedPage() {
        WizardPage selected = this.getSelectedPage();
        if (selected == null) {
            return true;
        }
        return selected.validatePage();
    }

    protected void pagePropertyChange(WizardPage page, PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("accessibleDescription".equals(property)) {
            if (page == this.getSelectedPage()) {
                this._updateAccessibleLabel();
            }
        } else if ("visible".equals(property) || "enabled".equals(property)) {
            if (page == this.getSelectedPage() && Boolean.FALSE.equals(event.getNewValue())) {
                WizardPage newSelect = null;
                WizardPage next = this.getNextPage(page);
                if (next != null) {
                    newSelect = next;
                } else {
                    WizardPage previous = this.getPreviousPage(page);
                    if (previous != null) {
                        newSelect = previous;
                    }
                }
                this.selectPage(newSelect, false);
            } else {
                this.enableButtons();
            }
            if ("visible".equals(property)) {
                this.firePropertyChange("pageVisible", null, page);
            }
        } else if ("canAdvance".equals(property) || "canGoBack".equals(property)) {
            this.enableButtons();
        } else if (("pageTitle".equals(property) || "label".equals(property)) && page == this.getSelectedPage()) {
            this._updateHeaderText(page);
        }
    }

    protected void resetFocus(final WizardPage page) {
        if (this._roadMap != null && this._roadMap.hasFocus()) {
            return;
        }
        if (page == null) {
            return;
        }
        Component initialFocus = page.getInitialFocus();
        if (initialFocus == null && !this._next.hasFocus() && !this._previous.hasFocus()) {
            initialFocus = !this._sequential || this._finish.isDefaultButton() ? this._finish : this._next;
        }
        if (initialFocus != null && initialFocus.isEnabled()) {
            final Component temp = initialFocus;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (page.isSelected()) {
                        FocusUtils.requestFocus(temp);
                    }
                }
            });
        }
    }

    protected void processWizardEvent(WizardEvent event) {
        Enumeration enumer;
        int id = event.getID();
        ListenerManager listeners = this._wizardListeners;
        if (listeners != null && (enumer = listeners.getListeners()) != null) {
            while (enumer.hasMoreElements()) {
                WizardListener listener = (WizardListener)enumer.nextElement();
                switch (id) {
                    case 2001: {
                        listener.wizardSelectionChanged(event);
                        break;
                    }
                    case 2002: {
                        listener.wizardApplyState(event);
                        break;
                    }
                    case 2003: {
                        listener.wizardCanceled(event);
                        break;
                    }
                    case 2004: {
                        listener.wizardFinished(event);
                        break;
                    }
                    case 2005: {
                        if (!(listener instanceof WizardListener2)) break;
                        ((WizardListener2)listener).wizardSaveState(event);
                        break;
                    }
                    case 2006: {
                        if (!(listener instanceof WizardListener2)) break;
                        ((WizardListener2)listener).wizardClosed(event);
                        break;
                    }
                }
            }
        }
    }

    protected void processEventImpl(AWTEvent event) {
        if (event instanceof WizardEvent) {
            this.processWizardEvent((WizardEvent)event);
        } else {
            super.processEventImpl(event);
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (PAGE_CONTAINER.equals(constraints) || "Center".equals(constraints) && comp != this._mainPanel && comp != this._centerHSp) {
            this._contentComp = comp;
            if (comp instanceof JComponent) {
                ((JComponent)comp).setBorder(_sCONTENT_EMPTY_BORDER);
            }
            this._contentPanel.add(comp, "Center", index);
        } else if (comp != this._topPanel && comp != this._leftPanel && comp != this._centerHSp && comp != this._mainPanel && comp != this._bottomPanel) {
            String label = constraints instanceof String ? (String)constraints : comp.getName();
            this.addPage(new WizardPage(comp, label));
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    protected void updateReadingDirection(int newReadingDirection) {
    }

    protected String paramString() {
        String str = super.paramString();
        WizardPage page = this._selectedPage;
        if (page != null) {
            str = str + ",selected page=" + page;
        }
        return str;
    }

    protected WizardBackgroundHandler createDefaultWizardBackgroundHandler() {
        WizardBackgroundHandler handler = new WizardBackgroundHandler();
        handler.setBackgroundGradient(WizardBackgroundHandler.Panel.HEADER, WizardBackgroundHandler.GradientType.HORIZONTAL, Color.white, UIManager.getColor("Panel.background"));
        return handler;
    }

    int __getPageIndex(WizardPage page) {
        int index = this._pages.indexOf(page);
        return index;
    }

    void __doCancelClick() {
        if (this._cancel.isEnabled()) {
            this._cancel.doClick();
        }
    }

    WizardPage[] __getAllPages() {
        return this._pages.toArray(new WizardPage[0]);
    }

    boolean __isSequential() {
        return this._sequential;
    }

    int __getActualPageCount() {
        return this._pages.size();
    }

    WizardPage __getPageAt(int index) {
        return (WizardPage)this._pages.elementAt(index);
    }

    public void __setSplitterMode(boolean mode, boolean divLineVisible) {
        if (this._splitterMode != mode) {
            this._splitterMode = mode;
            if (this.isSplitterMode()) {
                this.remove(this._leftPanel);
                this.remove(this._mainPanel);
                this._rightVSp = new WizardSplitter(0, this._contentPanel, this._bottomContent);
                this._rightVSp.setResizeWeight(1.0);
                this._rightVSp.setOneTouchExpandable(true);
                this._leftVSp = new WizardSplitter(0, this._roadMap, this._auxiliaryContent);
                this._leftVSp.setResizeWeight(1.0);
                this._leftVSp.setOneTouchExpandable(true);
                this._centerHSp = new WizardSplitter(1, this._leftVSp, this._rightVSp);
                this._centerHSp.setOneTouchExpandable(true);
                this.add((Component)this._centerHSp, "Center");
                this.revalidate();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BaseWizard.this._updateLeftAndCenterSplitterUI();
                        BaseWizard.this._updateRightSplitterUI();
                    }
                });
            } else {
                this.remove(this._centerHSp);
                if (this._contentComp != null) {
                    this._contentPanel.add(this._contentComp, "Center");
                }
                this._mainPanel.add((Component)this._contentPanel, "Center");
                if (this._bottomContent != null) {
                    this._mainPanel.add((Component)this._bottomContent, "South");
                }
                this._updateLeftPanelUI();
                this.add((Component)this._leftPanel, "West");
                this.add((Component)this._mainPanel, "Center");
                this.revalidate();
            }
            this._updateLeftPanelBorders();
        }
        if (this.isSplitterMode()) {
            this._rightVSp.setDividerLineVisible(divLineVisible);
            this._leftVSp.setDividerLineVisible(divLineVisible);
            this._centerHSp.setDividerLineVisible(divLineVisible);
        }
    }

    private void _createUI() {
        this.setLayout(new BorderLayout());
        this._listener = new Action();
        this._topPanel = new JPanel(new BorderLayout());
        this._headerLabel = new HeaderLabel();
        BackgroundPainter painter = BackgroundPainter.getInstance();
        this._headerLabel.setBackgroundPainter(painter);
        WizardBackgroundHandler bgHandler = this.createDefaultWizardBackgroundHandler();
        this.setBackgroundHandler(bgHandler);
        this._topPanel.add(this._headerLabel);
        this._mainPanel = new JPanel(new BorderLayout(0, 1));
        this._contentPanel = new BackgroundPanel(new BorderLayout()){

            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        };
        this._contentPanel.setBackgroundPainter(painter);
        this._contentPanel.setBorder(_sCONTENT_BORDER);
        this._mainPanel.add((Component)this._contentPanel, "Center");
        this._leftPanel = new JPanel(new BorderLayout());
        this._createButtonBar(this._listener);
        this._bottomPanel = new BackgroundPanel(new BorderLayout());
        this._bottomPanel.setBackgroundPainter(painter);
        this._bottomPanel.setBorder(_BUTTONBAR_BORDER);
        this._bottomPanel.add("North", this._buttonRow);
        this.add((Component)this._topPanel, "North");
        this.add((Component)this._leftPanel, "West");
        this.add((Component)this._mainPanel, "Center");
        this.add((Component)this._bottomPanel, "South");
        this._registerKeyboardActions();
    }

    private void _createButtonBar(Action action) {
        this._buttonRow = new DialogButtonBar();
        JButton button = this._createButton(action);
        this._buttonRow.add((Component)button, DialogButtonBar.CONSTRAINT_HELP);
        this._help = button;
        button = this._createButton(action);
        button.setVisible(false);
        this._buttonRow.add((Component)button, DialogButtonBar.CONSTRAINT_APPLY);
        this._apply = button;
        button = this._createButton(action);
        button.setVisible(false);
        this._buttonRow.add((Component)button, DialogButtonBar.CONSTRAINT_SAVE);
        this._save = button;
        button = this._createButton(action);
        button.setEnabled(false);
        this._buttonRow.add((Component)button, DialogButtonBar.CONSTRAINT_BACK);
        this._previous = button;
        this._previous.setHorizontalTextPosition(11);
        this._previous.setVerticalTextPosition(0);
        button = this._createButton(action);
        button.setEnabled(false);
        this._buttonRow.add((Component)button, DialogButtonBar.CONSTRAINT_NEXT);
        this._next = button;
        this._next.setHorizontalTextPosition(10);
        this._next.setVerticalTextPosition(0);
        button = this._createButton(action);
        button.setEnabled(false);
        this._buttonRow.add((Component)button, DialogButtonBar.CONSTRAINT_FINISH);
        this._finish = button;
        button = this._createButton(action);
        this._buttonRow.add((Component)button, DialogButtonBar.CONSTRAINT_CANCEL);
        this._cancel = button;
        this._cancel.setName(_CANCEL_NAME);
        this._help.setName(_HELP_NAME);
        this._apply.setName(_APPLY_NAME);
        this._previous.setName(_PREVIOUS_NAME);
        this._next.setName(_NEXT_NAME);
        this._finish.setName(_FINISH_NAME);
        this._save.setName(_SAVE_NAME);
    }

    private JButton _createButton(Action l) {
        JButton button = new JButton("");
        Insets margin = button.getMargin();
        if (margin != null) {
            margin.left = 2;
            margin.right = 1;
        } else {
            margin = new Insets(1, 2, 1, 1);
        }
        button.setMargin(margin);
        button.addActionListener(l);
        button.addFocusListener(l);
        button.setDefaultCapable(false);
        return button;
    }

    private void _loadButtonText(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle wizardBundle = ResourceBundle.getBundle(_BUNDLE_NAME, locale);
        EWTWizardUI wizardUI = (EWTWizardUI)this.ui;
        if (this._finishDefaulted) {
            this._setButtonLabel(this._finish, wizardBundle.getString(_FINISH_KEY));
        }
        this._setButtonLabel(this._help, wizardBundle.getString(_HELP_KEY));
        this._setButtonLabel(this._apply, wizardBundle.getString(_APPLY_KEY));
        this._setButtonLabel(this._save, wizardBundle.getString(_SAVE_KEY));
        this._setButtonLabel(this._previous, wizardUI.getPreviousString(this, wizardBundle.getString(_PREVIOUS_KEY)));
        this._setButtonLabel(this._next, wizardUI.getNextString(this, wizardBundle.getString(_NEXT_KEY)));
        this._setButtonLabel(this._cancel, wizardBundle.getString(this._closed ? _CLOSE_KEY : _CANCEL_KEY));
    }

    private void _setButtonLabel(JButton button, String label) {
        button.setMnemonic(StringUtils.getMnemonicKeyCode((String)label));
        button.setText(StringUtils.stripMnemonic((String)label));
    }

    private void _setClose() {
        if (!this._closed) {
            this._closed = true;
            Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
            ResourceBundle bundle = ResourceBundle.getBundle(_BUNDLE_NAME, locale);
            this._setButtonLabel(this._cancel, bundle.getString(_CLOSE_KEY));
            this._cancel.setName(_CLOSE_NAME);
        }
    }

    private void _setCancel() {
        if (this._closed) {
            this._closed = false;
            Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
            ResourceBundle bundle = ResourceBundle.getBundle(_BUNDLE_NAME, locale);
            this._setButtonLabel(this._cancel, bundle.getString(_CANCEL_KEY));
            this._cancel.setName(_CANCEL_NAME);
        }
    }

    private void _createBottomContent() {
        if (this._bottomContent == null) {
            this._bottomContent = new BottomContent();
            this._setMessagePanelBorder(this._flatLook);
            this._bottomContent.setBackgroundPainter(BackgroundPainter.getInstance());
            if (!this.isSplitterMode()) {
                this._mainPanel.add((Component)this._bottomContent, "South");
            }
            Background[] _panels = this.getBackgroundHandler().__getBackgrounds();
            WizardBackgroundHandler.Panel panel = WizardBackgroundHandler.findPanel(_MESSAGE);
            this._updatePaintContext(panel, _panels[panel.ordinal()]);
        }
    }

    private void _createAuxiliaryContent() {
        if (this._auxiliaryContent == null) {
            this._auxiliaryContent = new AuxiliaryContent();
            this._auxiliaryContent.setBackgroundPainter(BackgroundPainter.getInstance());
            if (!this.isSplitterMode()) {
                this._updateLeftPanelUI();
            }
            Background[] _panels = this.getBackgroundHandler().__getBackgrounds();
            WizardBackgroundHandler.Panel panel = WizardBackgroundHandler.findPanel(_AUXILIARY);
            this._updatePaintContext(panel, _panels[panel.ordinal()]);
        }
    }

    private void _updateHeaderText(WizardPage page) {
        String headerText = null;
        if (page != null && (headerText = page.getPageTitle()) == null && (headerText = page.getLabel()) == null && page instanceof TitledWizardPage) {
            headerText = ((TitledWizardPage)page).getTitle();
        }
        this._headerLabel.setText(headerText);
    }

    private boolean _validatePage(boolean doPageValidate, boolean pageChanging) {
        this._pageValidation = !doPageValidate || this.validateSelectedPage();
        WizardPage selectedPage = this.getSelectedPage();
        if (selectedPage != null) {
            boolean isValid;
            boolean bl = isValid = this._pageValidation && this._isValidationMessageContainsError();
            if (pageChanging && this._pageValidation) {
                this._updateValidationMessagePane(selectedPage, false);
            }
            selectedPage.setValid(isValid);
        }
        return this._pageValidation;
    }

    private boolean _isValidationMessageContainsError() {
        ValidationMessagePane pane = this.getValidationMessagePane();
        return pane == null || !pane.isErrorOrWarning();
    }

    private void _updateValidationMessagePane(WizardPage selected, boolean add) {
        ValidationMessagePane pane = this.getValidationMessagePane();
        if (pane != null) {
            ValidationComponent[] comps = selected.getValidationComponents();
            if (add) {
                pane.addPropertyChangeListener(this._listener);
                if (comps != null) {
                    for (int i = 0; i < comps.length; ++i) {
                        pane.addValidationComponent(comps[i]);
                        comps[i].addValidationMessageModelListener(this._listener);
                    }
                }
            } else {
                pane.removePropertyChangeListener(this._listener);
                if (comps != null) {
                    for (int i = 0; i < comps.length; ++i) {
                        comps[i].removeValidationMessageModelListener(this._listener);
                    }
                }
                pane.removeAllValidationComponents();
            }
        }
    }

    private boolean _isProgressPage(WizardPage page) {
        return page != null && page == this._progressPage && page.getParent() == this;
    }

    private boolean _isEndProcessPage(WizardPage page) {
        return page != null && page == this._endProcessPage && page.getParent() == this;
    }

    private void _registerKeyboardActions() {
        ActionListener cancelAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseWizard.this._cancel.doClick();
            }
        };
        this.registerKeyboardAction(cancelAction, KeyStroke.getKeyStroke(27, 0), 1);
        ActionListener helpAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BaseWizard.this.isHelpAvailable()) {
                    BaseWizard.this.doHelp();
                }
            }
        };
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(112, 0), 1);
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void _unregisterKeyboardActions() {
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(156, 0));
    }

    private void _updateAccessibleLabel() {
        if (this._accessibleLabel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String newValue;
                    WizardPage p = BaseWizard.this.getSelectedPage();
                    if (p != null && (newValue = p.getAccessibleDescription()) != null && !newValue.equals(BaseWizard.this._accessibleDesc)) {
                        BaseWizard.this._accessibleDesc = newValue;
                        BaseWizard.this._accessibleLabel.setText(newValue);
                        BaseWizard.this._accessibleLabel.setText("");
                    }
                }
            });
        }
    }

    private void _updateAccessibleTitle() {
        if (this._accessibleLabel != null) {
            String temp = null;
            Window w = SwingUtilities.getWindowAncestor(this);
            if (w == null) {
                return;
            }
            if (w instanceof Frame) {
                temp = ((Frame)w).getTitle();
            } else if (w instanceof Dialog) {
                temp = ((Dialog)w).getTitle();
            }
            final String title = temp;
            if (title != null && !"".equals(title)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BaseWizard.this._accessibleLabel.setText(title);
                    }
                });
            }
        }
    }

    private void _updatePaintContext(WizardBackgroundHandler.Panel panel, Background bg) {
        PaintCtxt paintCtxt = null;
        if (WizardBackgroundHandler.Panel.CONTENT == panel && this._contentPanel != null) {
            paintCtxt = (PaintCtxt)this._contentPanel.getPaintContext();
        } else if (WizardBackgroundHandler.Panel.HEADER == panel && this._headerLabel != null) {
            paintCtxt = (PaintCtxt)this._headerLabel.getPaintContext();
        } else if (WizardBackgroundHandler.Panel.LOGO == panel && this._logoCanvas != null) {
            paintCtxt = (PaintCtxt)this._logoCanvas.getPaintContext();
        } else if (WizardBackgroundHandler.Panel.ROADMAP == panel && this._roadMap != null) {
            paintCtxt = (PaintCtxt)this._roadMap.getPaintContext();
        } else if (WizardBackgroundHandler.Panel.AUXILIARY == panel && this._auxiliaryContent != null) {
            paintCtxt = (PaintCtxt)this._auxiliaryContent.getPaintContext();
        } else if (WizardBackgroundHandler.Panel.MESSAGE == panel && this._bottomContent != null) {
            paintCtxt = (PaintCtxt)this._bottomContent.getPaintContext();
        } else if (WizardBackgroundHandler.Panel.BUTTON == panel && this._bottomPanel != null) {
            paintCtxt = (PaintCtxt)this._bottomPanel.getPaintContext();
        }
        if (paintCtxt != null) {
            paintCtxt.setBackground(bg);
        }
    }

    private void _updateLeftPanelUI() {
        this._leftPanel.removeAll();
        if (this.isRoadmapVisible()) {
            this._leftPanel.add((Component)this._roadMap, "Center");
            if (this._auxiliaryContent != null) {
                this._leftPanel.add((Component)this._auxiliaryContent, "South");
            }
        } else if (this._auxiliaryContent != null) {
            this._leftPanel.add((Component)this._auxiliaryContent, "Center");
        }
        this._leftPanel.revalidate();
    }

    private void _updateLeftPanelBorders() {
        boolean auxExists;
        boolean isFlat = this.isFlatLook();
        boolean isSplitterMode = this.isSplitterMode();
        boolean isRoadmapVisible = this.isRoadmapVisible();
        boolean bl = auxExists = this.getAuxiliaryPane() != null;
        if (isRoadmapVisible) {
            this._roadMap.__setBorder(isFlat, auxExists, isSplitterMode);
        }
        if (auxExists) {
            if (isFlat) {
                if (isSplitterMode) {
                    if (isRoadmapVisible) {
                        this._auxiliaryContent.setBorder(_sAUXILIARY_PANEL_BORDER1);
                    } else {
                        this._auxiliaryContent.setBorder(_sAUXILIARY_PANEL_BORDER2);
                    }
                } else {
                    this._auxiliaryContent.setBorder(_sAUXILIARY_PANEL_BORDER);
                }
            } else {
                this._auxiliaryContent.setBorder(_sAUXILIARY_PANEL_NULL_BORDER);
            }
        }
    }

    private void _updateLeftAndCenterSplitterUI() {
        boolean auxPaneExists;
        boolean roadmapVisible = this.isRoadmapVisible();
        boolean bl = auxPaneExists = this.getAuxiliaryPane() != null;
        if (!roadmapVisible && !auxPaneExists) {
            this._centerHSp.setLeftComponent(null);
            this._centerHSp.setDividerSize(0);
        } else {
            this._centerHSp.setLeftComponent(this._leftVSp);
            this._centerHSp.setDividerSize(4);
            this._centerHSp.setDividerLocation(WizardSize.getNavigationPanelSize((int)this.getDefaultWizardSize()).width);
            if (!roadmapVisible && auxPaneExists) {
                this._leftVSp.setLeftComponent(null);
                this._leftVSp.setRightComponent(this._auxiliaryContent);
                this._leftVSp.setDividerSize(0);
            } else if (roadmapVisible && !auxPaneExists) {
                this._leftVSp.setLeftComponent(this._roadMap);
                this._leftVSp.setRightComponent(null);
                this._leftVSp.setDividerSize(0);
            } else {
                this._leftVSp.setLeftComponent(this._roadMap);
                this._leftVSp.setRightComponent(this._auxiliaryContent);
                this._leftVSp.setDividerSize(4);
                if (this._auxiliaryContent != null) {
                    this._leftVSp.setDividerLocation(this._centerHSp.getSize().height - this._auxiliaryContent.getPreferredSize().height - this._leftVSp.getDividerSize());
                }
            }
        }
    }

    private void _updateRightSplitterUI() {
        boolean billboardOrMessagePaneExists;
        boolean bl = billboardOrMessagePaneExists = this.getBillboard() != null || this.getValidationMessagePane() != null;
        if (!billboardOrMessagePaneExists) {
            this._rightVSp.setLeftComponent(this._contentPanel);
            this._rightVSp.setRightComponent(null);
            this._rightVSp.setDividerSize(0);
        } else {
            this._rightVSp.setLeftComponent(this._contentPanel);
            this._rightVSp.setRightComponent(this._bottomContent);
            this._rightVSp.setDividerSize(4);
            if (this._bottomContent != null) {
                this._rightVSp.setDividerLocation(this._centerHSp.getSize().height - this._bottomContent.getPreferredSize().height - this._rightVSp.getDividerSize());
            }
        }
    }

    private void _setMessagePanelBorder(boolean flat) {
        if (this._bottomContent == null) {
            return;
        }
        if (flat) {
            this._bottomContent.setBorder(_sMESSAGE_PANEL_BORDER);
        } else {
            this._bottomContent.setBorder(_sMESSAGE_PANEL_NULL_BORDER);
        }
    }

    private class AccessibleLabel
    extends JLabel {
        private AccessibleLabel() {
        }

        public void setText(String text) {
            String old = this.getText();
            super.setText(text);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", old, text);
            }
        }
    }

    private class AccessibleWizard
    extends JComponent.AccessibleJComponent {
        private AccessibleWizard() {
            super(BaseWizard.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private class Action
    extends WindowAdapter
    implements ActionListener,
    PropertyChangeListener,
    FocusListener,
    ValidationMessageModelListener {
        private Action() {
        }

        public void windowOpened(WindowEvent e) {
            BaseWizard.this.resetFocus(BaseWizard.this.getSelectedPage());
            BaseWizard.this._updateAccessibleLabel();
            e.getWindow().removeWindowListener(this);
        }

        public void actionPerformed(final ActionEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object source = event.getSource();
                    if (source == BaseWizard.this._apply) {
                        BaseWizard.this.doApply();
                    } else if (source == BaseWizard.this._cancel) {
                        if (BaseWizard.this._closed) {
                            BaseWizard.this.doClose();
                        } else {
                            BaseWizard.this.doCancel();
                        }
                    } else if (source == BaseWizard.this._finish) {
                        BaseWizard.this.doFinish();
                    } else if (source == BaseWizard.this._next) {
                        BaseWizard.this.doNext();
                    } else if (source == BaseWizard.this._previous) {
                        BaseWizard.this.doPrevious();
                    } else if (source == BaseWizard.this._help) {
                        BaseWizard.this.doHelp();
                    } else if (source == BaseWizard.this._save) {
                        BaseWizard.this.doSave();
                    }
                }
            });
        }

        public void propertyChange(PropertyChangeEvent event) {
            Object source = event.getSource();
            if (source == null) {
                return;
            }
            if (source == BaseWizard.this.getValidationMessagePane()) {
                WizardPage page;
                if (ValidationMessagePane.PANE_CONTENT_CHANGED.equals(event.getPropertyName()) && (page = BaseWizard.this.getSelectedPage()) != null) {
                    page.setValid(BaseWizard.this._pageValidation && !BaseWizard.this.getValidationMessagePane().isErrorOrWarning());
                }
            } else if (source instanceof WizardPage) {
                BaseWizard.this.pagePropertyChange((WizardPage)source, event);
            } else if (source == BaseWizard.this.getBackgroundHandler()) {
                WizardBackgroundHandler.Panel panel = WizardBackgroundHandler.findPanel(event.getPropertyName());
                Background bg = (Background)event.getNewValue();
                BaseWizard.this._updatePaintContext(panel, bg);
            }
        }

        public void focusGained(FocusEvent e) {
            JButton source;
            JRootPane pane = BaseWizard.this.getRootPane();
            JButton old = pane == null ? null : pane.getDefaultButton();
            if (old != (source = (JButton)e.getSource())) {
                if (old != null) {
                    old.setDefaultCapable(false);
                }
                source.setDefaultCapable(true);
                if (pane != null) {
                    pane.setDefaultButton(source);
                }
            }
        }

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                WizardPage next = BaseWizard.this.getNextPage(BaseWizard.this.getSelectedPage());
                JButton b = !BaseWizard.this._sequential || next == null ? BaseWizard.this._finish : BaseWizard.this._next;
                JButton source = (JButton)e.getSource();
                if (source != b) {
                    JRootPane pane = BaseWizard.this.getRootPane();
                    source.setDefaultCapable(false);
                    if (pane != null) {
                        pane.setDefaultButton(b);
                    }
                    if (b != null) {
                        b.setDefaultCapable(true);
                    }
                }
            }
        }

        public void messageAdded(ValidationMessageModelEvent event) {
            if (BaseWizard.this.isSplitterMode()) {
                int newLoc;
                int type = BaseWizard.this.getDefaultWizardSize();
                int currLoc = BaseWizard.this._rightVSp.getDividerLocation();
                if (currLoc > (newLoc = BaseWizard.this._rightVSp.getHeight() - WizardSize.getMessagePanelSize((int)type).height - BaseWizard.this._rightVSp.getDividerSize())) {
                    BaseWizard.this._rightVSp.setDividerLocation(newLoc);
                }
            }
        }

        public void messageRemoved(ValidationMessageModelEvent event) {
        }
    }

    private class BottomContent
    extends BackgroundPanel {
        private ValidationMessagePane _errorMsgPane;
        private Component _billboard;

        public BottomContent() {
            this.setLayout(new BorderLayout());
        }

        public Dimension getMaximumSize() {
            if (this.getComponentCount() == 0) {
                return new Dimension(0, 0);
            }
            Component comp = this.getComponent(0);
            if (comp instanceof ValidationMessagePane) {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            Dimension pref = this.getPreferredSize();
            return new Dimension(Integer.MAX_VALUE, pref.height);
        }

        public Dimension getMinimumSize() {
            if (this.getComponentCount() == 0) {
                return new Dimension(0, 0);
            }
            Component comp = this.getComponent(0);
            if (comp instanceof ValidationMessagePane) {
                return new Dimension(0, 0);
            }
            Dimension pref = this.getPreferredSize();
            return new Dimension(0, pref.height);
        }

        public Dimension getPreferredSize() {
            return WizardSize.getMessagePanelSize(BaseWizard.this.getDefaultWizardSize());
        }

        public void dispose() {
            if (this._errorMsgPane != null) {
                this._errorMsgPane.dispose();
                this._errorMsgPane = null;
            }
            this._billboard = null;
            this.removeAll();
        }

        public void setValidationMessagePane(ValidationMessagePane pane) {
            WizardPage selected = BaseWizard.this.getSelectedPage();
            if (selected != null && this.getValidationMessagePane() != null) {
                BaseWizard.this._updateValidationMessagePane(selected, false);
            }
            this._errorMsgPane = pane;
            if (selected != null && this.getValidationMessagePane() != null) {
                BaseWizard.this._updateValidationMessagePane(selected, true);
            }
            this.updateVisibility();
        }

        public ValidationMessagePane getValidationMessagePane() {
            return this._errorMsgPane;
        }

        public void setBillboard(Component billboard) {
            this._billboard = billboard;
            this.updateVisibility();
        }

        public Component getBillboard() {
            return this._billboard;
        }

        public void updateVisibility() {
            this.removeAll();
            boolean visible = true;
            if (this._errorMsgPane != null && this._billboard != null) {
                if (BaseWizard.this.getBottomContentMode() == 0) {
                    this.add(this._errorMsgPane);
                } else {
                    this.add(this._billboard);
                }
            } else if (this._errorMsgPane != null) {
                this.add(this._errorMsgPane);
            } else if (this._billboard != null) {
                this.add(this._billboard);
            } else {
                visible = false;
            }
            if (BaseWizard.this.isSplitterMode()) {
                BaseWizard.this._updateRightSplitterUI();
            }
            this.setVisible(visible);
            this.revalidate();
            this.repaint();
        }
    }

    private class LogoCanvas
    extends BackgroundLWComponent {
        private Image _image;

        private LogoCanvas() {
        }

        public void setImage(Image image) {
            this._image = image;
            ImageUtils.loadImage(image);
            WizardBackgroundHandler bgHandler = BaseWizard.this.getBackgroundHandler();
            bgHandler.setBackgroundImage(WizardBackgroundHandler.Panel.LOGO, WizardBackgroundHandler.Position.CENTER_RIGHT_EDGE, image, WizardBackgroundHandler.Stretch.NONE, WizardBackgroundHandler.ImageBoundary.PANE);
            this.revalidate();
            this.repaint();
        }

        public Image getImage() {
            return this._image;
        }

        public Dimension getPreferredSize() {
            return WizardSize.getHeaderSize(BaseWizard.this.getDefaultWizardSize());
        }
    }

    private class HeaderLabel
    extends JLabel {
        private boolean _doInit = true;
        private BackgroundPainter _painter;

        public HeaderLabel() {
            this.setBorder(_HEADER_BORDER);
            this.setOpaque(false);
            PaintCtxt paintContext = new PaintCtxt(this);
            JPaintContext.putPaintContext(this, paintContext);
        }

        public void setBackgroundPainter(BackgroundPainter painter) {
            this._painter = painter;
        }

        public PaintContext getPaintContext() {
            return JPaintContext.getPaintContext(this);
        }

        public void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (this._painter != null) {
                this._painter.paint(this.getPaintContext(), g, 0, 0, width, height);
            }
            super.paintComponent(g);
        }

        public Dimension getPreferredSize() {
            return WizardSize.getHeaderSize(BaseWizard.this.getDefaultWizardSize());
        }

        public void addNotify() {
            super.addNotify();
            if (this._doInit) {
                this._doInit = false;
                Font f = this.getFont();
                this.setFont(f.deriveFont(f.getStyle() | 1, (int)((double)f.getSize() * 1.3)));
            }
        }
    }

    private class AuxiliaryContent
    extends BackgroundPanel {
        private int _windowTitleHeight = -1;
        private Component _auxiliaryPane;

        public AuxiliaryContent() {
            this.setLayout(new BorderLayout());
        }

        public void setAuxiliaryPane(Component auxiiaryPane) {
            this._auxiliaryPane = auxiiaryPane;
            this.removeAll();
            if (this._auxiliaryPane != null) {
                this.add(this._auxiliaryPane);
            }
            this.setVisible(this._auxiliaryPane != null);
            this.revalidate();
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        public Dimension getPreferredSize() {
            Dimension uiDim = WizardSize.getAuxiliaryPanelSize(BaseWizard.this.getDefaultWizardSize());
            if (BaseWizard.this._auxPaneHeight != -1) {
                return new Dimension(uiDim.width, BaseWizard.this._auxPaneHeight);
            }
            if (BaseWizard.this.isRoadmapVisible()) {
                int auxPaneHeight;
                int type = BaseWizard.this.getDefaultWizardSize();
                if (this._windowTitleHeight == -1) {
                    Window w = WindowUtils.getWindow(this);
                    if (w == null) {
                        this._windowTitleHeight = -1;
                    } else {
                        Insets insets = w.getInsets();
                        this._windowTitleHeight = insets.top + insets.bottom;
                    }
                }
                if ((auxPaneHeight = WizardSize.getWizardSize((int)type).height - WizardSize.getHeaderSize((int)type).height - ((BaseWizard)BaseWizard.this)._bottomPanel.getPreferredSize().height - BaseWizard.this._roadMap.__getActualViewHeight() - (BaseWizard.this.isSplitterMode() ? BaseWizard.this._leftVSp.getDividerSize() : 0) - this._windowTitleHeight) > 0 && auxPaneHeight < uiDim.height) {
                    return new Dimension(uiDim.width, auxPaneHeight);
                }
            }
            return uiDim;
        }

        public void dispose() {
            this._auxiliaryPane = null;
            this.removeAll();
        }

        public Component getAuxiliaryPane() {
            return this._auxiliaryPane;
        }
    }

    private static class ContentBorder
    extends MatteBorder {
        public ContentBorder(int top, int left, int bottom, int right) {
            super(top, left, bottom, right, (Color)null);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.color = c.isEnabled() ? UIManager.getColor("controlDkShadow") : UIManager.getColor("controlShadow");
            super.paintBorder(c, g, x, y, width, height);
        }
    }
}

