/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.text;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.text.WrapInfo;
import oracle.bali.share.nls.LocaleUtils;

public class WrappedText
implements WrapInfo {
    private boolean _forceFit;
    private FontMetrics _metrics;
    private Locale _locale;
    private int _width;
    private String _text;
    private Vector _lines;

    public static String wrapText(String text, Component component) {
        return WrappedText.wrapText(text, WordWrapper.getTextWrapper(), component);
    }

    public static String wrapText(String text, TextWrapper wrapper, Component component) {
        return new WrappedText(text, wrapper, component).getWrappedText();
    }

    public WrappedText(String text, TextWrapper wrapper, Component component) {
        this(text, wrapper, component, false);
    }

    public WrappedText(String text, TextWrapper wrapper, Component component, boolean forceFit) {
        this(text, wrapper, WrappedText._getInnerWidth(component), component.getFontMetrics(component.getFont()), LocaleUtils.getDefaultableLocale((Component)component), forceFit);
    }

    public WrappedText(String text, TextWrapper wrapper, int width, FontMetrics metrics, Locale locale, boolean forceFit) {
        int currIndex;
        if (text == null) {
            text = "";
        }
        int foundIndex = -1;
        int textLength = text.length();
        this._text = text;
        this._width = width;
        this._metrics = metrics;
        this._locale = locale == null ? Locale.getDefault() : locale;
        this._forceFit = forceFit;
        if (metrics == null) {
            return;
        }
        if (this._width <= 0) {
            this._width = (int)Math.sqrt((double)((float)metrics.stringWidth(this._text) * (float)metrics.getHeight()) * 4.0) + 1;
        }
        while ((currIndex = foundIndex + 1) != textLength) {
            foundIndex = text.indexOf(10, currIndex);
            if (foundIndex == -1) {
                wrapper.wrapParagraph(this, text.substring(currIndex));
            } else if (foundIndex == currIndex) {
                this.addLine("", 0, 0);
            } else {
                wrapper.wrapParagraph(this, text.substring(currIndex, foundIndex));
            }
            if (foundIndex != -1) continue;
        }
    }

    public String getText() {
        return this._text;
    }

    public String getWrappedText() {
        int lineCount = this.getLineCount();
        StringBuffer sb = new StringBuffer(this.getText().length() + lineCount - 1);
        for (int i = 0; i < lineCount; ++i) {
            sb.append(this.getLine(i));
            if (i >= lineCount - 1) continue;
            sb.append('\n');
        }
        return new String(sb);
    }

    public int getLineCount() {
        if (this._lines == null) {
            return 1;
        }
        return this._lines.size();
    }

    public String getLine(int index) {
        if (index < 0 || index >= this.getLineCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (this._lines == null) {
            return this._text;
        }
        return (String)this._lines.elementAt(index);
    }

    public boolean addLine(String text, int start, int end) {
        if (text == this.getText() && start == 0 && end == text.length()) {
            return false;
        }
        Vector<String> lines = this._lines;
        if (lines == null) {
            this._lines = lines = new Vector<String>();
        }
        lines.addElement(text.substring(start, end));
        return true;
    }

    public boolean isCalculatingPreferred() {
        return !this._forceFit;
    }

    public FontMetrics getFontMetrics() {
        return this._metrics;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public int getWrapWidth() {
        return this._width;
    }

    private static int _getInnerWidth(Component component) {
        if (component instanceof JComponent) {
            JComponent jc = (JComponent)component;
            int width = jc.getWidth();
            if (jc.getBorder() != null) {
                Insets i = jc.getBorder().getBorderInsets(component);
                width -= i.left + i.right;
            }
            return width;
        }
        return component.getSize().width;
    }
}

