/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.text;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public class NumberTextField
extends JTextField {
    private static final char _PLUS = '+';
    private static final String _PLUS_STRING = "+";
    private static final String _EXPONENT_STRING = "E";
    private static final char _NULL_CHAR = '\u0000';
    private static final int _MAX_DECIMAL_DIGITS = 340;
    private static Method _sSetExponent;
    private static Method _sGetExponent;
    private Class _type;
    private boolean _signed = true;
    private boolean _decimal;
    private boolean _scientific;
    private boolean _groupingEnabled;
    private int _posStartScien = -1;
    private String _prevValidtext;
    private String _validScienNotation;
    private String _scienPattern;
    private int _decimalDigits = -1;
    private DecimalFormat _format;
    private DecimalFormat _oldFormat;
    private static final Class _DEFAULT_CLASS;

    public NumberTextField() {
        this((Number)null);
    }

    public NumberTextField(Number number) {
        Class<?> type = number == null ? _DEFAULT_CLASS : number.getClass();
        this.setDataType(type);
        this.setNumber(number);
    }

    public NumberTextField(int columns) {
        this((Number)null, columns);
    }

    public NumberTextField(Number number, int columns) {
        super(columns);
        Class<?> type = number == null ? _DEFAULT_CLASS : number.getClass();
        this.setDataType(type);
        this.setNumber(number);
    }

    public Number getNumber() {
        Number n;
        String string = this.getText();
        try {
            n = this._getNumber(string);
        }
        catch (NumberFormatException e) {
            n = null;
        }
        return n;
    }

    public void setNumber(Number n) {
        if (n == null) {
            this.setText("");
        } else {
            String s = this.convertNumberToString(this._parseNumber(n));
            this.setText(s);
            if (this.isScientific()) {
                this._prevValidtext = s;
            }
        }
    }

    public void setDataType(Class type) {
        if (this._isDataTypeEqual(type)) {
            this._type = type;
            return;
        }
        Number n = this.getNumber();
        this._type = type;
        if (n != null) {
            this.setNumber(n);
        }
        this.setDecimal(this._isDecimal(this._type));
    }

    public Class getDataType() {
        return this._type;
    }

    public boolean isSigned() {
        return this._signed;
    }

    public void setSigned(boolean signed) {
        if (signed != this.isSigned()) {
            this._signed = signed;
            if (!signed) {
                DecimalFormatSymbols symbols = this._getFormat().getDecimalFormatSymbols();
                char minus = symbols.getMinusSign();
                String s = this.getText();
                int index = s.indexOf(minus);
                if (index == 0) {
                    this.setText(s.substring(index + 1));
                } else {
                    index = s.indexOf(43);
                    if (index == 0) {
                        this.setText(s.substring(index + 1));
                    }
                }
            }
        }
    }

    public boolean isScientific() {
        return this._scientific;
    }

    public void setScientificPattern(String pattern) {
        this._scienPattern = pattern;
        this.setNumber(this.getNumber());
    }

    public void setScientific(boolean scientific) {
        if (this._scientific != scientific) {
            this._scientific = scientific;
            this.setNumber(this.getNumber());
        }
    }

    public boolean isGroupingEnabled() {
        return this._groupingEnabled;
    }

    public void setGroupingEnabled(boolean enabled) {
        if (this._groupingEnabled != enabled) {
            this._groupingEnabled = enabled;
            DecimalFormat format = this._getFormat();
            Number oldNumber = this.getNumber();
            format.setGroupingUsed(enabled);
            if (oldNumber != null) {
                this.setNumber(oldNumber);
            }
        }
    }

    public boolean isDecimal() {
        return this._decimal;
    }

    public void setDecimal(boolean isDecimal) {
        this.setDecimal(isDecimal, -1);
    }

    public void setDecimal(boolean isDecimal, int maxDecimalDigits) {
        Class type;
        if (isDecimal && !this._isDecimal(type = this.getDataType())) {
            return;
        }
        if (maxDecimalDigits <= -1) {
            maxDecimalDigits = 340;
        }
        int oldMax = this.getMaximumDecimalDigits();
        if (isDecimal != this.isDecimal() || maxDecimalDigits != oldMax) {
            this._decimal = isDecimal;
            if (maxDecimalDigits != oldMax) {
                this._format = null;
                this._decimalDigits = maxDecimalDigits;
                if (isDecimal) {
                    this._getFormat();
                }
            }
            if (!isDecimal) {
                DecimalFormatSymbols symbols = this._getFormat().getDecimalFormatSymbols();
                char decimal = symbols.getDecimalSeparator();
                String s = this.getText();
                int index = s.indexOf(decimal);
                String newText = null;
                if (index != -1) {
                    if (index == 0) {
                        newText = s.substring(1);
                    } else {
                        String left = s.substring(0, index);
                        newText = left + s.substring(index + 1);
                    }
                }
                if (newText != null) {
                    this.setText(newText);
                }
            }
        }
    }

    public int getMaximumDecimalDigits() {
        return this._getFormat().getMaximumFractionDigits();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._resetFormat();
    }

    protected Document createDefaultModel() {
        Document doc = super.createDefaultModel();
        if (doc instanceof AbstractDocument) {
            NumberTextFieldDocumentFilter filter = new NumberTextFieldDocumentFilter();
            ((AbstractDocument)doc).setDocumentFilter(filter);
        }
        return doc;
    }

    protected boolean validateNumber(Number n) {
        return true;
    }

    protected String convertNumberToString(Number n) {
        if (this._format != null) {
            int actualMax;
            int correctMax;
            String s;
            int decPt;
            float f;
            if ((this._type == Float.TYPE || this._type == Float.class) && ((f = n.floatValue()) <= 9999999.0f || f >= 0.001f) && (decPt = (s = n.toString()).indexOf(".")) != -1 && (correctMax = s.substring(decPt + 1, s.length()).length()) < (actualMax = this.getMaximumDecimalDigits())) {
                this._format.setMaximumFractionDigits(correctMax);
                String str = this._format.format(n);
                this._format.setMaximumFractionDigits(actualMax);
                return str;
            }
            if (this.isScientific() && this._type != BigInteger.class && (n.doubleValue() > 2.147483647E9 || n.doubleValue() < -2.147483648E9)) {
                if (this._scienPattern == null || "".equals(this._scienPattern)) {
                    int max = this.getMaximumDecimalDigits();
                    char[] patternChars = new char[max + 4];
                    patternChars[0] = 48;
                    patternChars[1] = 46;
                    for (int i = 2; i < max + 2; ++i) {
                        patternChars[i] = 35;
                    }
                    patternChars[i] = 69;
                    patternChars[i + 1] = 48;
                    this._scienPattern = new String(patternChars);
                }
                DecimalFormat format = (DecimalFormat)this._format.clone();
                format.applyPattern(this._scienPattern);
                String formattedString = format.format(n);
                String sNotation = null;
                Method meth = NumberTextField._sGetExponentMethod();
                if (meth != null) {
                    try {
                        sNotation = (String)meth.invoke((Object)format.getDecimalFormatSymbols(), new Object[0]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (sNotation == null) {
                    sNotation = _EXPONENT_STRING;
                }
                int posExp = formattedString.indexOf(sNotation);
                String beforeExponent = formattedString.substring(0, posExp);
                String afterExponent = formattedString.substring(posExp + sNotation.length(), formattedString.length());
                String beforeExponentFormatted = this._format.format(new Double(beforeExponent));
                if (this.getDataType() == BigDecimal.class) {
                    sNotation = _EXPONENT_STRING;
                }
                return beforeExponentFormatted + sNotation + afterExponent;
            }
            return this._format.format(n);
        }
        return n.toString();
    }

    protected char getDecimalSeparator() {
        return '\u0000';
    }

    protected String getExponentSeparator() {
        return null;
    }

    protected char getGroupingSeparator() {
        return '\u0000';
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (this.isScientific() && e.getID() == 1005) {
            this.setText(this._prevValidtext);
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (this.isScientific() && e.getID() == 401 && e.getKeyChar() == '\n') {
            this.setText(this._prevValidtext);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleNumberTextField();
        }
        return this.accessibleContext;
    }

    private static Method _sGetExponentMethod() {
        if (_sGetExponent == null) {
            Class<DecimalFormatSymbols> cls = DecimalFormatSymbols.class;
            try {
                _sGetExponent = cls.getMethod("getExponentSeparator", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return _sGetExponent;
    }

    private static Method _setExponentMethod() {
        if (_sSetExponent == null) {
            Class<DecimalFormatSymbols> cls = DecimalFormatSymbols.class;
            Class[] par = new Class[]{String.class};
            try {
                _sSetExponent = cls.getMethod("setExponentSeparator", par);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return _sSetExponent;
    }

    private Number _getNumber(String string) throws NumberFormatException {
        Number n = null;
        if (string.contains(_PLUS_STRING)) {
            string = string.replace(_PLUS_STRING, "");
        }
        if (this._type == BigDecimal.class) {
            if ("".equals(string)) {
                throw new NumberFormatException();
            }
            if (string.endsWith(_EXPONENT_STRING) || string.endsWith("e")) {
                string = string.substring(0, string.length() - 1);
            }
            return new BigDecimal(string);
        }
        if (this._type == BigInteger.class) {
            return new BigInteger(string);
        }
        DecimalFormat format = this._getFormat();
        try {
            n = format.parse(string);
        }
        catch (ParseException pe) {
            throw new NumberFormatException();
        }
        Object maxValue = null;
        if (this._type == Byte.TYPE || this._type == Byte.class) {
            if (n.doubleValue() > 127.0 || n.doubleValue() < -128.0) {
                throw new NumberFormatException();
            }
            if (!(n instanceof Byte)) {
                if (n.doubleValue() - (double)n.byteValue() > 0.0) {
                    throw new NumberFormatException();
                }
                n = new Byte(n.byteValue());
            }
        } else if (this._type == Short.TYPE || this._type == Short.class) {
            if (n.doubleValue() > 32767.0 || n.doubleValue() < -32768.0) {
                throw new NumberFormatException();
            }
            if (!(n instanceof Short)) {
                if (n.doubleValue() - (double)n.shortValue() > 0.0) {
                    throw new NumberFormatException();
                }
                n = new Short(n.shortValue());
            }
        } else if (this._type == Integer.TYPE || this._type == Integer.class) {
            if (n.doubleValue() > 2.147483647E9 || n.doubleValue() < -2.147483648E9) {
                throw new NumberFormatException();
            }
            if (!(n instanceof Integer)) {
                if (n.doubleValue() - (double)n.intValue() > 0.0) {
                    throw new NumberFormatException();
                }
                n = IntegerUtils.getInteger((int)n.intValue());
            }
        } else if (this._type == Long.TYPE || this._type == Long.class) {
            if (n.doubleValue() > 9.223372036854776E18 || n.doubleValue() < -9.223372036854776E18) {
                throw new NumberFormatException();
            }
            if (!(n instanceof Long)) {
                if (n.doubleValue() - (double)n.longValue() > 0.0) {
                    throw new NumberFormatException();
                }
                n = new Long(n.longValue());
            }
        } else if (this._type == Float.TYPE || this._type == Float.class) {
            if (Math.abs(n.doubleValue()) > 3.4028234663852886E38 || n.doubleValue() != 0.0 && Math.abs(n.doubleValue()) < (double)1.4E-45f) {
                throw new NumberFormatException();
            }
            if (!(n instanceof Float)) {
                n = new Float(n.floatValue());
            }
        } else if (this._type == Double.TYPE || this._type == Double.class) {
            if (Math.abs(n.doubleValue()) > Double.MAX_VALUE || n.doubleValue() != 0.0 && Math.abs(n.doubleValue()) < Double.MIN_VALUE) {
                throw new NumberFormatException();
            }
            if (!(n instanceof Double)) {
                n = new Double(n.doubleValue());
            }
        } else if (!(n instanceof Double)) {
            n = new Double(n.doubleValue());
        }
        return n;
    }

    private Number _parseNumber(Number num) {
        Number n = null;
        n = this._type == Byte.TYPE || this._type == Byte.class ? (Number)new Byte(num.byteValue()) : (Number)(this._type == Short.TYPE || this._type == Short.class ? (Number)new Short(num.shortValue()) : (Number)(this._type == Integer.TYPE || this._type == Integer.class ? (Number)IntegerUtils.getInteger((int)num.intValue()) : (Number)(this._type == Long.TYPE || this._type == Long.class ? (Number)new Long(num.longValue()) : (Number)(this._type == Float.TYPE || this._type == Float.class ? (Number)new Float(num.floatValue()) : (Number)(this._type == BigDecimal.class ? (Number)(num instanceof BigDecimal ? num : (num instanceof BigInteger ? new BigDecimal((BigInteger)num) : new BigDecimal(num.doubleValue()))) : (Number)(this._type == BigInteger.class ? (Number)(num instanceof BigInteger ? num : new BigInteger(num.toString())) : (Number)new Double(num.doubleValue())))))));
        return n;
    }

    private boolean _isDecimal(Class type) {
        return type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE || type == BigDecimal.class;
    }

    private boolean _isDataTypeEqual(Class type) {
        return !(this._type != type && (this._type != Byte.class && this._type != Byte.TYPE || type != Byte.class && type != Byte.TYPE) && (this._type != Short.class && this._type != Short.TYPE || type != Short.class && type != Short.TYPE) && (this._type != Integer.class && this._type != Integer.TYPE || type != Integer.class && type != Integer.TYPE) && (this._type != Long.class && this._type != Long.TYPE || type != Long.class && type != Long.TYPE) && (this._type != Float.class && this._type != Float.TYPE || type != Float.class && type != Float.TYPE) && (this._type != Double.class && this._type != Double.TYPE || type != Double.class && type != Double.TYPE));
    }

    private synchronized void _resetFormat() {
        this._oldFormat = this._format;
        this._format = null;
        this._getFormat();
    }

    private synchronized DecimalFormat _getFormat() {
        if (this._format == null) {
            char groupingSep;
            Method meth;
            String exponentSep;
            Number oldNumber = null;
            if (this._oldFormat != null) {
                try {
                    oldNumber = this._oldFormat.parse(this.getText());
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
            Locale loc = LocaleUtils.getDefaultableLocale((Component)this);
            this._format = (DecimalFormat)NumberFormat.getNumberInstance(loc);
            this._format.setGroupingUsed(this.isGroupingEnabled());
            this._format.setMaximumFractionDigits(this._decimalDigits);
            DecimalFormatSymbols symb = this._format.getDecimalFormatSymbols();
            char decimalSep = this.getDecimalSeparator();
            if (decimalSep != '\u0000') {
                symb.setDecimalSeparator(decimalSep);
            }
            if ((exponentSep = this.getExponentSeparator()) != null && !"".equals(exponentSep) && (meth = NumberTextField._setExponentMethod()) != null) {
                try {
                    meth.invoke((Object)symb, exponentSep);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((groupingSep = this.getGroupingSeparator()) != '\u0000') {
                symb.setGroupingSeparator(groupingSep);
            }
            this._format.setDecimalFormatSymbols(symb);
            if (oldNumber != null) {
                this.setNumber(oldNumber);
            }
        }
        return this._format;
    }

    private boolean _validateNumericPart(String oldText, String num, int offset, boolean isDecimal, boolean isSigned, boolean isGroupingEnabled) {
        int index;
        DecimalFormatSymbols symbols = this._getFormat().getDecimalFormatSymbols();
        char minus = symbols.getMinusSign();
        char decimal = symbols.getDecimalSeparator();
        char groupSepChar = symbols.getGroupingSeparator();
        StringBuffer buff = new StringBuffer(oldText);
        buff.insert(offset, num);
        String text = buff.toString();
        int minusIndex = oldText.indexOf(minus);
        int plusIndex = oldText.indexOf(43);
        int groupSepEndIndex = -1;
        int lastGroupSepCharIndex = -1;
        if (isGroupingEnabled) {
            groupSepEndIndex = text.length();
            int firstDecimalIndex = text.indexOf(decimal);
            if (firstDecimalIndex != -1) {
                groupSepEndIndex = firstDecimalIndex;
            }
            lastGroupSepCharIndex = text.lastIndexOf(groupSepChar);
        }
        int location = 0;
        for (int i = 0; i < num.length(); ++i) {
            location = offset + i;
            char c = num.charAt(i);
            if (c >= '0' && c <= '9') {
                if (location != 0 || !isSigned || minusIndex < 0 && plusIndex < 0) continue;
                return false;
            }
            if (c == minus || c == '+') {
                if (isSigned && location == 0 && minusIndex < 0 && plusIndex < 0) continue;
                return false;
            }
            if (c == decimal && isDecimal) {
                int decimalIndex = oldText.indexOf(decimal);
                if (decimalIndex >= 0) {
                    return false;
                }
                if (isSigned && location == 0 && (minusIndex >= 0 || plusIndex >= 0)) {
                    return false;
                }
                if (!isGroupingEnabled || location > lastGroupSepCharIndex) continue;
                return false;
            }
            if (c == groupSepChar && isGroupingEnabled) {
                if (isSigned && location == 0 && (minusIndex >= 0 || plusIndex >= 0)) {
                    return false;
                }
                if (location <= groupSepEndIndex && (location - 1 < 0 || text.charAt(location - 1) != groupSepChar) && (location + 2 > text.length() || text.charAt(location + 1) != groupSepChar)) continue;
                return false;
            }
            return false;
        }
        if (isGroupingEnabled && (text.startsWith(String.valueOf(groupSepChar)) || text.startsWith(String.valueOf('+') + groupSepChar) || text.startsWith(String.valueOf(minus) + groupSepChar))) {
            return false;
        }
        if (isDecimal && oldText != null && (index = oldText.indexOf(decimal)) != -1) {
            int maxDigits = this._getFormat().getMaximumFractionDigits();
            if (oldText.length() - index - 1 > maxDigits) {
                return false;
            }
        }
        return true;
    }

    private boolean _validateNumberString(String oldText, String num, int offset) {
        DecimalFormatSymbols symbols = this._getFormat().getDecimalFormatSymbols();
        int endOffset = offset + num.length();
        char minus = symbols.getMinusSign();
        char decimal = symbols.getDecimalSeparator();
        String sNotation = null;
        Method meth = NumberTextField._sGetExponentMethod();
        if (meth != null) {
            try {
                sNotation = (String)meth.invoke((Object)symbols, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (sNotation == null) {
            sNotation = _EXPONENT_STRING;
        }
        if (this.getDataType() == BigDecimal.class) {
            sNotation = _EXPONENT_STRING;
        }
        String scienCharSeq = null;
        int posStartScien = -1;
        int posEndScien = -1;
        StringBuffer buff = new StringBuffer(oldText);
        buff.insert(offset, num);
        if (!this.isScientific()) {
            if (!this._validateNumericPart(oldText, num, offset, this.isDecimal(), this.isSigned(), this.isGroupingEnabled())) {
                return false;
            }
        } else {
            posStartScien = buff.toString().indexOf(sNotation.charAt(0));
            if (posStartScien == -1) {
                if (!this._validateNumericPart(oldText, num, offset, this.isDecimal(), this.isSigned(), this.isGroupingEnabled())) {
                    return false;
                }
            } else {
                if (num.length() > 0 && this._posStartScien != -1 && (offset > this._posStartScien && offset < this._posStartScien + this._validScienNotation.length() || offset < this._posStartScien && num.indexOf(sNotation.charAt(0)) != -1)) {
                    return false;
                }
                if (offset <= oldText.indexOf(decimal) && num.indexOf(sNotation.charAt(0)) != -1) {
                    return false;
                }
                for (posEndScien = posStartScien + 1; posEndScien < buff.length() && sNotation.indexOf(buff.charAt(posEndScien)) != -1; ++posEndScien) {
                }
                scienCharSeq = buff.substring(posStartScien, posEndScien);
                if (!sNotation.startsWith(scienCharSeq)) {
                    return false;
                }
                int leftPartLOffset = Math.min(offset, posStartScien);
                int leftPartROffset = Math.min(endOffset, posStartScien);
                if (leftPartROffset > leftPartLOffset) {
                    StringBuffer leftPart = new StringBuffer(buff.substring(0, posStartScien));
                    String numLeftPart = buff.substring(leftPartLOffset, leftPartROffset);
                    leftPart.delete(leftPartLOffset, leftPartROffset);
                    if (!this._validateNumericPart(leftPart.toString(), numLeftPart, leftPartLOffset, true, this.isSigned(), this.isGroupingEnabled())) {
                        return false;
                    }
                }
                int rightPartLOffset = Math.max(offset, posEndScien);
                int rightPartROffset = Math.max(endOffset, posEndScien);
                if (rightPartROffset > rightPartLOffset) {
                    StringBuffer rightPart = new StringBuffer(buff.substring(posEndScien, buff.length()));
                    String numRightPart = buff.substring(rightPartLOffset, rightPartROffset);
                    rightPart.delete(rightPartLOffset - posEndScien, rightPartROffset - posEndScien);
                    if (!this._validateNumericPart(rightPart.toString(), numRightPart, rightPartLOffset - posEndScien, false, true, false)) {
                        return false;
                    }
                }
            }
        }
        Number n = null;
        String newString = buff.toString();
        try {
            n = this._getNumber(newString);
        }
        catch (NumberFormatException nfe) {
            return newString.equals(String.valueOf('+')) || newString.equals(String.valueOf(minus)) || newString.equals(String.valueOf(decimal)) || newString.equals(String.valueOf('+') + decimal) || newString.equals(String.valueOf(minus) + decimal);
        }
        if (this.validateNumber(n)) {
            if (this.isScientific()) {
                this._posStartScien = posStartScien;
                this._validScienNotation = scienCharSeq;
                this._prevValidtext = this._posStartScien == -1 || this._validScienNotation.equals(sNotation) ? newString : newString.substring(0, this._posStartScien);
            }
            return true;
        }
        return false;
    }

    private void _invalidateScientific() {
        this._prevValidtext = "";
        this._posStartScien = -1;
    }

    static {
        _DEFAULT_CLASS = Integer.class;
    }

    private class NumberTextFieldDocumentFilter
    extends DocumentFilter {
        private NumberTextFieldDocumentFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || str.length() == 0) {
                return;
            }
            if (!NumberTextField.this._validateNumberString(NumberTextField.this.getText(), str, offs)) {
                throw new BadLocationException(null, offs);
            }
            super.insertString(fb, offs, str, a);
        }

        public void remove(DocumentFilter.FilterBypass fb, int offs, int len) throws BadLocationException {
            if (len == 0) {
                return;
            }
            StringBuffer text = new StringBuffer(NumberTextField.this.getText());
            text.delete(offs, offs + len);
            if (text.length() > 0 && !NumberTextField.this._validateNumberString(text.toString(), "", offs)) {
                throw new BadLocationException(null, offs);
            }
            if (NumberTextField.this.isScientific() && text.length() == 0) {
                NumberTextField.this._invalidateScientific();
            }
            super.remove(fb, offs, len);
        }

        public void replace(DocumentFilter.FilterBypass fb, int offs, int len, String str, AttributeSet a) throws BadLocationException {
            if (len == 0 && (str == null || str.length() == 0)) {
                return;
            }
            StringBuffer text = new StringBuffer(NumberTextField.this.getText());
            text.delete(offs, offs + len);
            if (NumberTextField.this.isScientific()) {
                if (text.length() > 0 && !NumberTextField.this._validateNumberString(text.toString(), "", offs)) {
                    return;
                }
                if (text.length() == 0) {
                    NumberTextField.this._invalidateScientific();
                }
            }
            if (str == null) {
                str = "";
            }
            if (!(text.length() <= 0 && str.length() <= 0 || NumberTextField.this._validateNumberString(text.toString(), str, offs))) {
                throw new BadLocationException(null, offs);
            }
            if (NumberTextField.this.isScientific() && text.length() == 0 && str.length() == 0) {
                NumberTextField.this._invalidateScientific();
            }
            super.replace(fb, offs, len, str, a);
        }
    }

    public class AccessibleNumberTextField
    extends JTextComponent.AccessibleJTextComponent
    implements AccessibleValue {
        public AccessibleNumberTextField() {
            super(NumberTextField.this);
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return NumberTextField.this.getNumber();
        }

        public boolean setCurrentAccessibleValue(Number n) {
            if (NumberTextField.this.validateNumber(n)) {
                NumberTextField.this.setNumber(n);
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            states.add(AccessibleState.SINGLE_LINE);
            return states;
        }
    }
}

