/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.text.Collator;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ShuttleDnDSupport;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;

public class ListPicker
implements ItemPicker,
ShuttleDnDSupport.ItemPickerDnD {
    private JList _list;
    private ActionListener _actionListener;
    private PropertyChangeSupport _changeSupport;
    private boolean _sort;
    private JScrollPane _pane;
    private int _lastListSize;
    private Handler _handler;
    private int _dropInsertionIndex = -1;
    private int _dropFeedBackIndex = -1;

    public ListPicker(JList list) {
        if (null == list) {
            throw new IllegalArgumentException();
        }
        this._pane = new JScrollPane(list){

            public boolean isFocusTraversable() {
                return false;
            }

            public JViewport createViewport() {
                return new JViewport(){

                    public boolean isFocusTraversable() {
                        return false;
                    }
                };
            }
        };
        FocusUtils.setFocusable(this._pane.getVerticalScrollBar(), false);
        FocusUtils.setFocusable(this._pane.getHorizontalScrollBar(), false);
        this._list = list;
        this._list.setAutoscrolls(false);
        this._handler = new Handler();
        this._checkAndResetListModel();
        list.getSelectionModel().addListSelectionListener(this._handler);
        list.addMouseListener(this._handler);
        list.addFocusListener(this._handler);
        if (this.getItemsSorted()) {
            this.sortItems();
        }
        this._updateLastListSize();
        this._list.getModel().addListDataListener(this._handler);
        this._list.addPropertyChangeListener(this._handler);
        this._list.addKeyListener(this._handler);
    }

    public void dispose() {
        if (this._list == null) {
            return;
        }
        this._pane.setViewportView(null);
        this._pane = null;
        this._list.getSelectionModel().removeListSelectionListener(this._handler);
        this._list.removeMouseListener(this._handler);
        this._list.getModel().removeListDataListener(this._handler);
        this._list.removeFocusListener(this._handler);
        this._list.removeKeyListener(this._handler);
        this._list.removePropertyChangeListener(this._handler);
        this._handler = null;
        this._actionListener = null;
        this._changeSupport = null;
        this._list = null;
    }

    public boolean getItemsSorted() {
        return this._sort;
    }

    public void setItemsSorted(boolean sort) {
        if (sort != this._sort) {
            this._sort = sort;
            if (sort) {
                this.sortItems();
            }
        }
    }

    public JList getList() {
        return this._list;
    }

    public boolean isSelectableItemPresent() {
        return this._list.getModel().getSize() > 0;
    }

    public boolean isItemSelected() {
        return !this._list.isSelectionEmpty() && this.isSelectableItemPresent();
    }

    public void deselectAll() {
        this._list.clearSelection();
    }

    public void removeSelectedItems() {
        ListModel model = this._list.getModel();
        if (!(model instanceof DefaultListModel)) {
            return;
        }
        DefaultListModel dModel = (DefaultListModel)model;
        ListSelectionModel sModel = this._list.getSelectionModel();
        int[] selection = this._list.getSelectedIndices();
        int i = selection.length;
        this._list.setModel(new DefaultListModel());
        --i;
        while (i >= 0) {
            dModel.remove(selection[i]);
            --i;
        }
        this._list.setModel(dModel);
        int modelSize = dModel.getSize();
        int selLen = selection.length;
        if (modelSize > 0 && selLen > 0) {
            int highlight = selection[selLen - 1] - (selLen - 1);
            if (highlight >= modelSize) {
                highlight = modelSize - 1;
            }
            sModel.setSelectionInterval(highlight, highlight);
            this._list.ensureIndexIsVisible(highlight);
        }
    }

    public void removeAllSelectableItems() {
        ListModel model = this._list.getModel();
        if (!(model instanceof DefaultListModel)) {
            return;
        }
        DefaultListModel dModel = (DefaultListModel)model;
        dModel.removeAllElements();
    }

    public Transferable[] getSelectedItems() {
        Object[] selected = this._list.getSelectedValues();
        if (selected != null) {
            int count = selected.length;
            Transferable[] transferItems = new Transferable[count];
            for (int i = 0; i < count; ++i) {
                transferItems[i] = this.createTransferable(selected[i]);
            }
            return transferItems;
        }
        return null;
    }

    public Transferable[] getAllSelectableItems() {
        Object[] selected = this._getItems();
        if (selected != null) {
            int count = selected.length;
            Transferable[] transferItems = new Transferable[count];
            for (int i = 0; i < count; ++i) {
                transferItems[i] = this.createTransferable(selected[i]);
            }
            return transferItems;
        }
        return null;
    }

    public Component getComponent() {
        return this._pane;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        return null;
    }

    public void addActionListener(ActionListener listener) {
        this._actionListener = AWTEventMulticaster.add(this._actionListener, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this._actionListener = AWTEventMulticaster.remove(this._actionListener, listener);
        if (this._actionListener == null) {
            this._list.removeMouseListener(this._handler);
        }
    }

    public boolean addSelectedItems(Transferable[] selectedItems) {
        return this._insertItems(selectedItems);
    }

    public boolean canAcceptFlavors(DataFlavor[] flavors) {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(listener);
        }
    }

    public Component getDnDComponent() {
        return this.getList();
    }

    public boolean isOkayToDrag(Point loc) {
        JList list = this.getList();
        int index = list.locationToIndex(loc);
        return index != -1 && list.getCellBounds(index, index).contains(loc);
    }

    public boolean isOkayToDrop(Point location) {
        return true;
    }

    public void dragEnter(Point loc, boolean status) {
        this._drawDropFeedBack(!status, loc);
    }

    public void dragOver(Point loc, boolean status) {
        this._drawDropFeedBack(!status, loc);
    }

    public void dragExit() {
        this._drawDropFeedBack(true, null);
    }

    public void dropActionChanged(Point loc, boolean status) {
        this._drawDropFeedBack(!status, loc);
    }

    public void processDnDReorder() {
        this._dropInsertionIndex = -1;
    }

    public void drop(Point loc, boolean status) {
        JList list;
        int index;
        this._drawDropFeedBack(true, loc);
        if (status && (index = (list = this.getList()).locationToIndex(loc)) != -1 && list.getCellBounds(index, index).contains(loc)) {
            this._dropInsertionIndex = index;
        }
    }

    protected Transferable createTransferable(Object transferred) {
        return ObjectTransferable.createTransferable((Object)transferred);
    }

    protected synchronized void sortItems() {
        int i;
        ListModel model = this._list.getModel();
        if (!(model instanceof DefaultListModel)) {
            return;
        }
        Object[] items = this._getItems();
        int[] indexes = Sort.indirectQSort((Object[])items, (int)items.length, (Comparator)this.getComparator());
        DefaultListModel dModel = (DefaultListModel)model;
        int[] selIndexes = this._list.getSelectedIndices();
        this._list.setModel(new DefaultListModel());
        this._list.setSelectionModel(new DefaultListSelectionModel());
        dModel.removeAllElements();
        ListSelectionModel selModel = this._list.getSelectionModel();
        for (i = 0; i < indexes.length; ++i) {
            dModel.addElement(items[indexes[i]]);
        }
        this._list.setModel(dModel);
        selModel.clearSelection();
        block1: for (i = 0; i < selIndexes.length; ++i) {
            for (int j = 0; j < indexes.length; ++j) {
                if (selIndexes[i] != indexes[j]) continue;
                selModel.addSelectionInterval(j, j);
                continue block1;
            }
        }
        this._list.ensureIndexIsVisible(selModel.getMaxSelectionIndex());
        this._list.setSelectionModel(selModel);
    }

    protected Comparator getComparator() {
        Collator collator = Collator.getInstance(LocaleUtils.getDefaultableLocale((Component)this.getList()));
        return new StringComparator(collator);
    }

    void __selectItem(int index) {
        JList list = this.getList();
        int size = list.getModel().getSize();
        if (index >= 0 && index < size) {
            list.setSelectedIndex(index);
        }
    }

    int __getDropInsertionIndex() {
        return this._dropInsertionIndex;
    }

    void __resetDropInsertionIndex() {
        this._dropInsertionIndex = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _drawDropFeedBack(boolean erase, Point loc) {
        Graphics g;
        JList list = this.getList();
        int count = list.getModel().getSize();
        int newIndex = -1;
        if (!erase && loc != null) {
            newIndex = list.locationToIndex(loc);
            if (newIndex < 0 || newIndex >= count) {
                newIndex = count;
            } else {
                Rectangle bounds = list.getCellBounds(newIndex, newIndex);
                if (!bounds.contains(loc)) {
                    newIndex = count;
                }
            }
        }
        if (newIndex == this._dropFeedBackIndex) {
            return;
        }
        if (this._dropFeedBackIndex != -1) {
            Rectangle area = this._getFeedBackArea(this._dropFeedBackIndex);
            list.paintImmediately(area.x, area.y, area.width, area.height);
        }
        if (newIndex != -1 && (g = list.getGraphics()) != null) {
            try {
                Rectangle visibleRect = list.getVisibleRect();
                g.clipRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
                Rectangle area = this._getFeedBackArea(newIndex);
                g.setColor(Color.black);
                g.fillRect(area.x, area.y, area.width, area.height);
            }
            finally {
                g.dispose();
            }
        }
        this._dropFeedBackIndex = newIndex;
    }

    private Rectangle _getFeedBackArea(int index) {
        Rectangle drawArea;
        JList list = this.getList();
        int count = list.getModel().getSize();
        if (count == 0) {
            Insets inset = list.getInsets();
            int width = list.getWidth() - inset.left - inset.right;
            drawArea = new Rectangle(inset.left, inset.top, width, 2);
        } else {
            if (index >= count) {
                drawArea = list.getCellBounds(count - 1, count - 1);
                drawArea.y += drawArea.height - 1;
            } else {
                drawArea = list.getCellBounds(index, index);
            }
            drawArea.height = 2;
        }
        return drawArea;
    }

    private boolean _insertItems(Transferable[] items) {
        ListModel model = this._list.getModel();
        if (!(model instanceof DefaultListModel)) {
            return false;
        }
        if (!this._checkFlavorCompatibility(items)) {
            return false;
        }
        int numSelected = items.length;
        DefaultListModel dModel = (DefaultListModel)model;
        ListSelectionModel sModel = this._list.getSelectionModel();
        this._list.setSelectionModel(new DefaultListSelectionModel());
        this._list.setModel(new DefaultListModel());
        if (this._dropInsertionIndex == -1) {
            this._dropInsertionIndex = dModel.getSize();
        }
        int addIndex = this._dropInsertionIndex;
        sModel.clearSelection();
        for (int i = numSelected - 1; i >= 0; --i) {
            Transferable currItem = items[i];
            DataFlavor[] flavors = currItem.getTransferDataFlavors();
            if (flavors == null || flavors.length < 1) {
                return false;
            }
            Object incoming = null;
            try {
                incoming = currItem.getTransferData(flavors[0]);
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            dModel.add(this._dropInsertionIndex, incoming);
            sModel.addSelectionInterval(addIndex, addIndex);
            ++addIndex;
        }
        this._list.setModel(dModel);
        this._list.setSelectionModel(sModel);
        this._list.ensureIndexIsVisible(this._dropInsertionIndex);
        this._list.ensureIndexIsVisible(addIndex - 1);
        this._dropInsertionIndex = -1;
        if (this.getItemsSorted()) {
            this.sortItems();
        }
        return true;
    }

    private boolean _checkFlavorCompatibility(Transferable[] items) {
        if (items == null) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            Transferable current = items[i];
            if (current == null || this.canAcceptFlavors(current.getTransferDataFlavors())) continue;
            return false;
        }
        return true;
    }

    private Object[] _getItems() {
        ListModel model = this._list.getModel();
        int modelSize = model.getSize();
        Object[] selected = new Object[modelSize];
        if (model instanceof DefaultListModel) {
            DefaultListModel dModel = (DefaultListModel)model;
            dModel.copyInto(selected);
        } else {
            for (int i = 0; i < modelSize; ++i) {
                selected[i] = model.getElementAt(i);
            }
        }
        return selected;
    }

    private boolean _checkAndResetListModel() {
        ListModel model = this._list.getModel();
        if (model instanceof DefaultListModel) {
            return false;
        }
        int oldSize = model.getSize();
        DefaultListModel newModel = new DefaultListModel();
        for (int i = 0; i < oldSize; ++i) {
            newModel.add(i, model.getElementAt(i));
        }
        this._list.setModel(newModel);
        return true;
    }

    private void _firePropertyChange(String property, Object oldvalue, Object newValue) {
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(property, oldvalue, newValue);
        }
    }

    private void _checkItemCount() {
        if (this._changeSupport == null) {
            return;
        }
        int newSize = this._list.getModel().getSize();
        if (newSize > 0 && this._lastListSize == 0 || newSize == 0 && this._lastListSize > 0) {
            this._changeSupport.firePropertyChange("selection", Boolean.TRUE, Boolean.FALSE);
        }
        this._updateLastListSize();
    }

    private void _updateLastListSize() {
        this._lastListSize = this._list.getModel().getSize();
    }

    private class Handler
    extends MouseAdapter
    implements ListSelectionListener,
    ListDataListener,
    PropertyChangeListener,
    FocusListener,
    KeyListener {
        private Handler() {
        }

        public void valueChanged(ListSelectionEvent event) {
            ListPicker.this._firePropertyChange("selection", null, null);
        }

        public void intervalAdded(ListDataEvent e) {
            ListPicker.this._checkItemCount();
        }

        public void intervalRemoved(ListDataEvent e) {
            ListPicker.this._checkItemCount();
        }

        public void contentsChanged(ListDataEvent e) {
            ListPicker.this._checkItemCount();
        }

        public void mouseClicked(MouseEvent e) {
            int item;
            if (e.getClickCount() % 2 == 0 && SwingUtilities.isLeftMouseButton(e) && (item = ListPicker.this._list.locationToIndex(e.getPoint())) != -1) {
                ListPicker.this._actionListener.actionPerformed(new ActionEvent(ListPicker.this, e.getID(), null, e.getModifiers()));
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 && e.getModifiers() == 0 && ListPicker.this._list.getSelectedIndex() != -1 && ListPicker.this._actionListener != null) {
                e.consume();
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10 && e.getModifiers() == 0 && ListPicker.this._list.getSelectedIndex() != -1 && ListPicker.this._actionListener != null && ListPicker.this._list.getModel().getSize() > 0) {
                ListPicker.this._actionListener.actionPerformed(new ActionEvent(ListPicker.this, 1001, null));
                e.consume();
            }
        }

        public void keyTyped(KeyEvent e) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("selectionModel".equals(name)) {
                Object newValue;
                Object oldValue = evt.getOldValue();
                if (oldValue instanceof ListSelectionModel) {
                    ((ListSelectionModel)oldValue).removeListSelectionListener(this);
                }
                if ((newValue = evt.getNewValue()) instanceof ListSelectionModel) {
                    ((ListSelectionModel)newValue).addListSelectionListener(this);
                }
            } else if ("model".equals(name)) {
                Object newValue;
                Object oldValue = evt.getOldValue();
                if (oldValue instanceof ListModel) {
                    ((ListModel)oldValue).removeListDataListener(ListPicker.this._handler);
                }
                if ((newValue = evt.getNewValue()) instanceof ListModel) {
                    ((ListModel)newValue).addListDataListener(ListPicker.this._handler);
                }
                ListPicker.this._updateLastListSize();
                if (!ListPicker.this._checkAndResetListModel()) {
                    ListPicker.this._firePropertyChange("selection", null, null);
                }
            }
        }

        public void focusGained(FocusEvent e) {
            if (ListPicker.this._list.getSelectedIndex() == -1 && (ListPicker.this._list.getSelectionModel().getAnchorSelectionIndex() == -1 || ListPicker.this._list.getSelectionModel().getLeadSelectionIndex() == -1) && ListPicker.this._list.getModel().getSize() != 0) {
                ListPicker.this._list.getSelectionModel().setAnchorSelectionIndex(0);
                ListPicker.this._list.getSelectionModel().setLeadSelectionIndex(0);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

