/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.selection;

import java.util.Vector;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;

public class TwoDSelection {
    private OneDSelection _columnSelection;
    private OneDSelection _rowSelection;
    private CellRange[] _cellRanges;
    private static TwoDSelection _emptySelection;
    private static CellRangeComparator _cellRangeComparator;

    public TwoDSelection() {
    }

    public TwoDSelection(int index, boolean row) {
        OneDSelection part = new OneDSelection(index);
        this._init(row ? null : part, row ? part : null, null);
    }

    public TwoDSelection(OneDSelection columnSelection, OneDSelection rowSelection) {
        this._init(columnSelection, rowSelection, null);
    }

    public TwoDSelection(OneDSelection columnSelection, OneDSelection rowSelection, CellRange[] cellRanges) {
        this._init(columnSelection, rowSelection, cellRanges);
    }

    public TwoDSelection(Cell cell) {
        this(null, null, cell.column, cell.row);
    }

    public TwoDSelection(int column, int row) {
        this(null, null, column, row);
    }

    public TwoDSelection(OneDSelection columnSelection, OneDSelection rowSelection, CellRange cellRange) {
        this(columnSelection, rowSelection, cellRange.getLowerLimit(), cellRange.getUpperLimit());
    }

    public TwoDSelection(OneDSelection columnSelection, OneDSelection rowSelection, Cell cell) {
        this(columnSelection, rowSelection, cell.column, cell.row, cell.column, cell.row);
    }

    public TwoDSelection(OneDSelection columnSelection, OneDSelection rowSelection, Cell cell1, Cell cell2) {
        this(columnSelection, rowSelection, cell1.column, cell1.row, cell2.column, cell2.row);
    }

    public TwoDSelection(OneDSelection columnSelection, OneDSelection rowSelection, int column, int row) {
        this(columnSelection, rowSelection, column, row, column, row);
    }

    public TwoDSelection(OneDSelection columnSelection, OneDSelection rowSelection, int column1, int row1, int column2, int row2) {
        CellRange[] cellRanges = new CellRange[1];
        Cell cell1 = new Cell(column1, row1);
        Cell cell2 = new Cell(column2, row2);
        cellRanges[0] = new CellRange(cell1, cell2);
        this._init(columnSelection, rowSelection, cellRanges);
    }

    public CellRange[] getCellRanges() {
        return this._cellRanges;
    }

    public OneDSelection getColumnSelection() {
        if (this._columnSelection == null) {
            return OneDSelection.getEmptySelection();
        }
        return this._columnSelection;
    }

    public OneDSelection getRowSelection() {
        if (this._rowSelection == null) {
            return OneDSelection.getEmptySelection();
        }
        return this._rowSelection;
    }

    public final Cell getSingleCell() {
        CellRange[] cr = this.getCellRanges();
        if (cr != null && cr.length > 0) {
            Cell cl = cr[0].getLowerLimit();
            return new Cell(cl.column, cl.row);
        }
        return null;
    }

    public final int getSingleRow() {
        return this.getRowSelection().getSingleItem();
    }

    public final int getSingleColumn() {
        return this.getColumnSelection().getSingleItem();
    }

    public TwoDSelection add(TwoDSelection sel) {
        CellRange[] cellRangesResult = CellRange.addCellRanges(this.getCellRanges(), sel.getCellRanges());
        OneDSelection columnSel = this.getColumnSelection().add(sel.getColumnSelection());
        OneDSelection rowSel = this.getRowSelection().add(sel.getRowSelection());
        return new TwoDSelection(columnSel, rowSel, cellRangesResult);
    }

    public TwoDSelection subtract(TwoDSelection sel) {
        CellRange[] cellRangesResult = CellRange.subtractCellRanges(this.getCellRanges(), sel.getCellRanges());
        OneDSelection columnSel = this.getColumnSelection().subtract(sel.getColumnSelection());
        OneDSelection rowSel = this.getRowSelection().subtract(sel.getRowSelection());
        return new TwoDSelection(columnSel, rowSel, cellRangesResult);
    }

    public TwoDSelection addColumns(int start, int number) {
        OneDSelection colsel = this.getColumnSelection().addItems(start, number);
        OneDSelection rowsel = this.getRowSelection();
        CellRange[] ranges = this.getCellRanges();
        Object[] endResult = null;
        if (ranges != null && ranges.length > 0) {
            Vector<CellRange> result = new Vector<CellRange>();
            for (int i = 0; i < ranges.length; ++i) {
                int row1 = ranges[i].getLowerLimit().row;
                int row2 = ranges[i].getUpperLimit().row;
                int min = ranges[i].getLowerLimit().column;
                int max = ranges[i].getUpperLimit().column;
                if (start <= min) {
                    result.addElement(new CellRange(min + number, row1, max + number, row2));
                    continue;
                }
                if (start > max) {
                    result.addElement(new CellRange(min, row1, max, row2));
                    continue;
                }
                result.addElement(new CellRange(min, row1, start - 1, row2));
                result.addElement(new CellRange(start + number, row1, max + number, row2));
            }
            endResult = new CellRange[result.size()];
            result.copyInto(endResult);
        }
        return new TwoDSelection(colsel, rowsel, (CellRange[])endResult);
    }

    public TwoDSelection removeColumns(int start, int number) {
        OneDSelection colsel = this.getColumnSelection().removeItems(start, number);
        OneDSelection rowsel = this.getRowSelection();
        CellRange[] ranges = this.getCellRanges();
        Object[] endResult = null;
        if (ranges != null && ranges.length > 0) {
            Vector<CellRange> result = new Vector<CellRange>();
            for (int i = 0; i < ranges.length; ++i) {
                int row1 = ranges[i].getLowerLimit().row;
                int row2 = ranges[i].getUpperLimit().row;
                int min = ranges[i].getLowerLimit().column;
                int max = ranges[i].getUpperLimit().column;
                if (start + number <= min) {
                    result.addElement(new CellRange(min - number, row1, max - number, row2));
                    continue;
                }
                if (start > max) {
                    result.addElement(new CellRange(min, row1, max, row2));
                    continue;
                }
                if (start <= min && start + number - 1 >= max) continue;
                if (start > min && start + number - 1 < max) {
                    result.addElement(new CellRange(min, row1, start - 1, row2));
                    result.addElement(new CellRange(start, row1, max - number, row2));
                    continue;
                }
                if (start > min) {
                    result.addElement(new CellRange(min, row1, start - 1, row2));
                    continue;
                }
                if (start + number - 1 >= max) continue;
                result.addElement(new CellRange(start, row1, max - number, row2));
            }
            endResult = new CellRange[result.size()];
            result.copyInto(endResult);
        }
        return new TwoDSelection(colsel, rowsel, (CellRange[])endResult);
    }

    public TwoDSelection addRows(int start, int number) {
        OneDSelection colsel = this.getColumnSelection();
        OneDSelection rowsel = this.getRowSelection().addItems(start, number);
        CellRange[] ranges = this.getCellRanges();
        Object[] endResult = null;
        if (ranges != null && ranges.length > 0) {
            Vector<CellRange> result = new Vector<CellRange>();
            for (int i = 0; i < ranges.length; ++i) {
                int col1 = ranges[i].getLowerLimit().column;
                int col2 = ranges[i].getUpperLimit().column;
                int min = ranges[i].getLowerLimit().row;
                int max = ranges[i].getUpperLimit().row;
                if (start <= min) {
                    result.addElement(new CellRange(col1, min + number, col2, max + number));
                    continue;
                }
                if (start > max) {
                    result.addElement(new CellRange(col1, min, col2, max));
                    continue;
                }
                result.addElement(new CellRange(col1, min, col2, start - 1));
                result.addElement(new CellRange(col1, start + number, col2, max + number));
            }
            endResult = new CellRange[result.size()];
            result.copyInto(endResult);
        }
        return new TwoDSelection(colsel, rowsel, (CellRange[])endResult);
    }

    public TwoDSelection removeRows(int start, int number) {
        OneDSelection colsel = this.getColumnSelection();
        OneDSelection rowsel = this.getRowSelection().removeItems(start, number);
        CellRange[] ranges = this.getCellRanges();
        Object[] endResult = null;
        if (ranges != null && ranges.length > 0) {
            Vector<CellRange> result = new Vector<CellRange>();
            for (int i = 0; i < ranges.length; ++i) {
                int col1 = ranges[i].getLowerLimit().column;
                int col2 = ranges[i].getUpperLimit().column;
                int min = ranges[i].getLowerLimit().row;
                int max = ranges[i].getUpperLimit().row;
                if (start + number <= min) {
                    result.addElement(new CellRange(col1, min - number, col2, max - number));
                    continue;
                }
                if (start > max) {
                    result.addElement(new CellRange(col1, min, col2, max));
                    continue;
                }
                if (start <= min && start + number - 1 >= max) continue;
                if (start > min && start + number - 1 < max) {
                    result.addElement(new CellRange(col1, min, col2, start - 1));
                    result.addElement(new CellRange(col1, start, col2, max - number));
                    continue;
                }
                if (start > min) {
                    result.addElement(new CellRange(col1, min, col2, start - 1));
                    continue;
                }
                if (start + number - 1 >= max) continue;
                result.addElement(new CellRange(col1, start, col2, max - number));
            }
            endResult = new CellRange[result.size()];
            result.copyInto(endResult);
        }
        return new TwoDSelection(colsel, rowsel, (CellRange[])endResult);
    }

    public boolean contains(TwoDSelection sel) {
        return CellRange.cellRangesContain(this.getCellRanges(), sel.getCellRanges()) && this.getColumnSelection().contains(sel.getColumnSelection()) && this.getRowSelection().contains(sel.getRowSelection());
    }

    public boolean containsCell(Cell cell) {
        return this.containsCell(cell.column, cell.row);
    }

    public boolean containsCell(int column, int row) {
        return CellRange.cellRangesContain(this.getCellRanges(), column, row) || this.containsRow(row) || this.containsColumn(column);
    }

    public boolean containsRow(int row) {
        return this.getRowSelection().contains(row);
    }

    public boolean containsColumn(int column) {
        return this.getColumnSelection().contains(column);
    }

    public boolean isEmpty() {
        return (this._cellRanges == null || this._cellRanges.length == 0) && this.getColumnSelection().isEmpty() && this.getRowSelection().isEmpty();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TwoDSelection)) {
            return false;
        }
        TwoDSelection a = this.subtract((TwoDSelection)other);
        TwoDSelection b = ((TwoDSelection)other).subtract(this);
        return a.isEmpty() && b.isEmpty();
    }

    public int getSelectedCellCount() {
        CellRange[] ranges = this.getCellRanges();
        if (ranges == null) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < ranges.length; ++i) {
            Cell upper = ranges[i].getUpperLimit();
            Cell lower = ranges[i].getLowerLimit();
            total += (upper.column - lower.column + 1) * (upper.row - lower.row + 1);
        }
        return total;
    }

    public Cell getSelectedCellAtIndex(int index) {
        CellRange[] ranges = this.getCellRanges();
        if (ranges == null) {
            return null;
        }
        int total = 0;
        for (int i = 0; i < ranges.length; ++i) {
            Cell upper = ranges[i].getUpperLimit();
            Cell lower = ranges[i].getLowerLimit();
            int columns = upper.column - lower.column + 1;
            int rows = upper.row - lower.row + 1;
            if (total + columns * rows >= index + 1) {
                return new Cell(lower.column + (index - total) % columns, lower.row + (index - total) / columns);
            }
            total += columns * rows;
        }
        return null;
    }

    public String toString() {
        CellRange[] cr;
        OneDSelection rowSel;
        StringBuffer result = new StringBuffer();
        result.append("[");
        boolean addcomma = false;
        OneDSelection columnSel = this.getColumnSelection();
        if (!columnSel.isEmpty()) {
            result.append("columns = " + columnSel);
            addcomma = true;
        }
        if (!(rowSel = this.getRowSelection()).isEmpty()) {
            if (addcomma) {
                result.append(", ");
            }
            result.append("rows = " + rowSel);
            addcomma = true;
        }
        if ((cr = this.getCellRanges()) != null && cr.length > 0) {
            if (addcomma) {
                result.append(", ");
            }
            addcomma = true;
            result.append("cells = [");
            for (int i = 0; i < cr.length; ++i) {
                CellRange r = cr[i];
                result.append("[" + r.getLowerLimit() + ", " + r.getUpperLimit() + "]");
                if (i == cr.length - 1) continue;
                result.append(",");
            }
            result.append("]");
        }
        result.append("]");
        return result.toString();
    }

    public static final TwoDSelection getEmptySelection() {
        if (_emptySelection == null) {
            _emptySelection = new TwoDSelection();
        }
        return _emptySelection;
    }

    private void _setCellRanges(CellRange[] ranges) {
        this._cellRanges = ranges;
    }

    private void _setColumnSelection(OneDSelection columnSelection) {
        this._columnSelection = columnSelection;
    }

    private void _setRowSelection(OneDSelection rowSelection) {
        this._rowSelection = rowSelection;
    }

    private void _init(OneDSelection columnSelection, OneDSelection rowSelection, CellRange[] cellRanges) {
        this._setColumnSelection(columnSelection);
        this._setRowSelection(rowSelection);
        Object[] result = null;
        if (cellRanges != null && cellRanges.length > 0) {
            result = this._duplicateCellRangeArray(cellRanges);
            Sort.qSort((Object[])result, (int)result.length, (Comparator)TwoDSelection._getCellRangeComparator());
        }
        this._setCellRanges((CellRange[])result);
    }

    private static Comparator _getCellRangeComparator() {
        if (_cellRangeComparator == null) {
            _cellRangeComparator = new CellRangeComparator();
        }
        return _cellRangeComparator;
    }

    private CellRange[] _duplicateCellRangeArray(CellRange[] objects) {
        if (objects == null) {
            return null;
        }
        CellRange[] result = new CellRange[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            try {
                if (!(objects[i] instanceof CellRange)) continue;
                result[i] = (CellRange)objects[i].clone();
                continue;
            }
            catch (CloneNotSupportedException cnse) {
                // empty catch block
            }
        }
        return result;
    }

    private static class CellRangeComparator
    implements Comparator {
        private CellRangeComparator() {
        }

        public int compare(Object item1, Object item2) {
            CellRange a = (CellRange)item1;
            CellRange b = (CellRange)item2;
            if (this._cellLT(a.getLowerLimit(), b.getLowerLimit())) {
                return -1;
            }
            if (this._cellGT(a.getLowerLimit(), b.getLowerLimit())) {
                return 1;
            }
            return 0;
        }

        private boolean _cellLT(Cell a, Cell b) {
            return a.row < b.row || a.row == b.row && a.column < b.column;
        }

        private boolean _cellGT(Cell a, Cell b) {
            return a.row > b.row || a.row == b.row && a.column > b.column;
        }
    }
}

