/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicBorders;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class UIUtils {
    public static Dimension getMinimumSize(Painter painter, PaintContext context, JComponent component) {
        Dimension d = painter.getMinimumSize(context);
        UIUtils.addInsets(component, d);
        return d;
    }

    public static Dimension getPreferredSize(Painter painter, PaintContext context, JComponent component) {
        Dimension d = painter.getPreferredSize(context);
        UIUtils.addInsets(component, d);
        return d;
    }

    public static Dimension getMaximumSize(Painter painter, PaintContext context, JComponent component) {
        Dimension d = painter.getPreferredSize(context);
        UIUtils.addInsets(component, d);
        return d;
    }

    public static void paint(Graphics g, Painter painter, PaintContext context, JComponent component) {
        ImmInsets i = UIUtils.getInsets(component);
        g.setColor(context.getPaintForeground());
        painter.paint(context, g, i.left, i.top, component.getWidth() - (i.left + i.right), component.getHeight() - (i.top + i.bottom));
    }

    public static void fillBackground(Graphics g, JComponent c) {
        ImmInsets insets = UIUtils._getInsets(c, true);
        Color savedColor = g.getColor();
        g.setColor(c.getBackground());
        g.fillRect(insets.left, insets.top, c.getWidth() - (insets.left + insets.right), c.getHeight() - (insets.top + insets.bottom));
        g.setColor(savedColor);
    }

    public static boolean contains(Painter painter, PaintContext context, JComponent component, int x, int y) {
        int width = component.getWidth();
        int height = component.getHeight();
        if (x < 0 || x >= width || y < 0 || y >= height) {
            return false;
        }
        ImmInsets i = UIUtils.getInsets(component);
        return painter.contains(context, width - (i.left + i.right), height - (i.top + i.bottom), x - i.left, y - i.top);
    }

    public static void addInsets(JComponent component, Dimension d) {
        ImmInsets i = UIUtils.getInsets(component);
        d.width += i.left + i.right;
        d.height += i.top + i.bottom;
    }

    public static ImmInsets getInsets(JComponent c) {
        return UIUtils._getInsets(c, false);
    }

    private static ImmInsets _getInsets(JComponent c, boolean fill) {
        return UIUtils._getInsets(c, c.getBorder(), fill);
    }

    private static ImmInsets _getInsets(JComponent c, Border border, boolean fill) {
        if (border != null) {
            if (border instanceof BorderAdapter) {
                PaintContext context = ((BorderAdapter)border).getPaintContext(c);
                if (context != null) {
                    BorderPainter painter = ((BorderAdapter)border).getBorderPainter();
                    if (fill) {
                        return painter.getFillInsets(context);
                    }
                    return painter.getInsets(context);
                }
            } else if (fill) {
                if (border instanceof EmptyBorder || border instanceof BasicBorders.MarginBorder) {
                    return ImmInsets.getEmptyInsets();
                }
                if (border instanceof CompoundBorder) {
                    return UIUtils._getInsets(c, ((CompoundBorder)border).getOutsideBorder(), fill);
                }
            }
            return new ImmInsets(border.getBorderInsets(c));
        }
        return ImmInsets.getEmptyInsets();
    }

    private UIUtils() {
    }
}

