/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Locale;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.text.WrappedText;
import oracle.bali.ewt.util.StringUtils;

public class WrappingTextPainter
extends TruncatingTextPainter {
    private TextWrapper _wrapper;
    private WrappedText _wrappedText;

    public WrappingTextPainter() {
        this(WordWrapper.getTextWrapper());
    }

    public WrappingTextPainter(TextWrapper wrapper) {
        this._wrapper = wrapper;
    }

    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        String text;
        FontMetrics metrics;
        int width = 0;
        int height = 0;
        Font font = context.getPaintFont();
        if (font != null && (metrics = context.getFontMetrics(font)) != null && (text = this.getStringData(context)) != null) {
            WrappedText wrappedText = this._getWrappedText(text, availableWidth, metrics, context.getPaintLocale());
            int numLines = wrappedText.getLineCount();
            width = numLines == 1 ? metrics.stringWidth(StringUtils.getDisplayString(text, context)) : availableWidth;
            height = numLines * metrics.getHeight() - metrics.getLeading();
        }
        return new Dimension(width, height);
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        int stringHeight;
        String text = this.getStringData(context);
        if (text == null) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics();
        WrappedText wrappedText = this._getWrappedText(text, width, metrics, context.getPaintLocale());
        int numLines = wrappedText.getLineCount();
        float alignmentX = this.getAlignmentX(context);
        float alignmentY = this.getAlignmentY(context);
        int bottom = y + height - 1;
        if (alignmentY != 0.0f && (stringHeight = numLines * metrics.getHeight()) < height) {
            y = (int)((float)y + (float)(height - stringHeight) * alignmentY);
        }
        y += metrics.getAscent();
        int lineHeight = metrics.getHeight();
        for (int i = 0; i < numLines; ++i) {
            String lineText = wrappedText.getLine(i);
            if (y + lineHeight > bottom && i < numLines - 1) {
                lineText = this.getPaintText(context, lineText + wrappedText.getLine(i + 1), metrics, width);
            }
            this.paintText(context, g, metrics, lineText, x, y, width, alignmentX, -1);
            if ((y += lineHeight) > bottom) break;
        }
    }

    private synchronized WrappedText _getWrappedText(String text, int width, FontMetrics metrics, Locale locale) {
        WrappedText wrappedText = this._wrappedText;
        if (wrappedText == null || wrappedText.getWrapWidth() != width || wrappedText.getText() != text || wrappedText.getFontMetrics() != metrics) {
            this._wrappedText = wrappedText = new WrappedText(text, this._wrapper, width, metrics, locale, true);
        }
        return wrappedText;
    }
}

