/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class SeparatorBorderPainter
extends AbstractBorderPainter {
    public static final int ORIENTATION_TOP = 0;
    public static final int ORIENTATION_BOTTOM = 1;
    public static final int ORIENTATION_LEFT = 2;
    public static final int ORIENTATION_RIGHT = 3;
    private int _thickness;
    private int _orientation;
    private boolean _inset;

    public SeparatorBorderPainter(int thickness, boolean inset, int orientation) {
        this(null, thickness, inset, orientation);
    }

    public SeparatorBorderPainter(Painter wrappedPainter, int thickness, boolean inset, int orientation) {
        super(wrappedPainter);
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException();
        }
        this._thickness = thickness;
        this._orientation = orientation;
        this._inset = inset;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        int thickness = this._thickness;
        switch (this._orientation) {
            case 0: {
                top = thickness;
                break;
            }
            case 1: {
                bottom = thickness;
                break;
            }
            case 3: {
                right = thickness;
                break;
            }
            case 2: {
                left = thickness;
            }
        }
        return new ImmInsets(top, left, bottom, right);
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Painter painter = this._getPainter(context);
        Dimension d = painter.getPreferredSize(context);
        switch (this._orientation) {
            case 0: {
                painter.paint(context, g, x, y, width, d.height);
                break;
            }
            case 1: {
                painter.paint(context, g, x, y + height - d.height, width, d.height);
                break;
            }
            case 2: {
                painter.paint(context, g, x, y, d.width, height);
                break;
            }
            case 3: {
                painter.paint(context, g, x + width - d.width, y, d.width, height);
            }
        }
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    private Painter _getPainter(PaintContext context) {
        boolean horizontal;
        UIDefaults defaults = context.getPaintUIDefaults();
        boolean bl = horizontal = this._orientation == 0 || this._orientation == 1;
        String key = this._inset ? (horizontal ? "HorizInsetSeparatorPainter" : "VertInsetSeparatorPainter") : (horizontal ? "HorizOutsetSeparatorPainter" : "VertOutsetSeparatorPainter");
        return (Painter)defaults.get(key);
    }
}

