/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class OracleTabbedPaneUI
extends MetalTabbedPaneUI {
    private ChangeListener _selectionListener;

    public static ComponentUI createUI(JComponent component) {
        return new OracleTabbedPaneUI();
    }

    protected void installListeners() {
        super.installListeners();
        if (this._selectionListener == null) {
            this._selectionListener = new TabSelectionChange();
        }
        this.tabPane.addChangeListener(this._selectionListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._selectionListener != null) {
            this.tabPane.removeChangeListener(this._selectionListener);
        }
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect;
        super.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (selRect != null && tabPlacement == 1 && selectedIndex >= 0 && selRect.y + selRect.height + 1 >= y && selRect.x >= x && selRect.x <= x + w) {
            g.setColor(this.selectColor);
            g.drawLine(selRect.x + 2, y, selRect.x + selRect.width - 1, y);
            g.drawLine(selRect.x + 2, y + 1, selRect.x + selRect.width - 1, y + 1);
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect;
        super.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (selRect != null && tabPlacement == 3 && selectedIndex >= 0 && selRect.y - 1 <= h && selRect.x >= x && selRect.x <= x + w) {
            g.setColor(this.selectColor);
            g.drawLine(selRect.x + 2, y + h - 3, selRect.x + selRect.width - 1, y + h - 3);
            g.drawLine(selRect.x + 2, y + h - 2, selRect.x + selRect.width - 1, y + h - 2);
            g.drawLine(selRect.x + 2, y + h - 1, selRect.x + selRect.width - 1, y + h - 1);
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect;
        super.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (selRect != null && tabPlacement == 4 && selectedIndex >= 0 && selRect.x - 1 <= w && selRect.y >= y && selRect.y <= y + h) {
            g.setColor(this.selectColor);
            g.drawLine(x + w - 3, selRect.y + 2, x + w - 3, selRect.y + selRect.height - 1);
            g.drawLine(x + w - 2, selRect.y + 2, x + w - 2, selRect.y + selRect.height - 1);
            g.drawLine(x + w - 1, selRect.y + 2, x + w - 1, selRect.y + selRect.height - 1);
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Rectangle selRect;
        super.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (selRect != null && tabPlacement == 2 && selectedIndex >= 0 && selRect.x + selRect.width + 1 >= x && selRect.y >= y && selRect.y <= y + h) {
            g.setColor(this.selectColor);
            g.drawLine(x, selRect.y + 2, x, selRect.y + selRect.height - 1);
            g.drawLine(x + 1, selRect.y + 2, x + 1, selRect.y + selRect.height - 1);
        }
    }

    private class TabSelectionChange
    implements ChangeListener {
        private TabSelectionChange() {
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            int index = tabPane.getSelectedIndex();
            if (index >= 0) {
                Color col = tabPane.getComponentAt(index).getBackground();
                OracleTabbedPaneUI.this.selectColor = col == null ? UIManager.getColor("TabbedPane.selected") : col;
            }
        }
    }
}

