/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleInsetBorderPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.AndOrStatePainterSwitcher;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.FixedColorPainter;
import oracle.bali.ewt.painter.ImageSetPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class OracleSliderUI
extends BasicSliderUI
implements MouseListener {
    private boolean _armed;
    private static Painter _sTrackPainter;
    private static Insets _sFocusInsets;

    public OracleSliderUI(JSlider slider) {
        super(slider);
    }

    public static ComponentUI createUI(JComponent c) {
        return new OracleSliderUI((JSlider)c);
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if (key.equals("Slider.vertThumbPainter")) {
            return new ImageSetPainter((ImageSet)defaults.get("Slider.vertThumbSet"));
        }
        if (key.equals("Slider.vertThumbSet")) {
            return new ImageStrip((Image)defaults.get("Slider.vertThumbStrip"), 5);
        }
        if (key.equals("Slider.horzThumbPainter")) {
            return new ImageSetPainter((ImageSet)defaults.get("Slider.horzThumbSet"));
        }
        if (key.equals("Slider.horzThumbSet")) {
            return new ImageStrip((Image)defaults.get("Slider.horzThumbStrip"), 5);
        }
        return null;
    }

    public void installUI(JComponent component) {
        super.installUI(component);
        OracleUIUtils.putPaintContext(component, new Ctxt(this.slider));
        component.setOpaque(false);
    }

    public boolean isArmed() {
        return this._armed;
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
    }

    public void mousePressed(MouseEvent evt) {
        if (this.slider.isEnabled() && this.thumbRect.contains(evt.getX(), evt.getY())) {
            this._setArmed(true);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        this._setArmed(false);
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    protected Dimension getThumbSize() {
        if (this._isHorizontal()) {
            return new Dimension(17, 13);
        }
        return new Dimension(13, 17);
    }

    public void paintFocus(Graphics g) {
        PaintContext context = OracleUIUtils.getPaintContext(this.slider);
        Painter painter = OracleUIUtils.getFocusPainter();
        Color oldColor = g.getColor();
        g.setColor(context.getPaintUIDefaults().getColor("controlText"));
        painter.paint(context, g, this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
        g.setColor(oldColor);
    }

    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        Color oldForeground = this._setLabelColor(label);
        super.paintHorizontalLabel(g, value, label);
        label.setForeground(oldForeground);
    }

    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        Color oldForeground = this._setLabelColor(label);
        super.paintVerticalLabel(g, value, label);
        label.setForeground(oldForeground);
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        Color oldColor = this._setTickColor(g);
        super.paintMinorTickForHorizSlider(g, tickBounds, x);
        g.setColor(oldColor);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        Color oldColor = this._setTickColor(g);
        super.paintMajorTickForHorizSlider(g, tickBounds, x);
        g.setColor(oldColor);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int x) {
        Color oldColor = this._setTickColor(g);
        super.paintMinorTickForVertSlider(g, tickBounds, x);
        g.setColor(oldColor);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int x) {
        Color oldColor = this._setTickColor(g);
        super.paintMajorTickForVertSlider(g, tickBounds, x);
        g.setColor(oldColor);
    }

    public void paintThumb(Graphics g) {
        String painterKey = this._isHorizontal() ? "Slider.horzThumbPainter" : "Slider.vertThumbPainter";
        Painter painter = OracleUIUtils.getPainter(this.slider, painterKey);
        PaintContext context = OracleUIUtils.getPaintContext(this.slider);
        painter.paint(context, g, this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
    }

    public void paintTrack(Graphics g) {
        Painter painter = OracleSliderUI._getTrackPainter();
        PaintContext context = OracleUIUtils.getPaintContext(this.slider);
        int x = this.trackRect.x;
        int y = this.trackRect.y;
        int width = this.trackRect.width;
        int height = this.trackRect.height;
        if (this._isHorizontal()) {
            x -= this.trackBuffer;
            width += 2 * this.trackBuffer;
        } else {
            y -= this.trackBuffer;
            height += 2 * this.trackBuffer;
        }
        painter.paint(context, g, x, y, width, height);
    }

    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        this.focusInsets = OracleSliderUI._getFocusInsets();
    }

    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        slider.addMouseListener(this);
    }

    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this);
    }

    private boolean _isHorizontal() {
        return this.slider.getOrientation() == 0;
    }

    private void _setArmed(boolean armed) {
        if (armed != this._armed) {
            this._armed = armed;
            this.slider.repaint();
        }
    }

    private static Insets _getFocusInsets() {
        if (_sFocusInsets == null) {
            _sFocusInsets = new Insets(4, 2, 4, 2);
        }
        return _sFocusInsets;
    }

    private static Painter _getTrackPainter() {
        if (_sTrackPainter == null) {
            _sTrackPainter = new OracleInsetBorderPainter(new AndOrStatePainterSwitcher(new FixedColorPainter(FilledRectPainter.getPainter(), ColorScheme.NORMAL_INTENSITY), new FixedColorPainter(FilledRectPainter.getPainter(), "Slider.sliderColor"), 2, 2, 0, 0), true);
        }
        return _sTrackPainter;
    }

    private Color _setLabelColor(Component label) {
        PaintContext context = OracleUIUtils.getPaintContext(this.slider);
        Color foreground = context.getPaintForeground();
        if (foreground == ColorScheme.__sControlText) {
            foreground = context.getPaintUIDefaults().getColor("controlText");
        }
        Color oldForeground = label.getForeground();
        label.setForeground(foreground);
        return oldForeground;
    }

    private Color _setTickColor(Graphics g) {
        PaintContext context = OracleUIUtils.getPaintContext(this.slider);
        Color foreground = context.getPaintForeground();
        if (foreground == ColorScheme.__sControlText) {
            foreground = context.getPaintUIDefaults().getColor("controlText");
        }
        Color oldColor = g.getColor();
        g.setColor(foreground);
        return oldColor;
    }

    private class Ctxt
    extends JPaintContext {
        public Ctxt(JComponent comp) {
            super(comp);
        }

        public int getPaintState() {
            int state = super.getPaintState();
            if (OracleSliderUI.this.isArmed()) {
                state |= 2;
            }
            return state;
        }
    }
}

