/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.olaf.OracleThumbPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.PainterButton;
import oracle.bali.ewt.painter.ImageSetPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class OracleScrollBarUI
extends BasicScrollBarUI
implements PropertyChangeListener {
    private Tracker _tracker;
    private static final int _IMAGE_MASK = 7;
    private static Painter _hThumbPainter = new OracleThumbPainter(true);
    private static Painter _vThumbPainter = new OracleThumbPainter(false);

    public static ComponentUI createUI(JComponent component) {
        return new OracleScrollBarUI();
    }

    public void installUI(JComponent component) {
        super.installUI(component);
        OracleUIUtils.putPaintContext(component, this.createPaintContext(component));
        LookAndFeel.installColors(component, "ScrollBar.background", "ScrollBar.foreground");
        component.setOpaque(false);
        component.addPropertyChangeListener(this);
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
        component.removePropertyChangeListener(this);
    }

    public PaintContext createPaintContext(JComponent component) {
        return new PaintCtxt(component);
    }

    public boolean contains(JComponent c, int x, int y) {
        if (OracleUIUtils.pointIsInChild(c, x, y)) {
            return true;
        }
        return this.getTrackBounds().contains(x, y);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        if (this.scrollbar.getOrientation() == 1) {
            d.width = this.incrButton.getPreferredSize().width;
        } else {
            d.height = this.incrButton.getPreferredSize().height;
        }
        return d;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = super.getMaximumSize(c);
        if (this.scrollbar.getOrientation() == 1) {
            d.width = this.incrButton.getMaximumSize().width;
        } else {
            d.height = this.incrButton.getMaximumSize().height;
        }
        return d;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("orientation")) {
            if ((Integer)evt.getNewValue() == 0) {
                this._updateButtonPainter(this.incrButton, 3);
                this._updateButtonPainter(this.decrButton, 7);
            } else {
                this._updateButtonPainter(this.incrButton, 5);
                this._updateButtonPainter(this.decrButton, 1);
            }
        }
    }

    protected JButton createDecreaseButton(int orientation) {
        return this._getArrowButton(orientation);
    }

    protected JButton createIncreaseButton(int orientation) {
        return this._getArrowButton(orientation);
    }

    protected void installListeners() {
        super.installListeners();
        this._tracker = new Tracker();
        this.scrollbar.addMouseListener(this._tracker);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removeMouseListener(this._tracker);
        this._tracker = null;
    }

    private JButton _getArrowButton(int orientation) {
        Object key = this._getPainterKey(orientation);
        Object o = UIManager.getDefaults().get(key);
        PainterButton button = new PainterButton((Painter)o);
        button.setFocusable(false);
        return button;
    }

    private Object _getPainterKey(int orientation) {
        String key = null;
        switch (orientation) {
            case 1: {
                key = "UpScrollPainter";
                break;
            }
            case 5: {
                key = "DownScrollPainter";
                break;
            }
            case 7: {
                key = "LeftScrollPainter";
                break;
            }
            default: {
                key = "RightScrollPainter";
            }
        }
        return key;
    }

    private void _updateButtonPainter(JButton button, int orientation) {
        Object key = this._getPainterKey(orientation);
        UIDefaults defaults = OracleUIUtils.getUIDefaults(button);
        Object o = defaults.get(key);
        ((PainterButton)button).setPainter((Painter)o);
    }

    protected Dimension getMinimumThumbSize() {
        return this._getThumbPainter().getMinimumSize(this._getPaintContext());
    }

    protected Dimension getMaximumThumbSize() {
        return this._getThumbPainter().getMaximumSize(this._getPaintContext());
    }

    protected void installDefaults() {
        super.installDefaults();
        this.scrollbar.setOpaque(false);
    }

    protected Rectangle getDecreaseBounds() {
        Insets insets = this.scrollbar.getInsets();
        Rectangle thumbR = this.getThumbBounds();
        if (this.scrollbar.getOrientation() == 1) {
            int y = this.decrButton.getY() + this.decrButton.getHeight();
            return new Rectangle(insets.left, y, this.scrollbar.getWidth() - (insets.left + insets.right), thumbR.y - y);
        }
        int x = this.decrButton.getX() + this.decrButton.getWidth();
        return new Rectangle(x, insets.top, thumbR.x - x, this.scrollbar.getHeight() - (insets.top + insets.bottom));
    }

    protected Rectangle getIncreaseBounds() {
        Insets insets = this.scrollbar.getInsets();
        Rectangle thumbR = this.getThumbBounds();
        if (this.scrollbar.getOrientation() == 1) {
            int y = thumbR.y + thumbR.height;
            return new Rectangle(insets.left, y, this.scrollbar.getWidth() - (insets.left + insets.right), this.incrButton.getY() - y);
        }
        int x = thumbR.x + thumbR.width;
        return new Rectangle(x, insets.top, this.incrButton.getX() - x, this.scrollbar.getHeight() - (insets.top + insets.bottom));
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty()) {
            Rectangle trackBounds = this.getTrackBounds();
            if (trackBounds.isEmpty()) {
                return;
            }
            thumbBounds = trackBounds;
        }
        Painter thumb = this._getThumbPainter();
        thumb.paint(this._getPaintContext(), g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        Object o = null;
        if (key.equals("UpScrollPainter")) {
            o = defaults.get("UpScrollSet");
        } else if (key.equals("UpScrollSet")) {
            o = defaults.get("UpScrollStrip");
        } else if (key.equals("DownScrollPainter")) {
            o = defaults.get("DownScrollSet");
        } else if (key.equals("DownScrollSet")) {
            o = defaults.get("DownScrollStrip");
        } else if (key.equals("RightScrollPainter")) {
            o = defaults.get("RightScrollSet");
        } else if (key.equals("RightScrollSet")) {
            o = defaults.get("RightScrollStrip");
        } else if (key.equals("LeftScrollPainter")) {
            o = defaults.get("LeftScrollSet");
        } else if (key.equals("LeftScrollSet")) {
            o = defaults.get("LeftScrollStrip");
        }
        if (o instanceof ImageSet) {
            return new ImageSetPainter((ImageSet)o);
        }
        if (o instanceof Image) {
            return new ImageStrip((Image)o, 7);
        }
        return null;
    }

    boolean isArmed() {
        return this.isDragging;
    }

    void repaintThumb() {
        if (!this.scrollbar.isEnabled()) {
            return;
        }
        Rectangle r = this.getThumbBounds();
        this.scrollbar.repaint(r.x, r.y, r.width, r.height);
    }

    private Painter _getThumbPainter() {
        if (this.scrollbar.getOrientation() == 1) {
            return _vThumbPainter;
        }
        return _hThumbPainter;
    }

    private PaintContext _getPaintContext() {
        return OracleUIUtils.getPaintContext(this.scrollbar);
    }

    private class PaintCtxt
    extends JPaintContext {
        public PaintCtxt(JComponent component) {
            super(component);
        }

        public Color getSurroundingColor() {
            return this.getPaintBackground();
        }

        public int getPaintState() {
            int state = super.getPaintState();
            if (OracleScrollBarUI.this.isArmed()) {
                state |= 2;
            }
            return state;
        }
    }

    private class Tracker
    extends MouseAdapter {
        private Tracker() {
        }

        public void mouseReleased(MouseEvent e) {
            OracleScrollBarUI.this.repaintThumb();
        }

        public void mousePressed(MouseEvent e) {
            OracleScrollBarUI.this.repaintThumb();
        }
    }
}

