/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.PainterUI;
import oracle.bali.ewt.olaf.ProgressBarPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class OracleProgressBarUI
extends ProgressBarUI
implements PainterUI,
ChangeListener {
    private static final OracleProgressBarUI _sInstance = new OracleProgressBarUI();

    public static ComponentUI createUI(JComponent component) {
        return _sInstance;
    }

    public void installUI(JComponent component) {
        super.installUI(component);
        component.setOpaque(false);
        LookAndFeel.installBorder(component, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(component, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        JProgressBar bar = (JProgressBar)component;
        bar.addChangeListener(this);
        bar.setStringPainted(true);
        OracleUIUtils.putPaintContext(component, this.getPaintContext(component));
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        LookAndFeel.uninstallBorder(component);
        ((JProgressBar)component).removeChangeListener(this);
        OracleUIUtils.removePaintContext(component);
    }

    public PaintContext getPaintContext(JComponent component) {
        return new PaintCtxt((JProgressBar)component);
    }

    public Painter getPainter(JComponent component) {
        return ProgressBarPainter.getPainter();
    }

    public Dimension getPreferredSize(JComponent component) {
        return OracleUIUtils.getPreferredSize(this, component);
    }

    public Dimension getMinimumSize(JComponent component) {
        return OracleUIUtils.getMinimumSize(this, component);
    }

    public Dimension getMaximumSize(JComponent component) {
        return OracleUIUtils.getMaximumSize(this, component);
    }

    public void update(Graphics g, JComponent c) {
        OracleUIUtils.fillBackground(g, c);
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent component) {
        OracleUIUtils.paint(this, g, component);
    }

    public boolean contains(JComponent component, int x, int y) {
        return OracleUIUtils.contains(this, component, x, y);
    }

    public void stateChanged(ChangeEvent e) {
        ((JComponent)e.getSource()).repaint();
    }

    private OracleProgressBarUI() {
    }

    private static class PaintCtxt
    extends JPaintContext {
        private JProgressBar _bar;

        public PaintCtxt(JProgressBar bar) {
            super(bar);
            this._bar = bar;
        }

        public Object getPaintData(Object key) {
            if (LABEL_KEY.equals(key)) {
                if (this._bar.isStringPainted()) {
                    return this._bar.getString();
                }
                return null;
            }
            return super.getPaintData(key);
        }
    }
}

