/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

public class OracleHeaderItemPainter
extends AbstractBorderPainter {
    private static BorderPainter _sBorderPainter;
    private static final ImmInsets _sInsets;

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        return new BorderAdapter(OracleHeaderItemPainter.getBorderPainter());
    }

    private OracleHeaderItemPainter() {
    }

    public static BorderPainter getBorderPainter() {
        if (_sBorderPainter == null) {
            _sBorderPainter = new OracleHeaderItemPainter();
        }
        return _sBorderPainter;
    }

    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 2;
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        return _sInsets;
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        this._paintBorder(context, g, x, y, width, height);
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    private void _paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color control = defaults.getColor("control");
        Color shadow = defaults.getColor("normalIntensity");
        Color dark = defaults.getColor("darkIntensity");
        Color darkShadow = defaults.getColor("controlShadowDark");
        if ((state & 2) != 0) {
            g.setColor(dark);
            int temp1 = x;
            int temp2 = y;
            int temp3 = right;
            g.drawLine(temp1, y, temp3, y);
            g.drawLine(x, temp2, x, bottom);
        } else {
            g.setColor(shadow);
            g.drawLine(x, bottom, right, bottom);
            g.drawLine(right, y, right, bottom);
            if ((state & 4) == 0) {
                g.setColor(Color.white);
                int temp1 = x;
                int temp2 = y;
                int temp3 = right;
                g.drawLine(temp1, y, temp3, y);
                g.drawLine(x, temp2, x, bottom);
                g.setColor(control);
                g.drawLine(x, bottom, x, bottom);
                g.drawLine(right, y, right, y);
            }
        }
    }

    static {
        _sInsets = new ImmInsets(1, 1, 1, 1);
    }
}

