/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.Collator;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.border.UIBorderFactory;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.graphics.IconStrip;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.ShellUtils;
import oracle.bali.ewt.olaf.TypeAheadSelectionData;
import oracle.bali.ewt.olaf.TypeAheadSelectionListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class OracleFileChooserUI
extends BasicFileChooserUI
implements PropertyChangeListener {
    private static final String _KEY_NAME = "FILECHOOSER.NAME";
    private static final String _KEY_SIZE = "FILECHOOSER.SIZE";
    private static final String _KEY_TYPE = "FILECHOOSER.TYPE";
    private static final String _KEY_DATE = "FILECHOOSER.DATE";
    private static final String _KEY_ATTR = "FILECHOOSER.ATTR";
    private static final String _KEY_OPEN = "FILECHOOSER.OPEN";
    private static final String _KEY_SAVE = "FILECHOOSER.SAVE";
    private static final String _KEY_HELP = "COMMON.HELP";
    private static final String _KEY_CANCEL = "COMMON.CANCEL";
    private static final String _KEY_LOOKIN = "FILECHOOSER.LOOKIN";
    private static final String _KEY_FILETYPES = "FILECHOOSER.FILETYPES";
    private static final String _KEY_UP = "FILECHOOSER.UP";
    private static final String _KEY_HOME = "FILECHOOSER.HOME";
    private static final String _KEY_FOLDER = "FILECHOOSER.FOLDER";
    private static final String _KEY_PREVIEW = "FILECHOOSER.PREVIEW";
    private static final String _KEY_LIST = "FILECHOOSER.LIST";
    private static final String _KEY_DETAILS = "FILECHOOSER.DETAILS";
    private static final String _KEY_FILENAME = "FILECHOOSER.FILENAME";
    private static final String _KEY_FILES = "FILECHOOSER.FILES";
    private static final String _KEY_PREVIEW_LABEL = "FILECHOOSER.PREVIEW_LABEL";
    private static final String _KEY_READONLY = "FILECHOOSER.READONLY";
    private static final String _KEY_HIDDEN = "FILECHOOSER.HIDDEN";
    private static final String _KEY_READONLY_AND_HIDDEN = "FILECHOOSER.READONLY_AND_HIDDEN";
    private static final int _ICON_BORDER = 3;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final Dimension _vstrut6 = new Dimension(1, 6);
    private static final Insets _emptyMargin = new Insets(0, 0, 0, 0);
    private static final int _LIST_MIN_WIDTH = 300;
    private static final int _LIST_MIN_HEIGHT = 50;
    private static final int _PREVIEW_HEIGHT = 128;
    private static final int _PREVIEW_WIDTH = 128;
    static final int _INDENT_SPACE = 10;
    private static final int _COLUMN_FILENAME = 0;
    private static final int _COLUMN_FILESIZE = 1;
    private static final int _COLUMN_FILETYPE = 2;
    private static final int _COLUMN_FILEDATE = 3;
    private static final int _COLUMN_FILEATTR = 4;
    private static final int _COLUMN_COLCOUNT = 5;
    private static IconStrip _sFileIconStrip;
    private int[] _COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    int __lastIndex = -1;
    boolean __editing = false;
    int __editX = 20;
    JTextField __editCell;
    JList _list;
    private DirectoryComboBoxModel _directoryComboBoxModel;
    private Action _directoryComboBoxAction = new DirectoryComboBoxAction();
    private Action _newFolderAction = new NewFolderAction();
    private FilterComboBoxModel _filterComboBoxModel;
    private JTextField _filenameTextField;
    private JButton _approveButton;
    private JButton _cancelButton;
    private JButton _helpButton;
    private JLabel _lookInLabel;
    private JLabel _fileNameLabel;
    private JLabel _fileTypesLabel;
    private JLabel _filesLabel;
    private JLabel _previewLabel;
    private JButton _up;
    private JButton _home;
    private JButton _newFolder;
    private JToggleButton _listView;
    private JToggleButton _detailsView;
    private JPanel _previewPanel;
    private JCheckBox _previewButton;
    private JPanel _viewPanel;
    private JPanel _listPanel;
    private JComponent _detailsPanel;
    private JTable _table;
    private JScrollPane _tableScrollPane;
    private OracleDirectoryModel _model;
    private Window _parent = null;
    private int _startWidth = -1;
    private int _startHeight = -1;
    private int _lastWidth = -1;
    private int _lastHeight = -1;
    private KeyListener _keyHandler;
    private static boolean _sShellFolderAvailable;
    boolean useShellFolder = false;
    private String _newFolderErrorText = UIManager.getString("FileChooser.newFolderErrorText");
    private String _newFolderErrorSeparator = UIManager.getString("FileChooser.newFolderErrorSeparator");
    private File _curentDirectory;
    private ListSelectionModel _selectionModel;
    private boolean _directorySelected;
    private File _directory;
    private static Method _sIsFileSystemMethod;
    private static Method _sIsFileSystemRootMethod;
    private static boolean _sJDK14orHigher;

    public static ComponentUI createUI(JComponent c) {
        return new OracleFileChooserUI((JFileChooser)c);
    }

    public void installComponents(JFileChooser fileChooser) {
        File[] files;
        File[] cbFolders;
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        UIDefaults defaults = OracleUIUtils.getUIDefaults(fileChooser);
        Color fileChooserColor = defaults.getColor("FileChooser.background");
        fileChooser.setBackground(fileChooserColor);
        this._previewPanel = new JPanel(new BorderLayout(3, 3));
        this._previewPanel.setBorder(new EmptyBorder(6, 0, 6, 6));
        this._previewPanel.setPreferredSize(new Dimension(128, 128));
        JPanel fileChooserPanel = new JPanel(new BorderLayout(0, 0));
        fileChooserPanel.add("Center", leftPanel);
        fileChooserPanel.add("East", this._previewPanel);
        fileChooser.setLayout(new BorderLayout(6, 6));
        fileChooser.setBorder(new EmptyBorder(6, 6, 6, 6));
        fileChooser.add("Center", new GrayPane(fileChooserPanel));
        this._lookInLabel = new JLabel();
        this._fileTypesLabel = new JLabel();
        NonNullSelComboBox directoryComboBox = new NonNullSelComboBox();
        this._lookInLabel.setLabelFor(directoryComboBox);
        this._directoryComboBoxModel = new DirectoryComboBoxModel();
        directoryComboBox.setModel(this._directoryComboBoxModel);
        directoryComboBox.addActionListener(this._directoryComboBoxAction);
        directoryComboBox.setRenderer(new DirectoryComboBoxRenderer());
        directoryComboBox.setAlignmentX(0.0f);
        directoryComboBox.setAlignmentY(0.5f);
        this._filterComboBoxModel = new FilterComboBoxModel();
        fileChooser.addPropertyChangeListener(this._filterComboBoxModel);
        NonNullSelComboBox filterComboBox = new NonNullSelComboBox();
        filterComboBox.setModel(this._filterComboBoxModel);
        this._fileTypesLabel.setLabelFor(filterComboBox);
        filterComboBox.setRenderer(new FilterComboBoxRenderer());
        this._fileNameLabel = new JLabel();
        this._filesLabel = new JLabel();
        this._filesLabel.setAlignmentY(1.0f);
        this._up = OracleFileChooserUI._createButton(this.upFolderIcon, this.getChangeToParentDirectoryAction());
        this._home = OracleFileChooserUI._createButton(this.homeFolderIcon, this.getGoHomeAction());
        this._newFolder = OracleFileChooserUI._createButton(this.newFolderIcon, this.getNewFolderAction());
        this._newFolder.setAlignmentY(0.5f);
        this._newFolder.setMargin(_emptyMargin);
        ViewSwitch viewSwitcher = new ViewSwitch();
        this._listView = new JToggleButton(this.listViewIcon);
        this._listView.setSelected(true);
        this._listView.setAlignmentY(0.5f);
        this._listView.setMargin(_emptyMargin);
        this._listView.addItemListener(viewSwitcher);
        this._detailsView = new JToggleButton(this.detailsViewIcon);
        this._detailsView.setAlignmentY(0.5f);
        this._detailsView.setMargin(_emptyMargin);
        this._detailsView.addItemListener(viewSwitcher);
        ButtonGroup group = new ButtonGroup();
        group.add(this._listView);
        group.add(this._detailsView);
        JPanel topLeftPanel = new JPanel();
        topLeftPanel.setLayout(new BorderLayout(6, 6));
        JPanel panel1 = new JPanel(new BorderLayout(6, 6));
        panel1.add("North", this._lookInLabel);
        panel1.add("Center", this._fileTypesLabel);
        panel1.add("South", this._filesLabel);
        topLeftPanel.add("West", panel1);
        JPanel panel2 = new JPanel(new BorderLayout(6, 6));
        panel2.add("North", directoryComboBox);
        JPanel tempTopPanel = new JPanel(new BorderLayout());
        tempTopPanel.add("North", filterComboBox);
        panel2.add("Center", tempTopPanel);
        topLeftPanel.add("Center", panel2);
        JPanel topRightPanel = new JPanel();
        topRightPanel.setLayout(new GridLayout(3, 3, 2, 0));
        topRightPanel.add(this._up);
        topRightPanel.add(this._home);
        topRightPanel.add(Box.createHorizontalGlue());
        topRightPanel.add(Box.createHorizontalGlue());
        topRightPanel.add(Box.createHorizontalGlue());
        topRightPanel.add(Box.createHorizontalGlue());
        topRightPanel.add(this._newFolder);
        topRightPanel.add(this._listView);
        topRightPanel.add(this._detailsView);
        JPanel topPanel = new JPanel(new BorderLayout(3, 3));
        topPanel.add("Center", topLeftPanel);
        JPanel tempPanel = new JPanel(new BorderLayout());
        tempPanel.add("North", topRightPanel);
        topPanel.add("East", tempPanel);
        leftPanel.add("North", topPanel);
        JPanel middlePanel = new JPanel();
        middlePanel.setBorder(new EmptyBorder(2, 0, 0, 0));
        middlePanel.setLayout(new BorderLayout());
        JCheckBox cb = new JCheckBox();
        cb.addActionListener(this._getShowPreviewAction());
        cb.setSelected(true);
        this._previewButton = cb;
        JPanel accessoryPanel = this.getAccessoryPanel();
        accessoryPanel.setOpaque(true);
        accessoryPanel.setBackground(Color.white);
        accessoryPanel.setBorder(UIBorderFactory.getRaisedBevelBorder());
        JComponent accessory = fileChooser.getAccessory();
        boolean previewVisible = accessory != null;
        this._previewButton.setVisible(previewVisible);
        File[] roots = fileChooser.getFileSystemView().getRoots();
        if (roots != null && roots.length == 1 && _sShellFolderAvailable && (cbFolders = ShellUtils.getRoots()) != null && cbFolders.length > 0 && roots[0] == cbFolders[0]) {
            this.useShellFolder = true;
        }
        this._keyHandler = new KeyEventHandler();
        this._listPanel = this._createList(fileChooser);
        this._listPanel.setMinimumSize(new Dimension(300, 50));
        this._filesLabel.setLabelFor(this._list);
        this._viewPanel = new JPanel(new BorderLayout());
        this._viewPanel.add("Center", this._listPanel);
        middlePanel.add("Center", this._viewPanel);
        this._filenameTextField = new JTextField();
        this._fileNameLabel.setLabelFor(this._filenameTextField);
        this._filenameTextField.addActionListener(this.getApproveSelectionAction());
        this._filenameTextField.addKeyListener(this._keyHandler);
        String fileName = null;
        if (this._isMultiSelectionEnabled() && (files = fileChooser.getSelectedFiles()) != null && files.length > 0) {
            fileName = this._getFileNameString(files);
        }
        if (fileName == null) {
            fileName = this._getFileNameString(fileChooser.getSelectedFile());
        }
        this.setFileName(fileName);
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setBorder(new EmptyBorder(6, 0, 0, 0));
        fileNamePanel.setLayout(new BorderLayout(3, 3));
        fileNamePanel.add("West", this._fileNameLabel);
        fileNamePanel.add("Center", this._filenameTextField);
        JPanel bottomMiddlePanel = new JPanel(new BorderLayout(6, 6));
        bottomMiddlePanel.add("North", fileNamePanel);
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.add("West", this._previewButton);
        bottomMiddlePanel.add("Center", previewPanel);
        middlePanel.add("South", bottomMiddlePanel);
        leftPanel.add("Center", middlePanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        DialogButtonBar buttonBar = new DialogButtonBar();
        this._approveButton = new JButton();
        this._approveButton.addActionListener(this.getApproveSelectionAction());
        buttonBar.add((Component)this._approveButton, DialogButtonBar.CONSTRAINT_YES);
        this._cancelButton = new JButton();
        this._cancelButton.addActionListener(this.getCancelSelectionAction());
        buttonBar.add((Component)this._cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this._previewLabel = new JLabel();
        this._previewPanel.add("North", this._previewLabel);
        this._previewPanel.add((Component)accessoryPanel, "Center");
        this._previewPanel.setVisible(previewVisible);
        if (accessory != null) {
            accessoryPanel.add(accessory);
        }
        this._helpButton = new JButton();
        this._helpButton.setVisible(false);
        buttonBar.add((Component)this._helpButton, DialogButtonBar.CONSTRAINT_HELP);
        bottomPanel.add("South", buttonBar);
        bottomPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        fileChooser.add("South", bottomPanel);
    }

    public void uninstallComponents(JFileChooser fc) {
        if (this._table != null) {
            TableListener model = (TableListener)this._table.getModel();
            this.getModel().removeListDataListener(model);
        }
    }

    public void paint(Graphics g, JComponent c) {
        OracleUIUtils.fillBackground(g, c);
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        if (this.getModel().contains(f)) {
            int index = this.getModel().indexOf(f);
            this._ensureIndexIsVisible(index);
        }
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().invalidateFileCache();
        this.getModel().validateFileCache();
    }

    public String getFileName() {
        if (this._filenameTextField == null) {
            return null;
        }
        String fileNameText = this._filenameTextField.getText();
        if (fileNameText != null) {
            fileNameText = fileNameText.trim();
        }
        if (fileNameText == null || "".equals(fileNameText)) {
            return null;
        }
        if (this._isMultiSelectionEnabled() && fileNameText.startsWith("\"")) {
            return fileNameText;
        }
        JFileChooser fc = this.getFileChooser();
        if (this._curentDirectory == null) {
            return fileNameText;
        }
        if (OracleFileChooserUI._isFileSystemRoot(fc, this._curentDirectory)) {
            return this._curentDirectory.getPath();
        }
        File parentDir = this._curentDirectory.getParentFile();
        if (parentDir != null) {
            return fc.getFileSystemView().createFileObject(parentDir, fileNameText).getPath();
        }
        return fileNameText;
    }

    public void setFileName(String filename) {
        if (this._filenameTextField != null) {
            this._filenameTextField.setText(filename);
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String dirname) {
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this._filterComboBoxModel);
        this._cancelButton.removeActionListener(this.getCancelSelectionAction());
        this._approveButton.removeActionListener(this.getApproveSelectionAction());
        this._filenameTextField.removeActionListener(this.getApproveSelectionAction());
        this._filenameTextField.removeKeyListener(this._keyHandler);
        this._list.removeKeyListener(this._keyHandler);
        if (this._table != null) {
            this._table.removeKeyListener(this._keyHandler);
        }
        super.uninstallUI(c);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return this;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("SelectedFileChangedProperty")) {
            this.cancelEdit();
            File f = (File)e.getNewValue();
            JFileChooser fc = this.getFileChooser();
            if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || fc.isDirectorySelectionEnabled() && f.isDirectory())) {
                this.setFileName(this._getFileNameString(f));
            } else {
                this.setFileName(null);
            }
            this.setFileSelected();
        } else if ("SelectedFilesChangedProperty".equals(prop)) {
            this.cancelEdit();
            File[] files = (File[])e.getNewValue();
            JFileChooser fc = this.getFileChooser();
            if (this._isMultiSelectionEnabled()) {
                this.setFileName(this._getFileNameString(files));
                this.setFileSelected();
            }
        } else if (prop.equals("directoryChanged")) {
            this.cancelEdit();
            this.resetEditIndex();
            this.clearIconCache();
            this._clearSelection();
            File currentDirectory = this.getFileChooser().getCurrentDirectory();
            if (currentDirectory != null) {
                this._directoryComboBoxModel.addItem(currentDirectory);
                this._up.setEnabled(!this.getFileChooser().getFileSystemView().isRoot(currentDirectory));
                this.getNewFolderAction().setEnabled(currentDirectory.canWrite());
            }
        } else if (prop.equals("fileFilterChanged") || prop.equals("fileSelectionChanged")) {
            this.cancelEdit();
            this.resetEditIndex();
            this.clearIconCache();
            this._clearSelection();
        } else if (prop.equals("AccessoryChangedProperty")) {
            if (this.getAccessoryPanel() != null) {
                JComponent accessory;
                if (e.getOldValue() != null) {
                    this.getAccessoryPanel().remove((JComponent)e.getOldValue());
                }
                if ((accessory = (JComponent)e.getNewValue()) != null) {
                    this.getAccessoryPanel().add((Component)accessory, "Center");
                }
                boolean visible = accessory != null;
                this._previewButton.setVisible(visible);
                this._previewPanel.setVisible(visible);
            }
        } else if (prop.equals("ApproveButtonTextChangedProperty") || prop.equals("DialogTypeChangedProperty")) {
            JFileChooser chooser = this.getFileChooser();
            this._approveButton.setText(this.getApproveButtonText(chooser));
            this._approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
            this._approveButton.setMnemonic(this.getApproveButtonMnemonic(chooser));
        } else if (prop.equals("ApproveButtonMnemonicChangedProperty")) {
            this._approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
        } else if (prop.equals("ancestor") && e.getNewValue() != null) {
            this._installStrings();
            JRootPane root = this.getFileChooser().getRootPane();
            if (root != null && root.getDefaultButton() == null) {
                root.setDefaultButton(this._approveButton);
            }
        } else if ("MultiSelectionEnabledChangedProperty".equals(prop)) {
            this._setSelectionMode();
        }
    }

    public Action getNewFolderAction() {
        return this._newFolderAction;
    }

    protected void createModel() {
        super.createModel();
        this._model = new OracleDirectoryModel(this.getFileChooser());
    }

    public BasicDirectoryModel getModel() {
        return this._model;
    }

    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        fc.addPropertyChangeListener(this._model);
    }

    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
        fc.removePropertyChangeListener(this._model);
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if (_sFileIconStrip == null) {
            Image image = ImageUtils.getImageResource(OracleFileChooserUI.class, "icons/fileStrip.gif");
            _sFileIconStrip = new IconStrip(image, 15);
        }
        if (key instanceof String) {
            try {
                int index = Integer.parseInt((String)key);
                return _sFileIconStrip.getIcon(index);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this._approveButton;
    }

    protected void setDirectorySelected(boolean select) {
        this._directorySelected = select;
    }

    protected boolean isDirectorySelected() {
        return this._directorySelected;
    }

    protected void setDirectory(File f) {
        this._directory = f;
    }

    protected File getDirectory() {
        return this._directory;
    }

    void cancelEdit() {
        this.__editing = false;
        if (this.__editCell != null) {
            this._list.remove(this.__editCell);
        }
        if (this._table != null && this._table.isEditing()) {
            this._table.getCellEditor().cancelCellEditing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileSelected() {
        JFileChooser fc = this.getFileChooser();
        Object[] files = null;
        BasicDirectoryModel model = this.getModel();
        if (this._isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            files = fc.getSelectedFiles();
        }
        if (files != null && files.length > 0) {
            Object[] selectedObjects = this._list.getSelectedValues();
            this._selectionModel.setValueIsAdjusting(true);
            try {
                int index;
                Arrays.sort(files);
                Arrays.sort(selectedObjects);
                int shouldIndex = 0;
                int actuallyIndex = 0;
                while (shouldIndex < files.length && actuallyIndex < selectedObjects.length) {
                    int index2;
                    int comparison = ((File)files[shouldIndex]).compareTo((File)selectedObjects[actuallyIndex]);
                    if (comparison < 0) {
                        index2 = model.indexOf(files[shouldIndex]);
                        if (index2 >= 0) {
                            this._selectionModel.addSelectionInterval(index2, index2);
                        }
                        ++shouldIndex;
                        continue;
                    }
                    if (comparison > 0) {
                        index2 = model.indexOf(selectedObjects[actuallyIndex]);
                        if (index2 >= 0) {
                            this._selectionModel.removeSelectionInterval(index2, index2);
                        }
                        ++actuallyIndex;
                        continue;
                    }
                    ++shouldIndex;
                    ++actuallyIndex;
                }
                while (shouldIndex < files.length) {
                    index = model.indexOf(files[shouldIndex]);
                    if (index >= 0) {
                        this._selectionModel.addSelectionInterval(index, index);
                    }
                    ++shouldIndex;
                }
                while (actuallyIndex < selectedObjects.length) {
                    index = model.indexOf(selectedObjects[actuallyIndex]);
                    if (index >= 0) {
                        this._selectionModel.removeSelectionInterval(index, index);
                    }
                    ++actuallyIndex;
                }
            }
            finally {
                this._selectionModel.setValueIsAdjusting(false);
            }
        } else {
            File f = fc.getSelectedFile();
            if (f == null && this.isDirectorySelected()) {
                f = this.getDirectory();
            }
            if (f != null && this.getModel().contains(f)) {
                int index = this.getModel().indexOf(f);
                this._selectionModel.setSelectionInterval(index, index);
            } else {
                this._clearSelection();
            }
        }
    }

    private boolean _isMultiSelectionEnabled() {
        if (_sJDK14orHigher) {
            JFileChooser fc = this.getFileChooser();
            return fc.isMultiSelectionEnabled();
        }
        return false;
    }

    private void _setSelectionMode() {
        if (this._isMultiSelectionEnabled()) {
            this._selectionModel.setSelectionMode(2);
        } else {
            this._selectionModel.setSelectionMode(0);
            JFileChooser fc = this.getFileChooser();
            File f = fc.getSelectedFile();
            this._clearSelection();
            fc.setSelectedFiles(null);
            if (f != null) {
                fc.setSelectedFile(f);
            }
        }
    }

    private String _getFileNameString(File file) {
        JFileChooser fc = this.getFileChooser();
        return file == null ? null : (!OracleFileChooserUI._isFileSystem(fc, file) || OracleFileChooserUI._isFileSystemRoot(fc, file) ? fc.getName(file) : file.getName());
    }

    private String _getFileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this._getFileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private static boolean _isFileSystem(JFileChooser fc, File file) {
        FileSystemView fs = fc.getFileSystemView();
        if (_sJDK14orHigher) {
            try {
                if (_sIsFileSystemMethod == null) {
                    Class<FileSystemView> c = FileSystemView.class;
                    Class[] parm = new Class[]{File.class};
                    _sIsFileSystemMethod = c.getMethod("isFileSystem", parm);
                }
                Object[] args = new Object[]{file};
                Object o = _sIsFileSystemMethod.invoke((Object)fs, args);
                return Boolean.TRUE.equals(o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void _setCurrentDirectory(File file) {
        this._curentDirectory = file;
    }

    private static boolean _isFileSystemRoot(JFileChooser fc, File file) {
        FileSystemView fs = fc.getFileSystemView();
        if (_sJDK14orHigher) {
            try {
                if (_sIsFileSystemRootMethod == null) {
                    Class<FileSystemView> c = FileSystemView.class;
                    Class[] parm = new Class[]{File.class};
                    _sIsFileSystemRootMethod = c.getMethod("isFileSystemRoot", parm);
                }
                Object[] args = new Object[]{file};
                Object o = _sIsFileSystemRootMethod.invoke((Object)fs, args);
                return Boolean.TRUE.equals(o);
            }
            catch (Exception exception) {}
        } else {
            return fs.isRoot(file);
        }
        return false;
    }

    private void _ensureIndexIsVisible(int i) {
        if (i >= 0) {
            this._list.ensureIndexIsVisible(i);
            if (this._table != null) {
                this._table.scrollRectToVisible(this._table.getCellRect(i, 0, true));
            }
        }
    }

    private void _clearSelection() {
        this._selectionModel.clearSelection();
        if (this._table != null) {
            this._table.getColumnModel().getSelectionModel().clearSelection();
        }
    }

    private JPanel _createList(JFileChooser fc) {
        JPanel p = new JPanel(new BorderLayout());
        this._list = new JList();
        this._list.setCellRenderer(new FileRenderer());
        this._list.setModel(this.getModel());
        this._selectionModel = this._list.getSelectionModel();
        this._setSelectionMode();
        this._list.addListSelectionListener(this.createListSelectionListener(fc));
        this._list.addMouseListener(this.createDoubleClickListener(fc, this._list));
        this._list.addMouseListener(new SingleClickListener(this._list));
        this._list.addKeyListener(this._keyHandler);
        this._list.addKeyListener(this._createTASListenerForList());
        this.getModel().addListDataListener(new DelayedSelectionListener());
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        String action = "cancelListEdit";
        this._list.getInputMap(1).put(ks, action);
        this._list.getActionMap().put(action, new ListEditCancel());
        JScrollPane scrollpane = new JScrollPane(this._list);
        p.add((Component)scrollpane, "Center");
        return p;
    }

    private JComponent _createTable(JFileChooser fc) {
        ResourceBundle bundle = ResourceBundle.getBundle("oracle.bali.ewt.olaf.resource.OLAFBundle", fc.getLocale());
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        columnModel.setSelectionModel(new ColumnSelection());
        TableColumn nameColumn = new TableColumn(0);
        nameColumn.setHeaderValue(bundle.getString(_KEY_NAME));
        NameRenderer renderer = new NameRenderer();
        nameColumn.setCellRenderer(renderer);
        nameColumn.setCellEditor(new NameEditor(renderer));
        nameColumn.setIdentifier("name");
        nameColumn.setPreferredWidth(this._COLUMN_WIDTHS[0]);
        DefaultTableCellRenderer sizeRenderer = new DefaultTableCellRenderer();
        sizeRenderer.setHorizontalAlignment(4);
        TableColumn sizeColumn = new TableColumn(1);
        sizeColumn.setHeaderValue(bundle.getString(_KEY_SIZE));
        sizeColumn.setCellRenderer(sizeRenderer);
        sizeColumn.setIdentifier("size");
        sizeColumn.setPreferredWidth(this._COLUMN_WIDTHS[1]);
        TableColumn typeColumn = new TableColumn(2);
        typeColumn.setHeaderValue(bundle.getString(_KEY_TYPE));
        typeColumn.setIdentifier("type");
        typeColumn.setPreferredWidth(this._COLUMN_WIDTHS[2]);
        TableColumn dateColumn = new TableColumn(3);
        dateColumn.setHeaderValue(bundle.getString(_KEY_DATE));
        dateColumn.setIdentifier("date");
        dateColumn.setPreferredWidth(this._COLUMN_WIDTHS[3]);
        TableColumn attrColumn = new TableColumn(4);
        attrColumn.setHeaderValue(bundle.getString(_KEY_ATTR));
        attrColumn.setIdentifier("attribute");
        attrColumn.setPreferredWidth(this._COLUMN_WIDTHS[4]);
        columnModel.addColumn(nameColumn);
        columnModel.addColumn(sizeColumn);
        columnModel.addColumn(typeColumn);
        columnModel.addColumn(dateColumn);
        columnModel.addColumn(attrColumn);
        TableListener ds = new TableListener();
        this._table = new JTable(ds, columnModel);
        this._table.setSelectionModel(this._selectionModel);
        KeyStroke s = KeyStroke.getKeyStroke(9, 0);
        this._table.unregisterKeyboardAction(s);
        s = KeyStroke.getKeyStroke(9, 1);
        this._table.unregisterKeyboardAction(s);
        s = KeyStroke.getKeyStroke(10, 1);
        this._table.unregisterKeyboardAction(s);
        s = KeyStroke.getKeyStroke(10, 0);
        this._table.getInputMap(1).put(s, "None");
        this._table.addKeyListener(this._keyHandler);
        this._table.setAutoResizeMode(0);
        this._table.setShowGrid(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.setRowSelectionAllowed(false);
        this._table.setCellSelectionEnabled(true);
        this._table.getTableHeader().setReorderingAllowed(false);
        this._table.addKeyListener(this._createTASListenerForTable());
        Font f = fc.getFont();
        this._table.setRowHeight(fc.getFontMetrics(f).getHeight() + 4);
        this._tableScrollPane = new JScrollPane(this._table);
        this._tableScrollPane.addComponentListener(ds);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", this._tableScrollPane);
        return panel;
    }

    private void setEditIndex(int i) {
        this.__lastIndex = i;
    }

    private void resetEditIndex() {
        this.__lastIndex = -1;
    }

    private void _installStrings() {
        JFileChooser fc = this.getFileChooser();
        ResourceBundle bundle = ResourceBundle.getBundle("oracle.bali.ewt.olaf.resource.OLAFBundle", fc.getLocale());
        int type = fc.getDialogType();
        String text = fc.getApproveButtonText();
        int mnemonic = fc.getApproveButtonMnemonic();
        if (text == null) {
            if (type == 0) {
                text = bundle.getString(_KEY_OPEN);
            } else if (type == 1) {
                text = bundle.getString(_KEY_SAVE);
            }
            OracleFileChooserUI._setButtonText(this._approveButton, text);
        } else {
            OracleFileChooserUI._setButtonText(this._approveButton, text, mnemonic);
        }
        text = fc.getApproveButtonToolTipText();
        if (text == null) {
            // empty if block
        }
        this._approveButton.setToolTipText(text);
        OracleFileChooserUI._setButtonText(this._cancelButton, bundle.getString(_KEY_CANCEL));
        OracleFileChooserUI._setButtonText(this._helpButton, bundle.getString(_KEY_HELP));
        OracleFileChooserUI._setLabelText(this._lookInLabel, bundle.getString(_KEY_LOOKIN));
        OracleFileChooserUI._setLabelText(this._fileNameLabel, bundle.getString(_KEY_FILENAME));
        OracleFileChooserUI._setLabelText(this._fileTypesLabel, bundle.getString(_KEY_FILETYPES));
        OracleFileChooserUI._setLabelText(this._filesLabel, bundle.getString(_KEY_FILES));
        OracleFileChooserUI._setLabelText(this._previewLabel, bundle.getString(_KEY_PREVIEW_LABEL));
        text = bundle.getString(_KEY_UP);
        this._up.setToolTipText(text);
        OracleFileChooserUI._setAccessibleName(this._up, text);
        text = bundle.getString(_KEY_HOME);
        this._home.setToolTipText(text);
        OracleFileChooserUI._setAccessibleName(this._home, text);
        text = bundle.getString(_KEY_FOLDER);
        this._newFolder.setToolTipText(text);
        OracleFileChooserUI._setAccessibleName(this._newFolder, text);
        text = bundle.getString(_KEY_LIST);
        this._listView.setToolTipText(text);
        OracleFileChooserUI._setAccessibleName(this._listView, text);
        text = bundle.getString(_KEY_DETAILS);
        this._detailsView.setToolTipText(text);
        OracleFileChooserUI._setAccessibleName(this._detailsView, text);
        OracleFileChooserUI._setButtonText(this._previewButton, bundle.getString(_KEY_PREVIEW));
    }

    private OracleFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    private ActionListener _getShowPreviewAction() {
        return new ShowPreviewAction();
    }

    private void _switchToListView() {
        if (this._detailsPanel != null) {
            this._viewPanel.remove(this._detailsPanel);
        }
        this._viewPanel.add("Center", this._listPanel);
        this.getFileChooser().revalidate();
        this.getFileChooser().repaint();
        this._filesLabel.setLabelFor(this._list);
    }

    private void _switchToDetailsView() {
        boolean resize = false;
        if (this._detailsPanel == null) {
            this._detailsPanel = this._createTable(this.getFileChooser());
            this._detailsPanel.setMinimumSize(new Dimension(300, 50));
            resize = true;
        }
        this._viewPanel.remove(this._listPanel);
        this._viewPanel.add("Center", this._detailsPanel);
        if (resize) {
            OracleFileChooserUI._resizeTable(this._table, true);
        }
        this._filesLabel.setLabelFor(this._table);
        this.getFileChooser().revalidate();
        this.getFileChooser().repaint();
    }

    private void _renameFile(File f, String newFileName) {
        File f2;
        if (newFileName == null) {
            newFileName = "";
        }
        if (!(newFileName = newFileName.trim()).equals(this.getFileChooser().getName(f)) && f.renameTo(f2 = this.getFileChooser().getFileSystemView().createFileObject(this.getFileChooser().getCurrentDirectory(), newFileName))) {
            this.rescanCurrentDirectory(this.getFileChooser());
            this.getFileChooser().setSelectedFile(f2);
        }
    }

    private KeyListener _createTASListenerForList() {
        TypeAheadSelectionListData u = new TypeAheadSelectionListData();
        return new TypeAheadSelectionListener(u);
    }

    private KeyListener _createTASListenerForTable() {
        TypeAheadSelectionTableData u = new TypeAheadSelectionTableData();
        return new TypeAheadSelectionListener(u);
    }

    public Dimension getPreferredSize(JComponent component) {
        Dimension d;
        if (this._lastWidth != -1) {
            d = new Dimension(this._lastWidth, this._lastHeight);
        } else {
            LayoutManager lm = component.getLayout();
            if (lm == null) {
                return null;
            }
            d = lm.preferredLayoutSize(component);
            Window w = SwingUtilities.getWindowAncestor(component);
            Insets i = w == null ? new Insets(0, 0, 0, 0) : w.getInsets();
            int horzonInsets = i.left + i.right;
            int verticalInsets = i.top + i.bottom;
            int widthPlusInsets = d.width + horzonInsets;
            int heightPlusInsets = d.height + verticalInsets;
            if (widthPlusInsets > WindowUtils.DIALOG_MAXIMUM_WIDTH) {
                d.width = WindowUtils.DIALOG_MAXIMUM_WIDTH - horzonInsets;
            }
            if (heightPlusInsets > WindowUtils.DIALOG_MAXIMUM_HEIGHT) {
                d.height = WindowUtils.DIALOG_MAXIMUM_HEIGHT - verticalInsets;
            }
        }
        return d;
    }

    private static void _resizeTable(JTable table, boolean allColumns) {
        int tableWidth = table.getParent() == null ? table.getWidth() : table.getParent().getWidth();
        int columnSize = 0;
        TableColumnModel model = table.getColumnModel();
        for (int i = 0; i < 5; ++i) {
            if (i != 4 || (columnSize += model.getColumn(i).getWidth()) >= tableWidth) continue;
            TableColumn lastColumn = table.getColumnModel().getColumn(i);
            int width = tableWidth - columnSize + lastColumn.getWidth();
            lastColumn.setWidth(width);
            lastColumn.setPreferredWidth(width);
        }
    }

    private static void _setLabelText(JLabel label, String text) {
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        label.setText(StringUtils.stripMnemonic((String)text));
    }

    private static void _setButtonText(AbstractButton button, String text) {
        OracleFileChooserUI._setButtonText(button, StringUtils.stripMnemonic((String)text), StringUtils.getMnemonicKeyCode((String)text));
    }

    private static void _setButtonText(AbstractButton button, String text, int mnemonic) {
        button.setText(text);
        button.setMnemonic(mnemonic);
    }

    private static void _setAccessibleName(JComponent component, String name) {
        component.getAccessibleContext().setAccessibleName(name);
    }

    private static JButton _createButton(Icon icon, Action action) {
        PushButton b = new PushButton(icon);
        b.addActionListener(action);
        b.setLeftmost(false);
        b.setRightmost(false);
        return b;
    }

    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JFileChooser chooser = OracleFileChooserUI.this.getFileChooser();
                    JList list = (JList)e.getSource();
                    if (OracleFileChooserUI.this._isMultiSelectionEnabled()) {
                        Object[] objects = list.getSelectedValues();
                        if (objects != null) {
                            Vector<File> files = new Vector<File>(objects.length);
                            if (objects.length == 1 && ((File)objects[0]).isDirectory() && !chooser.isDirectorySelectionEnabled()) {
                                OracleFileChooserUI.this.setDirectorySelected(true);
                                OracleFileChooserUI.this.setDirectory((File)objects[0]);
                                OracleFileChooserUI.this._setCurrentDirectory(null);
                            } else {
                                boolean isDirPresent = false;
                                for (int i = 0; i < objects.length; ++i) {
                                    File f = (File)objects[i];
                                    boolean isDir = f.isDirectory();
                                    if (isDir) {
                                        isDirPresent = true;
                                    }
                                    if ((!isDir || !chooser.isDirectorySelectionEnabled()) && (isDir || !chooser.isFileSelectionEnabled())) continue;
                                    files.addElement(f);
                                }
                                int size = files.size();
                                if (size == 0 && objects.length > 1 && !chooser.isDirectorySelectionEnabled() && isDirPresent) {
                                    OracleFileChooserUI.this.setDirectorySelected(true);
                                    OracleFileChooserUI.this.setDirectory((File)OracleFileChooserUI.this.getModel().getElementAt(OracleFileChooserUI.this._selectionModel.getLeadSelectionIndex()));
                                    OracleFileChooserUI.this._setCurrentDirectory(null);
                                } else {
                                    OracleFileChooserUI.this.setDirectorySelected(false);
                                    if (objects.length == 1) {
                                        OracleFileChooserUI.this._setCurrentDirectory((File)objects[0]);
                                    }
                                }
                                if (size != 0) {
                                    chooser.setSelectedFiles(files.toArray(new File[0]));
                                }
                            }
                        }
                    } else {
                        File file = (File)list.getSelectedValue();
                        if (file != null) {
                            boolean isDir = file.isDirectory();
                            if (isDir && !chooser.isDirectorySelectionEnabled()) {
                                OracleFileChooserUI.this.setDirectorySelected(true);
                                OracleFileChooserUI.this.setDirectory(file);
                                OracleFileChooserUI.this._setCurrentDirectory(null);
                            } else {
                                OracleFileChooserUI.this.setDirectorySelected(false);
                                OracleFileChooserUI.this._setCurrentDirectory(file);
                                if (isDir && chooser.isDirectorySelectionEnabled() || !isDir && chooser.isFileSelectionEnabled()) {
                                    chooser.setSelectedFile(file);
                                } else {
                                    chooser.setSelectedFile(null);
                                }
                            }
                        } else {
                            OracleFileChooserUI.this.setDirectorySelected(false);
                        }
                    }
                    OracleFileChooserUI.this._ensureIndexIsVisible(OracleFileChooserUI.this._selectionModel.getLeadSelectionIndex());
                }
            }
        };
    }

    static {
        _sShellFolderAvailable = ShellUtils.isShellFolderAvailable();
        String version = System.getProperty("java.version");
        _sJDK14orHigher = version == null ? false : !version.startsWith("1.3");
    }

    private class TypeAheadSelectionListData
    implements TypeAheadSelectionData {
        private TypeAheadSelectionListData() {
        }

        public boolean isSelectionAllowed(Object source) {
            return this.getSize(source) > 0;
        }

        public int getSize(Object source) {
            JList src = (JList)source;
            ListModel model = src.getModel();
            return model.getSize();
        }

        public void setSelectedIndex(int index, Object source) {
            JList src = (JList)source;
            src.setSelectedIndex(index);
            OracleFileChooserUI.this._ensureIndexIsVisible(index);
        }

        public int getSelectedIndex(Object source) {
            JList src = (JList)source;
            return src.getSelectedIndex();
        }

        public String getElementAt(int index, Object source) {
            JList src = (JList)source;
            ListModel model = src.getModel();
            Object o = model.getElementAt(index);
            if (o != null) {
                if (o instanceof File) {
                    return ((File)o).getName();
                }
                return o.toString();
            }
            return null;
        }
    }

    private class TypeAheadSelectionTableData
    implements TypeAheadSelectionData {
        private TypeAheadSelectionTableData() {
        }

        public boolean isSelectionAllowed(Object source) {
            JTable src = (JTable)source;
            return src.getRowCount() > 0 && src.getColumnSelectionAllowed() && !src.isEditing();
        }

        public int getSize(Object source) {
            JTable src = (JTable)source;
            return src.getRowCount();
        }

        public void setSelectedIndex(int index, Object source) {
            JTable src = (JTable)source;
            src.setRowSelectionInterval(index, index);
            OracleFileChooserUI.this._ensureIndexIsVisible(index);
        }

        public int getSelectedIndex(Object source) {
            JTable src = (JTable)source;
            return src.getSelectedRow();
        }

        public String getElementAt(int index, Object source) {
            JTable src = (JTable)source;
            Object o = src.getValueAt(index, 0);
            if (o != null) {
                return o.toString();
            }
            return null;
        }
    }

    private class KeyHandlerEditor
    extends JTextField {
        private KeyHandlerEditor() {
        }

        public void processComponentKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                e.consume();
            }
        }
    }

    private class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = OracleFileChooserUI.this.getFileChooser();
            File currentDirectory = fc.getCurrentDirectory();
            File newFolder = null;
            try {
                newFolder = fc.getFileSystemView().createNewFolder(currentDirectory);
                if (OracleFileChooserUI.this._isMultiSelectionEnabled()) {
                    fc.setSelectedFiles(new File[]{newFolder});
                } else {
                    fc.setSelectedFile(newFolder);
                }
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(fc, OracleFileChooserUI.this._newFolderErrorText + OracleFileChooserUI.this._newFolderErrorSeparator + exc, OracleFileChooserUI.this._newFolderErrorText, 0);
                return;
            }
            fc.rescanCurrentDirectory();
        }
    }

    private class DelayedSelectionListener
    implements ListDataListener,
    Runnable {
        private DelayedSelectionListener() {
        }

        public void contentsChanged(ListDataEvent e) {
            SwingUtilities.invokeLater(this);
        }

        public void intervalAdded(ListDataEvent e) {
            SwingUtilities.invokeLater(this);
        }

        public void intervalRemoved(ListDataEvent e) {
        }

        public void run() {
            OracleFileChooserUI.this.setFileSelected();
        }
    }

    private class NonNullSelComboBox
    extends JComboBox {
        public void setSelectedItem(Object item) {
            if (item != null) {
                super.setSelectedItem(item);
            }
        }
    }

    private class ColumnSelection
    extends DefaultListSelectionModel {
        private ColumnSelection() {
        }

        public void addSelectionInterval(int index0, int index1) {
            super.addSelectionInterval(0, 0);
        }

        public void setAnchorSelectionIndex(int index) {
            super.setAnchorSelectionIndex(0);
        }

        public void setLeadSelectionIndex(int index) {
            super.setLeadSelectionIndex(0);
        }

        public void setSelectionInterval(int index0, int index1) {
            super.setSelectionInterval(0, 0);
        }

        public boolean isSelectedIndex(int index) {
            return index == 0;
        }
    }

    private class NameEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    FocusListener,
    ActionListener {
        private DefaultTableCellRenderer _renderer;
        private JComponent _editingContainer;
        private JTextField _editingComponent = new JTextField();
        private int _offset;
        private Icon _editingIcon;

        public NameEditor(DefaultTableCellRenderer renderer) {
            this._renderer = renderer;
            this._editingContainer = new EditorContainer();
            this._editingContainer.add(this._editingComponent);
            this._editingComponent.addFocusListener(this);
            this._editingComponent.addActionListener(this);
        }

        public Object getCellEditorValue() {
            return this._editingComponent.getText();
        }

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                this.stopCellEditing();
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (!(anEvent instanceof MouseEvent)) {
                return false;
            }
            MouseEvent e = (MouseEvent)anEvent;
            if (e.getID() != 501) {
                return false;
            }
            Point p = new Point(e.getX(), e.getY());
            int row = OracleFileChooserUI.this._table.rowAtPoint(p);
            if (e.getClickCount() == 1) {
                if (OracleFileChooserUI.this.__lastIndex == row && !OracleFileChooserUI.this._table.isEditing()) {
                    e.consume();
                    OracleFileChooserUI.this.resetEditIndex();
                    return true;
                }
                OracleFileChooserUI.this.setEditIndex(row);
            } else if (e.getClickCount() == 2) {
                OracleFileChooserUI.this.resetEditIndex();
                File f = (File)OracleFileChooserUI.this.getModel().getElementAt(row);
                if (OracleFileChooserUI.this.getFileChooser().isTraversable(f)) {
                    OracleFileChooserUI.this.getFileChooser().setCurrentDirectory(f);
                } else {
                    OracleFileChooserUI.this.getFileChooser().approveSelection();
                }
                e.consume();
            } else {
                OracleFileChooserUI.this.resetEditIndex();
            }
            return false;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this._determineOffset(value);
            this._editingComponent.setText(value != null ? value.toString() : "");
            Font font = this._renderer.getFont();
            if (font == null) {
                font = OracleFileChooserUI.this._table.getFont();
            }
            this._editingContainer.setFont(font);
            this._editingComponent.setNextFocusableComponent(OracleFileChooserUI.this._table);
            return this._editingContainer;
        }

        private void _determineOffset(Object value) {
            this._editingIcon = ((IconAndString)value).icon;
            if (this._editingIcon != null) {
                this._offset = this._renderer.getIconTextGap() + this._editingIcon.getIconWidth();
            }
        }

        private class EditorContainer
        extends JComponent {
            public EditorContainer() {
                this.setLayout(null);
            }

            public void paint(Graphics g) {
                Dimension size = this.getSize();
                if (NameEditor.this._editingIcon != null) {
                    int yLoc = Math.max(0, (this.getSize().height - NameEditor.this._editingIcon.getIconHeight()) / 2);
                    g.setColor(OracleFileChooserUI.this._table.getSelectionBackground());
                    g.fillRect(0, yLoc, NameEditor.this._editingIcon.getIconWidth() + NameEditor.this._offset, NameEditor.this._editingIcon.getIconHeight());
                    NameEditor.this._editingIcon.paintIcon(this, g, 0, yLoc);
                }
                super.paint(g);
            }

            public void doLayout() {
                Dimension cSize = this.getSize();
                NameEditor.this._editingComponent.getPreferredSize();
                NameEditor.this._editingComponent.setBounds(NameEditor.this._offset, 0, cSize.width - NameEditor.this._offset, cSize.height);
            }
        }
    }

    private class NameRenderer
    extends DefaultTableCellRenderer {
        private NameRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0 && isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : noFocusBorder);
            this.setFont(table.getFont());
            this.setValue(value);
            return this;
        }

        protected void setValue(Object value) {
            if (value instanceof IconAndString) {
                IconAndString is = (IconAndString)value;
                this.setText(is.string);
                this.setIcon(is.icon);
            } else {
                super.setValue(value);
            }
        }
    }

    private class IconAndString {
        public final Icon icon;
        public final String string;

        public IconAndString(Icon icon, String string) {
            this.icon = icon;
            this.string = string;
        }

        public String toString() {
            return this.string;
        }
    }

    private class TableListener
    extends AbstractTableModel
    implements ListDataListener,
    ComponentListener {
        private DefaultTableModel _store;
        private NumberFormat _format;
        private DateFormat _df;
        private ResourceBundle _bundle;
        private final String _READONLY;
        private final String _HIDDEN;
        private final String _READONLY_AND_HIDDEN;

        public TableListener() {
            this._bundle = ResourceBundle.getBundle("oracle.bali.ewt.olaf.resource.OLAFBundle", OracleFileChooserUI.this.getFileChooser().getLocale());
            this._READONLY = this._bundle.getString(OracleFileChooserUI._KEY_READONLY);
            this._HIDDEN = this._bundle.getString(OracleFileChooserUI._KEY_HIDDEN);
            this._READONLY_AND_HIDDEN = this._bundle.getString(OracleFileChooserUI._KEY_READONLY_AND_HIDDEN);
            OracleFileChooserUI.this.getModel().addListDataListener(this);
            this._format = NumberFormat.getNumberInstance(OracleFileChooserUI.this.getFileChooser().getLocale());
            this._store = new DefaultTableModel(OracleFileChooserUI.this.getModel().getSize(), 5);
            this._df = DateFormat.getDateTimeInstance(3, 3, OracleFileChooserUI.this.getFileChooser().getLocale());
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return this._store.getRowCount();
        }

        public Object getValueAt(int row, int column) {
            Object data = null;
            if (row >= OracleFileChooserUI.this.getModel().getSize()) {
                return null;
            }
            data = this._store.getValueAt(row, column);
            if (data == null) {
                Object e = OracleFileChooserUI.this.getModel().getElementAt(row);
                File file = (File)e;
                switch (column) {
                    case 0: {
                        data = new IconAndString(OracleFileChooserUI.this.getFileChooser().getIcon(file), OracleFileChooserUI.this.getFileChooser().getName(file));
                        break;
                    }
                    case 1: {
                        if (file.isDirectory()) {
                            data = null;
                            break;
                        }
                        long size = file.length();
                        if (size < 1024L) {
                            data = size + " bytes";
                            break;
                        }
                        if (size < 0x100000L) {
                            double d = (double)size / 1024.0;
                            this._format.setMaximumFractionDigits(0);
                            data = this._format.format(d) + " KB";
                            break;
                        }
                        double d = (double)size / 1048576.0;
                        this._format.setMinimumFractionDigits(2);
                        this._format.setMaximumFractionDigits(2);
                        data = this._format.format(d) + " MB";
                        break;
                    }
                    case 2: {
                        data = OracleFileChooserUI.this.getFileChooser().getTypeDescription(file);
                        break;
                    }
                    case 3: {
                        data = this._df.format(new Date(file.lastModified()));
                        break;
                    }
                    case 4: {
                        String attributes = "";
                        boolean isReadOnly = !file.canWrite();
                        boolean isHidden = file.isHidden();
                        if (isReadOnly && isHidden) {
                            attributes = this._READONLY_AND_HIDDEN;
                        } else if (isReadOnly) {
                            attributes = this._READONLY;
                        } else if (isHidden) {
                            attributes = this._HIDDEN;
                        }
                        data = attributes;
                    }
                }
                this._store.setValueAt(data, row, column);
            }
            return data;
        }

        public void setValueAt(Object data, int row, int column) {
            String name = data == null ? null : data.toString();
            File f = (File)OracleFileChooserUI.this.getModel().getElementAt(row);
            OracleFileChooserUI.this._renameFile(f, name);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public void intervalAdded(ListDataEvent e) {
            for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                this._store.insertRow(i, (Object[])null);
            }
            this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }

        public void intervalRemoved(ListDataEvent e) {
            for (int i = e.getIndex1(); i >= e.getIndex0(); --i) {
                this._store.removeRow(i);
            }
            this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }

        public void contentsChanged(ListDataEvent e) {
            int newCount = OracleFileChooserUI.this.getModel().getSize();
            int oldCount = this._store.getRowCount();
            int diff = newCount - oldCount;
            if (oldCount != 0) {
                this._store.setNumRows(0);
            }
            if (newCount != 0) {
                this._store.setNumRows(newCount);
            }
            if (diff > 0) {
                this.fireTableRowsInserted(oldCount, newCount - 1);
            } else if (diff < 0) {
                this.fireTableRowsDeleted(newCount, oldCount - 1);
            }
            if (newCount != 0) {
                this.fireTableRowsUpdated(0, newCount - 1);
            }
        }

        public void componentResized(ComponentEvent e) {
            OracleFileChooserUI._resizeTable(OracleFileChooserUI.this._table, false);
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
            OracleFileChooserUI._resizeTable(OracleFileChooserUI.this._table, false);
        }

        public void componentHidden(ComponentEvent e) {
        }
    }

    private class ViewSwitch
    implements ItemListener {
        private ViewSwitch() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (e.getSource() == OracleFileChooserUI.this._listView) {
                    OracleFileChooserUI.this._switchToListView();
                } else if (e.getSource() == OracleFileChooserUI.this._detailsView) {
                    OracleFileChooserUI.this._switchToDetailsView();
                }
                OracleFileChooserUI.this._ensureIndexIsVisible(OracleFileChooserUI.this._selectionModel.getLeadSelectionIndex());
            }
        }
    }

    private class OracleDirectoryModel
    extends BasicDirectoryModel {
        private Collator _compare;

        public OracleDirectoryModel(JFileChooser filechooser) {
            super(filechooser);
            Locale l = LocaleUtils.getDefaultableLocale((Component)filechooser);
            this._compare = Collator.getInstance(l);
            this._compare.setStrength(0);
        }

        protected boolean lt(File a, File b) {
            String s2;
            String s1 = a.getName();
            return this._compare.compare(s1, s2 = b.getName()) < 0;
        }
    }

    private class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent e) {
            OracleFileChooserUI.this.getFileChooser().setCurrentDirectory((File)((JComboBox)e.getSource()).getSelectedItem());
        }
    }

    private class ShowPreviewAction
    extends AbstractAction {
        protected ShowPreviewAction() {
            super("ShowPreviewAction");
        }

        public void actionPerformed(ActionEvent e) {
            OracleFileChooserUI.this._previewPanel.setVisible(!OracleFileChooserUI.this._previewPanel.isVisible());
        }
    }

    private class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener,
    ComponentListener {
        private FileFilter[] _filters;

        public FilterComboBoxModel() {
            this._filters = OracleFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this._filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            } else if ("ancestor".equals(prop)) {
                if (OracleFileChooserUI.this._parent != null) {
                    OracleFileChooserUI.this._parent.removeComponentListener(this);
                }
                OracleFileChooserUI.this._parent = null;
                OracleFileChooserUI.this._startWidth = -1;
                OracleFileChooserUI.this._startHeight = -1;
                if (e.getNewValue() != null) {
                    OracleFileChooserUI.this._parent = WindowUtils.getWindow((Component)e.getSource());
                    if (OracleFileChooserUI.this._parent != null) {
                        OracleFileChooserUI.this._parent.addComponentListener(this);
                    }
                }
            }
        }

        public void componentResized(ComponentEvent e) {
            if (OracleFileChooserUI.this._startWidth == -1) {
                return;
            }
            Component c = e.getComponent();
            int width = c.getWidth();
            int height = c.getHeight();
            if (width < OracleFileChooserUI.this._startWidth || height < OracleFileChooserUI.this._startHeight) {
                if (width < OracleFileChooserUI.this._startWidth) {
                    width = OracleFileChooserUI.this._startWidth;
                }
                if (height < OracleFileChooserUI.this._startHeight) {
                    height = OracleFileChooserUI.this._startHeight;
                }
                c.setSize(width, height);
            }
        }

        public void componentShown(ComponentEvent e) {
            Component c = e.getComponent();
            OracleFileChooserUI.this._startWidth = c.getWidth();
            OracleFileChooserUI.this._startHeight = c.getHeight();
        }

        public void componentHidden(ComponentEvent e) {
            Container cont = (Container)e.getComponent();
            Insets i = cont.getInsets();
            OracleFileChooserUI.this._lastWidth = cont.getWidth();
            OracleFileChooserUI.this._lastHeight = cont.getHeight();
            if (i != null) {
                OracleFileChooserUI.this._lastWidth -= i.left + i.right;
                OracleFileChooserUI.this._lastHeight -= i.top + i.bottom;
            }
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                OracleFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter currentFilter = OracleFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this._filters.length; ++i) {
                    if (this._filters[i] != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    OracleFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return OracleFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this._filters != null) {
                return this._filters.length;
            }
            return 0;
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return OracleFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this._filters != null) {
                return this._filters[index];
            }
            return null;
        }
    }

    private class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        private FilterComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            FileFilter filter = (FileFilter)value;
            if (filter != null) {
                this.setText(filter.getDescription());
            }
            return this;
        }
    }

    private class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Vector _directories = new Vector();
        private int[] _depths = null;
        private File _selectedDirectory = null;
        private FileSystemView _fsv = OracleFileChooserUI.this.getFileChooser().getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = OracleFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            File f;
            if (directory == null) {
                return;
            }
            this._directories.clear();
            File[] baseFolders = null;
            baseFolders = OracleFileChooserUI.this.useShellFolder ? ShellUtils.getRoots() : this._fsv.getRoots();
            this._directories.addAll(Arrays.asList(baseFolders));
            File canonical = null;
            try {
                canonical = directory.getCanonicalFile();
            }
            catch (IOException e) {
                canonical = directory;
            }
            File sf = null;
            if (OracleFileChooserUI.this.useShellFolder) {
                sf = ShellUtils.getShellFolder(canonical);
            } else {
                try {
                    sf = this._fsv.createFileObject(directory.getCanonicalPath());
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            Vector<File> path = new Vector<File>(10);
            for (f = sf; f != null; f = f.getParentFile()) {
                path.addElement(f);
            }
            int pathCount = path.size();
            for (int i = 0; i < pathCount; ++i) {
                f = (File)path.get(i);
                if (!this._directories.contains(f)) continue;
                int topIndex = this._directories.indexOf(f);
                for (int j = i - 1; j >= 0; --j) {
                    this._directories.insertElementAt(path.get(j), topIndex + i - j);
                }
                break;
            }
            this.calculateDepths();
            this.setSelectedItem(sf);
        }

        private void calculateDepths() {
            this._depths = new int[this._directories.size()];
            block0: for (int i = 0; i < this._depths.length; ++i) {
                File dir = (File)this._directories.get(i);
                File parent = dir.getParentFile();
                this._depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals((File)this._directories.get(j))) continue;
                    this._depths[i] = this._depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this._depths != null && i >= 0 && i < this._depths.length ? this._depths[i] : 0;
        }

        public void setSelectedItem(Object _selectedDirectory) {
            this._selectedDirectory = (File)_selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this._selectedDirectory;
        }

        public int getSize() {
            return this._directories.size();
        }

        public Object getElementAt(int index) {
            return this._directories.elementAt(index);
        }
    }

    private class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer
    implements Icon {
        private Icon _icon;
        private int _depth;

        private DirectoryComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File directory = (File)value;
            if (directory == null) {
                this.setText("");
                return this;
            }
            String fileName = OracleFileChooserUI.this.getFileChooser().getName(directory);
            this.setText(fileName);
            this._icon = OracleFileChooserUI.this.getFileChooser().getIcon(directory);
            this._depth = OracleFileChooserUI.this._directoryComboBoxModel.getDepth(index);
            this.setIcon(this);
            return this;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this._icon.paintIcon(c, g, x + this._depth * 10, y);
        }

        public int getIconWidth() {
            return this._icon.getIconWidth() + this._depth * 10;
        }

        public int getIconHeight() {
            return this._icon.getIconHeight();
        }

        protected String paramString() {
            return "";
        }
    }

    private class FileRenderer
    extends DefaultListCellRenderer {
        private FileRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            String fileName = OracleFileChooserUI.this.getFileChooser().getName(file);
            this.setText(fileName);
            Icon icon = OracleFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (isSelected) {
                OracleFileChooserUI.this.__editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    private class SingleClickListener
    extends MouseAdapter
    implements ActionListener,
    FocusListener,
    Runnable {
        private JList _list;

        public SingleClickListener(JList list) {
            this._list = list;
            OracleFileChooserUI.this.__editCell = new KeyHandlerEditor();
            OracleFileChooserUI.this.__editCell.addActionListener(this);
            OracleFileChooserUI.this.__editCell.addFocusListener(this);
            OracleFileChooserUI.this.__editCell.setNextFocusableComponent(this._list);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1) {
                int index = this._list.locationToIndex(e.getPoint());
                JFileChooser fc = OracleFileChooserUI.this.getFileChooser();
                if (!(OracleFileChooserUI.this._isMultiSelectionEnabled() && fc.getSelectedFiles().length > 1 || index < 0 || OracleFileChooserUI.this.__lastIndex != index || OracleFileChooserUI.this.__editing)) {
                    File f = (File)this._list.getSelectedValue();
                    if (f != null) {
                        OracleFileChooserUI.this.__editing = true;
                        Rectangle r = this._list.getCellBounds(index, index);
                        this._list.add(OracleFileChooserUI.this.__editCell);
                        OracleFileChooserUI.this.__editCell.setText(fc.getName(f));
                        OracleFileChooserUI.this.__editCell.setFont(this._list.getFont());
                        OracleFileChooserUI.this.__editCell.setBounds(OracleFileChooserUI.this.__editX + r.x, r.y, r.width - OracleFileChooserUI.this.__editX, r.height);
                        OracleFileChooserUI.this.__editCell.requestFocus();
                        OracleFileChooserUI.this.__editCell.selectAll();
                    }
                } else {
                    if (index >= 0) {
                        OracleFileChooserUI.this.setEditIndex(index);
                    } else {
                        OracleFileChooserUI.this.resetEditIndex();
                    }
                    OracleFileChooserUI.this.cancelEdit();
                }
            } else {
                OracleFileChooserUI.this.resetEditIndex();
                OracleFileChooserUI.this.cancelEdit();
            }
            this._list.repaint();
        }

        public void actionPerformed(ActionEvent e) {
            JTextField tf = (JTextField)e.getSource();
            File f = (File)this._list.getSelectedValue();
            String newFileName = tf.getText();
            OracleFileChooserUI.this._renameFile(f, newFileName);
            OracleFileChooserUI.this.resetEditIndex();
            OracleFileChooserUI.this.cancelEdit();
            this._list.requestFocus();
            this._list.repaint();
        }

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void run() {
            if (OracleFileChooserUI.this.__lastIndex != -1) {
                OracleFileChooserUI.this._renameFile((File)this._list.getModel().getElementAt(OracleFileChooserUI.this.__lastIndex), OracleFileChooserUI.this.__editCell.getText());
            }
            OracleFileChooserUI.this.resetEditIndex();
            OracleFileChooserUI.this.cancelEdit();
            this._list.repaint();
        }
    }

    private class KeyEventHandler
    extends KeyAdapter {
        private KeyEventHandler() {
        }

        public void keyTyped(KeyEvent ke) {
            if (ke.getSource() == OracleFileChooserUI.this._filenameTextField && OracleFileChooserUI.this._curentDirectory != null) {
                OracleFileChooserUI.this._setCurrentDirectory(null);
            }
        }

        public void keyPressed(KeyEvent ke) {
            Object eventSource = ke.getSource();
            if ((eventSource == OracleFileChooserUI.this._list || eventSource == OracleFileChooserUI.this._table) && ke.getKeyCode() == 10) {
                File dir;
                if (ke.getModifiers() != 2) {
                    return;
                }
                JFileChooser fc = OracleFileChooserUI.this.getFileChooser();
                if (fc.isDirectorySelectionEnabled() && (dir = (File)OracleFileChooserUI.this._list.getSelectedValue()) != null && dir.isDirectory()) {
                    fc.setCurrentDirectory(dir);
                    ke.consume();
                }
            }
        }
    }

    private class ListEditCancel
    extends AbstractAction {
        private ListEditCancel() {
        }

        public boolean isEnabled() {
            return OracleFileChooserUI.this.__editCell == null ? false : OracleFileChooserUI.this.__editCell.isShowing();
        }

        public void actionPerformed(ActionEvent e) {
            OracleFileChooserUI.this.cancelEdit();
            OracleFileChooserUI.this.resetEditIndex();
            OracleFileChooserUI.this._list.requestFocus();
            OracleFileChooserUI.this._list.repaint();
        }
    }
}

