/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import oracle.bali.ewt.layout.DelegatingLayout;

public class HidingLayout
extends DelegatingLayout {
    private LayoutManager _containedLayout = null;

    public HidingLayout(LayoutManager containedLayout) {
        if (containedLayout == null) {
            throw new IllegalArgumentException();
        }
        this._containedLayout = containedLayout;
    }

    public LayoutManager getContainedLayout() {
        return this._containedLayout;
    }

    public void layoutContainer(Container target) {
        super.layoutContainer(target);
        int numChildren = target.getComponentCount();
        for (int i = 0; i < numChildren; ++i) {
            Component currChild = target.getComponent(i);
            if (!this.shrinkComponent(target, currChild)) continue;
            currChild.setSize(0, 0);
        }
    }

    protected boolean shrinkComponent(Container target, Component child) {
        if (child.isVisible()) {
            Dimension targetSize = target.getSize();
            Insets targetInsets = target.getInsets();
            targetSize.width -= targetInsets.right;
            targetSize.height -= targetInsets.bottom;
            Rectangle currBounds = child.getBounds();
            if (currBounds.x + currBounds.width > targetSize.width || currBounds.y + currBounds.height > targetSize.height) {
                return true;
            }
        }
        return false;
    }
}

