/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.FocusUtils;

public class TextFieldInputHandler
extends CellInputHandler {
    boolean _dirty;
    private JTextField _textField;
    private String _initText = null;
    private static TextFieldInputHandler _sInputHandler;

    public final JTextField getJTextField() {
        return (JTextField)this.getEditControl(null, -1, -1);
    }

    public void updateUI() {
        if (this._textField != null) {
            SwingUtilities.updateComponentTreeUI(this._textField);
        }
    }

    public void focusGained(AWTEvent why, Grid grid, int column, int row) {
        if (why instanceof MouseEvent) {
            grid.startCellEdit(column, row);
        }
    }

    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        super.mousePressed(e, grid, column, row);
        Cell focusCell = grid.getFocusCell();
        if (focusCell != null && focusCell.column == column && focusCell.row == row && SwingUtilities.isLeftMouseButton(e)) {
            grid.startCellEdit(column, row);
        }
    }

    public void keyPressed(KeyEvent ke, Grid grid, int column, int row) {
        super.keyPressed(ke, grid, column, row);
        if (!FocusUtils.areNewFocusAPIsAvailable() && ke.getKeyCode() == 127) {
            JTextField control = this.getJTextField();
            if (control.isEditable()) {
                this._initText = "";
            }
            grid.startCellEdit(column, row);
            ke.consume();
        }
    }

    public void keyTyped(KeyEvent e, Grid grid, int column, int row) {
        super.keyTyped(e, grid, column, row);
        JTextField control = this.getJTextField();
        if (control.isEditable()) {
            char c = e.getKeyChar();
            this._initText = c == '\b' || c == '\u007f' ? "" : String.valueOf(c);
        } else {
            control.selectAll();
        }
        e.consume();
    }

    public synchronized Component getEditControl(Grid grid, int column, int row) {
        if (this._textField == null) {
            this._textField = this.createTextField();
            this._initTextField(this._textField);
            this._addKeyListener(this._textField);
        }
        return this._textField;
    }

    public boolean isDirty(Grid grid, int column, int row) {
        return this._dirty;
    }

    public void startEdit(Grid grid, int column, int row, Object data) {
        JTextField field = this.getJTextField();
        if (this._initText == null) {
            field.setText((String)data);
            if (data != null) {
                field.selectAll();
            }
            this._dirty = false;
        } else if ("".equals(this._initText)) {
            field.setText(this._initText);
            this._dirty = true;
        } else {
            field.setText(this._initText);
            String text = field.getText();
            if (text == null || "".equals(text)) {
                field.setText((String)data);
                if (data != null) {
                    field.selectAll();
                }
                this._initText = null;
                this._dirty = false;
            }
        }
    }

    public synchronized Object commitEdit(Grid grid, int column, int row) {
        JTextField edit = this.getJTextField();
        String data = edit.getText();
        return data;
    }

    public static CellInputHandler getCellInputHandler() {
        if (_sInputHandler == null) {
            _sInputHandler = TextFieldInputHandler.createTextFieldInputHandler();
        }
        return _sInputHandler;
    }

    public static TextFieldInputHandler createTextFieldInputHandler() {
        return new TextFieldInputHandler();
    }

    public static TextFieldInputHandler createTextFieldInputHandler(JTextField textField) {
        return new TextFieldInputHandler(textField);
    }

    protected TextFieldInputHandler() {
        this(null);
    }

    protected TextFieldInputHandler(JTextField textField) {
        if (textField != null) {
            this._textField = textField;
            this._initTextField(textField);
            this._addKeyListener(textField);
        }
    }

    protected JTextField createTextField() {
        return new JTextField();
    }

    private void _initTextField(JTextField textField) {
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        Dirty d = new Dirty();
        textField.getKeymap().removeKeyStrokeBinding(enterKey);
        textField.getDocument().addDocumentListener(d);
        if (textField.getBorder() instanceof UIResource) {
            textField.setBorder(new EmptyBorder(0, 2, 0, 0));
        }
        textField.addFocusListener(d);
    }

    private void _addKeyListener(JTextField textField) {
        textField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    e.consume();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    e.consume();
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private class Dirty
    extends FocusAdapter
    implements DocumentListener {
        private Dirty() {
        }

        public void insertUpdate(DocumentEvent e) {
            TextFieldInputHandler.this._dirty = true;
        }

        public void removeUpdate(DocumentEvent e) {
            TextFieldInputHandler.this._dirty = true;
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void focusGained(FocusEvent e) {
            JTextField textField = (JTextField)e.getSource();
            if (TextFieldInputHandler.this._initText != null && textField.getText().length() == 1) {
                textField.select(1, 1);
            }
            TextFieldInputHandler.this._initText = null;
        }
    }
}

