/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import javax.swing.JTextField;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.TextFieldInputHandler;
import oracle.bali.ewt.text.NumberTextField;

public class NumberInputHandler
extends TextFieldInputHandler {
    public NumberInputHandler() {
    }

    public NumberInputHandler(NumberTextField field) {
        super(field);
    }

    public final NumberTextField getNumberTextField() {
        return (NumberTextField)this.getEditControl(null, -1, -1);
    }

    public void startEdit(Grid grid, int column, int row, Object data) {
        if (data != null && !(data instanceof Number)) {
            throw new IllegalArgumentException("data " + data + " must be a number");
        }
        NumberTextField field = this.getNumberTextField();
        if (data != null) {
            field.setDataType(data.getClass());
            field.setNumber((Number)data);
        }
        super.startEdit(grid, column, row, data == null ? null : this.getNumberTextField().getText());
    }

    public Object commitEdit(Grid grid, int column, int row) {
        NumberTextField field = this.getNumberTextField();
        return field.getNumber();
    }

    public static CellInputHandler getCellInputHandler() {
        return new NumberInputHandler();
    }

    protected NumberTextField createNumberTextField() {
        return new NumberTextField();
    }

    protected final JTextField createTextField() {
        return this.createNumberTextField();
    }
}

