/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public class FontUtils {
    private static Font _defaultDialogFont;
    private static Font _defaultSansSerifFont;
    private static Font _defaultSerifFont;
    private static Font _defaultMonospacedFont;
    private static Font _defaultDialogInputFont;

    private FontUtils() {
    }

    public static Font deriveFontUsingStyle(Font baseFont, int derivingStyle, int derivedStyles) {
        int currStyle = baseFont.getStyle();
        int newStyle = currStyle & ~derivedStyles | derivingStyle & derivedStyles;
        if (newStyle == currStyle) {
            return baseFont;
        }
        return new Font(baseFont.getName(), newStyle, baseFont.getSize());
    }

    public static Font getDefaultDialogFont() {
        if (_defaultDialogFont == null) {
            _defaultDialogFont = new Font("Dialog", 0, 12);
        }
        return _defaultDialogFont;
    }

    public static Font getDefaultSansSerifFont() {
        if (_defaultSansSerifFont == null) {
            _defaultSansSerifFont = new Font("SansSerif", 0, 12);
        }
        return _defaultSansSerifFont;
    }

    public static Font getDefaultSerifFont() {
        if (_defaultSerifFont == null) {
            _defaultSerifFont = new Font("Serif", 0, 12);
        }
        return _defaultSerifFont;
    }

    public static Font getDefaultMonospacedFont() {
        if (_defaultMonospacedFont == null) {
            _defaultMonospacedFont = new Font("Monospaced", 0, 12);
        }
        return _defaultMonospacedFont;
    }

    public static Font getDefaultDialogInputFont() {
        if (_defaultDialogInputFont == null) {
            _defaultDialogInputFont = new Font("DialogInput", 0, 12);
        }
        return _defaultDialogInputFont;
    }

    public static final int getAverageWidth(Font font) {
        return FontUtils.getAverageWidth(Toolkit.getDefaultToolkit().getFontMetrics(font));
    }

    public static int getAverageWidth(FontMetrics metrics) {
        return metrics.charWidth('e');
    }

    public static final int getMinimumWidth(Font font) {
        return FontUtils.getMinimumWidth(Toolkit.getDefaultToolkit().getFontMetrics(font));
    }

    public static int getMinimumWidth(FontMetrics metrics) {
        return metrics.charWidth('.');
    }
}

