/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.geometry;

import oracle.bali.ewt.geometry.AbstractWrappingGeometryManager;
import oracle.bali.ewt.geometry.GeometryManager;
import oracle.bali.share.collection.Range;

public class ReversedGeometryManager
extends AbstractWrappingGeometryManager {
    public ReversedGeometryManager(GeometryManager geometryManager) {
        super(geometryManager);
    }

    public int getItemPosition(int modelIndex) {
        int pos = super.getItemPosition(modelIndex) + super.getItemSize(modelIndex);
        return this._reverseLocation(pos);
    }

    public int getItemAt(int location) {
        location = this._reverseLocation(location);
        int result = super.getItemAt(location);
        return result;
    }

    public void setItemVisibleIndex(int modelIndex, int visibleIndex) {
        super.setItemVisibleIndex(modelIndex, this._reverseVIndex(visibleIndex));
    }

    public int getItemVisibleIndex(int modelIndex) {
        return this._reverseVIndex(super.getItemVisibleIndex(modelIndex));
    }

    public int visibleIndexToIndex(int visibleIndex) {
        return super.visibleIndexToIndex(this._reverseVIndex(visibleIndex));
    }

    public Range[] visibleRangesToRanges(Range[] visibleRanges) {
        Range[] newRanges = new Range[visibleRanges.length];
        for (int i = 0; i < visibleRanges.length; ++i) {
            int low = this._reverseVIndex(visibleRanges[i].getLowerLimit());
            int high = this._reverseVIndex(visibleRanges[i].getUpperLimit());
            if (high < low) {
                int tmp = high;
                high = low;
                low = tmp;
            }
            newRanges[i] = new Range(low, high);
        }
        return super.visibleRangesToRanges(newRanges);
    }

    public Range[] rangesToVisibleRanges(Range[] modelRanges) {
        Range[] result = super.rangesToVisibleRanges(modelRanges);
        for (int i = 0; i <= result.length / 2 + 1; ++i) {
            int j = result.length - 1 - i;
            Range r1 = result[i];
            Range r2 = result[j];
            if (i <= j) {
                result[i] = new Range(this._reverseVIndex(r2.getUpperLimit()), this._reverseVIndex(r2.getLowerLimit()));
            }
            if (i >= j) continue;
            result[j] = new Range(this._reverseVIndex(r1.getUpperLimit()), this._reverseVIndex(r2.getLowerLimit()));
        }
        return result;
    }

    private int _reverseVIndex(int src) {
        return this.getVisibleItemCount() - 1 - src;
    }

    private int _reverseDSIndex(int src) {
        return this.getItemCount() - 1 - src;
    }

    private int _reverseLocation(int location) {
        return this.getTotalSize() - 1 - location;
    }
}

