/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.geometry;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.ewt.geometry.GeometryEvent;
import oracle.bali.ewt.geometry.GeometryListener;
import oracle.bali.ewt.geometry.GeometryManager;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.share.collection.Range;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.sort.Sort;

public abstract class AbstractGeometryManager
implements GeometryManager {
    private GeometryChangeListener _listener;
    private ListenerManager _manager;
    private boolean _resizing;

    protected AbstractGeometryManager() {
    }

    public void setResizing(boolean resizing) {
        this._resizing = resizing;
    }

    public boolean isResizing() {
        return this._resizing;
    }

    public OneDModelListener getOneDModelListener() {
        if (this._listener == null) {
            this._listener = new GeometryChangeListener();
        }
        return this._listener;
    }

    protected void itemsAdded(int startIndex, int numberOfItems) {
    }

    protected void itemsRemoved(int startIndex, int numberOfItems) {
    }

    public abstract void resetAll(int var1);

    public abstract int getItemPosition(int var1);

    public abstract int getItemAt(int var1);

    public abstract void setTotalSize(int var1);

    public abstract int getTotalSize();

    public abstract void setItemVisible(int var1, boolean var2);

    public abstract boolean isItemVisible(int var1);

    public abstract void setItemVisibleIndex(int var1, int var2);

    public abstract void setItemSize(int var1, int var2);

    public abstract int getItemSize(int var1);

    public abstract int getSeparatorSize();

    public abstract void setSeparatorSize(int var1);

    public abstract int getItemCount();

    public abstract int getVisibleItemCount();

    public abstract int getItemVisibleIndex(int var1);

    public abstract int visibleIndexToIndex(int var1);

    public Range[] visibleRangesToRanges(Range[] visibleRanges) {
        return this._transform(visibleRanges, true);
    }

    public Range[] rangesToVisibleRanges(Range[] modelRanges) {
        return this._transform(modelRanges, false);
    }

    public abstract void setDefaultItemSize(int var1);

    public abstract int getDefaultItemSize();

    public abstract boolean isItemResizable(int var1);

    public abstract int getMinimumItemSize(int var1);

    public abstract int getMaximumItemSize(int var1);

    private int _transformIndex(int index, boolean vtom) {
        if (vtom) {
            return this.visibleIndexToIndex(index);
        }
        return this.getItemVisibleIndex(index);
    }

    private Range[] _transform(Range[] ranges, boolean vtom) {
        int i;
        if (ranges.length == 1 && ranges[0].getLowerLimit() == ranges[0].getUpperLimit()) {
            int s = this._transformIndex(ranges[0].getLowerLimit(), vtom);
            return new Range[]{new Range(s, s)};
        }
        Vector<Object> resultVector = new Vector<Object>();
        int total = 0;
        for (i = 0; i < ranges.length; ++i) {
            int[] resultArray = this._transformRange(ranges[i], vtom);
            resultVector.addElement(resultArray);
            total += resultArray.length;
        }
        int[] singles = new int[total];
        total = 0;
        for (i = 0; i < resultVector.size(); ++i) {
            int[] src = (int[])resultVector.elementAt(i);
            System.arraycopy(src, 0, singles, total, src.length);
            total += src.length;
        }
        Sort.qSort((int[])singles, (int)singles.length, (boolean)true);
        resultVector = new Vector();
        int lo = -1;
        int hi = -1;
        for (i = 0; i < singles.length; ++i) {
            if (singles[i] < 0) continue;
            if (lo == -1 && hi == -1) {
                lo = singles[i];
                hi = singles[i];
                continue;
            }
            if (singles[i] == hi + 1) {
                hi = singles[i];
                continue;
            }
            resultVector.addElement(new Range(lo, hi));
            lo = singles[i];
            hi = singles[i];
        }
        if (lo != -1 && hi != -1) {
            resultVector.addElement(new Range(lo, hi));
        }
        Object[] result = new Range[resultVector.size()];
        resultVector.copyInto(result);
        return result;
    }

    private int[] _transformRange(Range r, boolean vtom) {
        int low = r.getLowerLimit();
        int high = r.getUpperLimit();
        int count = high - low + 1;
        int[] singles = new int[count];
        for (int i = low; i <= high; ++i) {
            singles[i - low] = this._transformIndex(i, vtom);
        }
        return singles;
    }

    public void addGeometryListener(GeometryListener listener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener((EventListener)listener);
    }

    public void removeGeometryListener(GeometryListener listener) {
        if (this._manager != null) {
            this._manager.removeListener((EventListener)listener);
        }
    }

    protected void fireGeometryEvent(int eventID, int item, int changeValue) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumer = this._manager.getListeners();
        if (enumer == null) {
            return;
        }
        GeometryEvent event = new GeometryEvent(this, eventID, item, changeValue);
        while (enumer.hasMoreElements()) {
            GeometryListener listener = (GeometryListener)enumer.nextElement();
            listener.geometryChanged(event);
        }
    }

    private class GeometryChangeListener
    implements OneDModelListener {
        private GeometryChangeListener() {
        }

        public void invalidateItems(OneDModelEvent e) {
        }

        public void itemsAdded(OneDModelEvent e) {
            AbstractGeometryManager.this.itemsAdded(e.getStartIndex(), e.getItemCount());
        }

        public void itemsRemoved(OneDModelEvent e) {
            AbstractGeometryManager.this.itemsRemoved(e.getStartIndex(), e.getItemCount());
        }
    }
}

