/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.elaf.EWTHeaderUI;
import oracle.bali.ewt.elaf.basic.BasicEWTTableUI;
import oracle.bali.ewt.elaf.windows.WindowsCornerComponentPainter;
import oracle.bali.ewt.elaf.windows.WindowsInsetBorderPainter;
import oracle.bali.ewt.elaf.windows.WindowsTableGeometryHelper;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.table.SpreadTable;

public class WindowsEWTTableUI
extends BasicEWTTableUI {
    private static final Border _BORDER = new BorderAdapter(new WindowsInsetBorderPainter(false));
    private static Painter[] _sCornerPainters = new Painter[4];
    private static WindowsEWTTableUI _sInstance;

    protected WindowsEWTTableUI() {
    }

    public static ComponentUI createUI(JComponent component) {
        if (_sInstance == null) {
            _sInstance = new WindowsEWTTableUI();
        }
        return _sInstance;
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("EWTTable.border".equals(key)) {
            return _BORDER;
        }
        if ("EWTTable.scrollPaneBorder".equals(key)) {
            return _BORDER;
        }
        return null;
    }

    public Painter getCornerPainter(JComponent component, int corner) {
        Painter painter = null;
        if (corner >= 0 && corner <= 3) {
            painter = _sCornerPainters[corner];
            if (painter == null) {
                painter = new WindowsCornerComponentPainter(KEY_DRAW_RAISED, true, corner);
            }
            WindowsEWTTableUI._sCornerPainters[corner] = painter;
        }
        if (painter == null) {
            painter = NullPainter.getPainter();
        }
        return painter;
    }

    public void updateGeometry(JComponent component) {
        SpreadTable table = (SpreadTable)component;
        BorderPainter bp = null;
        if (table.isRowHeaderVisible()) {
            Header header = table.getRowHeader();
            bp = ((EWTHeaderUI)UIManager.getUI(header)).getHeaderItemBorderPainter(header);
        }
        WindowsTableGeometryHelper.updateGeometry((SpreadTable)component, bp);
    }

    public int getDefaultColumnHeaderHeight(JComponent component) {
        SpreadTable table = (SpreadTable)component;
        if (table.isRowHeaderVisible()) {
            return table.getGrid().getDefaultRowHeight();
        }
        return table.getGrid().getDefaultRowHeight() + 2 + 2;
    }
}

