/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.print.PrinterGraphics;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class PivotGrippyPainter
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 5;
    private static final int _GRIPPY_GAP = -1;
    private static final int _GRIPPY_STRIDE = 4;
    private static final int _MIN_GRIPPIES = 3;
    private static final int _MIN_PERP_GRIPPY_SIZE = 9;
    private static final int _MIN_ORIENT_GRIPPY_SIZE = 13;
    private static Painter _sPainter;

    public static Painter getPainter() {
        if (_sPainter == null) {
            _sPainter = new PivotGrippyPainter();
        }
        return _sPainter;
    }

    public Dimension getSize(PaintContext context, int width, int height) {
        if (width > 9) {
            width = 9;
        }
        if (height > 13) {
            height = 13;
        }
        return new Dimension(width, height);
    }

    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(9, 13);
    }

    public int getRepaintFlags(PaintContext context) {
        return 131;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        boolean paint;
        int state;
        boolean printing;
        Color savedColor = g.getColor();
        boolean bl = printing = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        if (!printing) {
            Color grippyColor = UIManager.getColor("EWTPivotPivotGrippy.background");
            g.setColor(grippyColor);
            g.fillRect(x, y, width, height);
            grippyColor = UIManager.getColor("EWTPivotPivotGrippy.border");
            g.setColor(grippyColor);
            g.drawRect(x, y, width, height);
        }
        boolean enabled = ((state = context.getPaintState()) & 1) == 0;
        boolean bl2 = paint = printing ? false : enabled;
        if (paint) {
            boolean isArmed;
            int numGrippies = 3;
            int grippySize = numGrippies * 5 + (numGrippies - 1) * -1;
            int grippyWidth = 5;
            int grippyHeight = grippySize;
            int yOffset = 4;
            int grippyX = x + (width - grippyWidth) / 2;
            int grippyY = y + (height - grippyHeight) / 2;
            int topRightCornerX = grippyX + grippyWidth - 1;
            int topRightCornerY = grippyY;
            int bottomLeftCornerX = grippyX;
            int bottomLeftCornerY = grippyY + grippyHeight - 1;
            int numTopRightCornerDots = 1;
            int numBottomLeftCornerDots = 1;
            UIDefaults defaults = context.getPaintUIDefaults();
            Color highlight = Color.white;
            Color dark = defaults.getColor("PivotTable.darkGrippy");
            boolean bl3 = isArmed = (state & 2) != 0;
            while (numGrippies > 0) {
                PivotGrippyPainter.__drawGrippys(g, grippyX, grippyY, 5, highlight, dark, isArmed);
                --numGrippies;
                grippyY += yOffset;
            }
            PivotGrippyPainter.__drawGrippys(g, topRightCornerX, topRightCornerY, numTopRightCornerDots, highlight, dark, isArmed);
            PivotGrippyPainter.__drawGrippys(g, bottomLeftCornerX, bottomLeftCornerY, numBottomLeftCornerDots, highlight, dark, isArmed);
        }
        g.setColor(savedColor);
    }

    static void __drawGrippys(Graphics g, int x, int y, int length, Color highlight, Color dark, boolean isArmed) {
        int darkDots = 0;
        darkDots = length % 2 == 0 ? length / 2 : (length + 1) / 2;
        int whiteDots = length - darkDots;
        if (isArmed) {
            int i;
            g.setColor(highlight);
            int tempX = x;
            int tempY = y;
            for (i = 0; i < darkDots; ++i) {
                g.drawLine(tempX, tempY, tempX, tempY);
                tempX += 2;
                tempY += 2;
            }
            g.setColor(dark);
            ++x;
            ++y;
            for (i = 0; i < whiteDots; ++i) {
                g.drawLine(x, y, x, y);
                x += 2;
                y += 2;
            }
        } else {
            int i;
            g.setColor(dark);
            int tempX = x;
            int tempY = y;
            for (i = 0; i < darkDots; ++i) {
                g.drawLine(tempX, tempY, tempX, tempY);
                tempX += 2;
                tempY += 2;
            }
            g.setColor(highlight);
            ++x;
            ++y;
            for (i = 0; i < whiteDots; ++i) {
                g.drawLine(x, y, x, y);
                x += 2;
                y += 2;
            }
        }
    }

    private PivotGrippyPainter() {
    }
}

