/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.ColorChange;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class DateEditorPainter
extends ColorChange {
    public DateEditorPainter(Painter wrappedPainter) {
        super(wrappedPainter);
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        g.setColor(this._getFillColor(context));
        Dimension d = super.getSize(context, width, height);
        g.fillRect(x, y, d.width, d.height);
        if (savedColor != null) {
            g.setColor(savedColor);
        }
        super.paint(context, g, x, y, width, height);
    }

    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 0x2000;
    }

    protected Color getColor(PaintContext context) {
        boolean hasFocus;
        UIDefaults defaults = context.getPaintUIDefaults();
        int state = context.getPaintState();
        boolean disabled = (state & 1) != 0;
        boolean active = (state & 4) == 0;
        boolean bl = hasFocus = (state & 0x40) != 0;
        if (disabled) {
            return defaults.getColor("textInactiveText");
        }
        if (hasFocus) {
            return defaults.getColor("textHighlightText");
        }
        return context.getPaintForeground();
    }

    private Color _getFillColor(PaintContext context) {
        int state = context.getPaintState();
        boolean active = (state & 4) == 0;
        boolean hasFocus = (state & 0x40) != 0;
        boolean disabled = (state & 1) != 0;
        UIDefaults defaults = context.getPaintUIDefaults();
        if (!disabled && hasFocus) {
            return defaults.getColor("textHighlight");
        }
        return context.getPaintBackground();
    }
}

