/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import oracle.bali.ewt.button.ContinuousButtonModel;
import oracle.bali.ewt.elaf.EWTSpinButtonUI;
import oracle.bali.ewt.spinBox.SpinAccelerator;
import oracle.bali.ewt.spinBox.SpinButton;

public abstract class BasicEWTSpinButtonUI
extends EWTSpinButtonUI {
    AbstractButton _increment;
    AbstractButton _decrement;
    SpinButton _spinner;
    private Internal _internal;
    private static final String _INCREMENT_NAME = "Increment_Button";
    private static final String _DECREMENT_NAME = "Decrement_Button";

    public void installUI(JComponent component) {
        this._spinner = (SpinButton)component;
        this._increment = this.createIncrementButton(component);
        this._decrement = this.createDecrementButton(component);
        this._increment.setName(_INCREMENT_NAME);
        this._decrement.setName(_DECREMENT_NAME);
        this._increment.setModel(new Model(this._increment));
        this._decrement.setModel(new Model(this._decrement));
        this._updateEnabled();
        component.add(this._increment);
        component.add(this._decrement);
        this._internal = new Internal();
        this._spinner.addPropertyChangeListener(this._internal);
        this._spinner.setLayout(this._internal);
    }

    public void uninstallUI(JComponent component) {
        this._spinner.removePropertyChangeListener(this._internal);
        this._spinner.setLayout(null);
        component.remove(this._increment);
        component.remove(this._decrement);
        ContinuousButtonModel model = (ContinuousButtonModel)this._increment.getModel();
        model.stopTimer();
        model = (ContinuousButtonModel)this._decrement.getModel();
        model.stopTimer();
        this._spinner = null;
        this._increment = null;
        this._decrement = null;
    }

    protected BasicEWTSpinButtonUI() {
    }

    public AbstractButton getIncrementButton(JComponent component) {
        return this._increment;
    }

    public AbstractButton getDecrementButton(JComponent component) {
        return this._decrement;
    }

    protected abstract AbstractButton createIncrementButton(JComponent var1);

    protected abstract AbstractButton createDecrementButton(JComponent var1);

    void _updateEnabled() {
        boolean enabled;
        SpinButton spinner = this._spinner;
        boolean bl = enabled = spinner.isEnabled() && spinner.isIncrementEnabled();
        if (!enabled) {
            this._increment.getModel().setPressed(false);
            this._increment.getModel().setArmed(false);
        }
        this._increment.setEnabled(enabled);
        boolean bl2 = enabled = spinner.isEnabled() && spinner.isDecrementEnabled();
        if (!enabled) {
            this._decrement.getModel().setPressed(false);
            this._decrement.getModel().setArmed(false);
        }
        this._decrement.setEnabled(enabled);
    }

    private class Model
    extends ContinuousButtonModel {
        public Model(AbstractButton button) {
            super(button);
        }

        public SpinAccelerator getAccelerator() {
            return BasicEWTSpinButtonUI.this._spinner.getAccelerator();
        }

        protected void processPulse() {
            int type = this.getButton() == BasicEWTSpinButtonUI.this._increment ? 1 : 2;
            BasicEWTSpinButtonUI.this._spinner.fireSpinButtonEvent(type);
        }
    }

    private class Internal
    implements LayoutManager,
    PropertyChangeListener {
        private Internal() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension incrementSize = BasicEWTSpinButtonUI.this._increment.getPreferredSize();
            Dimension decrementSize = BasicEWTSpinButtonUI.this._decrement.getPreferredSize();
            return new Dimension(Math.max(incrementSize.width, decrementSize.width), incrementSize.height + decrementSize.height);
        }

        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            int width = size.width;
            int height = size.height;
            BasicEWTSpinButtonUI.this._increment.setBounds(0, 0, width, height /= 2);
            BasicEWTSpinButtonUI.this._decrement.setBounds(0, height, width, height);
        }

        public void propertyChange(PropertyChangeEvent event) {
            String name = event.getPropertyName();
            if (name == null || "enabled".equals(name) || "incrementEnabled".equals(name) || "decrementEnabled".equals(name)) {
                BasicEWTSpinButtonUI.this._updateEnabled();
            } else if ("incrementArmed".equals(name)) {
                if (Boolean.TRUE.equals(event.getNewValue())) {
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._decrement.getModel()).setArmedState(false);
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._increment.getModel()).setArmedState(true);
                } else {
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._increment.getModel()).setArmedState(false);
                }
            } else if ("decrementArmed".equals(name)) {
                if (Boolean.TRUE.equals(event.getNewValue())) {
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._increment.getModel()).setArmedState(false);
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._decrement.getModel()).setArmedState(true);
                } else {
                    ((ContinuousButtonModel)BasicEWTSpinButtonUI.this._decrement.getModel()).setArmedState(false);
                }
            }
        }
    }
}

