/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.drawer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.bali.ewt.drawer.Drawer;
import oracle.bali.ewt.elaf.EWTDrawerUI;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;

class DrawerPopup
extends JComponent {
    static TaskScheduler _sTaskScheduler = TaskScheduler.getDefaultTaskScheduler();
    private static final int _SLIDE_OUT_TIME = 200;
    private static final int _STATE_CLOSED = 0;
    private static final int _STATE_OPENING = 1;
    private static final int _STATE_OPEN = 2;
    private transient int _state;
    private transient Slide _slide;
    private transient int _slidingPos;
    private transient int _multiplier;
    private transient boolean _horizontal;
    private transient Image _offscreen;
    private Drawer _parent;
    private JComponent _content;
    private transient JButton _button;

    public DrawerPopup(Drawer parent) {
        this.setLayout(null);
        this._parent = parent;
        this._content = new JPanel();
        this._content.setLayout(new BorderLayout(2, 2));
        this.add(this._content);
        this._state = 0;
    }

    public void setContent(Component content) {
        if (this._content.getComponentCount() > 0) {
            this._content.remove(0);
        }
        if (content != null) {
            this._content.add(content, "Center");
            this._fixContentUI();
            if (content instanceof JComponent) {
                ((JComponent)content).setBorder(null);
            }
            this._content.setBackground(content.getBackground());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Object object = this.getTreeLock();
        synchronized (object) {
            DrawerPopup drawerPopup = this;
            synchronized (drawerPopup) {
                if (this._state == 0) {
                    this._setUI();
                    this._fillBuffer();
                    if (this._offscreen == null) {
                        this._state = 2;
                    } else {
                        this._state = 1;
                        Dimension size = this._content.getSize();
                        Dimension buttonSize = this._button.getSize();
                        Dimension popupSize = this.getSize();
                        int orientation = this._parent.getOrientation();
                        switch (orientation) {
                            case 1: {
                                this._horizontal = false;
                                this._slidingPos = popupSize.height;
                                break;
                            }
                            case 3: {
                                this._horizontal = false;
                                this._slidingPos = buttonSize.height - size.height;
                                break;
                            }
                            default: {
                                this._horizontal = true;
                                this._slidingPos = buttonSize.width - size.width;
                                break;
                            }
                            case 2: {
                                this._horizontal = true;
                                this._slidingPos = popupSize.width;
                            }
                        }
                        this._multiplier = orientation == 2 || orientation == 1 ? -1 : 1;
                        if (this._slide == null) {
                            this._slide = new Slide();
                        }
                        this._slide.start();
                    }
                }
            }
        }
        if (this._state == 2) {
            this.revalidate();
        }
    }

    public void closeLater() {
        ActionListener action = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawerPopup.this.close();
            }
        };
        Timer timer = new Timer(200, action);
        timer.setRepeats(false);
        timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.getTreeLock();
        synchronized (object) {
            DrawerPopup drawerPopup = this;
            synchronized (drawerPopup) {
                if (this._state != 0) {
                    if (this._state == 1) {
                        this._slide.cancel();
                    }
                    this._state = 0;
                    this._parent.popupClosed();
                    if (this._offscreen != null) {
                        this._offscreen.flush();
                        this._offscreen = null;
                    }
                    this._content.remove(this._button);
                    this._button = null;
                }
            }
        }
    }

    public void paintInterior(Graphics g) {
        Image offscreen;
        if (this._state == 1 && (offscreen = this._offscreen) != null) {
            if (this._horizontal) {
                g.drawImage(offscreen, this._slidingPos, 0, this);
            } else {
                g.drawImage(offscreen, 0, this._slidingPos, this);
            }
        }
    }

    public void doLayout() {
        int state = this._state;
        Dimension size = this.getSize();
        Dimension preferredSize = this.getPreferredSize();
        int orientation = this._parent.getOrientation();
        int width = size.width;
        int height = size.height;
        switch (this._parent.getOrientation()) {
            default: {
                height = Math.max(size.height, preferredSize.height);
                break;
            }
            case 2: 
            case 4: {
                width = Math.max(size.width, preferredSize.width);
            }
        }
        if (state == 2) {
            int x = 0;
            int y = 0;
            switch (orientation) {
                default: {
                    break;
                }
                case 3: {
                    y = size.height - height;
                    break;
                }
                case 4: {
                    x = size.width - width;
                }
            }
            this._content.setBounds(x, y, width, height);
        } else {
            this._content.setBounds(-width, 0, width, height);
        }
    }

    public Dimension getMinimumSize() {
        this._setUI();
        return this._content.getMinimumSize();
    }

    private void _fixContentUI() {
        Component content = this._parent.getContent();
        if (content != null) {
            if (content instanceof JComponent) {
                ((JComponent)content).setBorder(null);
            }
            this._content.setBackground(content.getBackground());
        }
    }

    public Dimension getPreferredSize() {
        this._setUI();
        return this._content.getPreferredSize();
    }

    public void updateComponentTreeUI() {
        SwingUtilities.updateComponentTreeUI(this);
        this._fixContentUI();
    }

    public void updateUI() {
        super.updateUI();
        if (!this.isShowing()) {
            this._button = null;
        }
    }

    boolean slideOnceMore(int count) {
        int slideInterval;
        int max;
        Dimension d = this._content.getSize();
        Dimension size = this.getSize();
        if (this._horizontal) {
            max = size.width - d.width;
            slideInterval = (size.width - max) * count / 200;
        } else {
            max = size.height - d.height;
            slideInterval = (size.height - max) * count / 200;
        }
        if (slideInterval == 0) {
            slideInterval = 1;
        }
        this._slidingPos += this._multiplier * slideInterval;
        if (this._multiplier < 0) {
            max = 0;
        }
        if (this._slidingPos * this._multiplier < max) {
            if (this._horizontal) {
                this._paintBuffer(this._slidingPos, 0);
            } else {
                this._paintBuffer(0, this._slidingPos);
            }
            return true;
        }
        this._state = 2;
        this.revalidate();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _paintBuffer(int x, int y) {
        Image offscreen = this._offscreen;
        if (offscreen != null) {
            Graphics g = this.getGraphics();
            try {
                g.drawImage(offscreen, x, y, null);
            }
            finally {
                g.dispose();
            }
        }
    }

    private void _setUI() {
        if (this._button == null) {
            String layoutConstraint;
            EWTDrawerUI ui = this._parent.getEWTDrawerUI();
            int orientation = this._parent.getOrientation();
            switch (orientation) {
                case 1: {
                    layoutConstraint = "North";
                    break;
                }
                case 3: {
                    layoutConstraint = "South";
                    break;
                }
                case 2: {
                    layoutConstraint = "West";
                    break;
                }
                default: {
                    layoutConstraint = "East";
                }
            }
            this._button = ui.getPopUpArrowButton(this._parent);
            this._button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DrawerPopup.this.close();
                }
            });
            this._content.add((Component)this._button, layoutConstraint);
            this._content.setBorder(ui.getDrawerBorder(this._parent));
        }
    }

    private void _fillBuffer() {
        JComponent content = this._content;
        if (this._offscreen != null) {
            this._offscreen.flush();
        }
        Dimension d = content.getSize();
        this._offscreen = content.createImage(d.width, d.height);
        if (this._offscreen != null) {
            Graphics g = this._offscreen.getGraphics();
            g.setColor(content.getBackground());
            g.fillRect(0, 0, d.width, d.height);
            g.setClip(0, 0, d.width, d.height);
            g.setColor(content.getForeground());
            g.setFont(content.getFont());
            content.paint(g);
        }
    }

    private class Slide
    implements Task {
        private int _count;

        private Slide() {
        }

        public void runTask(TaskEvent e) {
            if (DrawerPopup.this.slideOnceMore(this._count)) {
                this._count = 1 + (int)e.getTimeDelta();
                _sTaskScheduler.schedule((Task)this, 1);
            }
        }

        public void start() {
            this._count = 1;
            _sTaskScheduler.schedule((Task)this, 1);
        }

        public void cancel() {
            _sTaskScheduler.cancel((Task)this);
        }
    }
}

