/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dnd;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.JFCSupport;

@Deprecated
class DnDUtils {
    private static final int _SOLARIS_OS = 1;
    private static final int _MAC_OS = 2;
    private static final int _WINDOWS_OS = 3;
    private static int _sOSVariant;

    DnDUtils() {
    }

    public static DropTarget getEWTDropTarget(Component c) {
        if (c instanceof JComponent) {
            return JFCSupport.getEWTDropTarget((JComponent)c);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintImmediate(Component c, int x, int y, int width, int height) {
        if (c instanceof JComponent) {
            ((JComponent)c).paintImmediately(x, y, width, height);
        } else if (c instanceof RootPaneContainer) {
            Container jc;
            for (Container parent = jc = ((RootPaneContainer)((Object)c)).getContentPane(); parent != c; parent = parent.getParent()) {
                Point location = parent.getLocation();
                x -= location.x;
                y -= location.y;
            }
            DnDUtils.paintImmediate(jc, x, y, width, height);
        } else {
            Graphics g = c.getGraphics();
            try {
                g.clipRect(x, y, width, height);
                c.update(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    public static void setEWTDropTarget(Component c, DropTarget t) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (!(c instanceof JComponent)) {
            throw new IllegalArgumentException("Illegal component type");
        }
        JFCSupport.setEWTDropTarget((JComponent)c, t);
    }

    public static Component getTopmostParent(Component component, Point local) {
        Container parent;
        int x = local.x;
        int y = local.y;
        while (!(component instanceof Window) && component != null && JComponent.isLightweightComponent(component) && (parent = component.getParent()) != null) {
            Point location = component.getLocation();
            x += location.x;
            y += location.y;
            component = parent;
        }
        local.x = x;
        local.y = y;
        return component;
    }

    public static Component getTargetComponentOutside(Component component, Point local) {
        Component top = DnDUtils.getTopmostParent(component, local);
        return DnDUtils.getTargetComponent(top, local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component getTargetComponent(Component component, Point local) {
        Object proxy = null;
        int x = local.x;
        int y = local.y;
        if (component instanceof Container) {
            Container container = (Container)component;
            Object object = container.getTreeLock();
            synchronized (object) {
                int count = container.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    Container parent;
                    Component child = container.getComponent(i);
                    if (!child.isVisible() || child instanceof JPanel && (parent = child.getParent()) instanceof JRootPane && ((JRootPane)parent).getGlassPane() == child || child == proxy) continue;
                    Point location = child.getLocation();
                    int childX = x - location.x;
                    int childY = y - location.y;
                    if (!child.contains(childX, childY)) continue;
                    local.x = childX;
                    local.y = childY;
                    return DnDUtils.getTargetComponent(child, local);
                }
            }
        }
        return component;
    }

    public static int getDefaultActions(int eventModifiers) {
        int actions = 3;
        switch (DnDUtils._getOS()) {
            case 1: 
            case 3: {
                if ((eventModifiers & 2) == 0) break;
                actions = 1;
                break;
            }
            case 2: {
                if ((eventModifiers & 8) == 0) break;
                actions = 1;
            }
        }
        return actions;
    }

    private static int _getOS() {
        int os = _sOSVariant;
        if (os == 0) {
            os = 3;
            String osName = null;
            try {
                osName = System.getProperty("os.name");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (osName != null) {
                if (osName.startsWith("Solaris")) {
                    os = 1;
                } else if (osName.startsWith("Mac")) {
                    os = 2;
                }
            }
            _sOSVariant = os;
        }
        return os;
    }
}

