/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;

public class DialogHeader
extends JPanel {
    private static final int _UI_IMAGE_HEIGHT = 40;
    private static final int _UI_IMAGE_WIDTH = 40;
    private static final Border _BORDER = new HeaderBorder();
    private String _headerTitle;
    private JLabel _headerImageLabel;
    private MultiLineLabel _headerDescription;

    public DialogHeader() {
        this._init();
    }

    public DialogHeader(String headerDescription, Image headerImage) {
        this._init();
        this.setHeaderDescription(headerDescription);
        this.setHeaderImage(headerImage);
    }

    public void setHeaderImage(Image image) {
        if (this._headerImageLabel == null) {
            if (image == null) {
                return;
            }
            this._headerImageLabel = new JLabel();
        }
        ImageIcon icon = null;
        if (image != null) {
            ImageUtils.loadImage(image);
            icon = new ImageIcon(image);
        }
        this._headerImageLabel.setIcon(icon);
        this._checkHeader();
    }

    public Image getHeaderImage() {
        if (this._headerImageLabel == null) {
            return null;
        }
        Icon icon = this._headerImageLabel.getIcon();
        return icon == null ? null : ((ImageIcon)icon).getImage();
    }

    public void setHeaderTitle(String label) {
        this._headerTitle = label;
    }

    public String getHeaderTitle() {
        return this._headerTitle;
    }

    public void setHeaderDescription(String label) {
        if (this._headerDescription == null) {
            if (label == null || "".equals(label)) {
                return;
            }
            this._headerDescription = new MultiLineLabel(WordWrapper.getTextWrapper(), label);
            this._headerDescription.setPreferredAspectRatio(9.7f);
            this._headerDescription.setVerticalShrinking(true);
        } else {
            this._headerDescription.setText(label);
        }
        this._checkHeader();
    }

    public String getHeaderDescription() {
        return this._headerDescription == null ? null : this._headerDescription.getText();
    }

    public void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            int right = this.getWidth();
            int bottom = this.getHeight();
            Color c = this.getBackground();
            if (c == null) {
                c = UIManager.getColor("Panel.background");
            }
            if (g instanceof Graphics2D) {
                GradientPaint grad = new GradientPaint(0.0f, 0.0f, Color.white, right, 0.0f, c);
                ((Graphics2D)g).setPaint(grad);
            }
            g.fillRect(0, 0, right, bottom);
        }
    }

    private void _init() {
        this.setBorder(_BORDER);
        this.setLayout(new HeaderLayout());
    }

    private void _checkHeader() {
        if (this._headerImageLabel != null) {
            if (this._headerImageLabel.getIcon() == null) {
                this.remove(this._headerImageLabel);
            } else {
                this.add(this._headerImageLabel);
            }
        }
        if (this._headerDescription != null) {
            if (this._headerDescription.getText() == null || "".equals(this._headerDescription.getText())) {
                this.remove(this._headerDescription);
            } else {
                this.add(this._headerDescription);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private static class HeaderBorder
    implements Border {
        private static final Insets _INSETS = new Insets(10, 10, 12, 10);

        private HeaderBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int bottom = y + height - 1;
            int right = x + width - 1;
            Color old = g.getColor();
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(x, bottom - 1, right - 1, bottom - 1);
            g.setColor(Color.white);
            g.drawLine(x, bottom, right, bottom);
            g.drawLine(right, bottom - 1, right, bottom - 1);
            g.setColor(old);
        }

        public Insets getBorderInsets(Component c) {
            return _INSETS;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class HeaderLayout
    implements LayoutManager2 {
        private static final int _HGAP = 15;

        private HeaderLayout() {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension size = new Dimension();
            if (DialogHeader.this._headerImageLabel != null) {
                Dimension imageSize = DialogHeader.this._headerImageLabel.getPreferredSize();
                size.width += imageSize.width;
                size.height = imageSize.height;
            }
            if (DialogHeader.this._headerDescription != null) {
                Dimension descSize = DialogHeader.this._headerDescription.getPreferredSize();
                if (DialogHeader.this._headerImageLabel != null) {
                    size.width += 15;
                }
                size.width += descSize.width;
                size.height = Math.max(descSize.height, size.height);
            }
            Insets inset = parent.getInsets();
            size.width += inset.left + inset.right;
            size.height += inset.top + inset.bottom;
            return size;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            Insets inset = parent.getInsets();
            int height = parent.getHeight() - (inset.top + inset.bottom);
            int right = parent.getWidth() - inset.right;
            if (DialogHeader.this._headerImageLabel != null) {
                Dimension labelSize = DialogHeader.this._headerImageLabel.getPreferredSize();
                DialogHeader.this._headerImageLabel.setBounds(right -= labelSize.width, inset.top, labelSize.width, Math.min(height, labelSize.height));
                right -= 15;
            }
            if (DialogHeader.this._headerDescription != null) {
                DialogHeader.this._headerDescription.setBounds(inset.left, inset.top, right -= inset.left, height);
            }
        }

        public Dimension maximumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }
    }
}

